/*
 * PCN System
 * Author:      Steve Tuecke
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * pcn_c_hdr.h
 *
 * A standard, portable C header file for getting string procedure
 * declaration, etc.
 */

#ifndef _PCN_INCLUDE_PCN_C_HDR_H
#define _PCN_INCLUDE_PCN_C_HDR_H

#ifdef s2010
#define PCN_DONT_INCLUDE_STRING
#define PCN_DONT_INCLUDE_ANSI
extern int strlen();
extern char *strcpy();
extern char *strncpy();
extern char *strcat();
extern char *strncat();
extern char *strchr();
extern char *strrchr();
extern void *memcpy();
extern void *memset();
#endif /* s2010 */

#ifndef PCN_DONT_INCLUDE_STRING
#include <string.h>
#endif
#ifdef PCN_INCLUDE_STRINGS
#include <strings.h>
#endif


#ifndef PCN_DONT_INCLUDE_ANSI

#include <stddef.h>
#include <stdlib.h>

#else  /* !PCN_DONT_INCLUDE_ANSI */

#ifndef atof
extern double atof();
#endif

#if defined(s2010)
#define MALLOC_RETURN char
#else
#define MALLOC_RETURN void
#endif
extern void free();
extern MALLOC_RETURN *malloc();
extern MALLOC_RETURN *realloc();


#ifdef symmetry

#include <sys/types.h>

#ifndef NULL
#define NULL ((void *) 0)
#endif

#endif /* symmetry */


#endif /* !PCN_DONT_INCLUDE_ANSI */


#ifdef PCN_SYSV
#include <stdio.h>
extern FILE *fdopen();
#endif /* PCN_SYSV */

/*
 * Some procedure defines to provide for portability...
 */
#ifdef PCN_STRCHR_TO_INDEX
#define strchr(S,C)     index(S,C)
#define strrchr(S,C)    rindex(S,C)
#endif

#ifdef PCN_MEMCPY_TO_BCOPY
#define memcpy(Dest,Src,Length)		bcopy(Src,Dest,Length)
#endif

#ifdef PCN_NO_MEMMOVE
#define memmove(Dest,Src,Length) \
{ \
    char *__Src = ((char *) (Src)); \
    char *__Dest = ((char *) (Dest)); \
    char *__EndSrc = (__Src + (Length)); \
    char *__EndDest = (__Dest + (Length)); \
    if ( (__Src < __Dest) && (__Dest < __EndSrc) ) \
    { \
	/* Overlapping, with __Dest > __Src, so copy from end */ \
	while (__EndSrc > __Src) \
	{ \
	    *(--__EndDest) = *(--__EndSrc); \
	} \
    } \
    else if ( (__Dest < __Src) && (__Src < __EndDest) ) \
    { \
	/* Overlapping, with __Dest < __Src, so copy from beginning */ \
	while (__Src < __EndSrc) \
	{ \
	    *(__Dest++) = *(__Src++); \
	} \
    } \
    else if ( __Src != __Dest ) \
    { \
	/* Non-overlapping (and not the same), so memcpy() can be trusted */ \
	memcpy(Dest,Src,Length); \
    } \
}
#endif /* PCN_NO_MEMMOVE */

#ifdef PCN_USE_BZERO
#define ZeroOutMemory(Where,Size)	bzero(Where,Size)
#else
#define ZeroOutMemory(Where,Size)	memset(Where,0,Size)
#endif

#ifdef PCN_GETWD_TO_GETCWD
extern char *getcwd();
#define getwd(S)	getcwd(S,MAX_PATH_LENGTH)
#else
extern char *getwd();
#endif

#ifdef PCN_REMOVE_TO_UNLINK
#define remove(Filename)		unlink(Filename)
#endif

#ifdef PCN_RENAME_TO_LINK
#define rename(OldName, NewName)	_p_rename_to_link(OldName, NewName)
#endif


#endif /* _PCN_INCLUDE_PCN_C_HDR_H */
