
%{
    
#include "co_parse.h"

static char buf[1000];
static char *save;
static char errbuf[200];


/*
 * This is the magic that allows us to force yyparse() to return after 
 * each form. If _p_co_parse_done_flag is true, we force YY_INPUT to return 
 * EOF.
 */

#ifdef FLEX_SCANNER

#undef YY_INPUT
#define YY_INPUT(buf,result,max_size)	\
	\
    if (_p_co_push_token) { buf[0] = _p_co_push_token; result = 1; _p_co_push_token = 0;} \
    else if (_p_co_parse_done_flag)	\
    {	\
	_p_co_parse_done_flag = 0;	\
	result = 0;	\
    }	\
    else 	\
    { 	\
	int c = getc(yyin); 	\
	result = (c == EOF) ? YY_NULL : (buf[0] = c, 1); 	\
    }

#define CHECK_YYTEXT_LENGTH

#else /* FLEX_SCANNER */

#undef YYLMAX
#define YYLMAX LEX_INPUT_BUFFER_SIZE

#define CHECK_YYTEXT_LENGTH if (strlen(yytext) >= LEX_INPUT_BUFFER_SIZE) \
	{ \
	    fprintf(stderr, \
		    "Fatal error: lexical analyzer encountered a a string that\n             is too long to handle (length = %d)\n", \
		    strlen(yytext));\
	    exit_from_c(1); \
	}

static int _p_co_tmp;

#undef input
#define input() (yysptr > yysbuf ? (yytchar = *--yysptr) : \
		(_p_co_push_token ? (yytchar = _p_co_push_token, \
				     _p_co_push_token = 0, \
				     yytchar) : \
		     (_p_co_parse_done_flag ? \
		            (yytchar = _p_co_parse_done_flag = 0) \
		             : ((yytchar = getc(yyin)) == EOF ? 0 : yytchar))))

#endif /* FLEX_SCANNER */
    
static int string_to_octal();
static int string_to_hex();

%}

identifier ([a-zA-Z_][0-9a-zA-Z_]*)

exponent_part ([eE][-+]?[0-9]+)
fractional_constant (([0-9]*"."[0-9]+)|([0-9]+"."))
floating_constant (({fractional_constant}{exponent_part}?)|([0-9]+{exponent_part}))

integer_suffix_opt (([uU]?[lL]?)|([lL][uU]))
decimal_constant ([1-9][0-9]*{integer_suffix_opt})
octal_constant ("0"[0-7]*{integer_suffix_opt})
hex_constant ("0"[xX][0-9a-fA-F]+{integer_suffix_opt})

simple_escape [abfnrtv'"?\\]
octal_escape  ([0-7]{1,3})
hex_escape ("x"[0-9a-fA-F]+)

escape_sequence ([\\]({simple_escape}|{octal_escape}|{hex_escape}))
c_char ([^'\\\n]|{escape_sequence})
s_char ([^"\\\n]|{escape_sequence})

h_tab [\011]
form_feed [\014]
v_tab [\013]
c_return [\015]

horizontal_white ([ ]|{h_tab})

%s CHAR_CONST

%%

<INITIAL>[']	{ save = buf; save[0] = 0; BEGIN(CHAR_CONST); }

<INITIAL>"->"	{ return IMPLY; }
<INITIAL>"?="	{ return MATCH; }
<INITIAL>"<="	{ return LEQ; }
<INITIAL>">="	{ return GEQ; }
<INITIAL>"!="	{ return NEQ; }
<INITIAL>":="	{ return COLONEQ; }
<INITIAL>"::"	{ return COLONCOLON; }
<INITIAL>"=="	{ return EQ; }
<INITIAL>"||"	{ return BARBAR; }
<INITIAL>"over"	{ return OVER; }
<INITIAL>".." { return DOTS; }

<INITIAL>"default" { return DEFAULT; }

<INITIAL>"in" { return IN; }


<CHAR_CONST>{escape_sequence}+   { strcat(save, yytext); }
<CHAR_CONST>['] {
		  char buf[32], *s;
		  if (save[0] == '\\')
		  {
		      switch(save[1])
		      {
		      case 'n':
                          sprintf(buf, "%d", '\n');
			  s = buf;
			  break;

		      case 't':
                          sprintf(buf, "%d", '\t');
			  s = buf;
			  break;

		      case 'v':
                          sprintf(buf, "%d", '\v');
			  s = buf;
			  break;

		      case 'b':
                          sprintf(buf, "%d", '\b');
			  s = buf;
			  break;

		      case 'f':
                          sprintf(buf, "%d", '\f');
			  s = buf;
			  break;

		      case 'a':
                          sprintf(buf, "%d", '\a');
			  s = buf;
			  break;

		      case '\\':
		      case '?':
		      case '"':
		      case '\'':
			  sprintf(buf, "%d", save[1]);
			  s = buf;
			  break;

		      case 'x':
			  sprintf(buf, "%d",
			          string_to_hex(save + 2));
			  s = buf;
			  break;

 		      case '0':
 		      case '1':
 		      case '2':
 		      case '3':
 		      case '4':
 		      case '5':
 		      case '6':
 		      case '7':
			  sprintf(buf, "%d",
			          string_to_octal(save + 1));
			  s = buf;
			  break;

		      default:
			  sprintf(errbuf, "Unknown character constant %s",
				  save);
			  _p_co_syntax_error(errbuf);
			  s = "0";
			  break;
		      }
		  }
		  else
		  {
		      sprintf(buf, "%d", save[0]);
		      s = buf;
		  }

		  yylval = _p_co_new_string(s);

		  BEGIN(INITIAL);
		  return(INTEGERconstant);

	      }

<CHAR_CONST>\\.  { printf("Invalid escape sequence in char const: %s\n", yytext); }
<CHAR_CONST>\n   { printf("Invalid: newline in char const\n"); }
<CHAR_CONST>.   { strcat(save, yytext); }

<INITIAL>["]{s_char}*["]     {
    CHECK_YYTEXT_LENGTH;
    yylval = _p_co_new_string_len(yytext+1, strlen(yytext) - 2); return STRING;}

<INITIAL>{identifier}        { yylval = _p_co_new_string(yytext); return ID; }

<INITIAL>{decimal_constant}  { yylval = _p_co_new_string(yytext); return(INTEGERconstant); }
<INITIAL>{octal_constant}    { yylval = _p_co_new_string(yytext); return OCTALconstant;}
<INITIAL>{hex_constant}      { yylval = _p_co_new_string(yytext); return(HEXconstant);}
<INITIAL>{floating_constant}/[^.] { yylval = _p_co_new_string(yytext); return(FLOATINGconstant);}

<INITIAL>^#[^\n]*\n { _p_co_parse_cpp_directive(yytext); }

<INITIAL>[ \t]	;

<INITIAL>"\n" { _p_co_lineno++; }
<INITIAL>. { return *yytext; }

%%

#ifdef FLEX_SCANNER

void _p_co_clear_input()
{
    yyrestart(yyin);
}

#else /* FLEX_SCANNER */


void _p_co_clear_input()
{
    yysptr=yysbuf;	
}

int yywrap()
{
    return 1;
}

#endif /* FLEX_SCANNER */


#if 0
static int get_one_char()
{
    int rc;
    extern int yytchar;

    if (yysptr > yysbuf)
    {
	rc = yytchar = *--yysptr;
	printf("get_one_char: returning unputted char %d\n", rc);
    }
    else if (_p_co_push_token)
    {
	rc = _p_co_push_token;
	_p_co_push_token = 0;
	printf("get_one_char: got push_token and returning %d\n", rc);
    }
    else if (_p_co_parse_done_flag)	
    {	
	_p_co_parse_done_flag = 0;	
	rc = 0;
	printf("get_one_char: got parse_done_flag and returning 0\n");
    }	
    else 	
    { 	
	int c = getc(yyin);
	if (c == EOF)
	{
	    rc = 0;
	    printf("get_one_char: got char eof and returning 0\n");
	}
	else
	{
	    rc = c;
	    printf("get_one_char: got char %d and returning %d\n",
		   rc, rc);
	}
    }
    return rc;
}
#endif

static int string_to_octal(s)
char *s;
{
    int val;

    val = 0;

    while (*s != '\0')
    {
	if (*s < '0' || *s > '7')
	{
	    sprintf(errbuf, "Invalid octal character %c", *s);
	    _p_co_syntax_error(errbuf);
	    return 0;
	}
	val = val * 8 + *s - '0';
	s++;
    }
    return val;
}

static int string_to_hex(s)
char *s;
{
    int val;

    val = 0;

    while (*s != '\0')
    {
	if (*s >= '0' && *s <= '9')
	{
	    val = val * 16 + *s - '0';
	}
	else if (*s >= 'a' && *s <= 'f')
	{
	    val = val * 16 + *s - 'a' + 10;
	}
	else if (*s >= 'A' && *s <= 'F')
	{
	    val = val * 16 + *s - 'A' + 10;
	}
	else
	{
	    sprintf(errbuf, "Invalid hex character %c", *s);
	    _p_co_syntax_error(errbuf);
	    return 0;
	}
	    
	s++;
    }
    return val;
}

