
%{ 

#include "co_parse.h"

/* Bison on some machines does not include this, but needs to... */
#if defined(iris) || defined(ksr1)
#include <alloca.h>
#endif

#define SyntaxError _p_co_syntax_error

static int in_quoted_block = 0;

static int block_depth = 0;
static int block_start_line[200];
%}



%token ID IN DOTS COLONCOLON
%token FLOATINGconstant INTEGERconstant CHARACTERconstant
%token OCTALconstant HEXconstant
%token STRING 
%token IMPLY MATCH LEQ GEQ EQ NEQ 
%token DEFAULT COLONEQ
%token OVER BARBAR

/*
 * These precedences are used to disambiguate { ; } between an empty 
 * sequential block or a block with two empty statements. See the 
 * first production for Element.
 */

%nonassoc HIGHPREC
%nonassoc  ';' ID IN OVER
%nonassoc LOWPREC

/* 
 * These precedences are used to provide the proper parsing of 
 * arithmetic expressions. See the productions for Exp.
 */
%left '+' '-'
%left '*' '/' '%'
%right UNARY

%%

/* Syntax of Programs */

/*
 * Notice that we don't have a list-based production to collect all
 * forms in a program. This is because we are invoking some lexing
 * magic to get yyparse to return after each form.
 *
 * We get an empty form if we hit eof. Flag this if it happens. 
 * We need to do this since we're forcing YY_INPUT (in the lexer) to 
 * return "eof" at the end of each form.
 *
 * If we get a program or directive, flag the parse as done and remember the
 * parse tree. The parse tree returned is a list, since parsing a function
 * will generate a directive as well as a function.
 *
 */ 
   

Form            : Program   
		    {
			_p_co_parse_done_flag = 1;
			_p_co_parse_tree = $1;
		    }
                | Directive
		    {
			_p_co_parse_tree = $1;
			_p_co_parse_done_flag = 1;
		    }
    		| /* empty */ 
		    {
			_p_co_parse_tree = _p_co_nil();
			_p_co_parse_completely_done_flag = 1;
		    }
                ;


/* Parse a directive.  Internal form returned is
 *  
 *     {{TAG_COLON, module, directive-name},
 *      local-temp-max,
 *      {TAG_DIRECTIVE, [list]}}
 */

   
Directive       :  '-' Identifier Args
		    {
			datum *name, *args, *ident, *dir, *out;

			if (strcmp(D_SVAL($2), "directive") == 0)
			{
			    /* We have a "-directive" form. Grab the
			     * first argument as the directive name.
			     */

			    name = D_CAR(D_LHEAD($3));

			    if (!(D_IS_TUPLE(name) && D_NARGS(name) == 2 &&
				  D_IS_TAG(D_ARG(name, 0)) &&
				  D_IS_STRING(D_ARG(name, 1))))
			    {
				SyntaxError("Invalid -directive directive: First argument must be a string");
				name = _p_co_new_string("<invalid_name>");
			    }
			    else
			    {
				name = D_ARG(name, 1);
			    }
			    
			    D_LHEAD($3) = D_CDR(D_LHEAD($3));
			    args = $3;
			}
			else
			{
			    name = $2;
			    args = $3;
			}

			D_NEW_TUPLE_3(ident, D_TAG_COLON,
				      D_TAG_CURRENT_MODULE,
				      name);

			/*
			 * If we're compiling without any transforms, turn
			 * on compilation of assignments in guard tests.
			 *
			 */
			if (D_IS_STRING(name) &&
			    strcmp(D_SVAL(name), "no_xforms") == 0)
			{
			    _p_co_allow_assignment_in_guard = 1;
			}

			D_NEW_TUPLE_2(dir, D_TAG_DIRECTIVE, args);
			D_NEW_TUPLE_3(out,
				      ident,
				      _p_co_new_integer(_p_co_l_temp_max),
				      dir);
			/* Return the output as a 1-element list */
			D_NEW_TUPLE_2($$, out, _p_co_nil());
		    }
		;

Program         : ProgDecl Identifier '(' ProgramArgList ')' DeclarationList ErrorBlockOrCall
		    {
			datum *ident, *prog, *directive, *tail, *pair;

			D_NEW_TUPLE_3(ident, D_TAG_COLON,
				      D_TAG_CURRENT_MODULE, $2);


			/* If we have program annotations, pass them
			 * through as a directive _program_annotations.
			 */
			if (!D_IS_NIL($1))
			{
			    datum *t1, *t2, *t3;

			    /* t1 = {DIRECTIVE, [foo | args]} */
			    
			    D_NEW_TUPLE_2(t1, D_TAG_DIRECTIVE,
					  _p_co_cons($2, UNLIST($1)));

			    /* t2 = {":", mod, "_program_annotations"} */
			    D_NEW_TUPLE_3(t2, D_TAG_COLON,
					  D_TAG_CURRENT_MODULE,
					 _p_co_new_string("_program_annotations"));

			    /* t3 = {t2, 0, t1} */
			    D_NEW_TUPLE_3(t3, t2, _p_co_new_integer(0), t1);
			    D_NEW_TUPLE_2(tail, t3, _p_co_nil());
			}
			else
			{
			    tail = _p_co_nil();
			}

			/* We really need to walk the ProgramArgList here
			 * to find occurrences of {type, var}, replace
			 * them with just var, and add an entry to
			 * the declaration list.
			 *
			 * But for simplicity, we're doing that in a
			 * postprocessing stage.
			 */
			D_NEW_TUPLE_4(prog, D_TAG_PROGRAM,
				      UNLIST($4),
				      UNLIST($6),
				      $7);
			D_NEW_TUPLE_3(pair,
				      ident,
				      _p_co_new_integer(_p_co_l_temp_max),
				      prog);
			D_NEW_TUPLE_2($$, pair, tail);
		    }
			
		;

ProgDecl	: /* empty */ 			%prec LOWPREC
		    {
			$$ = _p_co_nil();
		    } 
		| Identifier
		    {
			$$ = _p_co_new_list($1);
		    }

		| ProgDecl Identifier
		    {
			$$ = _p_co_append_list($1, $2);
		    }
		;

ProgramArgList	: /* empty */
		    {
			$$ = _p_co_nil();
		    }
		| ProgramArg
		    {
			$$ = _p_co_new_list($1);
		    }
		| ProgramArgList ',' ProgramArg
		    {
			$$ = _p_co_append_list($1, $3);
		    }
		;

ProgramArg	: VarTypeList Mutable
		    {
			D_NEW_TUPLE_2($$, $1, $2);
		    }
		| Identifier          
		    {
			D_NEW_TUPLE_3($$, D_TAG_VAR, $1, _p_co_nil());
		    }
		;

VarTypeList	: Identifier 
		    {
			$$ = _p_co_new_list($1);
		    }
		| VarTypeList Identifier
		    {
			$$ = _p_co_append_list($1, $2);
		    }
		;

Declaration	: VarTypeList MutableList ';'
		    {
			datum *l, *t;
			
			$$ = _p_co_nil();

			for (l = REAL_UNLIST($2); D_IS_TUPLE(l); l = D_CDR(l))
			{
			    D_NEW_TUPLE_2(t, $1, D_CAR(l));
			    $$ = _p_co_append_list($$, t);
			}
		    }
		;

DeclarationList : /* empty */ 
		    {
			$$ = _p_co_nil();
		    }
		| DeclarationList Declaration 
		    {
			/* Perform some list surgery to do list appends
			 * without traversing the list.
			 *
			 * _p_co_append_list() doesn't work since it expects
			 * the second argument to be an element, not a list.
			 */

			if (D_IS_NIL($1))
			{
			    $$ = $2;
			}
			else if (!D_IS_LIST($1))
			{
			    printf("ACK!\n");
			    _p_co_print($1);
			    exit(1);
			}
			else
			{
			    /* Memory leak here, in the list datum for $2 */
			
			    *(D_LTAIL($1)) = D_LHEAD($2);
			    D_LTAIL($1) = D_LTAIL($2);
			    $$ = $1;
			}
		    }
		;

Mutable         : Identifier Dimension 
		    {
			D_NEW_TUPLE_3($$, D_TAG_VAR, $1, $2);
		    }
		;

MutableList     : Mutable 
		    {
			$$ = _p_co_new_list($1);
		    }
		| MutableList ',' Mutable
		    {
			$$ = _p_co_append_list($1, $3);
		    }
		;

Dimension       : /* empty */ 
		    {
			$$ = _p_co_nil();
		    }
		| '[' ']'
		    {
			datum *zero;
			
			zero = _p_co_new_tuple_2(D_TAG_INTEGER_CONST,
					       _p_co_new_string("0"));
			$$ = _p_co_new_tuple_2(D_TAG_TUPLE,
				      _p_co_new_tuple_2(zero,
					     _p_co_new_tuple_2(D_TAG_TUPLE,
							       _p_co_nil())));
		    }
		| '[' Exp ']'
		    {
			$$ = _p_co_new_tuple_2(D_TAG_TUPLE,
				      _p_co_new_tuple_2($2,
					     _p_co_new_tuple_2(D_TAG_TUPLE,
							       _p_co_nil())));
		    }
		;

Block           : BlockStart '?' Implications '}' 
		    {
			block_depth--;
			D_NEW_TUPLE_3($$, D_TAG_BLOCK, 
				      D_TAG_CHOICE_COMP, UNLIST($3));
		    }
		| BlockStart Op Blocks '}' 
		    {
			block_depth--;
			D_NEW_TUPLE_3($$, D_TAG_BLOCK, 
				      $2, UNLIST($3));
		    }
		| BlockStart Blocks '}' 
		    {
#ifdef TARGET1
			printf("%s:%d: Warning: Implicit block operator used\n",
			       _p_co_filename,
			       block_start_line[block_depth]);
#endif
			block_depth--;
			D_NEW_TUPLE_3($$, D_TAG_BLOCK, 
				      D_TAG_SEQ_COMP, UNLIST($2));
		    }
		| BlockStart error '}'
		    {
			block_depth--;
			SyntaxError("Invalid block");
			$$ = _p_co_nil();
		    }
		;

BlockStart	: '{'
		    {
			block_depth++;
			block_start_line[block_depth] = _p_co_lineno;
		    }
		;

Op              : BARBAR
		    {
			$$ = D_TAG_PAR_COMP;
		    }
		|  ';'
		    {
			$$ = D_TAG_SEQ_COMP;
		    }

		| '<' LocalCall '>'
		    {
			D_NEW_TUPLE_2($$, D_TAG_USER_DEF_COMP, $2);
		    }
		| '<' Identifier '>'
		    {
			D_NEW_TUPLE_2($$, D_TAG_USER_DEF_COMP, $2);
		    }
		;

Blocks		: Element
		    {
			if ($1 == NULL)
			    $$ = _p_co_nil();
			else
			    $$ = _p_co_new_list($1);
		    }
		| Blocks Separator Element
		    {
			if ($3 == NULL)
			    $$ = $1;
			else
			    $$ = _p_co_append_list($1, $3);
		    }
 		;

Separator       : ',' 
		| ';'
		;

Element         : /* empty */ 			%prec 	HIGHPREC
		    {
#ifdef TARGET1
			_p_co_warning("Encountered empty element");
#endif
			$$ = NULL;
		    }
		| '!' CallForm
		    {
#ifdef TARGET1
			_p_co_warning("Capabilities are no longer supported");
			$$ = _p_co_new_tuple_2(D_TAG_CAPABILITY,
					       $2);
#else
			SyntaxError("Capabilities are no longer supported");
			$$ = NULL;
#endif
		    }
		| Call IMPLY MaybeCall
		    {
			SyntaxError("Implications must be within choice blocks");
			if (block_depth > 1)
			    _p_co_push_token = ';';
			$$ = NULL;
		    }
		/*
		 * This production is for catching common errors encountered
		 * when porting old code to the new parser. We notice here
		 * a weak form of single-statement implication (stronger forms
		 * lead to conflicts).
		 */
		| ErrorInfixOps IMPLY MaybeCall
		    {
			SyntaxError("Implications must be within choice blocks");

			/*
			 * If we're not in a toplevel block, arrange
			 * for a separator to be the next token
			 * shifted by the parser. See the
			 * YY_INPUT macro in lex.l.
			 */
			if (block_depth > 1)
			    _p_co_push_token = ';';
			$$ = NULL;
		    }
		| '$' Identifier Subscript
		    {
			if (!in_quoted_block)
			{
			    SyntaxError("Bare variables not allowed outside quoted blocks");
			    $$ = NULL;
			    YYERROR;
			}
			else
			{
			    $$ = _p_co_new_tuple_3(D_TAG_INTERP_VAR, $2, $3);
			}
		    }
		| Var COLONEQ Exp
		    {
			D_NEW_TUPLE_3($$, D_TAG_PRIM,
				      D_TAG_ASSIGN,
				      _p_co_cons($1, _p_co_cons($3, _p_co_nil())));
		    }
		| Var '=' Term
		    {
			D_NEW_TUPLE_3($$, D_TAG_PRIM,
				      D_TAG_DEFINE,
				      _p_co_cons($1, _p_co_cons($3, _p_co_nil())));
		    }
		| Var COLONEQ Term error 
		    {
			SyntaxError("The RHS of an assignment statement must be a numeric expression");
			$$ = NULL;
		    }
		| Call
		| Block			
		| Identifier OVER Exp DOTS Exp COLONCOLON Element
		    {
			datum *var;
			D_NEW_TUPLE_3(var, D_TAG_VAR, $1, _p_co_nil());
			D_NEW_TUPLE_5($$,
				      D_TAG_OVER,
				      var,
				      $3,
				      $5,
				      $7);
		    }
		| LocalCall IN LocalCall
		    {
			D_NEW_TUPLE_3($$, D_TAG_IN, $1, $3);
		    }
		;


/*
 * This is used in the Element : ErrorInfixOps -> MaybeCall
 * production
 */
MaybeCall	: /* empty */
		| Call
    		| Var '=' Term
    		| Var COLONEQ Term
    		;

ErrorInfixOps	: Var InfixOp Term
    		| Var InfixOp Term ',' ErrorInfixOps
    		;

Call		: CallForm
		;

Implication     : /* empty */
		    {
			$$ = _p_co_nil();
		    }
		| Guard IMPLY BlockOrCall
		    {
			$$ = _p_co_new_tuple_3(D_TAG_IMPLIES, $1, $3);
		    }
		;

BlockOrCall	: Block
		| Call
		    {
			$$ = _p_co_new_tuple_3(D_TAG_BLOCK, D_TAG_PAR_COMP,
					       _p_co_new_list($1));
		    }
		| Var COLONEQ Exp
		    {
			datum *asgn;

			asgn = _p_co_new_tuple_3(D_TAG_PRIM,
						 D_TAG_ASSIGN,
						 _p_co_cons($1, _p_co_cons($3, _p_co_nil())));
			$$ = _p_co_new_tuple_3(D_TAG_BLOCK, D_TAG_PAR_COMP,
					       _p_co_new_list(asgn));
		    }
		| Var '=' Term
		    {
			datum *asgn;

			asgn = _p_co_new_tuple_3(D_TAG_PRIM,
						 D_TAG_DEFINE,
						 _p_co_cons($1, _p_co_cons($3, _p_co_nil())));
			$$ = _p_co_new_tuple_3(D_TAG_BLOCK, D_TAG_PAR_COMP,
					       _p_co_new_list(asgn));
		    }
		;

/*
 * This production is used to catch some commonly used
 * un-block-wrapped statements.
 *
 * It is used in the Program and Implication productions.
 */
ErrorBlockOrCall	: Block
		| ErrorInfixOps IMPLY MaybeCall
		    {
			SyntaxError("Implications must be within choice blocks");
			/*
			 * If we're not in a toplevel block, arrange
			 * for a separator to be the next token
			 * shifted by the parser. See the
			 * YY_INPUT macro in lex.l.
			 */
			if (block_depth > 1)
			    _p_co_push_token = ';';
			$$ = NULL;
		    }
		| Call
		    {
			SyntaxError("Bare calls are not allowed");
			$$ = _p_co_new_tuple_3(D_TAG_BLOCK, D_TAG_SEQ_COMP,
					       _p_co_new_list($1));
		    }
		| Var COLONEQ Exp
		    {
			SyntaxError("Bare calls are not allowed");
			$$ = _p_co_new_tuple_3(D_TAG_BLOCK, D_TAG_SEQ_COMP,
					       _p_co_new_list($1));
		    }
		| Var '=' Term
		    {
			SyntaxError("Bare calls are not allowed");
			$$ = _p_co_new_tuple_3(D_TAG_BLOCK, D_TAG_SEQ_COMP,
					       _p_co_new_list($1));
		    }
		;

Implications    : Implication
		    {
			if (D_IS_NIL($1))
			    $$ = $1;
			else
			    $$ = _p_co_new_list($1);
		    }
		| Implications Separator Implication
		    {
			if (D_IS_NIL($3))
			    $$ = $1;
			else
			    $$ = _p_co_append_list($1, $3);
		    }
		;

Guard           : Tests 
		    {
			$$ = UNLIST($1);
		    }
		| DEFAULT 
		    {
			$$ = D_TAG_DEFAULT;
		    }
		;

Tests           : Test 
		    {
			$$ = _p_co_new_list($1);
		    }
		| Tests ',' Test
		    {
			$$ = _p_co_append_list($1, $3);
		    }
		;

Test            : Term InfixOp Term 
		    {
			D_NEW_TUPLE_4($$, D_TAG_GUARD_INFIX_OP, $2, $1, $3);
		    }
		| Var '=' Term
		    {
			if (_p_co_allow_assignment_in_guard)
			{
			    D_NEW_TUPLE_3($$, D_TAG_PRIM,
					  D_TAG_DEFINE,
					  _p_co_cons($1,
						     _p_co_cons($3, _p_co_nil())));
			}
			else
			{
			    $$ = NULL;
			    YYERROR;
			}
		    }
		| Call
		    {
			$$ = _p_co_new_tuple_2(D_TAG_GUARD_CALL, $1);
		    }
		;

InfixOp         : '<' 
		    {
			$$ = D_TAG_LESS_THAN;
		    }
		| '>' 
		    {
			$$ = D_TAG_GREATER_THAN;
		    }
		| LEQ 
		    {
			$$ = D_TAG_LESS_EQUAL;
		    }
		| GEQ 
		    {
			$$ = D_TAG_GREATER_EQUAL;
		    }
		| EQ 
		    {
			$$ = D_TAG_EQUAL;
		    }
		| NEQ 
		    {
			$$ = D_TAG_NOT_EQUAL;
		    }
		| MATCH
		    {
			$$ = D_TAG_MATCH;
		    }
		;

CallForm        : LocalCall 
		| RemoteCall 
		;

RemoteCall      : LocalCall '@' Integer
		    {
			$$ = $1;
			_p_co_set_arg($$, 3, $3);
		    }
		| LocalCall '@' LocalCall
		    {
			$$ = $1;
			_p_co_set_arg($$, 3, $3);
		    }
		| LocalCall '@' Identifier
		    {
			$$ = $1;
			_p_co_set_arg($$, 3, _p_co_new_tuple_4(D_TAG_CALL, $3,
						       _p_co_nil(), _p_co_nil()));
		    }
		;

LocalCall       : QID ':' QID Args 
		    {
			datum *ident = _p_co_new_tuple_3(D_TAG_COLON, $1, $3);
			$$ = _p_co_new_tuple_4(D_TAG_CALL, ident, $4, _p_co_nil());
		    }
		| QID Args 
		    {
			$$ = _p_co_new_tuple_4(D_TAG_CALL, $1, $2, _p_co_nil());
		    }
		| '`' Identifier '`'
		    {
			/* This parses as
			 *    {CALL, {COLON, "_metacall", var}, [], []}
			 */
			
			$$ = _p_co_new_tuple_4(D_TAG_CALL,
			       _p_co_new_tuple_3(D_TAG_COLON,
						 _p_co_new_string("_metacall"),
						 _p_co_new_tuple_3(D_TAG_VAR, $2, _p_co_nil())),
					       _p_co_nil(), _p_co_nil());
		    }
		;

QID             : Identifier 
		| '`' Identifier '`' 
		    {
			$$ = _p_co_new_tuple_3(D_TAG_VAR, $2, _p_co_nil());
		    }
		| '`' '$' Identifier '`' 
		    {
			if (in_quoted_block)
			    $$ = _p_co_new_tuple_3(D_TAG_VAR, _p_co_new_tuple_3(D_TAG_INTERP_VAR, $3, _p_co_nil()), _p_co_nil());
			else
			{
			    SyntaxError("$-quoted procedure calls not allowed outside quoted blocks");
			    $$ = _p_co_nil();
			    YYERROR;
			}
		    }
		| '$' Identifier 
		    {
			if (in_quoted_block)
			    $$ = _p_co_new_tuple_3(D_TAG_INTERP_VAR, $2, _p_co_nil());
			else
			{
			    SyntaxError("$-quoted procedure calls not allowed outside quoted blocks");
			    $$ = _p_co_nil();
			    YYERROR;
			}
		    }
		;

Args            : '(' ')' 
		    {
			$$ = _p_co_nil();
		    }
		| '(' ArgList ')'
		    {
			$$ = UNLIST($2);
		    }
		;

ArgList         : Term 
		    {
			$$ = _p_co_new_list($1);
		    }
		| ArgList ',' Term
		    {
			$$ = _p_co_append_list($1, $3);
		    }
		;

Term		: SymbolicExp
		| Exp
		;

SymbolicExp	: String
		| List
		| Tuple
		| ModProc
		| BlockQuote { in_quoted_block = 1; } 
			QuotedBlock { $$ = $3; in_quoted_block = 0; }
		;

QuotedBlock	: ModProc BlockQuote
		    {
			$$ = _p_co_new_quoted_block($1);
		    }
		| Element BlockQuote
		    {
			$$ = _p_co_new_quoted_block($1);
		    }
		;

ModProc		: QID ':' QID
		    {
			$$ = _p_co_new_tuple(3);
			_p_co_set_arg($$, 0, D_TAG_COLON);
			_p_co_set_arg($$, 1, $1);
			_p_co_set_arg($$, 2, $3);
		    }
		;


BlockQuote	: '^'
		;

List            : '[' ']' 
		    {
			$$ = _p_co_new_tuple(2);
			_p_co_set_arg($$, 0, D_TAG_TUPLE);
			_p_co_set_arg($$, 1, _p_co_nil());
		    }
		| '[' ElementsAsList ']'
		    {
			$$ = D_LHEAD($2);
		    }
		| '[' ElementsAsList '|' Term ']'
		    {
			*(D_LTAIL($2)) = $4;
			$$ = D_LHEAD($2);
		    }
		;

ElementsAsList	: Elements
		    {
			int len, i;
			datum *d, **tail, *new, *new2;
			datum *head;

			tail = &head;

			for (d = REAL_UNLIST($1); !D_IS_NIL(d); d = D_CDR(d))
			{
			    new2 = _p_co_new_tuple(2);
			    new = _p_co_new_tuple_2(D_TAG_TUPLE,
						    new2);
			    
			    *tail = new;
			    
			    _p_co_set_arg(new2, 0, D_CAR(d));

			    tail = &D_CDR(new2);
			}
			*tail = _p_co_new_tuple_2(D_TAG_TUPLE, _p_co_nil());

			$$ = _p_co_new_list_0();
			D_LHEAD($$) = head;
			D_LTAIL($$) = tail;
		    }
    


Tuple           : '{' Elements '}' 
		    {
			int len, i;
			datum *d, *tup;


			len = 0;
			for (d = REAL_UNLIST($2); !D_IS_NIL(d); d = D_CDR(d))
			    len++;

			tup = _p_co_new_tuple(len);

			i = 0;
			for (d = REAL_UNLIST($2); !D_IS_NIL(d); d = D_CDR(d))
			{
			    _p_co_set_arg(tup, i, D_CAR(d));
			    i++;
			}
			
			$$ = _p_co_new_tuple(2);
			_p_co_set_arg($$, 0, D_TAG_TUPLE);
			_p_co_set_arg($$, 1, tup);
		    }
		| '{' '}' 
		    {
			$$ = _p_co_new_tuple(2);
			_p_co_set_arg($$, 0, D_TAG_TUPLE);
			_p_co_set_arg($$, 1, _p_co_nil());
		    }
		;

Elements        : Term 
		    {
			$$ = _p_co_new_list($1);
		    }
		| Elements ',' Term
		    {
			$$ = _p_co_append_list($1, $3);
		    }
		;

Exp		: BinaryExp
		| UnaryExp
		| '(' Exp ')' 
		    {
			$$ = $2;
		    }
		| Number
		| Var
		| FunctionCall
		;

FunctionCall	: CallForm
		    {
			if (!_p_co_backward_compatibility_flag)
			{
			    $$ = $1;
			}
			else
			{
			    /*
			     * We have {CALL, ident, arglist, anno}
			     *
			     * and we want to create {"name", arg1, arg2, ...}
			     * or {":", "mod", {"name", arg1, arg2, ...}}
			     *
			     */
			    
			    datum *tup, *d, *result;
			    datum *ident, *args;
			    int len, i;
			    int have_length = 0;

			    ident = D_ARG($1, 1);
			    args = D_ARG($1, 2);

			    len = 0;
			    for (d = REAL_UNLIST(args);
				 !D_IS_NIL(d); d = D_CDR(d))
				len++;

			    /*
			     * len is the length of the argument list
			     */
			    
			    tup = _p_co_new_tuple(len + 1);

			    /* We are creating the {"name", arg1, arg2, ...} tuple in
			     * tup.
			     *
			     * Result is the tuple that will be returned (wrapped in
			     * a TAG_TUPLE). Depending on whether we have p() or
			     * m:p(), we set result to either tup or mp.
			     */

			    if (D_IS_STRING(ident))
			    {
				/* We check for occurrences of the length() primitive
				 * here, since it gets real tough later on
				 * (since {"length", f} is exactly the same as
				 * length(f).
				 */
				D_ARG(tup, 0) = _p_co_new_tuple_2(D_TAG_STRING_CONST,
								  ident);
				    
				if (strcmp(D_SVAL(ident), "length") == 0 &&
				    len == 1)
				{
				    args = REAL_UNLIST(args);
				    
				    /* Rewrite the length call as an expression. */
				    $$ = _p_co_new_tuple_3(D_TAG_EXP,
							   D_TAG_LENGTH,
							   _p_co_cons(D_ARG(args, 0),
								      _p_co_nil()));
				    have_length = 1;
				}
				else
				{
				    /* We return tup */
				    result = tup;
				}
			    }
			    else if (D_IS_TUPLE(ident) &&
				     D_NARGS(ident) == 3 &&
				     D_IS_TAG(D_ARG(ident, 0)) &&
				     D_IVAL(D_ARG(ident, 0)) == TAG_COLON)
			    {
				datum *mp = _p_co_new_tuple(3);

				/*
				 * Create mp to be the tuple
				 * {":", "mod", tup}
				 */

				D_ARG(mp, 0) = _p_co_new_tuple_2(D_TAG_STRING_CONST,
							      _p_co_new_string(":"));
				D_ARG(mp, 1) = _p_co_new_tuple_2(D_TAG_STRING_CONST,
							      D_ARG(ident,1));
				D_ARG(mp, 2) = _p_co_new_tuple_2(D_TAG_TUPLE,
								 tup);

				/*
				 * and fill in tup[0] with "name"
				 */

				D_ARG(tup, 0) = _p_co_new_tuple_2(D_TAG_STRING_CONST,
								  D_ARG(ident,2));

				/* We return mp */
				result = mp;
			    }

			    if (!have_length)
			    {
				
				/*
				 * Fill in the arguments of tup
				 */
				
				i = 0;
				for (d = REAL_UNLIST(args);
				     !D_IS_NIL(d); d = D_CDR(d))
				{
				    _p_co_set_arg(tup, i+1, D_CAR(d));
				    i++;
				}
				$$ = _p_co_new_tuple_2(D_TAG_TUPLE,
						       result);
			    }
			}
		    }
		;

BinaryExp	: Exp '+' Exp
		    {
			$$ = _p_co_new_tuple_3(D_TAG_EXP,
					      D_TAG_PLUS,
					      _p_co_cons($1,
							 _p_co_cons($3, _p_co_nil())));
		    }
		| Exp '-' Exp
		    {
			$$ = _p_co_new_tuple_3(D_TAG_EXP,
					       D_TAG_MINUS,
					       _p_co_cons($1,
							  _p_co_cons($3, _p_co_nil())));
		    }
		| Exp '*' Exp
		    {
			$$ = _p_co_new_tuple_3(D_TAG_EXP,
					       D_TAG_TIMES,
					       _p_co_cons($1,
							  _p_co_cons($3, _p_co_nil())));
		    }
		| Exp '/' Exp
		    {
			$$ = _p_co_new_tuple_3(D_TAG_EXP,
					       D_TAG_DIV,
					       _p_co_cons($1,
							  _p_co_cons($3, _p_co_nil())));
		    }
		| Exp '%' Exp
		    {
			$$ = _p_co_new_tuple_3(D_TAG_EXP,
					       D_TAG_MODULO,
					       _p_co_cons($1,
							  _p_co_cons($3, _p_co_nil())));
		    }
		;

UnaryExp	: '-' Exp %prec UNARY
		    {
			datum *zero;
			datum *a0, *a1;

			a0 = D_ARG($2, 0);
			a1 = D_ARG($2, 1);

			if (D_IS_TAG(a0) &&
			    (D_IVAL(a0) == TAG_INTEGER_CONST ||
			     D_IVAL(a0) == TAG_DOUBLE_CONST) &&
			    D_IS_STRING(a1))
			{
			    /*
			     * We have a negated constant. Stash a
			     * '-' at the beginning of the string.
			     */
			    
			    char *str, *new;

			    str = D_SVAL(a1);
			    new = (char *) malloc(strlen(str) + 2);
			    strcpy(new, "-");
			    strcat(new, str);
			    D_SVAL(a1) = new;
			    free(str);
			    $$ = $2;
			}
			else
			{
			    zero = _p_co_new_tuple_2(D_TAG_INTEGER_CONST,
						     _p_co_new_string("0"));
			    $$ = _p_co_new_tuple_3(D_TAG_EXP,
						   D_TAG_MINUS,
						   _p_co_cons(zero,
							      _p_co_cons($2, _p_co_nil())));
			}
		    }
		;

Number		: Double
		| Integer
		;

Double		: FLOATINGconstant
		    {
			$$ = _p_co_new_tuple(2);
			_p_co_set_arg($$, 0, D_TAG_DOUBLE_CONST);
			_p_co_set_arg($$, 1,  $1);
		    }

		;

String		: STRING
		    {
			$$ = _p_co_new_tuple(2);
			_p_co_set_arg($$, 0, D_TAG_STRING_CONST);
			_p_co_set_arg($$, 1,  $1);
		    }

Integer		: IntegerForm
		    {
			$$ = _p_co_new_tuple(2);
			_p_co_set_arg($$, 0, D_TAG_INTEGER_CONST);
			_p_co_set_arg($$, 1,  $1);
		    }
			
IntegerForm	: INTEGERconstant 
		| CHARACTERconstant
		| OCTALconstant
		| HEXconstant
		;	

Var             : Identifier Subscript 
		    {
			D_NEW_TUPLE_3($$, D_TAG_VAR,
				      $1, $2);
			_p_co_check_var_for_temp_max($1);
		    }
		| '$' Identifier Subscript
		    {
			if (in_quoted_block)
			{
			    D_NEW_TUPLE_3($$, D_TAG_INTERP_VAR,
					  $2, $3);
			}
			else
			{
			    SyntaxError("$vars not allowed outside quoted blocks");
			    $$ = _p_co_nil();
			    YYERROR;
			}
			_p_co_check_var_for_temp_max($2);
		    }
		;

/* This production lets us use the reserved word "in" as an
 * identifier.
 */

Identifier	: ID 
		    {
			$$ = $1;
		    }
		| IN 
		    {
			$$ = _p_co_new_string("in"); 

		    }
		| OVER
		    {
			$$ = _p_co_new_string("over"); 
		    }
		;

Subscript       : /* empty */
		    {
			$$ = _p_co_nil();
		    }
		| '[' Exp ']' 
		    {
			$$ = _p_co_new_tuple_2(D_TAG_TUPLE,
				   _p_co_new_tuple_2($2,
					      _p_co_new_tuple_2(D_TAG_TUPLE,
								_p_co_nil())));
		    }
		;

%%

int yyerror(s)
char *s;
{
    SyntaxError(s);
}


