#include "co_parse.h"

main(argc, argv)
int argc;
char **argv;
{
    FILE *fp;
    char *file;
    datum *tree;
    int had_errors;
    int error_count;
    int gmax;
    extern char *getenv();
    int print_tree;
    char *name;
    extern int yydebug;
    extern char *rindex();
    int tokenize;

    if (getenv("BACK"))
    {
	int one = 1;
	_p_co_set_backward_compatibility(&one);
    }

    name = rindex(argv[0], '/');
    if (name)
	name++;
    else
	name = argv[0];
    if (strcmp(name, "check") == 0)
	print_tree = 0;
    else
	print_tree = 1;

    if (strcmp(name, "dparse") == 0)
	yydebug = 1;
    else
	yydebug = 0;

    if (strcmp(name, "tokenize") == 0)
	tokenize = 1;
    else
	tokenize = 0;

    if (argc == 1)
    {
	file = "stdin";
	fp = stdin;
    }
    else
    {
	char buf[1024];

	file = argv[1];

	sprintf(buf, "/lib/cpp -DPCN %s", file);
	fp = popen(buf, "r");
	if (fp == NULL)
	{
	    perror("popen");
	    exit(1);
	}
    }

    if (tokenize)
    {
	int tok;
	char tok_buf[100];

	while ((tok = yylex()) != 0)
	{
	    if (tok >= 258 && tok <= 280)
		sprintf(tok_buf, "%d", tok);
	    else
	    {
		tok_buf[0] = tok;
		tok_buf[1] = 0;
	    }

	    if (tok == ID || tok == CHARACTERconstant ||
		tok == INTEGERconstant)
		printf("Got token %s %s\n", tok_buf, yylval->data.sval);
	    else
		printf("Got token %s\n", tok_buf);
	}
	
    }
    else
    {
	_p_co_init_parser(file,  &fp);
	
	do
	{
	    _p_co_parse_one_form(&tree, &had_errors);
	    
	    if (tree && print_tree)
	    {
		printf("Got parse tree:\n");
		_p_co_print(tree);
		_p_co_free_parse_tree(&tree);
	    }
	}
	while (tree);
	
	_p_co_get_parse_error_count(&error_count);
	_p_co_get_global_temp_max(&gmax);
	printf("Parse had %d errors, gmax=%d\n", error_count, gmax);
    }
}

exit_from_c(rc)
int rc;
{
    exit(rc);
}
