#TOP_OF_FILE#
#
# Do not insert code above the TOP_OF_FILE line. It will be removed in the
# installation process

($prog = $0) =~ s,.*/,,;    

#
# node-control is a script that runs as a daemon on each machine that
# worker nodes will be running on.  The currently active machines
# can be determined by examining the files in directory $HOME/.pcn_control.
# Files in this directory are named with the hostname of the machine,
# and contain the port being listened on.    
#
# The script host-control will be available to send commands to each 
# of the active nodes (to kill off processes, say).
#

# Variables:
#
#	$ENV'source_dir	directory in which control scripts are found
#
#	$config_dir	directory in which .pcn_control is found
#
#	$timeout	how long before an idle node-control is timed out
#
#	$debug		debug flag
#

#
#

if (!$ENV'source_dir)
{
    print "Hmm. Source directory not set. Required perl files may not be found\n";
}
else
{
    push(@INC, $ENV'source_dir);
}

sub load_file
{
    local($file) = @_;
    if (!do $file)
    {
	if ($@)
	{
	    die "host-control: load-file $file failed: \n$@";
	}
	else
	{
	    if (do "$file.fallback")
	    {
		warn "host-control: perl source '$file' not found, using fallback\n";
	    }
	    else
	    {
		die "host-control: perl source '$file' not found\n";
	    }
	}
    }
}

&load_file("server.pl");
&load_file("utils.pl");
&load_file("getopts.pl");

$rcs_version_string = '$Revision: 2.8 $';
($rcs_version) = ($rcs_version_string =~ /Revision:\s*(\S+)/);

# The node commands are defined here:
&load_file("node-cmds.pl");

print "\n" if -t;
print "PCN Node control version $rcs_version\n";
print "\n" if -t;

&process_args;

&setup_handlers;

&initialize;

&connect_to_hosts;

$interactive = -t;


$| = 1;

if (!$interactive)
{
    print TTY "Forking...\n";
    fork && exit;
}

&redirect_output;

&run;

-f $logfile && unlink($logfile);
exit(0);

sub process_args
{
    &Getopts("dh:p:c:");
    
    $verbose = $debug = $opt_d;

    if ($opt_h)
    {
	die "Must specify port with -p\n" unless $opt_p;
	$host_machine = $opt_h;
	$host_port = $opt_p;
    }
    elsif ($opt_p)
    {
	die "Must specify host with -h\n";
    }

}

sub setup_handlers
{
    $SIG{INT} = sighandler;
    $SIG{TERM} = sighandler;
    $SIG{HUP} = sighandler;
    $SIG{ALRM} = timeout;

    # On second thought, I'm disabling the following code, replacing it
    # with a waitpid in the EOF handling code for the pcn child process.

    # This has some problems with `command` in 3.44. I know it works in
    # 4.010, so...

#    if ($] >= 4.010)
#    {
#	print "Enabling reaper\n";
#	$SIG{CHLD} = reaper;
#    }
}

sub initialize
{
    $timeout = 60 * 60;

    $hostname = &gethostname;

    print "This host is $hostname\n" if $debug;

    #
    # Directory to find .pcn_control file
    #
    $control_dir = "$ENV{HOME}/.pcn_control";
    
    $control_dir = $ENV{PCN_CONTROL_DIR} if $ENV{PCN_CONTROL_DIR};
    
    print "Control dir is $control_dir\n" if $verbose;
    
    if (!-d $control_dir)
    {
	print "Making control directory $control_dir\n";
	if (!mkdir($control_dir, 0755))
	{
	    die "Can't mkdir $control_dir: $!\n";
	}
    }

    $control_dir = $opt_c if $opt_c;
    
    -d $control_dir || mkdir($control_dir, 0755) || 
	die "Can't mkdir $control_dir: $!\n";
    
    $port = &read_node_file($hostname);
    if ($port)
    {
	print "Host file for $hostname exists, trying to connect to port $port\n" if $verbose;
	eval "&server'connect(\$hostname, \$port, *S)";
	if ($@ =~ /connection\s+refused/i)
	{
	    close(S);
	    print "Good. Server not running\n" if $verbose;
	}
	elsif ($@)
	{
	    die "Error during connect: $@";
	}
	else
	{
	    die "Server already running on $hostname\n";
	}
    }

    $control_handle = "CONTROL_PORT";
    $control_port = eval "&server'createAnon(*$control_handle)";
    print "Listening on port $control_port on host $hostname\n";
    &write_node_file($hostname, $control_port);

    %connections = ();
    $next_handle = "CONNECT001";
}

sub connect_to_hosts
{
#
# Try to connect to any hosts running
#
    local($connected);
    &dir_exists($control_dir, "$control_dir/hosts");

    opendir(DIR, "$control_dir/hosts") || die "Can't opendir $control_dir: $!\n";
    while ($name = readdir(DIR))
    {
	next if $name =~ /^\./;

	$host = $name;
	
	$port = &read_host_file("$name");
	
	next unless $port;

	print "Got host on $host/$port\n";
	
	if (!&connect_to_host($host, $port))
	{
	    print "Couldn't connect to $host/$port\n";
	    &unlink_host_file("$name");
	}
	else
	{
	    $connected = 1;
	}
    }
    closedir(DIR);

    if ($host_machine && !grep($_ eq $host_machine, values %connections))
    {
	if (&connect_to_host($host_machine, $host_port))
	{
	    if (! -f "$control_dir/hosts/$host_machine")
	    {
		&write_host_file("$host_machine", $host_port);
	    }
	}
    }

    if (-t)
    {
	print "Connections are:\n" if $verbose;
	while (($host, $port) = each(%connections))
	{
	    print "\t$host $port\n" if $verbose;
	}
	local(@hosts) = values(%connections);
	if (@hosts)
	{
	    print SAVED_STDOUT "Connected to hosts on @hosts\n";
	}
    }
}

sub connect_to_host
{
    local($host, $port) = @_;
    
    $handle = $next_handle;
    
    eval "&server'connect(\$host, \$port, *$handle)";
    if ($@ =~ /connection\s*refused/i)
    {
	print "Connection to $host/$port refused\n";
	return undef;
    }
    elsif ($@)
    {
	chop($@);
	die "Connect to $host/$port failed: $@\n";
    }
    
    print "Connected to host\n" if $verbose;
    
    select($handle); $| = 1;
    select(STDOUT);

    local($line) = scalar(<$handle>);
    chop($line);
    print "Got banner '$line'\n" if $verbose;

    print $handle "Hello. Connected to $prog on <$hostname/$control_port>\n" || die "print";
    
    $next_handle++;
    $connections{$handle} = $host;
    return 1;
}

sub run
{
    local($done);

    #
    # Now just loop in an accept, processing connections one at a time
    #
    
    $done = 0;
    
    while (!$done)
    {
	alarm($timeout);
	@ready = &select($control_handle, keys %connections, keys %pcn_pids );
	
	print "Got ready '", join(',', @ready), "'\n";
	
	for $handle (@ready)
	{
	    if ($handle eq $control_handle)
	    {
		#
		# The only thing that connects to a node is a host
		#
		$newhandle = $next_handle++;
		do {
		    print "Trying to accept\n";
		    @from_addr =
			eval "&server'accept(*$newhandle, *$control_handle)";
		} while ($@ && $@ =~ /Interrupted system call/);
		
		print "accepted\n";
		
		select($newhandle); $| = 1;
		select(STDOUT);

		local($host) = &full_hostname(join('.', @from_addr));
		
		print "Accepted connection from $host\n";
		
		$connections{$newhandle} = $host;
		print $newhandle "Hello. Connected to $prog on <$hostname/$control_port>\n" || die "print";

		&flush($newhandle);

		print "Waiting...\n" if $verbose;
		local($hport) = scalar(<$newhandle>);

		print "Got host port $hport\n" if $verbose;
		&write_host_file($host, $hport);
	    }
	    elsif ($pcn_pids{$handle})
	    {
		print "got pcn output on $handle\n";
		&process_pcn_output($handle);
	    }
	    else
	    {
		print "got message on $handle\n";
		&process_mesg($handle);
	    }
	}
    }

    close($control_handle);
    &unlink_node_file($hostname);
}

#
# Timeout handler
#
sub timeout
{
    &broadcast("start-output:\n");
    &broadcast("node-control on $hostname timing out\n.\n");
    &unlink_node_file($hostname);
    -f $logfile && unlink($logfile);
    exit(0);
}


#
# Process a connection on CONN_FD
#
sub process_mesg
{
    local($handle) = @_;

    print "waiting in process_mesg...\n";
    $_ = <$handle>;
    print "got mesg\n";

    if (!$_)
    {
	print "EOF on $handle\n";
	close($handle);
	delete $connections{$handle};
	return;
    }
    
    chop;
    return if (/^\s*$/);
    ($cmd, @args) = split;
    print "got cmd '$cmd', ", scalar(@args), " args: ", join(', ', @args), "\n";
    
    if ($func = $cmds{$cmd})
    {
	print "Evaling func '$func'\n";
	$conn_handle = $handle;
	$rc = eval "&$func(\@args)";
	die "Command failed: $@\n" if $@;
	print "Command finishes returning $rc\n";
	if ($rc)
	{
	    print $handle "Node-control on $hostname/$control_port exiting at ",
	                  &ltime(time), "\n";
	    print $handle ".\n";
	    close($handle);
	    delete $connections{$handle};
	    return;
	}
    }
    else
    {
	print $handle "Unknown command $cmd\n";
    }
    print $handle ".\n";
    &flush($handle);
}

sub broadcast
{
    local($handle);

    for $handle (keys %connections)
    {
	print "sending on handle $handle host $connections{$handle}\n";
	print $handle @_;
	&flush($handle);
    }
}

sub sighandler
{
    local($sig) = @_;

    print "Got signal $sig\n";
    &broadcast("start-output:\n");
    &broadcast("Node-control on $hostname/$control_port exiting at ",
	       &ltime(time), "\ndue to signal $sig\n");
    &unlink_node_file($hostname);
    -f $logfile && unlink($logfile);
    exit(0);
}

sub reaper
{
    print "Reaper called...\n";

    local($pid) = wait;
    print "Child $pid had died\n";
}
    
sub redirect_output
{
    if (!$debug)
    {
	$logfile = "/tmp/node-control.$$";
	open(LOG, ">$logfile") || die "Can't open logfile $logfile: $!\n";
	if (-t STDOUT)
	{
	    open(SAVED_STDOUT, ">&STDOUT") || warn "Can't reopen stdout: $!\n";
	    select(SAVED_STDOUT); $| = 1; select(STDOUT);
	}
	else
	{
	    open(SAVED_STDOUT, ">/dev/null");
	}
	open(STDOUT, ">&LOG") || die "Can't reopen stdout: $!\n";
	open(STDERR, ">&LOG") || die "Can't reopen stderr: $!\n";
	select(STDERR); $| = 1;
	select(LOG); $| = 1;
	select(STDOUT); $| = 1;
    }
    else
    {
	print "DEBUGGING\n";
	if (-t STDOUT)
	{
	    open(SAVED_STDOUT, ">&STDOUT") || warn "Can't reopen stdout: $!\n";
	    select(SAVED_STDOUT); $| = 1; select(STDOUT);
	}
	else
	{
	    open(SAVED_STDOUT, ">/dev/null");
	}
    }
}

# Local Variables: ***
# mode: cperl ***
# End: ***

