#TOP_OF_FILE#
#
# Do not insert code above the TOP_OF_FILE line. It will be removed in the
# installation process
    
($prog = $0) =~ s,.*/,,;    

if (!$ENV'source_dir)
{
  print "Hmm. Source directory not set. Required perl files may not be found\n";
}
else
{
    if (!-d $ENV'source_dir)
    {
	print "Hmm. Source directory $ENV'source_dir does not exist. Required perl files may not be found\n";
    }
    push(@INC, $ENV'source_dir);
}
    
&load_file("getopts.pl");
&load_file("errno.ph");

&Getopts("v");

$verbose = $opt_v;

#
# Directory to find .pcn_control file
#
$control_dir = "$ENV{HOME}/.pcn_control";

$control_dir = $ENV{PCN_CONTROL_DIR} if $ENV{PCN_CONTROL_DIR};

print "Control dir is $control_dir\n" if $verbose;

if (!-d $control_dir)
{
    print "Making control directory $control_dir\n";
    if (!mkdir($control_dir, 0755))
    {
	die "Can't mkdir $control_dir: $!\n";
    }
}


#
# List of pending connections
#
%pending = ();

&load_file("server.pl");
&load_file("utils.pl");
&load_file("alias.pl");

# The host commands are defined here:
&load_file("host-cmds.pl");

$hostname = &gethostname;

print "This host is $hostname\n" if $verbose;

#
#
$rcs_version_string = '$Revision: 2.8 $';
($rcs_version) = ($rcs_version_string =~ /Revision:\s*(\S+)/);
print "\n";
print "PCN Host control version $rcs_version\n";
if ($host_control_guru)
{
    print "Guru mode: eval enabled\n";
}
print "\n";

#
# Set up a port to listen to so that the nodes can connect to me upon startup
#

$listen_handle = "LISTEN";
$listen_port = eval "&server'createAnon(*$listen_handle)";
print "Listening on $listen_port\n";

&write_host_file($hostname, $listen_port);

$SIG{INT} = handler;
$SIG{TERM} = handler;
$SIG{HUP} = handler;

%node_connections = ();
%node_connections_rev = ();
%cmd_connections = ();
%cmd_connections_rev = ();
$cmd_conn_idx = 0;

%misc_connections_funcs = ();
%misc_connections_data = ();

$connection_handle = "CONNECT001";

&setup_connections;

&command_initialize;

#
# Read the .host-control.rc file
#

&read_rc_file;

$| = 1;

$done = 0;

$needprompt=1;
while (!$done)
{
    #
    # This is fun. Wrap the command loop up in an eval so that
    # we can catch signals (namely keyboard interrupt) safely.
    #
    # Lotsa backslashes. Gotta escape $, ", @, \n, %
    #
    eval <<ENDOFEVAL;
    
    print \"HC> \" if \$needprompt;
    \$needprompt = 0;
    \$neednl = 1;
    
    \@ready = &select(\"STDIN\",
		      keys \%misc_connections_funcs,
		      \$listen_handle,
		      values \%node_connections,
		      values \%cmd_connections);

    for \$handle (\@ready)
    {
	if (\$handle eq \"STDIN\")
	{
	    \$done = &process_keyboard();
	}
	elsif (\$handle eq \$listen_handle)
	{
	    local(\$handle) = \$connection_handle++;
	    local(\@addr);
	    
	    \@addr = eval \"&server'accept(*\$handle, *\$listen_handle)\";
	    die \"Accept failed: \$@\\n\" if \$@;
#	    print \"Got connection from \@addr\\n\";
	    &process_connection(\$handle, \@addr);
	}
	elsif (\$cmd_connections_rev{\$handle})
	{
    	    &process_cmd_mesg(\$handle);
	}
	elsif (\$misc_connections_funcs{\$handle})
	{
	    local(\$func) = \$misc_connections_funcs{\$handle};
	    &\$func(\$handle, split(/$;/, \$misc_connections_data{\$handle}));
	}
	else
	{
	    &process_node_mesg(\$handle);
	}
    }
ENDOFEVAL

    if ($@ =~ /got signal INT/)
    {
	print "\nInterrupt\n";
    }
    elsif ($@ =~ /got signal\s*(\S+)/)
    {
	$done = 1;
	print "\nExiting on signal $1\n";
    }
    elsif ($@)
    {
	chop($@);
	warn "Eval failed: <$@>\n" unless $@ =~ /host-control got signal/;
	$done = 1;
    }
}

&exit;

sub exit
{
    local($ans);
    local(@conns);

    @conns = keys %node_connections;
    if (@conns > 0)
    {
	if ($vars{"kill-nodes-on-exit"} eq "prompt")
	{
	    do {
		print "Kill node-control daemons before exiting? ";
		$kill = <STDIN>;
		chop($kill);
	    } until $kill =~ /^[ynYN]/;
	}
	else
	{
	    $kill = $vars{"kill-nodes-on-exit"};
	}
	
	if ($kill =~ /^[Yy]/)
	{
	    &send_command(all, "kill");
	}
	else
	{
	    &send_command(all, "quit");
	}
    }
    &unlink_host_file($hostname);
    exit(0);
}

sub handler
{
    local($sig) = @_;

    die "$prog got signal $sig\n";
}

sub process_connection
{
    local($handle, @addr) = @_;
    local($host, $port, $fileport);
    local($line);

    $host = &hostname_from_addr(@addr);

    $host = join(".", @addr) unless $host;

    &termout("Got connection from host $host\n");

    &flush($handle);
    print $handle "You have connected to $prog on <$hostname/$listen_port>\n";
    &flush($handle);

    $line = <$handle>;
    chop $line;
    print "got line '$line'\n" if $verbose;
    if ($line =~ /node-control/i)
    {
	&termout("connection is from a node\n") if $verbose;
	$node_connections{$host} = $handle;
	$node_connections_rev{$handle} = $host;

	local($h, $p);

	if (($h, $p) = ($line =~ m#<(.*)/(\d+)>#))
	{
	    print "banner got '$h' '$p'\n" if $verbose;
	    if ($h ne $host)
	    {
		&termout("Ack! hostname in banner ($h) does not match hostname from accept ($host)\n");
	    }
	    else
	    {
		$ports{$host} = $p if $p;
	    }
	}
    }
    else
    {
	if ($line =~ /interactive/i)
	{
	    print "Setting interactive for $host $handle\n" if $verbose;
	    $interactive{$handle} = 1;
	    print $handle "HC> ";
	    &flush($handle);
	}
	elsif ($line =~ /PCN.*\s+arch=(\S+).*\s+het=(\d+)(\s*listen_port=(\d+))?/)
	{
	    local(%enabled, $n_enabled);

	    $n_enabled = &find_enabled_hosts(*enabled);
	    
	    $pcnarch = $1;
	    $pcnhet = $2;
	    $pcn_listen_port = $4;
	    $pcn_host = $host;
	    print "Got PCN startup arch='$pcnarch' het='$pcnhet' port='$pcn_listen_port'\n" if $verbose;
	    print "Received PCN startup request from $host\n";
	    print $handle "OK\n";

	    &flush($handle);
	    print "sent ack\n" if $verbose;
	    local($old) = $suppress_command_output;
	    $suppress_command_output = 1;
	    if ($pcnhet)
	    {
		&enable("all");
	    }
	    else
	    {
		local($host, $hostarch, @a);

		for $host (keys %node_connections)
		{
		    @a = &send_command_to_host_collecting_reply($host, "arch");
		    $hostarch = $a[0];

		    # Disable all hosts that are not of the right architecture

		    if ($hostarch ne $pcnarch)
		    {
			&enable_host($host, "no")
			    if (defined($enabled{$host}));
		    }
		}
	    }
	    $suppress_command_output = $old;		
	}
	&termout("connection is cmd\n") if $verbose;
	local($idx) = $cmd_conn_idx++;
	local($h) = "$host:$idx";
	$cmd_connections{$h} = $handle;
	$cmd_connections_rev{$handle} = $h;
    }

    delete $pending{$host} if $pending{$host};

    select($handle); $| = 1;
    select(STDOUT);
}

    
sub process_keyboard
{
    $_ = <STDIN>;
    return 1 unless $_;
    chop;

    s/^\s+//;

    s/^!(\S)/! $1/;

    $neednl = 0;
    local($rc) = &execute_command($_);
    $needprompt = 1;
    $rc;
}

sub execute_command
{
    local($line) = @_;
    local($cmd, @args, $func, $rc);

    $rc = 0;

    $_ = $line;

    return if (/^\s*$/);

    ($cmd, @args) = split;

    $cmd = &expand_alias($cmd);

    $func = $cmds{$cmd};

    if (!$func)
    {
	local($abbrev) = $abbrevs{$cmd};
	if ($abbrev =~ /:/)
	{
	    $abbrev =~ s/:/ /g;
	    &termout("Ambiguous abbreviation: $abbrev\n");
	    
	}
	else
	{
	    $func = $cmds{$abbrev};
	}
    }

    if ($func)
    {
#	print "Executing function $func\n";
	$rc = eval "&$func(\@args)";
	if ($@)
	{
	    warn "Command failed: $@\n";
	}

#	print "Command returns $rc\n";
    }
    else
    {
	&termout("Command $cmd not found\n");
    }
    return $rc;
}

sub process_node_mesg
{
    local($handle) = @_;
    local($name, $host);

    $host = $node_connections_rev{$handle};

    if (!$host)
    {
	&termout("\nCouldn't find host for handle $handle\n");
	return;
    }

    while (1)
    {
	$_ = <$handle>;
	
	if (!$_) {
	    if ($host) {
		&disconnect($host);
	    }
	    else {
		close($handle);
	    }
	    return;
	}

	chop;

	print "+++PMSG '$_'\n" if $verbose;

	if (/^cmd:\s*(\S+)\s*(.*)$/)
	{
	    &termout("Nodes can't run commands any more\n");
	    last;
#	    local(@args) = split(/\s+/,$2);
#	    &process_host_cmd($handle, $host, $1,@args);
	}
	elsif (/^start-output:/)
	{
	    &process_node_output($handle, $host, $_);
	    last;
	}
	else
	{
	    last if (/^\.$/);
	    &termout("bad node message from $host $handle\n");
	    &termout("$_\n");
	}
    }
}

sub process_cmd_mesg
{
    local($handle) = @_;
    local($name, $host);

    $host = $cmd_connections_rev{$handle};

    if (!$host)
    {
	&termout("\nCouldn't find host for handle $handle\n");
	return;
    }

    while (1)
    {
	$_ = <$handle>;
	
	if (!$_)
	{
	    if ($host)
	    {
		&disconnect($host);
	    }
	    else
	    {
		close($handle);
	    }
	    return;
	}

	chop;

	s/\r//;

	print "+++PCMSG '$_'\n" if $verbose;

	if ($interactive{$handle})
	{
	    print "Got interactive cmd $_\n" if $verbose;
	    last if ($_ =~ /\s*!/);
	    local($old) = select($handle);
	    &execute_command($_);
	    print "HC> ";
	    $| = 1;
	    select($old);
	    last;
	}
	elsif (/^cmd:\s*(\S+)\s*(.*)$/)
	{
	    local(@args) = split(/\s+/,$2);
	    &process_host_cmd($handle, $host, $1,@args);
	}
	elsif (/^start-output:/)
	{
	    &termout("shouldn't get start-output on node pipe\n");
	    last;
	}
	else
	{
	    last if (/^\.$/);
	    &termout("bad cmd message from $host $handle\n");
	    &termout("$_\n");
	}
    }
}

sub process_node_output
{
    local($handle, $host, $initial_line) = @_;
    print "Start PNO from ", caller, ": $initial_line\n" if $verbose;
    &termout("Output from node $host:\n") if $vars{"show-output"} eq "yes";
    while (1)
    {
	$_ = <$handle>;
	
	if (!$_)
	{
	    if ($host)
	    {
		&disconnect($host);
	    }
	    else
	    {
		close($handle);
	    }
	    return;
	}

	chop;

	print "PNO: $_\n" if $verbose;

	if (/^cmd:\s*(\S+)\s*(.*)$/)
	{
	    &termout("Ack! shouldn't get cmd: from node $handle $host\n");
	    last;
#	    local(@args) = split(/\s+/,$2);
#	    &process_host_cmd($handle, $host, $1,@args);
	}
	elsif (/^start-output:/)
	{
	    &process_node_output($handle, $host, $_);
	    last;
	}
	else
	{
#	    print "got '$_'\n";
	    last if (/^\.$/);
	    if ($vars{"collect-output"} eq "yes")
	    {
		$node_output{$host} .= $_ . "\n";
	    }
	    &termout("$_\n") if $vars{"show-output"} eq "yes";

	    if (/WORKER:\s*command\s+failed:\s+exec\s+failed:\s+(.*)\s*$/i)
	    {
		&termout("Exec of worker failed, notifying pcn\n");
		&notify_pcn_worker_failed($host, $pcn_host, $pcn_listen_port, $1);
	    }
	}
    }
}


	
sub process_host_cmd
{
    local($handle, $host, $cmd, @args) = @_;

    print "Got cmd $cmd ", scalar(@args), " args: '@args'\n" if $verbose;

    if ($cmd eq "port")
    {
	local($fileport, $port);

	$port = $args[0];

	if (!$port)
	{
	    print $handle "Invalid port cmd\n";
	}
	else
	{
	
	    $fileport = &read_node_file($host);
	    if (defined($fileport) && $fileport != $port)
	    {
		&termout("Ack! node file for $host has a different port $fileport\n");
	    }
	    &write_node_file($host, $port);
	    
	    $ports{$host} = $port;
	}
    }
    elsif ($cmd eq "load-config")
    {
	local($old);
	$old = select($handle);
	&termout("Loading config from ", $args[0], "\n");
	&load_config(@args);
	&termout("done.\n");
	select($old);
    }
    elsif ($cmd eq "host-exit")
    {
	# Ahh, the magic of it all. $done here is the same $done up in
	# the main loop.
	$done = 1;
    }
    elsif ($cmd eq "startnodes")
    {
	local($nstarted);
	$nstarted = &host_start_nodes(@args);
	print $handle "Started: $nstarted\n";
    }
    elsif ($cmd eq "startnodes_withdir")
    {
	local($nstarted);
	local($dir, $pcn, @args1) = @args;
	$nstarted = &host_start_nodes_withdir($dir, $pcn, @args1);
	print $handle "Started: $nstarted\n";
    }
    elsif ($cmd eq "enabled-hosts")
    {
	local($n, %enabled);

	$n = &find_enabled_hosts(*enabled);
	print "Got $n enabled hosts\n" if $verbose;
	print $handle "enabled hosts: $n ", join(' ', keys(%enabled)), "\n";
	print "sent response\n" if $verbose;
    }
    else
    {
	print $handle "Command $cmd not found\n";
    }

    print $handle ".\n";
    &flush($handle);
}

# Write a message to the terminal, inserting a newline if necessary
#
sub termout
{
    print STDOUT "\n" if $neednl;
    $needprompt = 1;
    $neednl = 0;
    print STDOUT @_;
}

sub host_start_nodes_withdir
{
    local($dir, $pcn, $nnodes, @args) = @_;
    local(@cmd);

    if ($vars{"host-config-loaded"} eq "yes")
    {
	@cmd = ("start_fork", @args);
    }
    else
    {
	@cmd = ("start_fork_withdir", $dir, $pcn, @args);
    }
    &host_start_nodes_aux($nnodes, @cmd);
}


sub host_start_nodes
{
    local($nnodes, @args) = @_;
    local(@cmd) = ("start_fork", @args);
    &host_start_nodes_aux($nnodes, @cmd);
}

#
# Start up $nnodes pcn nodes by connecting to the node daemons.
# Similar to start-nodes script, but hopefully faster.
#
sub host_start_nodes_aux
{
    local($nnodes, @cmd) = @_;
    local(%enabled) = ();
    local($host, @repl, $repl, $n_enabled);

    print "Starting nodes with '@cmd'\n" if $verbose;

    &termout("Got request to start $nnodes PCN nodes\n");

    $n_enabled = &find_enabled_hosts(*enabled);
    print "Enabled hosts: ", join(' ', keys %enabled), "\n" if $verbose;

    if ($n_enabled == 0)
    {
	print "Ack! No enabled nodes\n" if $verbose;
	return 0;
    }

    if ($nnodes < 0)
    {
	print "Got negative nnodes, using nenabled=$nenabled\n" if $verbose;
	$nnodes = $n_enabled;
    }

    while ($nstarted < $nnodes)
    {
	if ($n_enabled == 0)
	{
	    print "Ack! No more enabled nodes\n" if $verbose;
	    last;
	}
	
	for $host (keys %enabled)
	{
	    print "Sending command '@cmd' to $host\n" if $verbose;
	    @repl = &send_command_to_host_collecting_reply($host, @cmd);
	    print "Reply is '@repl'\n" if $verbose;
	    if (grep(/success/i, @repl))
	    {
		&termout("Started node on $host\n");
		$nstarted++;
	    }
	    else
	    {
		&termout("Failed to start node on $host\n");
		delete $enabled{$host};
		$n_enabled--;
	    }
	    last if ($nstarted >= $nnodes);
	}
    }
    &termout("Started $nstarted of $nnodes\n");
    return $nstarted;
}

sub find_enabled_hosts
{
    local(*enabled) = @_;
    local($n_enabled, $host, @repl);
    
    $n_enabled = 0;

    for $host (keys %ports)
    {
	@repl =&send_command_to_host_collecting_reply($host, "set", "enabled");
	print "got reply '@repl'\n" if $verbose;

	if (grep(/^enabled\s*=\s*yes/, @repl))
	{
	    $enabled{$host} = 1;
	    $n_enabled++;
	}
    }
    $n_enabled;
}

sub setup_connections
{
    local(@node_list) = &get_node_list;
    local($name, $port);
    
    for (@node_list)
    {
	($name, $port) = split(/\//);
	next unless $name && $port;

	print "Got name $name\n" if $verbose;
	
	$port = &read_node_file("$name");
	
	if (!$port)
	{
	    print "Invalid file $name\n";
	    next;
	}

	if (!&connect_to_node($name, $port))
	{
	    &unlink_node_file("$name");
	}
    }
}

sub connect_to_node
{
    local($name, $port) = @_;
    
    $this_handle = $connection_handle;
    
    eval "&server'connect(\$name, \$port, *$this_handle)";
    if ($@ =~ /connection\s*refused/i)
    {
	&termout("Connection to $name/$port refused\n");
	return undef;
    }
    elsif($@)
    {
	die "Error connecting to $name/$port: $@\n";
    }
    &termout("Connected to $name/$port\n");

    $connection_handle++;
    
    select($this_handle); $| = 1;
    select(STDOUT);

    print "getting banner\n" if $verbose;
    
    chop($banner = <$this_handle>);
    
    print "Banner: $banner\n" if $verbose;

    print $this_handle "$listen_port\n";
    &flush($this_handle);
    
    $node_connections{$name} = $this_handle;
    $node_connections_rev{$this_handle} = $name;
    $ports{$name} = $port;

    return 1;
}

sub send_command
{
    local($where, $cmd, @args) = @_;
    local($host, $handle);

    print "Sending command $cmd\n" if $verbose;

    if ($node_connections{$where})
    {
	&send_command_to_host($where, $cmd, @args);
    }
    elsif ($where eq "all")
    {
	for $host (keys %node_connections)
	{
	    &send_command_to_host($host, $cmd, @args);
	}
    }
    else
    {
	&termout("Unknown host $where\n");
    }
}

#
# There's some trickery here to get around a race condition.
#
# It is possible for the host to send a command to a node. Before the
# node processes the command, it sends some pcn output. So we have
# to watch out here for a line "start-output:" which heralds the beginning
# of a packet of node output. process_node_output handles this.
# 
sub send_command_to_host_collecting_reply
{
    local($host, $cmd, @args) = @_;
    local($handle) = $node_connections{$host};
    local(@reply);

    print "Sending $cmd to $host on $handle\n" if $verbose;

    print  "$cmd @args\n" if $verbose;
    print $handle "$cmd @args\n";
    &flush($handle);
    
    while (1)
    {
	$ret = <$handle>;
	
	if (!$ret)
	{
	    &disconnect($host);
	    return;
	}
	chop($ret);

	print "*** '$ret'\n" if $verbose;
	
	if ($ret =~ /start-output:/)
	{
	    &process_node_output($handle, $host, $_);
	    next;
	}

	last if ($ret =~ /^\.$/);

        push(@reply, $ret);
    }
    @reply;
}

sub send_command_to_host
{
    local($host, $cmd, @args) = @_;
    local($handle) = $node_connections{$host};

    print "Sending $cmd to $host on $handle\n" if $verbose;
    print "Remote command $cmd on $host:\n" unless $suppress_command_output;

    print $handle "$cmd @args\n";
    
    while (1)
    {
	$ret = <$handle>;

	print "SCTH: $ret" if $verbose;
	
	if (!$ret)
	{
	    &disconnect($host);
	    return;
	}
	if ($ret =~ /start-output:/)
	{
	    &process_node_output($handle, $host, $_);
	    next;
	}
	last if ($ret =~ /^\.$/);
	&termout($ret) unless $suppress_command_output;
    }
}

sub disconnect
{
    local($host) = @_;
    local($handle);

    if ($handle = $node_connections{$host})
    {
	&termout("Disconnecting node $host\n");
	close($handle);
	delete $node_connections{$host};
	delete $node_connections_rev{$handle};
	delete $ports{$host};

        # Hmm. I think the only reason a node will EOF is when it exits,
        # so we can get rid of the node file (in case the node abends
  	# and doesn't get rid of it itself).
	
	&unlink_node_file($host);
    }
    elsif ($handle = $cmd_connections{$host})
    {
	&termout("Disconnecting cmd $host\n");
	close($handle);
	delete $cmd_connections{$host};
	delete $cmd_connections_rev{$handle};
    }
    elsif ($handle = $cmd_connections_rev{$host})
    {
	$host = $cmd_connections_rev{$handle};
	&termout("Disconnecting cmd $host\n");
	close($handle);
	delete $cmd_connections{$host};
	delete $cmd_connections_rev{$handle};
    }	
    else
    {
	&termout("Disconnect: unknown host $host\n");
    }
}

sub wait_for_connection
{
    local($timeout) = @_;
    local($old_timeout_handler) = $SIG{ARLM};
    local(@addr);
    local($handle, $name);

    $timeout = 600 unless $timeout;
    
    sub accept_timeout { die "Accept timed out\n"; }

    $SIG{ALRM} = "accept_timeout";

    $handle = $connection_handle;

    alarm($timeout);

    @addr = eval "&server'accept(*$handle, *$listen_handle)";

    alarm(0);
    $SIG{ALRM} = $old_timeout_handler;

    chop($@);
    if ($@ =~ /timed\s*out/)
    {
	return undef;
    }
    elsif ($@)
    {
	&termout("Accept failed: $@\n");
	return undef;
    }

    $connection_handle++;
    &process_connection($handle, @addr);

    $name = &hostname_from_addr(@addr);
    $name ? $name : join(" ", @addr);
}

sub read_rc_file
{
    if (open(RCFILE, "<$ENV{HOME}/.host-control.rc"))
    {
	while (<RCFILE>)
	{
	    chop;
	    &execute_command($_);
	}
	close(RCFILE);
    }
}

sub write_rc_file
{
    local($var, $val);
    if (open(RCFILE, ">$ENV{HOME}/.host-control.rc"))
    {
	while (($var, $val) = each %vars)
	{
	    print RCFILE "$var $val\n";
	}
	close(RCFILE);
    }
}

sub add_misc_pipe
{
    local($handle, $func, @data) = @_;

    print "Adding misc pipe $handle $func\n" if $verbose;
    $misc_connections_funcs{$handle} = $func;
    $misc_connections_data{$handle} = join($;, @data);
}

sub remove_misc_pipe
{
    local($handle) = @_;
    local($func) = $misc_connections_funcs{$handle};

    if (defined($func))
    {
	print "Removing misc pipe $handle $func\n" if $verbose;
	delete $misc_connections_funcs{$handle};
	delete $misc_connections_data{$handle};
    }
}

sub load_file
{
    local($file) = @_;
    if (!do $file)
    {
	if ($@)
	{
	    die "host-control: load-file $file failed: \n$@";
	}
	else
	{
	    if (do "$file.fallback")
	    {
		warn "host-control: perl source '$file' not found, using fallback\n";
	    }
	    else
	    {
		die "host-control: perl source '$file' not found\n";
	    }
	}
    }
}

sub notify_pcn_worker_failed
{
    local($worker_host, $pcn_host, $pcn_port, $errmsg) = @_;

    # Template for worker_ctl_msg_t
    local($msg_tmpl, $msg_len) = ("i4a256", 4 * 4 + 256);
    local($n, $msg);
    local($type, $i1, $i2, $i3, $buf);

    eval "&server'connect(\$pcn_host, \$pcn_port, *PCN_CONN_HANDLE)";
    if ($@ =~ /connection\s*refused/i)
    {
	&termout("Connection to PCN $pcn_host/$pcn_port refused\n") if $debug;
	undef $@;
    }
    elsif($@)
    {
	&termout("Error connecting to PCN $pcn_host/$pcn_port: $@\n") if $debug;
	undef $@;
    }
    else
    {
        &termout("Connected to $pcn_host/$pcn_port\n") if $debug;
	$n = read(PCN_CONN_HANDLE, $msg, $msg_len);
	if ($n < 0)
	{
	    &termout("Error reading from pcn: $!\n") if $debug;
	    return;
	}
	&termout("Read '$n' bytes from pcn\n") if $debug;
	
	($type, $i1, $i2, $i3, $buf) = unpack($msg_tmpl, $msg);
	&termout("Got '$type' '$i1' '$i2' '$i3' '$buf'\n") if $debug;
	$type = 13;
	$buf = "$worker_host: $errmsg";
	$buf = substr($buf, 0, 255) if (length($buf) > 255);
#	$buf .= "\0" x (256 - length($buf));
#	print "Buf is '$buf'\n";
	$msg = pack($msg_tmpl, ($type, $i1, $i2, $i3, $buf));
	print PCN_CONN_HANDLE $msg;
	close(PCN_CONN_HANDLE);
    }
}

