
%aliases = ();

sub return_alias
{
    local($word) = @_;
    $aliases{$word};
}

sub expand_alias
{
    local($word) = @_;
    local($expand) = $aliases{$word};

    $expand ? $expand : $word;
}

sub add_alias
{
    local($word, $alias) = @_;

    $aliases{$word} = $alias;
}

sub remove_alias
{
    local($word) = @_;

    if ($aliases{$word})
    {
	delete $aliases{$word};
    }
    else
    {
	print "$word not aliased\n";
    }
}

sub write_aliases
{
    local($word, $alias);

    while (($word, $alias) = each %aliases)
    {
	print "$word $alias\n";
    }
}
	
1;
