
#ifndef _XawMyList_h
#define _XawMyList_h

/***********************************************************************
 * $Header: /tmp_mnt/ufs/pcn/carl/PCN/IF/Xsw/RCS/MyList.h,v 1.2 91/05/29 18:14:15 carl Exp $
 *
 * MyList Widget
 *
 ***********************************************************************/

#include <X11/Xaw/Simple.h>

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 callback            Callback           XtCallbackList  NULL       **6
 columnSpacing       Spacing            Dimension       6
 cursor		     Cursor		Cursor		left_ptr
 defaultColumns      Columns            int             2          **5
 destroyCallback     Callback		Pointer		NULL 
 font		     Font		XFontStruct*	XtDefaultFont
 forceColumns        Columns            Boolean         False      **5
 foreground	     Foreground		Pixel		XtDefaultForeground
 height		     Height		Dimension	0          **1
 insensitiveBorder   Insensitive	Pixmap		Gray
 internalHeight	     Height		Dimension	2
 internalWidth	     Width		Dimension	4
 myList                MyList               String *        NULL       **2
 longest             Longest            int             0          **3  **4
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 numberStrings       NumberStrings      int             0          **4
 pasteBuffer         Boolean            Boolean         False
 rowSpacing          Spacing            Dimension       4
 sensitive	     Sensitive		Boolean		True
 verticalList        Boolean            Boolean         False
 width		     Width		Dimension	0          **1
 x		     Position		Position	0
 y		     Position		Position	0

 **1 - If the Width or Height of the myList widget is zero (0) then the value
       is set to the minimum size necessay to fit the entire myList.

       If both Width and Height are zero then they are adjusted to fit the
       entire myList that is created width the number of default columns 
       specified in the defaultColumns resource.

 **2 - This is an array of strings the specify elements of the myList.
       This resource must be specified. 
       (What good is a myList widget without a myList??  :-)

 **3 - Longest is the length of the widest string in pixels.

 **4 - If either of these values are zero (0) then the myList widget calculates
       the correct value. 

       (This allows you to make startup faster if you already have 
        this information calculated)

       NOTE: If the numberStrings value is zero the myList must 
             be NULL terminated.

 **5 - By setting the MyList.Columns resource you can force the application to
       have a given number of columns.	     
        
 **6 - This returns the name and index of the item selected in an 
       XawMyListReturnStruct that is pointed to by the client_data
       in the CallbackProc.

*/


/*
 * Value returned when there are no highlighted objects. 
 */

#define XAW_MYLIST_NONE -1	

#define XtCList "List"
#define XtCSpacing "Spacing"
#define XtCLongest "Longest"
#define XtCMaxChars "MaxChars"
#define XtCNumberStrings "NumberStrings"
#define XtCItem "Item"
#define XtCStateArray "StateArray"
#define XtCVertical "Vertical"
#define XtCRotate "Rotate"
#define XtCRigidZoom "RigidZoom"
#define XtCZoom "Zoom"

#define XtNlist "list"
#define XtNlongest "longest"
#define XtNmaxChars "maxChars"
#define XtNnumberStrings "numberStrings"
#define XtNspacing "spacing"
#define XtNtopItem "topItem"
#define XtNstateArray "stateArray"
#define XtNvertical "vertical"
#define XtNrotate "rotate"
#define XtNcurrentItem "currentItem"
#define XtNrigidZoom "rigidZoom"
#define XtNzoom "zoom"

typedef struct {
	Boolean state;
	int item;
} MyListItemInfo;

typedef struct {
  String label;
  void * pointer;
  Boolean state;
} ListElement;


/* Class record constants */

extern WidgetClass myListWidgetClass;

typedef struct _MyListClassRec *MyListWidgetClass;
typedef struct _MyListRec      *MyListWidget;

/* The myList return structure. */

typedef struct _XawMyListReturnStruct {
  String string;
  int myList_index;
} XawMyListReturnStruct;

extern void XswListSetItem();
extern void XswListRedisplay();

#endif /* _XawMyList_h */
/* DON'T ADD STUFF AFTER THIS #endif */
