/*
 * $XConsortium: MultiList.h,v 1.15 89/12/11 15:08:59 kit Exp $
 *
 * Copyright 1989 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*  This is the MultiList widget, it is useful to display a multiList, without the
 *  overhead of having a widget for each item in the multiList.  It allows 
 *  the user to select an item in a multiList and notifies the application through
 *  a callback function.
 *
 *	Created: 	8/13/88
 *	By:		Chris D. Peterson
 *                      MIT X Consortium
 */

#ifndef _XswMultiList_h
#define _XswMultiList_h

/***********************************************************************
 *
 * MultiList Widget
 *
 ***********************************************************************/

#include <X11/Xaw/Simple.h>

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 callback            Callback           XtCallbackMultiList  NULL       **6
 columnSpacing       Spacing            Dimension       6
 cursor		     Cursor		Cursor		left_ptr
 defaultColumns      Columns            int             2          **5
 destroyCallback     Callback		Pointer		NULL 
 font		     Font		XFontStruct*	XtDefaultFont
 forceColumns        Columns            Boolean         False      **5
 foreground	     Foreground		Pixel		XtDefaultForeground
 height		     Height		Dimension	0          **1
 insensitiveBorder   Insensitive	Pixmap		Gray
 internalHeight	     Height		Dimension	2
 internalWidth	     Width		Dimension	4
 multiList                MultiList               String *        NULL       **2
 longest             Longest            int             0          **3  **4
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 numberStrings       NumberStrings      int             0          **4
 pasteBuffer         Boolean            Boolean         False
 rowSpacing          Spacing            Dimension       4
 sensitive	     Sensitive		Boolean		True
 verticalMultiList        Boolean            Boolean         False
 width		     Width		Dimension	0          **1
 x		     Position		Position	0
 y		     Position		Position	0

 **1 - If the Width or Height of the multiList widget is zero (0) then the value
       is set to the minimum size necessay to fit the entire multiList.

       If both Width and Height are zero then they are adjusted to fit the
       entire multiList that is created width the number of default columns 
       specified in the defaultColumns resource.

 **2 - This is an array of strings the specify elements of the multiList.
       This resource must be specified. 
       (What good is a multiList widget without a multiList??  :-)

 **3 - Longest is the length of the widest string in pixels.

 **4 - If either of these values are zero (0) then the multiList widget calculates
       the correct value. 

       (This allows you to make startup faster if you already have 
        this information calculated)

       NOTE: If the numberStrings value is zero the multiList must 
             be NULL terminated.

 **5 - By setting the MultiList.Columns resource you can force the application to
       have a given number of columns.	     
        
 **6 - This returns the name and index of the item selected in an 
       XswMultiListReturnStruct that is pointed to by the client_data
       in the CallbackProc.

*/


/*
 * Value returned when there are no highlighted objects. 
 */

#define XSW_LIST_NONE -1	

#define XtCList "List"
#define XtCSingle "Single"
#define XtCSpacing "Spacing"
#define XtCColumns "Columns"
#define XtCLongest "Longest"
#define XtCNumberStrings "NumberStrings"

#define XtNcursor "cursor"
#define XtNcolumnSpacing "columnSpacing"
#define XtNdefaultColumns "defaultColumns"
#define XtNforceColumns "forceColumns"
#define XtNlist "list"
#define XtNsingle "single"      /* True = single selection */
#define XtNlongest "longest"
#define XtNnumberStrings "numberStrings"
#define XtNpasteBuffer "pasteBuffer"
#define XtNrowSpacing "rowSpacing"
#define XtNverticalMultiList "verticalMultiList"
 
/* Class record constants */

extern WidgetClass multiListWidgetClass;

typedef struct _MultiListClassRec *MultiListWidgetClass;
typedef struct _MultiListRec      *MultiListWidget;

/* The multiList return structure. */

typedef struct _XswMultiListReturnStruct {
  String string;
  int list_index;
} XswMultiListReturnStruct;

/******************************************************************
 *
 * Exported Functions
 *
 *****************************************************************/

/*	Function Name: XswMultiListChange.
 *	Description: Changes the multiList being used and shown.
 *	Arguments: w - the multiList widget.
 *                 multiList - the new multiList.
 *                 nitems - the number of items in the multiList.
 *                 longest - the length (in Pixels) of the longest element
 *                           in the multiList.
 *                 resize - if TRUE the the multiList widget will
 *                          try to resize itself.
 *	Returns: none.
 *      NOTE:      If nitems of longest are <= 0 then they will be caluculated.
 *                 If nitems is <= 0 then the multiList needs to be NULL terminated.
 */

extern void XswMultiListChange(); /* w, multiList, nitems, longest, resize */

/*	Function Name: XswMultiListUnhighlight
 *	Description: unlights the current highlighted element.
 *	Arguments: w - the widget.
 *                 item - the item to unhightlight.
 *	Returns: none.
 */

extern void XswMultiListUnhighlight(); /* w */

/*	Function Name: XswMultiListHighlight
 *	Description: Highlights the given item.
 *	Arguments: w - the multiList widget.
 *                 item - the item to hightlight.
 *	Returns: none.
 */

extern void XswMultiListHighlight(); /* w, item */


/*	Function Name: XswMultiListShowCurrent
 *	Description: returns the currently highlighted objects.
 *	Arguments: w - the multiList widget.
 *	Returns: the info about the currently highlighted objects.
 */

extern XswMultiListReturnStruct * XswMultiListShowCurrent(); /* w */

#endif /* _XswMultiList_h */
/* DON'T ADD STUFF AFTER THIS #endif */
