#if ( !defined(lint) && !defined(SABER))
  static char PCN_rcsid[] = "$Header: /ufs/comp/carl/PCN/IF/Xsw/RCS/Entry.c,v 1.6 1992/01/23 03:14:00 carl Exp $";
#endif

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/
/* 
 * Entry.c - Entry composite widget
 * 
 */
#include <stdio.h>
#include <string.h>

#include <X11/IntrinsicP.h>
#include <X11/Xresource.h>
#include "Xsw.h"

#include <X11/Xaw/Label.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/AsciiSrc.h>
#include <X11/Xaw/Form.h>
#include "EntryP.h"

#define FIELDWIDTH 200


/****************************************************************
 *
 * entry Resources
 *
 ****************************************************************/

static XtResource resources[] = {
#define offset(field) XtOffset(EntryWidget, entry.field)
  { XtNcallback, XtCCallback, XtRCallback, sizeof(XtPointer),
      offset(callback), XtRCallback, NULL},
  { XtNdefaults, XtCDefaults, XtRStringList, sizeof(StringList),
      offset(defaults), XtRString, ""},
  { XtNlabels, XtCLabels, XtRStringList, sizeof(StringList),
      offset(labels), XtRString, "Empty Entry Widget"},
};

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

static void Initialize();
static void Destroy(), DrawIt();
static void ClassPartInitialize();

static void TakePointer(), CallCallbacks();

static XtActionsRec actions[] = {
        {"XswEntryTakePointer", TakePointer},
	{"XswEntryCallCallbacks", CallCallbacks},
};


EntryClassRec entryClassRec = {
  {
/* core_class fields      */
    /* superclass         */    (WidgetClass) &formClassRec,
    /* class_name         */    "entry",
    /* widget_size        */    sizeof(EntryRec),
    /* class_initialize   */    NULL,
    /* class_part_init    */	ClassPartInitialize,
    /* class_inited       */	FALSE,
    /* initialize         */    Initialize,
    /* initialize_hook    */	NULL,
    /* realize            */    XtInheritRealize,
    /* actions            */    actions,
    /* num_actions	  */	XtNumber(actions),
    /* resources          */    resources,
    /* num_resources      */    XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* compress_motion	  */	TRUE,
    /* compress_exposure  */	TRUE,
    /* compress_enterleave*/	TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    Destroy,
    /* resize             */    XtInheritResize,
    /* expose             */    DrawIt,
    /* set_values         */    NULL,
    /* set_values_hook    */	NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */	NULL,
    /* accept_focus       */    NULL,
    /* version            */	XtVersion,
    /* callback_private   */    NULL,
    /* tm_table           */    NULL,
    /* entry_geometry     */	XtInheritQueryGeometry,
    /* display_accelerator*/	XtInheritDisplayAccelerator,
    /* extension          */	NULL
  },{
/* composite_class fields */
    /* geometry_manager   */    XtInheritGeometryManager,
    /* change_managed     */    XtInheritChangeManaged,
    /* insert_child	  */	XtInheritInsertChild,
    /* delete_child	  */	XtInheritDeleteChild,
    /* extension          */	NULL
  },{
/* constraint class fields */
    /* subresources       */    NULL,
    /* subresource_count  */    0,
    /* constraint_size    */    sizeof(EntryConstraintsRec),
    /* initialize         */    NULL,
    /* destroy            */    NULL,
    /* set_values         */    NULL,
    /* extension          */    NULL
  },{
/* form_class fields */
    /* layout             */   XtInheritLayout
  }
};

WidgetClass entryWidgetClass = (WidgetClass)&entryClassRec;


/* ARGSUSED */
static void
  TakePointer(w,event,params,num_params)
     Widget w;
     XEvent *event;
     String *params;
     Cardinal *num_params;
{
  XswGrabPointer(w);
}

/* ARGSUSED */
static void
  CallCallbacks(w,event,params,num_params)
     Widget w;
     XEvent *event;
     String *params;
     Cardinal *num_params;
{
  XtCallCallbacks(XtParent(w), XtNcallback, NULL);
}


/* ARGSUSED */
static void
DrawIt(w, event)
EntryWidget w;
XExposeEvent event;
{
  int i = 0;

  while (i < w->entry.num_labels) {
    if (w->entry.text_w[i] != NULL) {
      XswGrabPointer(w->entry.text_w[i]);
      break;
    } 
    i++;
  }
}


/* ARGSUSED */
static void
ClassPartInitialize(class)
WidgetClass class;
{
  ;
}

static void
Destroy(w)
EntryWidget w;
{ 
  XswFreeStringList(w->entry.return_list);
  XtFree((char *) (w->entry.text_w));
}

/* ARGSUSED */
static void
Initialize(request, new)
EntryWidget request, new;
{
  Widget previous_w, vert_w, label_w;
  Widget first_w = NULL;
  Cardinal arg_cnt;
  Arg args[20];
  int i, num_defaults;
  static char textTranslations[] = 
    "<Key>Return: XswEntryCallCallbacks()";
  XtTranslations trans_table;

  trans_table = XtParseTranslationTable(textTranslations);

  new->entry.exposed = False;

  new->entry.num_labels = XswCountStrings(new->entry.labels);
  num_defaults = XswCountStrings(new->entry.defaults);
  new->entry.num_entries = 0;

  new->entry.text_w = 
    (Widget *) XtMalloc(new->entry.num_labels * (sizeof(Widget)));

  /* create label and text fields */

  i = 0;
  previous_w = vert_w = NULL;

  while(new->entry.labels[i] != NULL) {
    arg_cnt = 0;
    XtSetArg(args[arg_cnt],XtNfromVert, previous_w); arg_cnt++;
    XtSetArg(args[arg_cnt],XtNjustify,XtJustifyLeft); arg_cnt++;
    XtSetArg(args[arg_cnt],XtNlabel,new->entry.labels[i]); arg_cnt++;
    XtSetArg(args[arg_cnt],XtNbottom, XtChainTop); arg_cnt++;
    XtSetArg(args[arg_cnt],XtNtop, XtChainTop); arg_cnt++;
    XtSetArg(args[arg_cnt],XtNright, XtChainLeft); arg_cnt++;
    XtSetArg(args[arg_cnt],XtNleft, XtChainLeft); arg_cnt++;
    label_w = XtCreateManagedWidget("Label", labelWidgetClass,
				       (Widget) new,
				       args, arg_cnt);

    if(i < num_defaults) {
      if(strcmp(new->entry.defaults[i], XtNNULL)) {
	arg_cnt = 0;
	XtSetArg(args[arg_cnt],XtNeditType,XawtextEdit); arg_cnt++;
	XtSetArg(args[arg_cnt], XtNstring,
		 new->entry.defaults[i]); arg_cnt++; 
	XtSetArg(args[arg_cnt],XtNtype,XawAsciiString); arg_cnt++;
	XtSetArg(args[arg_cnt],XtNuseStringInPlace,False); arg_cnt++;
	XtSetArg(args[arg_cnt],XtNwidth,FIELDWIDTH); arg_cnt++;
	XtSetArg(args[arg_cnt],XtNfromVert,previous_w); arg_cnt++;
	XtSetArg(args[arg_cnt],XtNhorizDistance,2); arg_cnt++; 
	XtSetArg(args[arg_cnt],XtNfromHoriz,label_w); arg_cnt++; 
	XtSetArg(args[arg_cnt],XtNbottom, XtChainTop); arg_cnt++;
	XtSetArg(args[arg_cnt],XtNtop, XtChainTop); arg_cnt++;
	XtSetArg(args[arg_cnt],XtNright, XtChainRight); arg_cnt++;
	XtSetArg(args[arg_cnt],XtNleft, XtChainLeft); arg_cnt++;
	new->entry.text_w[i]
	  = XtCreateManagedWidget("Text",asciiTextWidgetClass,
				  (Widget) new, args, arg_cnt);
	XtOverrideTranslations(new->entry.text_w[i],
			       trans_table);
	if (vert_w != NULL) {
	  XtInstallAccelerators(vert_w,
                    new->entry.text_w[i]);
	} else {
	  first_w = new->entry.text_w[i];
	}
	vert_w = new->entry.text_w[i];

	new->entry.num_entries++;
      } else {
	new->entry.text_w[i] = NULL;
      }
    } else {
      new->entry.text_w[i] = NULL;
    }
    previous_w = label_w;
    i++;
  }

  if ((first_w != vert_w) && (first_w != NULL))
    XtInstallAccelerators(vert_w, first_w);

  if (new->entry.num_entries == 1) {
    i = 0;
    while (i < new->entry.num_labels) {
      if (new->entry.text_w[i] != NULL) {
	XtSetKeyboardFocus((Widget) new,new->entry.text_w[i]);
      }
      i++;
    }
  }

  new->entry.return_list =
    (StringList)XtMalloc((new->entry.num_labels+1)*sizeof(String));
  for (i = 0; i < new->entry.num_labels ; i++)
    new->entry.return_list[i] = XtNewString("");  
  new->entry.return_list[i] = NULL;  
}


StringList
  XswEntryGetAll(w)
EntryWidget w;
{
  Arg args[5];
  int i;
  String str;

  XtSetArg(args[0],XtNstring, &str);
  for (i=0; i<w->entry.num_labels; i++) {
    if (w->entry.text_w[i] != NULL) {
      XtGetValues(w->entry.text_w[i],args,1);
    } else {
      str = "";
    }
    XtFree(w->entry.return_list[i]);
    w->entry.return_list[i] = XtNewString(str);
  }
  w->entry.return_list[i] = NULL;
  return w->entry.return_list;
}


void
  XswEntrySetAll(w, list)
EntryWidget w;
StringList list;
{
  int i;
  
  i = 0;
  while ((list[i] != NULL) && (i < w->entry.num_labels)) {
    if (w->entry.text_w[i] != NULL)
      XtVaSetValues(w->entry.text_w[i], XtNstring, list[i], NULL);
    i++;
  }
}


Boolean
  XswEntrySetOne(w, entry, value)
EntryWidget w;
int entry;
String value;
{
  if ((entry < w->entry.num_labels) &&
      (w->entry.text_w[entry] != NULL)) {
    XtVaSetValues(w->entry.text_w[entry], XtNstring, value, NULL);
    return True;
  } else {
    return False;
  }
}   

String
  XswEntryGetOne(w, entry)
EntryWidget w;
int entry;
{
  String str;

  if ((entry < w->entry.num_labels) &&
      (w->entry.text_w[entry] != NULL)) {
    XtVaGetValues(w->entry.text_w[entry], XtNstring, &str, NULL);
    return str;
  } else {
    return NULL;
  }
}   

void
  XswEntryClear(w)
EntryWidget w;
{
  Arg args[2];
  int i;
  
  XtSetArg(args[0], XtNstring, "");
  for (i=0; i<w->entry.num_labels; i++)
    if (w->entry.text_w[i] != NULL)
      XtSetValues(w->entry.text_w[i], args, 1);
}

