#ifndef _ORAChart_h
#define _ORAChart_h

/*
 * $Header: /ufs/comp/mei/PROJ_PCN/onprofile/IFModel/Xsw/RCS/Chart.h,v 1.1 1992/04/17 18:22:43 mei Exp $
 *
 * Chart Widget public include file
 */

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

#include <X11/Core.h>

/* Resources:
 * Name		     Class		RepType		Default Value
 * ----		     -----		-------		-------------
 * foreground        Foreground         Pixel         XtDefaultForeground
 * highlight         Foreground         Pixel         XtDefaultForeground
 * 
 * cellWidth         CellSize           int                 16
 * cellHeight        CellSize           int                 16
 * 
 * boxThickness      BoxThickness       int                 3
 * cellSeparation    CellSeparation     int                 1
 *
 * box               Box                Boolean             True
 * rigidZoom         RigidZoom          Boolean             True
 *
 * colors            Colors             PixelList           black
 * patterns          Patterns           PatternList         solid
 * palette           Palette            String              Palette
 *
 * widthInCells      NumberCells        Cardinal              32
 * heightInCells     NumberCells        Cardinal              32
 * curX              CurX               Cardinal               0
 * curY              CurY               Cardinal               0
 * 
 * cellArray         CellArray          double *             NULL
 * stateArray        StateArray         Boolean *            NULL
 *
 * twoD              TwoD               Boolean              True
 * zoom              Zoom               Boolean              True
 *
 * callback          Callback           Callback             NULL
 * chartResize       Callback           Callback             NULL
 */

#define XtNcellWidth		"cellWidth"
#define XtNcellHeight		"cellHeight"
#define XtNboxThickness         "boxThickness"
#define XtNcellSeparation       "cellSeparation"

#define XtNbox                  "box"
#define XtNrigidZoom            "rigidZoom"

#define XtNcolors               "colors"
#define XtNpatterns             "patterns"
#define XtNpalette              "palette"

#define XtNwidthInCells		"widthInCells"
#define XtNheightInCells	"heightInCells"
#define XtNcurX			"curX"
#define XtNcurY			"curY"

#define XtNcellArray		"cellArray"
#define XtNstateArray		"stateArray"

#define XtNtwoD			"twoD"
#define XtNzoom                 "zoom"

/* hui */
#define XtNchartResize          "chartResize"

 
#define XtCCellSize		"CellSize"
#define XtCBoxThickness         "Frame"
#define XtCCellSeparation       "CellSeparation"

#define XtCBox                  "Box"
#define XtCRigidZoom            "RigidZoom"

#define XtCPalette              "Palette"
#define XtCColors               "Colors"
#define XtCPatterns             "Patterns"

#define XtCNumberCells		"NumberCells"
#define XtCCurX			"CurX"
#define XtCCurY			"CurY"

#define XtCCellArray		"CellArray"
#define XtCStateArray		"StateArray"

#define XtCTwoD			"TwoD"
#define XtCZoom                 "Zoom"


typedef struct {
  Boolean state;
  Cardinal x;
  Cardinal y;
} ChartPointInfo;


#define END_OF_LIST -1
#define XtRPattern   "Pattern"
typedef int Pattern;
#define XtRPatternList   "PatternList"
typedef int * PatternList;

/******************************************************************
 *
 * Exported Functions
 *
 *****************************************************************/

/*      Function Name: XswChartRedisplay.
 *      Description: Forces a redraw of the chart widget.
 *      Arguments: w - the Chart Widget to redraw.
 *      Returns: none.
 */
extern void XswChartRedisplay(/*Widget w*/);


/*      Function Name: XswChartNumValues.
 *      Description: Returns number of distinct values used to display
 *                   three dimensional charts.
 *      Arguments: w - the Chart Widget to query.
 *      Returns: the number of values.
 */
extern int XswChartNumValues(/*Widget w*/);


/*      Function Name: XswChartSetRow.
 *      Description: Set the state of a full row of the chart.
 *      Arguments: w - the Chart Widget to alter.
 *                 row - the row whose state should be set.
 *                 state - if True then row is selected, 
 *                         if False then row is deselected.
 *      Returns: none.
 */
extern void XswChartSetRow(/*Widget w, int row, Boolean state*/);


/*      Function Name: XswChartSetCol.
 *      Description: Set the state of a full column of the chart.
 *      Arguments: w - the Chart Widget to alter.
 *                 col - the column whose state should be set.
 *                 state - if True then column is selected, 
 *                         if False then column is deselected.
 *      Returns: none.
 */
extern void XswChartSetCol(/*Widget w, int col, Boolean state*/);

/* Class record constants */

extern WidgetClass chartWidgetClass;

typedef struct _ChartClassRec *ChartWidgetClass;
typedef struct _ChartRec      *ChartWidget;

#endif /* _ORAChart_h */
/* DON'T ADD STUFF AFTER THIS #endif */



