#if ( !defined(lint) && !defined(SABER))
static char PCN_rcsid[] = "$Header: /tmp_mnt/Net/alriga/alriga1/alriga1/kessel/IF/Xpert/RCS/xpert.c,v 1.13 1992/01/23 00:08:54 kessel Exp $";
#endif

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

#include <stdio.h>

#include <Xsw/Xsw.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Label.h>
#include <Xsw/Dir.h>
#include <Xsw/Help.h>
#include <Xsw/QuerySet.h>

#include "xpcn_icon.h"

/*ARGSUSED*/
int UpdateButton(w, client_data, ret_val)
Widget w;
caddr_t client_data;
caddr_t ret_val;
{
  XswDirUpdate((Widget)client_data);
}

void
main(argc, argv)
     int argc;
     char *argv[];
{
  Widget pane, box, directory, top_level, label, q_set, help;
  XtAppContext context;
  Display *dpy;
  Atom wm_delete_window;
  Cardinal arg_cnt;
  Arg args[20];
  void EditIt();
  void CompileIt();
  void RunIt();
  void GaugeIt();
  void GenericCallback();
  void ProfileCallback();
  void PCNCallback();
  void CosmicPCNCallback();
  void ChangePCNDir();
  void HelpButton();
  void QuitXpert(), QuitXpertAction();
  void XpcnAckAction();
  Pixmap icon_pixmap = (Pixmap) 0;


  static XtActionsRec window_actions[] = {
    { "QuitXpert", QuitXpertAction },
    { "XpcnAck", XpcnAckAction },
  };

  top_level = XtAppInitialize(&context, "Xpcn", NULL, 0,
			      &argc, argv, NULL, NULL, 0);
  
  XtSetArg(args[0], XtNiconPixmap, &icon_pixmap);
  XtGetValues(top_level, args, 1);
  if (icon_pixmap == (Pixmap) 0) {
    XtSetArg(args[0], XtNiconPixmap,
	     XCreateBitmapFromData(XtDisplay(top_level),
				   XtScreen(top_level)->root,
				   xpcn_bits, xpcn_width, xpcn_height));
    XtSetValues(top_level, args, 1);
  }

  XtAugmentTranslations(top_level,
    XtParseTranslationTable("<Prop>XPCN_ACK:XpcnAck()"));

  XtAppAddActions(context, window_actions, XtNumber(window_actions));

  XswInitialize(top_level);
  pane = XtCreateManagedWidget("pcnPane", panedWidgetClass, top_level,
			       NULL, 0);
  help = 
    XtCreatePopupShell("pcnHelp", helpWidgetClass, pane,
		       NULL, 0);

  XswRegisterCallback("EditIt",EditIt,top_level);
  XswRegisterCallback("CompileIt",CompileIt,top_level);
  XswRegisterCallback("GaugeIt",GaugeIt, top_level);
  XswRegisterCallback("EditCallback",GenericCallback,EditIt);
  XswRegisterCallback("CompileCallback",GenericCallback,CompileIt);
  XswRegisterCallback("RunCallback",GenericCallback,RunIt);
  XswRegisterCallback("GaugeCallback",GenericCallback,GaugeIt);
  XswRegisterCallback("ProfileCallback",ProfileCallback,NULL);
  XswRegisterCallback("PCNCallback",PCNCallback,NULL);
  XswRegisterCallback("CosmicPCNCallback",CosmicPCNCallback,NULL);
  XswRegisterCallback("HelpButton",HelpButton,help);
  XswRegisterCallback("QuitXpert",QuitXpert,NULL);
  XswRegisterCallback("ChangePCNDir",ChangePCNDir,NULL);

  box = XtCreateManagedWidget("pcnBox", boxWidgetClass, pane,
			      NULL, 0);

  arg_cnt = 0;
/***********************
  if (*argv) {
    XtSetArg(args[arg_cnt], XtNcurrentDirectory, *argv); arg_cnt++;
  }
************************/

  XtSetArg(args[arg_cnt], XtNselectType, Single); arg_cnt++;
  directory = 
    XtCreateManagedWidget("pcnDirectory", dirWidgetClass, pane,
			  args, arg_cnt);

  label = XtCreateWidget("XGauge", labelWidgetClass,
                              pane, (ArgList)NULL, (Cardinal)0);
  arg_cnt = 0;
  XtSetArg(args[arg_cnt], XtNdirectory, directory); arg_cnt++;
  XtSetArg(args[arg_cnt], XtNhelp, help); arg_cnt++;
  q_set = XtCreateWidget("querySet", querySetClass,
                         label, args, arg_cnt);

  InitPCNbuttons(box, directory, q_set);

  /*SetDirIconName(CurrentDirectory);*/

  XtRealizeWidget(top_level);

  dpy = XtDisplay(top_level);
  wm_delete_window = XInternAtom(dpy, "WM_DELETE_WINDOW", False);
  (void) XSetWMProtocols(dpy, XtWindow(top_level), &wm_delete_window, 1);

  XswAppMainLoop(context);
}









