#if ( !defined(lint) && !defined(SABER))
  static char PCN_rcsid[] = "$Header: /ufs/comp/carl/PCN/IF/Xpert/RCS/send_command.c,v 1.16 1992/01/23 03:05:52 carl Exp $";
#endif

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

#include <stdio.h>
#include <sys/param.h>
#include <Xsw/Xsw.h>

#ifdef next040
/* Steve Tuecke, 11/30/92 -- This is a hack to get around the X11R5
 * installation on the Argonne MCS NeXTs.
 */ 
#define X_NOT_POSIX
#endif

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <X11/Xatom.h>

#ifndef EPOCH
#define EPOCH "epoch"
#endif

#ifndef INITFILE
#define INITFILE "xpcn-init.el"
#endif

struct s_message {
  String message;
  struct s_message *next;
  void (*notify)();
  Widget w;
  XtPointer client_data, call_data;
};

static int EditFound = 0;
static Window editWindow = (Window) NULL;
static Atom cmdProp, ackProp;

static int OkToSend = 1;
static struct s_message *CmdHead = NULL;
static struct s_message *CmdTail = NULL;
static struct s_message *PendingCmd = NULL;

String PCNAck;

/* ARGSUSED */
void 
XpcnAckAction(w, event, params, num_params)
     Widget w;
     XEvent *event;
     String *params;
     int num_params;
{
  Display *dpy = XtDisplay(w);
  if (PendingCmd != NULL) {
    Atom actual_type;
    int actual_format;
    unsigned long nitems;
    unsigned long bytes_after;
    unsigned char *value;

    XGetWindowProperty(dpy, XtWindow(XswTopWidget()), ackProp, 0, 8,
		       False, AnyPropertyType, &actual_type,
		       &actual_format, &nitems, &bytes_after,
		       &value);

    XtFree(PCNAck);
    PCNAck = (String) value;
    if (PendingCmd->notify != NULL)
      (PendingCmd->notify)(PendingCmd->w,
			   PendingCmd->client_data,
			   PendingCmd->call_data);
    XtFree(PendingCmd->message);
    XtFree((char *) PendingCmd);
    PendingCmd = NULL;
  }
  if (CmdHead != NULL) {
    XChangeProperty(dpy, editWindow,
		    cmdProp, XA_STRING, 8,
		    PropModeReplace,
		    (unsigned char *) CmdHead->message, strlen(CmdHead->message)+1);
    PendingCmd = CmdHead;
    CmdHead = CmdHead->next;
    if (CmdHead == NULL) CmdTail = NULL;
  }
  else
    OkToSend = 1;
}

void PCNAckOk(w,text,call_data)
     Widget w;
     String text;
     XtPointer call_data;
{
  if (strcmp(PCNAck,"OK")) {
    XtWarning(text);
    XBell(XtDisplay(XswTopWidget()),0);
  }
}

Window get_edit_window(dpy, key, create)
     Display *dpy;
     char *key;
     int create;
{
  Window editWindow;
  Window get_edit_window1();
  Atom editProp;

  Atom actual_type;
  int actual_format;
  unsigned long nitems;
  unsigned long bytes_after;
  unsigned char *value;

  editProp = XInternAtom(dpy, "XPCN_EDIT",False);

  /* Make sure that there are no hangers on */
  XGetWindowProperty(dpy, RootWindow(dpy,DefaultScreen(dpy)),
		     editProp, 0, 8,
		     True, AnyPropertyType, &actual_type,
		     &actual_format, &nitems, &bytes_after,
		     &value);

  editWindow =
    get_edit_window1(dpy, RootWindow (dpy, DefaultScreen(dpy)),
		     editProp, key);
  if (editWindow != (Window) NULL)
    EditFound = 1;
  if (create == False)
    return editWindow;
  if (editWindow == (Window) NULL) {
    if (fork() == 0) {
      char *epoch = EPOCH;
      char *initfile = INITFILE;
      execl(epoch,epoch,
	    "-l",initfile,
	    "-class","Xpcn",
	    (char *) NULL);
    } else {
      do {
	sleep(1);
	XGetWindowProperty(dpy, RootWindow(dpy,DefaultScreen(dpy)),
			   editProp, 0, 8,
			   True, AnyPropertyType, &actual_type,
			   &actual_format, &nitems, &bytes_after,
			   &value);
      } while (actual_type == None);
      editWindow = *((Window *) value);
      XFree((char *) value);
    }
  }
  else 
    EditFound = 1;
  return editWindow;
}

Window get_edit_window1 (dpy, w, prop, key)
     Display *dpy;
     Window w;
     Atom prop;
     char *key;
{
  Window root, parent;
  unsigned int nchildren;
  Window *children = NULL;
  int n;

  Atom actual_type;
  int actual_format;
  unsigned long nitems;
  unsigned long bytes_after;
  unsigned char *value;

  XGetWindowProperty(dpy, w, prop, 0, 8,
		     False, AnyPropertyType, &actual_type,
		     &actual_format, &nitems, &bytes_after,
		     &value);
  
  if (actual_type != None) {
    /* Don't use key for now */
    /*  if (!strcmp(value,key)) { */
    XFree((char *) value);
    return w;
    /*    } */

  }
  if (XQueryTree (dpy, w, &root, &parent, &children, &nchildren)) {
    w = (Window) NULL;
    for (n = 0; n < nchildren && w == (Window) NULL; n++) 
      w = get_edit_window1(dpy, children[n],prop, key);
  }
  if (children) XFree ((char *) children);
  return w;
}

exit_from_editor(w,state,call_data)
     Widget w;
     int state;
     XtPointer call_data;
{
  if (editWindow != (Window) NULL && state == 0) {
    send_command(w,"(DELETESCREENS)",False,
		 exit_from_editor,1,NULL);
    return;
  }
  if (editWindow != (Window) NULL && !EditFound) 
    send_command(w,"(EXIT)",False,
		 XswExitProgramCallback,NULL,call_data);
  else 
    XswExitProgramCallback(w,NULL,call_data);
}

send_command(w, command, create, notify, client_data, call_data)
     Widget w;
     unsigned char *command;
     int create;
     void (*notify)();
     XtPointer client_data;
     XtPointer call_data;
{
  Display *dpy;
  Widget dw = w;
  while (! XtIsShell(dw)) dw = XtParent(dw);
  dpy = XtDisplay(dw);

  if (editWindow  == (Window) NULL) {
    char hostname[MAXHOSTNAMELEN];
    char cmdbuf[MAXPATHLEN+sizeof("(CD \"/\")")+1];

    gethostname(hostname,MAXHOSTNAMELEN);
    editWindow = get_edit_window(dpy,hostname,create);  
    cmdProp = XInternAtom(dpy, "XPCN_CMD", False);
    ackProp = XInternAtom(dpy, "XPCN_ACK", False);
    PCNAck = XtNewString("");
    if (editWindow != (Window) NULL) {
      sprintf(cmdbuf,"(CONNECT \"%d\")",XtWindow(XswTopWidget()));
      send_command(w, cmdbuf, False, NULL, NULL, NULL);
      strcpy(cmdbuf,"(CD \"");
      getwd(cmdbuf+strlen(cmdbuf));
      strcat(cmdbuf,"/\")");
      send_command(w, cmdbuf, False, NULL, NULL, NULL);
    }
  }

  if (editWindow != (Window) NULL) {
    /*    printf("Sending command %s to %d\n", command, editWindow);  */

    struct s_message *tPtr =
      (struct s_message *) XtMalloc(sizeof(struct s_message));
    tPtr->notify = notify;
    tPtr->w = w;
    tPtr->client_data = client_data;
    tPtr->call_data = call_data;
    tPtr->message = XtNewString((char *) command);
    tPtr->next = NULL;
    if (OkToSend) {
      OkToSend = 0;
      XChangeProperty(dpy, editWindow,
		      cmdProp, XA_STRING, 8,
		      PropModeReplace, command,
		      strlen((char *) command)+1);
      PendingCmd = tPtr;
    } else {
      if (CmdHead == NULL) 
	CmdHead = tPtr;
      else 
	CmdTail->next = tPtr;
      CmdTail = tPtr;
    }
  }
  return editWindow == (Window) NULL ? 0 : 1;
}
