
/********************************************************/
/* File: SelectP.h                                      */
/* Content: Private definitions for Select Widget       */
/*   for selecting a snapshot for the profile data      */
/* Date: 2/1992                                         */
/********************************************************/

#ifndef _XawSelectP_h
#define _XawSelectP_h

/********************************************************/
/* Select Widget's Private Data                         */
/********************************************************/

#include "Select.h"
#include <X11/Xaw/FormP.h>

/* New fields for the SelectS widget class record */

typedef struct {int foo;} SelectClassPart;

/* Full class record declaration */
typedef struct _SelectClassRec {
    CoreClassPart       core_class;
    CompositeClassPart  composite_class;
    ConstraintClassPart constraint_class;
    FormClassPart       form_class;
    SelectClassPart    select_class;
} SelectClassRec;

extern SelectClassRec selectClassRec;

/* New fields for the Select widget record */
typedef struct {
    /* resources */
    int    curr_snap;        /* what is the current selection */
    int    show_snap;      
    int    total_snap;       /* total possible selections */
    int    width;            /* select Widget's width */
    XtPointer *data_ptr;     /* ptr to the internal data structure */
    /* private state */
    Widget topform;          /* form widget as top level */
    Widget whichselection;   /* label button for display what is selected */
    int    which_width;
    Widget showallselection; /* command button to popup a complete selection list */
    int    show_width;
    Widget scrollHoriz;      /* scrollbar for displaying selections before selecting */
    float  thumb_width;      /* thumb size for the scrollbar */
    int    scroll_width;
    Widget popshell;         /* for the popup */
    Widget popform;          /* form widget to maintain popped widget */
    Widget popdismiss;       /* to leave the popup */
    Widget popapply;         /* to select the highlighted selection */
    Widget popview;          /* viewport widget for poplist */
    Widget poplist;          /* selection list */
    String *list;            /* the complete selection list */
} SelectPart;

/**************************************
*                                     *
*             (popshell)              *
*                 |                   *
*             (popform)               *
*         ____/   |   \______         *
*        /        |          \        *
*(popdismiss) (popapply)   (popview)  *
*                             |       *
*                          (poplist)  *
*                                     *
**************************************/

/********************************************************/
/* Full instance record declaration                     */
/********************************************************/

typedef struct _SelectRec {
    CorePart            core;
    CompositePart       composite;
    ConstraintPart      constraint;
    FormPart            form;
    SelectPart          select;
} SelectRec;

typedef struct {
   /* resources */
   /* private state */
   Boolean reparented;
} SelectConstraintsPart;

typedef struct {
   FormConstraintsPart     form;
   SelectConstraintsPart   select;
}SelectConstraintsRec, *SelectConstraints;

#endif /* _XawSelectP_h */
