#if ( !defined(lint) && !defined(SABER))
  static char PCN_rcsid[] = "$Header: /ufs/comp/mei/PROJ_PCN/onprofile/IFModel/Model/Gauge/RCS/Select.c,v 1.2 1992/04/17 18:15:54 mei Exp $";
#endif

/********************************************************/
/* File: Select.c                                       */
/* Content: Select Widget for selecting target snapshot */
/*  to be displayed                                     */
/* Date: 2/1992                                         */
/********************************************************/
#include <stdio.h>

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Viewport.h>

#include <Xsw/Xsw.h>
#include <Xsw/Help.h>
#include "SelectP.h"

#define LIST_MAX     300
#define LABEL_MAX    128
#define DIVIDER        6 
#define WIDTH_MAX    380 

extern void get_showsnap();
extern int SelectSnap();
extern int get_snaptotal();
extern int get_snap_no();
extern char *get_snapname();

/********************************************************/
/* Select Resources                                     */
/********************************************************/
static XtResource resources[] = {

#define offset(field) XtOffset(SelectWidget, select.field)

{ XtNcurrSnap,    XtCCurrSnap,    XtRInt,     sizeof(int),
offset(curr_snap),     XtRImmediate,       "0"   },

{ XtNtotalSnap,   XtCTotalSnap,   XtRInt,     sizeof(int),
offset(total_snap),     XtRImmediate,      "0"   },

{ XtNsnapWidth,   XtCSnapWidth,   XtRInt,     sizeof(int),
offset(width),          XtRImmediate,      "380" },

{ XtNdataPtr,     XtCDataPtr,     XtRPointer, sizeof(XtPointer),
offset(data_ptr),       XtRImmediate,      (XtPointer) NULL},

#undef offset
};
 
/********************************************************/
/* Full class record constant                           */
/********************************************************/
/* for application */
static void MakeSnapButtons(/* widget w */);
static void UpdateSelectionLabel(/* SelectWidget sw */);
static void to_new_scroll_position(/* Widget w, 
                             int newpos,thumb_width */);
/* for widget */
static void Initialize(/* SelectWidget request, new */);
static void Destroy(/* SelectWidget sw */);
static Boolean SetValues(/* SelectWidget current, request, new */);

SelectClassRec selectClassRec = {
   {
/* core_class fields      */
    /* superclass         */    (WidgetClass) &formClassRec,
    /* class_name         */    "select",
    /* widget_size        */    sizeof(SelectRec),
    /* class_initialize   */    NULL,
    /* class_part_init    */    NULL,
    /* class_inited       */    FALSE,
    /* initialize         */    Initialize,
    /* initialize_hook    */    NULL,
    /* realize            */    XtInheritRealize,
    /* actions            */    NULL,
    /* num_actions        */    0,
    /* resources          */    resources,
    /* num_resources      */    XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* compress_motion    */    TRUE,
    /* compress_exposure  */    TRUE,
    /* compress_enterleave*/    TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    Destroy,
    /* resize             */    XtInheritResize,
    /* expose             */    NULL,
    /* set_values         */    SetValues,
    /* set_values_hook    */    NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */    NULL,
    /* accept_focus       */    NULL,
    /* version            */    XtVersion,
    /* callback_private   */    NULL,
    /* tm_table           */    NULL,
    /* query_geometry     */    XtInheritQueryGeometry,
    /* display_accelerator*/    XtInheritDisplayAccelerator,
    /* extension          */    NULL
  },{/* composite_class fields */
    /* geometry_manager   */    XtInheritGeometryManager,
    /* change_managed     */    XtInheritChangeManaged,
    /* insert_child       */    XtInheritInsertChild,
    /* delete_child       */    XtInheritDeleteChild,
    /* extension          */    NULL
  },{
/* constraint class fields */
    /* subresources       */    NULL,
    /* subresource_count  */    0,
    /* constraint_size    */    sizeof(SelectConstraintsRec),
    /* initialize         */    NULL,
    /* destroy            */    NULL,
    /* set_values         */    NULL,
    /* extension          */    NULL
  },
  { /* form_class fields */
    /* layout             */   XtInheritLayout
  }
};
 
WidgetClass selectWidgetClass = (WidgetClass) &selectClassRec;
 
/********************************************************/
/* Name: Initialize                                     */
/* Content : side effect routine to be called during    */
/*   creation of Select Widget                          */
/* Date: 2/1992 (become a widget in 3/1992)             */
/********************************************************/
/* ARGSUSED */
static void
Initialize(request, neww)
SelectWidget request, neww;
{
int    size1; /* for showallbutton */
int    size2; /* for snapshot name button */
int    tmp;

/* width */
    if(neww->select.width <= (2*DIVIDER) || neww->select.width > WIDTH_MAX )
          neww->select.width=380;

    /* give 1/4 for showall, 3/4 for showselection */
    tmp = neww->select.width-(2*DIVIDER); /* head & tail */
    size1=tmp / 4;
    size2=tmp-size1-DIVIDER;

    neww->select.show_width=size1;
    neww->select.which_width=size2;
    neww->select.scroll_width= tmp;

/* curr_snap (always start at 0) */
    neww->select.curr_snap=0;

/* data_ptr + total_snap(total_snap does not have to be public resource) */
    if(neww->select.data_ptr == NULL) {
      XtWarning("Select Initialize: ptr to data structure is not set.");
      neww->select.total_snap=1;
      } else {
         neww->select.list=(String *)XtMalloc(sizeof(String)*LIST_MAX);
         neww->select.total_snap=get_snaptotal(neww->select.data_ptr);
         get_showsnap(neww->select.data_ptr,neww->select.list);
    }/* if */

    if(neww->select.total_snap <= 0) {
      XtWarning("Select Initialize: total snap number is = 0.");
      neww->select.total_snap=1;
    }

    neww->select.thumb_width= 1.0/neww->select.total_snap;

    (void) MakeSnapButtons(neww);
    to_new_scroll_position(neww->select.scrollHoriz,
              neww->select.curr_snap, neww->select.thumb_width);
}

/* ARGSUSED */
static void 
Destroy(sw)
SelectWidget sw;
{
    XtFree((char *)sw->select.list);
}

/* ARGSUSED */
static Boolean 
SetValues(current, request, neww)
SelectWidget current, request, neww;
{
  if(neww->select.width != current->select.width) {
    /* does not need to do anything, resize does it */
    if(neww->select.width < 0) {
        XtWarning("Select SetValues: widget has no width ?");
        neww->select.width=current->select.width;
    }
  }/* if, width */

  if(neww->select.total_snap != current->select.total_snap) {
    XtWarning("Select SetValues : total snap should not be changed.");
    neww->select.total_snap=current->select.total_snap;
  } /* if, total_snap */

  if(neww->select.data_ptr != current->select.data_ptr) {
    XtWarning("Select SetValues : data ptr should not be changed.");
    neww->select.data_ptr=current->select.data_ptr;
  } /* if, data_ptr */ 
   
  if(neww->select.curr_snap != current->select.curr_snap) {
    if(neww->select.curr_snap < 0 ||
           neww->select.curr_snap > neww->select.total_snap) {
      XtWarning("Select SetValues : snap number is out of range.");
      neww->select.curr_snap=current->select.curr_snap;
    }
    /** change the display **/
    UpdateSelectionLabel(neww);
  } /* if, curr_snap */
  to_new_scroll_position(neww->select.scrollHoriz,
              neww->select.curr_snap, neww->select.thumb_width);
}

/********************************************************/
/* Name : UpdateSelectionLabel                          */
/* Content : to alter the selection button's label and  */
/*  call SelectSnap to reflect the view change.         */
/* Date: 2/1992                                         */
/********************************************************/
/* ARGSUSED */
static void 
UpdateSelectionLabel(sw)
SelectWidget sw;
{
char snapname[LABEL_MAX];
 
  sprintf(snapname,"Current Snapshot: #%3d    %25s",
      sw->select.curr_snap,
        get_snapname(sw->select.data_ptr,sw->select.curr_snap));

  XtVaSetValues(sw->select.whichselection,XtNlabel,snapname,NULL);
 
/* to refresh the main profile data display */
  SelectSnap(sw->select.curr_snap, sw->select.data_ptr);
}

/********************************************************/
/* Name: to_new_scroll_position                         */
/* Content: move the scroll bar thumb to a new position */
/* Date: 2/1992                                         */
/********************************************************/
/* ARGSUSED */
static void 
to_new_scroll_position(w,newpos,thumb_width)
Widget w;    /* scrollbar */
int newpos;  /* the new selection */
float thumb_width;
{
XawScrollbarSetThumb(w, 
                 (float) newpos*thumb_width,
                             (float) thumb_width);
}

/********************************************************/
/* Name: Jump_right_one, Jump_left_right_multi          */
/* Name: Jump_left_one                                  */
/* Content: the movement of a horizontal scrollbar's    */
/*     thumb to the left and right one at once (1st or  */
/*     3rd buttons) or successively by pressing shift   */
/*     key at the same time.                            */
/* Date: 2/1992                                         */
/********************************************************/
/* ARGSUSED */
static void 
jump_right_one(sw)
SelectWidget sw;
{
int new_snap;

    new_snap=((sw->select.curr_snap+1) >= sw->select.total_snap) ?
                 sw->select.total_snap-1 : sw->select.curr_snap+1;
    XtVaSetValues((Widget)sw, XtNcurrSnap, new_snap, NULL);
}

/* ARGSUSED */
static void 
jump_left_one(sw)
SelectWidget sw;
{
int new_snap;
 
    new_snap =((sw->select.curr_snap-1) < 0) ?
                                   0 : sw->select.curr_snap-1;
    XtVaSetValues((Widget)sw, XtNcurrSnap, new_snap, NULL);
}

/* ARGSUSED */
static void 
jump_left_right_multi(sw)
SelectWidget sw;
{
float pos;
int   new_snap;
 
    XtVaGetValues(sw->select.scrollHoriz,XtNtopOfThumb,&pos,NULL);
    new_snap = (int) (pos / sw->select.thumb_width);
    XtVaSetValues((Widget)sw, XtNcurrSnap, new_snap, NULL);
}

/********************************************************/
/* Name : Move_left_right                               */
/* Content: to control the movement of the horizontal   */
/*   scrollbar's movement from left<->right             */
/*   1st button - move left one snapshot and refresh    */
/*                view                                  */
/*   2nd button - jump or scroll continuous to left or  */
/*                right                                 */
/*   3rd button - move right one snapshot and refresh   */
/*                view                                  */
/* Date: 2/1992                                         */
/********************************************************/
/* ARGSUSED */
static void Move_left_right(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
SelectWidget sw=(SelectWidget) client_data;
int          thumb=(int) call_data;
Dimension    d_leng;
int          leng, whichbutton;
 
    XtVaGetValues(w,XtNlength,&d_leng,NULL);
    leng=(int)d_leng;
    whichbutton = (thumb > leng) ? 2 : ((thumb < 0) ? 3:1);

    switch (whichbutton) {
      case 1:jump_left_one(sw);
             break;
      case 2: jump_left_right_multi(sw);
             break;
      case 3:jump_right_one(sw);
             break;
    } /*switch*/
}

/********************************************************/
/* Name: PopupList                                      */
/* Content: to popup the complete snapshot table list   */
/* Date: 2/1992                                         */
/********************************************************/
/*ARGSUSED*/
static void 
PopupList(w,client_data,call_data)
Widget w; /* showallselection */
XtPointer client_data, call_data;
{
SelectWidget sw= (SelectWidget) client_data;
Position     x,y;
Dimension    width, height;
 
   XtVaGetValues((Widget)sw, XtNwidth, &width, XtNheight, &height, NULL);
   XtTranslateCoords((Widget)sw,
               (Position) width+10,
               (Position) 0,
               &x,&y);
   XtVaSetValues(sw->select.popshell, XtNx, x, XtNy, y, NULL);
 
   XtSetSensitive(w,FALSE);
   XtPopup(sw->select.popshell,XtGrabNone); /* popshell */
}

/********************************************************/
/* Name: Popapply                                       */
/* Content: to take the highlighted selection from the  */
/*   snapshot table list and update the main display    */
/* Date: 2/1992                                         */
/********************************************************/
/*ARGSUSED*/
static void 
Popapply(w,client_data,call_data)
Widget w;
XtPointer client_data, call_data;
{
int          new_snap;
SelectWidget sw=(SelectWidget) client_data;
XawListReturnStruct *result=XawListShowCurrent(sw->select.poplist);
 
   if(result->list_index != -1) {
      XawListUnhighlight(sw->select.poplist);
      new_snap = get_snap_no(result->string);
      XtVaSetValues((Widget)sw,XtNcurrSnap,new_snap,NULL);
   }/* else nothing is high lighted */
}
 
/********************************************************/
/* Name: PopdownList                                    */
/* Content: popdown the showallselection's popup shell  */
/* Date: 2/1992                                         */
/********************************************************/
/*ARGSUSED*/
static void PopdownList(w,client_data,call_data)
Widget w;
XtPointer client_data, call_data;
{
SelectWidget sw=(SelectWidget) client_data;
 
   XawListUnhighlight(sw->select.poplist);
   XtPopdown(sw->select.popshell);  /* popshell */
   XtSetSensitive(sw->select.showallselection,True);
}

/********************************************************/
/* Name: MakeSnapButtons                                */
/* Content: create the widgets needed for allowing the  */
/*   selection of snapshot display                      */
/* Date: 2/1992                                         */
/********************************************************/
static void 
MakeSnapButtons(w)
SelectWidget w;
{
   w->select.topform = XtVaCreateManagedWidget(
             "topform",
              formWidgetClass,
              (Widget)w,
              XtNborderWidth, 0,
              NULL);
 
/* button for display what is current display */
   w->select.whichselection = XtVaCreateManagedWidget(
                     "whichselection",
                     labelWidgetClass,
                     w->select.topform,
                     XtNresize,False,
                     XtNlabel,"Current Snapshot Selection",
                     XtNhorizDistance, DIVIDER,
                     XtNwidth, w->select.which_width,
                     NULL);

/* button for display the complete snaptable */
   w->select.showallselection = XtVaCreateManagedWidget(
                      "ShowAll",
                       commandWidgetClass,
                       w->select.topform,
                       XtNwidth, w->select.show_width,
                       XtNfromHoriz, w->select.whichselection,
                       XtNhorizDistance, DIVIDER/2,
                       NULL);
    XtAddCallback(w->select.showallselection, XtNcallback,PopupList,w);
 
    w->select.scrollHoriz = XtVaCreateManagedWidget(
                       "scrollHoriz",
                        scrollbarWidgetClass,
                        w->select.topform,
                        XtNwidth, w->select.scroll_width,
                        XtNorientation, XtorientHorizontal,
                        XtNhorizDistance, DIVIDER,
                        XtNfromVert, w->select.showallselection,
                        NULL);

/* move the position and hange the select label */
    XtAddCallback(w->select.scrollHoriz,XtNscrollProc,Move_left_right,w);
    XtAddCallback(w->select.scrollHoriz,XtNjumpProc,Move_left_right,w);

/* widgets for the showallselection's popup */
    w->select.popshell=XtVaCreatePopupShell(
                    "popshell",
                    transientShellWidgetClass,
                    (Widget) w,
                    XtNtitle,"Snapshot List",
                    NULL);


    w->select.popform = XtVaCreateManagedWidget(
                    "popform",
                    formWidgetClass,
                    w->select.popshell,
                    XtNborderWidth, 0,
                    NULL);
 
    w->select.popdismiss= XtVaCreateManagedWidget(
                   "popdismiss",
                    commandWidgetClass,
                    w->select.popform,
                    XtNlabel,"Quit",
                    NULL);
    XtAddCallback(w->select.popdismiss,XtNcallback,PopdownList,w);
 
    w->select.popapply= XtVaCreateManagedWidget(
                    "popapply",
                    commandWidgetClass,
                    w->select.popform,
                    XtNfromHoriz, w->select.popdismiss,
                    XtNlabel,"Apply",
                    NULL);
    XtAddCallback(w->select.popapply,XtNcallback,Popapply,w);
 
    w->select.popview=XtVaCreateManagedWidget(
                    "popview",
                    viewportWidgetClass,
                    w->select.popform,
                    XtNfromVert, w->select.popdismiss,
                    XtNallowVert, True,
                    XtNallowHoriz, True,
                    NULL);
 
    w->select.poplist = XtVaCreateManagedWidget(
                    "poplist",
                    listWidgetClass,
                    w->select.popview,
                    XtNlist,w->select.list,
                    XtNverticalList, True,
                    XtNcolumnSpacing, 12,
                    NULL);
 
}

