/* $Id: load.c,v 1.12 1993/06/02 11:34:23 sverker Exp $ */

#include "include.h"
#include "term.h"
#include "initial.h"
#include "tree.h"
#include "predicate.h"
#include "exstate.h"
#include "engine.h"
#include "parser.tab.h"
#include "error.h"

extern FILE *yyin;
extern int parse();


void load(file)
    FILE *file;
{
    yyin = file;
    parse();
}


/* $load/1 succeed or fail */
bool akl_load(Arg)
    Argdecl;
{
    register Term X0;
    
    Deref(X0,A(0));

    if(IsATM(X0)) {
	if((yyin = fopen(AtmPname(Atm(X0)), "r")) == NULL) {
	    akl_error(E_OPEN_FILE, X0);
	    return FALSE;
	}
	parse();
	fclose(yyin);
	return TRUE;
    } else {
	akl_error(E_FILE_SPEC,X0);
	return FALSE;
    }
}


void initialize_load() {

  define("$load",akl_load,1);
}
