/* $Id: display.c.m4,v 1.5 1993/10/19 14:05:12 bd Exp $ */

/* Note: This incarnation of display.c was generated by M4. This causes a
 * number of blank lines before the program text. Just in case you wondered.
 */

define(m4_tolower,
  `translit($1,ABCDEFGHIJKLMNOPQRSTUVWXYZ,abcdefghijklmnopqrstuvwxyz)')

changequote(,)

define(m4_const,case $1:
    Instr_Term("m4_tolower($1)", "(%s)");
    break;)

define(m4_functor,case $1:
    Instr_Functor("m4_tolower($1)", "('%s'/%ld)");
    break;)

define(m4_index,case $1:
    Instr_Index("m4_tolower($1)", "(%ld)");
    break;)

define(m4_index_binding,case $1:
    Instr_Index("m4_tolower($1)", "(%ld,"    );
    break;)

define(m4_index_const,case $1:
    Instr_Index_Term("m4_tolower($1)", "(%ld,", "%s)");
    break;)

define(m4_index_const_label_label,case $1:
    Instr_Index_Term_Label_Label("m4_tolower($1)",
	"(%ld,", "%s,", "%#lx,", "%#lx)");
    break;)

define(m4_index_constlist,case $1:
    Instr_Index_Size("m4_tolower($1)", "(%ld,", "%ld-");
    for (n = *(pc-1), prefix = "["; n > 0; n -= 1, prefix = ",") {
      printf("%s", prefix);
      ConstantTableEntry("(%s,", "%#lx)");
    }
    printf("])");
    break;)

define(m4_index_functor_label_level_offset_index,case $1:
    Instr_Index_Functor_Label_Level_Offset_Index("m4_tolower($1)",
	"(%ld,", "'%s'/%ld,", "%#lx,", "%ld,", "%ld,", "%ld)");
    break;)

define(m4_index_functor_label_offset_index,case $1:
    Instr_Index_Functor_Label_Offset_Index("m4_tolower($1)",
	"(%ld,", "'%s'/%ld,", "%#lx,", "%ld,", "%ld)");
    break;)

define(m4_index_functorlist,case $1:
    Instr_Index_Size("m4_tolower($1)", "(%ld,", "%ld-");
    for (n = *(pc-1), prefix = "["; n > 0; n -= 1, prefix = ",") {
      printf("%s", prefix);
      FunctorTableEntry("('%s'/%ld,", "%#lx)");
    }
    printf("])");
    break;)

define(m4_index_index,case $1:
    Instr_Index_Index("m4_tolower($1)", "(%ld,", "%ld)");
    break;)

define(m4_index_index_label_label,case $1:
    Instr_Index_Index_Label_Label("m4_tolower($1)",
	"(%ld,", "%ld,", "%#lx,", "%#lx)");
    break;)

define(m4_index_index_offset,case $1:
    Instr_Index_Index_Offset("m4_tolower($1)", "(%ld,", "%ld,", "%ld)");
    break;)

define(m4_index_label,case $1:
    Instr_Index_Label("m4_tolower($1)", "(%ld,", "%#lx)");
    break;)

define(m4_index_labels_5,case $1:
    Instr_Index_Labels_5("m4_tolower($1)",
	"(%ld,", "%#lx,", "%#lx,", "%#lx,", "%#lx,", "%#lx)");
    break;)

define(m4_index_label_arity,case $1:
    Instr_Index_Label_Size("m4_tolower($1)", "(%ld,", "%#lx,", "%ld)");
    break;)

define(m4_index_label_constlist,case $1:
    Instr_Index_Label_Size("m4_tolower($1)", "(%ld,", "#lx,", "%ld-");
    for (n = *(pc-1), prefix = "["; n > 0; n -= 1, prefix = ",") {
      printf("%s", prefix);
      ConstantTableEntry("(%s,", "%#lx)");
    }
    printf("])");
    break;)

define(m4_index_label_index,case $1:
    Instr_Index_Label_Index("m4_tolower($1)", "(%ld,", "%#lx,", "%ld)");
    break;)

define(m4_index_label_label,case $1:
    Instr_Index_Label_Label("m4_tolower($1)", "(%ld,", "%#lx,", "%#lx)");
    break;)

define(m4_index_label_level_index,case $1:
    Instr_Index_Label_Level_Index("m4_tolower($1)",
	"(%ld,", "%#lx,", "%ld,", "%ld)");
    break;)

define(m4_index_offset,case $1:
    Instr_Index_Offset("m4_tolower($1)", "(%ld,", "%ld)");
    break;)

define(m4_index_offset_const,case $1:
    Instr_Index_Offset_Term("m4_tolower($1)", "(%ld,", "%ld,", "%s)");
    break;)

define(m4_index_offset_functor_label_level_offset_index,case $1:
    Instr_Index_Offset_Functor_Label_Level_Offset_Index("m4_tolower($1)",
	"(%ld,", "%ld,", "'%s'/%ld,", "%#lx,", "%ld,", "%ld,", "%ld)");
    break;)

define(m4_index_offset_functor_label_offset_index,case $1:
    Instr_Index_Offset_Functor_Label_Offset_Index("m4_tolower($1)",
	"(%ld,", "%ld,", "'%s'/%ld,", "%#lx,", "%ld,", "%ld)");
    break;)

define(m4_index_offset_label_index,case $1:
    Instr_Index_Offset_Label_Index("m4_tolower($1)",
	"(%ld,", "%ld,", "%#lx,", "%ld)");
    break;)

define(m4_index_offset_label_level_index,case $1:
    Instr_Index_Offset_Label_Level_Index("m4_tolower($1)",
	"(%ld,", "%ld,", "%#lx,", "%ld,", "%ld)");
    break;)

define(m4_indices_3,case $1:
    Instr_Indices_3("m4_tolower($1)", "(%ld,", "%ld,", "%ld)");
    break;)

define(m4_label,case $1:
    Instr_Label("m4_tolower($1)", "(%#lx)");
    break;)

define(m4_label_arity,case $1:
    Instr_Label_Size("m4_tolower($1)", "(%#lx,", "%ld)");
    break;)

define(m4_label_arity_live,case $1:
    Instr_Label_Size_Size("m4_tolower($1)", "(%#lx,", "%ld,", "%ld)");
    break;)

define(m4_label_index_binding,case $1:
    Instr_Label_Index("m4_tolower($1)", "(%#lx,", "%ld,"   );
    break;)

define(m4_label_label,case $1:
    Instr_Label_Label("m4_tolower($1)", "(%#lx,", "%#lx)");
    break;)

define(m4_label_live,case $1:
    Instr_Label_Size("m4_tolower($1)", "(%#lx,", "%ld)");
    break;)

define(m4_level_label,case $1:
    Instr_Level_Label("m4_tolower($1)", "(%ld,", "%#lx)");
    break;)

define(m4_none,case $1:
    Instr_None("m4_tolower($1)");
    break;)

define(m4_offset,case $1:
    Instr_Offset("m4_tolower($1)", "(%ld)");
    break;)

define(m4_pred,case $1:
    Instr_Pred("m4_tolower($1)", "('%s'/%ld)");
    break;)

define(m4_pred_live,case $1:
    Instr_Pred_Size("m4_tolower($1)", "('%s'/%ld,", "%ld)");
    break;)

define(m4_size,case $1:
    Instr_Size("m4_tolower($1)", "(%ld)");
    break;)

define(m4_foobar,case $1:
    printf("m4_tolower($1)(<NOT YET IMPLEMENTED>)");
    break;)

undefine(define)
undefine(include)

#include <string.h>
#include "include.h"
#include "instructions.h"
#include "term.h"
#include "predicate.h"
#include "tree.h"
#include "exstate.h"
#include "error.h"
#include "unify.h"
#include "initial.h"
#include "display.h"
#include "engine.h"
#include "trace.h"
#include "config.h"

#include "debug.h"

/* The following macros will turn the instruction macros in "insdefs.h"
 * into printing statements.
 */

/* Basic hooks: */

#define CodeWord(n,x)		printf((x), (long) GetCodeWord(n))
#define BeginCodeWord(n)	{ code codeword = *(pc+(n))
#define CodeField(x,i,n)	printf((x), (long) GetCodeField(codeword,i,n))
#define EndCodeWord(dummy)	}
#define StartInstruction(x)	printf("%s", (x))
#define EndInstruction(n)	pc += (n)

/* Special operand types: */

#define LabelWord(n,x)		CodeWord(n,x)

#define IndexWord(n,x)		PrintfRegIndex(x, GetCodeWord(n))

#define IndexField(x,i) \
	PrintfRegIndex(x, GetCodeField(codeword,i*INDEX_BITS,INDEX_BITS))

#define FunctorWord(n,x) {\
  Functor f = (Functor) GetCodeWord(n); \
  printf((x), FnkPname(f), (long) FnkArity(f)); \
}

#define TermWord(n,x) {\
  Term ZZZc = code_to_term(GetCodeWord(n)); \
  char buf[400]; \
  if (IsATM(ZZZc)) { \
    buf[0] = '\0'; strcat(buf, "'"); \
    strncat(buf, AtmPname(Atm(ZZZc)), sizeof(buf)-2); \
    strcat(buf, "'"); \
  } else if (IsINT(ZZZc)) { \
    sprintf(buf, "%ld", IntVal(Int(ZZZc))); \
  } else if (IsFLT(ZZZc)) { \
    sprintf(buf, "%E", FltVal(Flt(ZZZc))); \
  } else { \
    sprintf(buf, "{UNKNOWN %#lx}", Tad(ZZZc)); \
  } \
  printf((x), buf); \
}

#define PredWord(n,x) {\
  predicate *p = (predicate*) GetCodeWord(n); \
  printf((x), AtmPname(p->name), p->arity); \
}

/* Auxiliary macros: */

#define GetCodeField(w,i,n)	(((w) >> (i)) & ((1L << (n))-1))
#define GetCodeWord(n)		(*(pc+(n)))
#define PrintfRegIndex(x,i)	printf((x), (long) ((i)/sizeof(Term)))
#define GetOpCode(ptr)		((opcode) (*(ptr)))
#define FetchOpCode(n)		op = GetOpCode(pc+(n))

/* And at last we include the instruction definitions */

#include "instrdefs.h"


#define MAXVARNAME 511

int maxvarname;
int varcount;

typedef struct {
  void *var;
  int name;
} varname_entry;

varname_entry *varname = NULL;


void display_lone_b_continuation();
void display_b_continuation();
void display_a_continuations();
void display_here();
void display_cont_args();
void display_and();

bool choicebox_is_on_path();
bool andbox_is_on_path();


bool akl_initialize_varname(Arg)
     Argdecl;
{
  initialize_varname();

  return TRUE;
}

void initialize_varname()
{
  int i;

  if (varname != NULL) {
    varname =
      (varname_entry *) realloc(varname, MAXVARNAME*sizeof(varname_entry));
  } else {
    varname = (varname_entry *) malloc(MAXVARNAME*sizeof(varname_entry));
  }

  if (varname == NULL) {
    FatalError("Out of memory -- initialize_varname");
  }

  varcount = 0;
  for(i = 0; i < MAXVARNAME; i++) {
    varname[i].var = NULL;
    varname[i].name = 0;
  }

  maxvarname = MAXVARNAME;
}


void initialize_display() {

  initialize_varname();

  define("$initialize_varname", akl_initialize_varname, 0);
}


#define VarnameHash(x,n)	((((long)(x))/sizeof(void*)) % (n))

void reconstruct_varname(newmax, gczap)	/* reallocate and rehash varnames */
     int newmax;
     int gczap;		/* 0 => just copy the entries */
			/* 1 => zap entries for gc */
{
  int i, j;
  varname_entry *newvarname;
  void *v;
  newvarname = (varname_entry *) malloc(newmax*sizeof(varname_entry));
  if (newvarname == NULL) {
    FatalError("Couldn't grow varname table");
  }

  for(i = 0; i < newmax; i += 1) {
    newvarname[i].var = NULL;
    newvarname[i].name = 0;
  }

  for (i = 0; i < maxvarname; i += 1) {
    v = varname[i].var;
    if (v != NULL) {
      if (gczap) {
	if (IsCopied(v)) {
	  v = Forw(v);
	} else {
	  continue;
	}
      }
      j = VarnameHash(v, newmax);
      for (;;) {
	if (newvarname[j].var == NULL) {
	  newvarname[j].var = v;
	  newvarname[j].name = varname[i].name;
	  break;
	}
	j += 1;
	if (j == newmax)
	  j = 0;
      }
    }
  }

  free(varname);
  varname = newvarname;
  maxvarname = newmax;
}


void gc_varname()
{
  reconstruct_varname(maxvarname, 1);
}


long variable_descriptor(t)
     Term t;
{    
  long int hash, i;
    
  void *v = (void*) Ref(t);

 retry:
  hash = VarnameHash(v, maxvarname);
  i = hash;
 loop:
  if(varname[i].var == v)
    goto showit;
  if(varname[i].var == NULL) {
    varname[i].var = v;
    varname[i].name = varcount++;
    goto showit;
  }
  i++;
  if(i == MAXVARNAME)
    i = 0;
  if(i != hash)
    goto loop;

  /* Table is completely full, so double its size and try again */

  reconstruct_varname(maxvarname*2, 0);
  goto retry;

 showit:
  return varname[i].name;
}

void display_variable(fl, t, tsiz)
     FILE *fl;
     Term t;
     int tsiz;
{
  fprintf(fl, "_%ld", variable_descriptor(t));

  if(IsCvaTerm(t)) {
    RefCvaMethod(Ref(t))->print(fl, RefGva(Ref(t)), tsiz-1);
  }
}


void display_term(t, tsiz)
     Term t;
     int tsiz;
{
  fdisplay_term(stdout, t, tsiz);
}


void fdisplay_term(fl, t, tsiz)
     FILE *fl;
     Term t;
     int tsiz;
{
    int	i;
    int tsiz1 = tsiz;
    register Term tmp;

    if(Eq(t, NullTerm)) {
      fprintf(fl, "NULL");
      return;
    }

    tmp = t;
    DerefSwitchTerm(tmp,varlbl,intlbl,atmlbl,fltlbl,lstlbl,strlbl,genlbl);
 varlbl:
    display_variable(fl, tmp, tsiz);
    goto exitlbl;
 intlbl:
    fprintf(fl,"%d",IntVal(Int(tmp)));
    goto exitlbl;
 fltlbl:
    fprintf(fl,"%E",FltVal(Flt(tmp)));
    goto exitlbl;
 atmlbl:
    fprintf(fl,"%s",AtmPname(Atm(tmp)));
    goto exitlbl;
 lstlbl:
    if(tsiz == 0) {
      fprintf(fl,"[...]");
      goto exitlbl;
    }

    fprintf(fl,"[");
    {
      Term a;
      GetLstCar(a,Lst(tmp));
      fdisplay_term(fl,a,tsiz-1);
      GetLstCdr(tmp,Lst(tmp));
      Deref(tmp,tmp);
      while(IsLST(tmp) && (--tsiz1 != 0)) {
	fprintf(fl,",");
	GetLstCar(a,Lst(tmp));
	fdisplay_term(fl,a,tsiz-1);
	GetLstCdr(tmp,Lst(tmp));
	Deref(tmp,tmp);
      }
    }
    if(tsiz1 == 0)
      fprintf(fl,",...]");
    else if(Eq(tmp, NIL))
      fprintf(fl,"]");
    else {
      fprintf(fl,"|");
      fdisplay_term(fl,tmp,tsiz-1);
      fprintf(fl,"]");
    }
    goto exitlbl;
 strlbl:	    
    fprintf(fl,"%s(", AtmPname(StrName(Str(tmp))));
    if(tsiz == 0) {
      fprintf(fl,"...)");
      goto exitlbl;
    }
    for(i=0 ; i != StrArity(Str(tmp)); i++) {
      Term a;
      GetStrArg(a,Str(tmp),i);
      fdisplay_term(fl,a,tsiz-1);
      if(i != (StrArity(Str(tmp)) - 1))
	fprintf(fl,",");
    }
    fprintf(fl,")");
    goto exitlbl;
 genlbl:
    if (!(Gen(tmp)->method->print(fl,Gen(tmp),tsiz-1)))
      fprintf(fl, "<unknown generic:%#lx>", (long)Gen(tmp));
    goto exitlbl;

 exitlbl:
    return;
}
	    

/* display_code(pc) prints the instruction at pc, and returns the
 * increment to the next instruction, in case you would like to
 * disassemble a sequence of instructions.
 */
int display_code(pc)
    /* NOTE: The instruction macros use "pc" implicitly! */
    code *pc;
{
  int n;
  code *pc0 = pc;
  /* NOTE: The instruction macros use "op" implicitly! */
  opcode op;

  char *prefix;

  FetchOpCode(0);
  switch(CodeToEnum(op)) {
  case SWITCH_ON_TERM:
    Instr_Labels_7("switch_on_term",
		   "(%#lx,", " %#lx,", " %#lx,", " %#lx,",
		   " %#lx,", " %#lx,", " %#lx)");
    break;
  case TRY_SINGLE:
    Instr_Label("try_single", "(%#lx)");
    break;
  case TRY:
    Instr_Label("try", "(%#lx)");
    break;
  case RETRY:
    Instr_Label("retry", "(%#lx)");
    break;
  case TRUST:
    Instr_Label("trust", "(%#lx)");
    break;
  case TRY_ME:
    Instr_None("try_me");
    break;
  case TRY_ME_ELSE:
    Instr_Label("try_me_else", "(%#lx)");
    break;
  case RETRY_ME_ELSE:
    Instr_Label("retry_me_else", "(%#lx)");
    break;
  case TRUST_ME:
    Instr_None("trust_me");
    break;
  case GUARD_COLLECT:
    Instr_Indices_3("guard_collect", "(%ld,", "%ld,", "%ld)");
    break;
  case GUARD_UNIT:
    Instr_None("guard_unit");
    break;
  case GUARD_NOISY_CUT:
    Instr_None("guard_noisy_cut");
    break;
  case GUARD_NOISY_COMMIT:
    Instr_None("guard_noisy_commit");
    break;
  case GUARD_QUIET_WAIT:
    Instr_None("guard_quiet_wait");
    break;
  case GUARD_CUT:
    Instr_None("guard_cut");
    break;
  case GUARD_COMMIT:
    Instr_None("guard_commit");
    break;
  case GUARD_WAIT:
    Instr_None("guard_wait");
    break;
  case GUARD_HALT:
    Instr_None("guard_halt");
    break;
  case ALLOCATE:
    Instr_Size("allocate", "(%ld)");
    break;
  case CALL:
    Instr_Pred("call", "('%s'/%ld)");
    break;
  case META_CALL:
    Instr_Index("meta_call", "(%ld)");
    break;
  case EXECUTE:
    Instr_Pred("execute", "('%s'/%ld)");
    break;
  case PROCEED:
    Instr_None("proceed");
    break;
  case FAIL:
    Instr_None("fail");
    break;
  case GET_X_VARIABLE:
    Instr_Index_Index("get_x_variable", "(%ld,", "%ld)");
    break;
  case GET_Y_VARIABLE:
    Instr_Index_Index("get_y_variable", "(%ld,", "%ld)");
    break;
  case GET2_Y_VARIABLE:
    Instr_Index_Index("get2_y_variable", "(%ld,", "%ld, ");
    Next_Index_Index("%ld,", "%ld)");
    break;
  case GET3_Y_VARIABLE:
    Instr_Index_Index("get3_y_variable", "(%ld,", "%ld, ");
    Next_Index_Index("%ld,", "%ld, ");
    Next_Index_Index("%ld,", "%ld)");
    break;
  case GET4_Y_VARIABLE:
    Instr_Index_Index("get4_y_variable", "(%ld,", "%ld, ");
    Next_Index_Index("%ld,", "%ld, ");
    Next_Index_Index("%ld,", "%ld, ");
    Next_Index_Index("%ld,", "%ld)");
    break;
  case GET5_Y_VARIABLE:
    Instr_Index_Index("get5_y_variable", "(%ld,", "%ld, ");
    Next_Index_Index("%ld,", "%ld, ");
    Next_Index_Index("%ld,", "%ld, ");
    Next_Index_Index("%ld,", "%ld, ");
    Next_Index_Index("%ld,", "%ld)");
    break;
  case GET_X_VALUE:
    Instr_Index_Index("get_x_value", "(%ld,", "%ld)");
    break;
  case GET_Y_VALUE:
    Instr_Index_Index("get_y_value", "(%ld,", "%ld)");
    break;
  case GET_CONSTANT:
    Instr_Term_Index("get_constant", "(%s,", "%ld)");
    break;
  case GET_NIL:
    Instr_Index("get_nil", "(%ld)");
    break;
  case GET_STRUCTURE:
    Instr_Functor_Index("get_structure", "('%s'/%ld", "%ld)");
    break;
  case GET_LIST:
    Instr_Index("get_list", "(%ld)");
    break;
  case GET_LIST_X0:
    Instr_None("get_list_x0");
    break;
  case GET_NIL_X0:
    Instr_None("get_nil_x0");
    break;
  case GET_STRUCTURE_X0:
    Instr_Functor("get_structure_x0", "('%s'/%ld)");
    break;
  case GET_CONSTANT_X0:
    Instr_Term("get_constant_x0", "(%s)");
    break;
  case PUT_X_VOID:
    Instr_Index("put_x_void", "(%ld)");
    break;
  case PUT_Y_VOID:
    Instr_Index("put_y_void", "(%ld)");
    break;
  case PUT_X_VARIABLE:
    Instr_Index_Index("put_x_variable", "(%ld,", "%ld)");
    break;
  case PUT_Y_VARIABLE:
    Instr_Index_Index("put_y_variable", "(%ld,", "%ld)");
    break;
  case PUT_X_VALUE:
    Instr_Index_Index("put_x_value", "(%ld,", "%ld)");
    break;
  case PUT_Y_VALUE:
    Instr_Index_Index("put_y_value", "(%ld,", "%ld)");
    break;
  case PUT2_Y_VALUE:
    Instr_Index_Index("put2_y_value", "(%ld,", "%ld, ");
    Next_Index_Index("%ld,", "%ld)");
    break;
  case PUT3_Y_VALUE:
    Instr_Index_Index("put3_y_value", "(%ld,", "%ld, ");
    Next_Index_Index("%ld,", "%ld, ");
    Next_Index_Index("%ld,", "%ld)");
    break;
  case PUT4_Y_VALUE:
    Instr_Index_Index("put4_y_value", "(%ld,", "%ld, ");
    Next_Index_Index("%ld,", "%ld, ");
    Next_Index_Index("%ld,", "%ld, ");
    Next_Index_Index("%ld,", "%ld)");
    break;
  case PUT5_Y_VALUE:
    Instr_Index_Index("put5_y_value", "(%ld,", "%ld, ");
    Next_Index_Index("%ld,", "%ld, ");
    Next_Index_Index("%ld,", "%ld, ");
    Next_Index_Index("%ld,", "%ld, ");
    Next_Index_Index("%ld,", "%ld)");
    break;
  case PUT_CONSTANT:
    Instr_Term_Index("put_constant", "(%s,", "%ld)");
    break;
  case PUT_NIL:
    Instr_Index("put_nil", "(%ld)");
    break;
  case PUT_STRUCTURE:
    Instr_Functor_Index("put_structure", "('%s'/%ld", "%ld)");
    break;
  case PUT_LIST:
    Instr_Index("put_list", "(%ld)");
    break;
  case UNIFY_VOID:
    Instr_None("unify_void");
    break;
  case UNIFY_Y_VARIABLE:
    Instr_Index("unify_y_variable", "(%ld)");
    break;
  case UNIFY_X_VARIABLE:
    Instr_Index("unify_x_variable", "(%ld)");
    break;
  case UNIFY_X_VALUE:
    Instr_Index("unify_x_value", "(%ld)");
    break;
  case UNIFY_Y_VALUE:
    Instr_Index("unify_y_value", "(%ld)");
    break;
  case UNIFY_CONSTANT:
    Instr_Term("unify_constant", "(%s)");
    break;
  case UNIFY_NIL:
    Instr_None("unify_nil");
    break;
  case UNIFY_LIST:
    Instr_None("unify_list");
    break;
  case UNIFY_STRUCTURE:
    Instr_Functor("unify_structure", "('%s'/%ld)");
    break;
  case SWITCH_ON_CONSTANT:
    Instr_Size("switch_on_constant", "(%ld, ");
    for (n = *(pc-1), prefix = "["; n > 0; n -= 1, prefix = ",") {
      printf("%s", prefix);
      ConstantTableEntry("(%s,", "%#lx)");
    }
    Next_Label("], %#lx)");
    break;
  case SWITCH_ON_STRUCTURE:
    Instr_Size("switch_on_structure", "(%ld, ");
    for (n = *(pc-1), prefix = "["; n > 0; n -= 1, prefix = ",") {
      printf("%s", prefix);
      FunctorTableEntry("('%s'/%ld,", "%#lx)");
    }
    Next_Label("], %#lx)");
    break;
  case SEND3:
    Instr_None("send3");
    break;
#ifdef BAM
  m4_none(FAIL_DEC)
  m4_index(LOAD_NIL)
  m4_index_const(LOAD_ATOM)
  m4_index_const(LOAD_INTEGER)
  m4_index_index(READ_CAR)
  m4_index_index(READ_CDR)
  m4_indices_3(READ_ARG)
  m4_index_index(SET_REG_REG)
  m4_index_index(SET_REG_YVAR)
  m4_index_index(SET_YVAR_REG)
  m4_index_labels_5(TERM_SWITCH)
  m4_index_constlist(ATOM_SWITCH)
  m4_index_label_constlist(ATOM_WITH_ELSE_SWITCH)
  m4_index_label_constlist(ATOM_WITH_ATOM_ELSE_SWITCH)
  m4_index_label(ATOM_TYPE)
  m4_index_label_label(ATOM_TYPE_WITH_ELSE)
  m4_index_constlist(KNOWN_ATOM_SWITCH)
  m4_index_constlist(KNOWN_ATOM_WITH_ATOM_ELSE_SWITCH)
  m4_index_constlist(INTEGER_SWITCH)
  m4_index_label_constlist(INTEGER_WITH_ELSE_SWITCH)
  m4_index_label_constlist(INTEGER_WITH_INTEGER_ELSE_SWITCH)
  m4_index_label(INTEGER_TYPE)
  m4_index_label_label(INTEGER_TYPE_WITH_ELSE)
  m4_index_constlist(KNOWN_INTEGER_SWITCH)
  m4_index_constlist(KNOWN_INTEGER_WITH_INTEGER_ELSE_SWITCH)
  m4_index_label_label(LIST_SWITCH)
  m4_index_label_label(LIST_TYPE_WITH_ELSE)
  m4_index_label(STRUCT_TYPE)
  m4_index_label_label(STRUCT_TYPE_WITH_ELSE)
  m4_index_functorlist(KNOWN_FUNCTOR_SWITCH)
  m4_index_functorlist(KNOWN_FUNCTOR_WITH_FUNCTOR_ELSE_SWITCH)
  m4_index_index_label_label(INT_COMPARE_REG_REG)
  m4_index_const_label_label(INT_COMPARE_REG_INT)
  m4_index_index_label_label(EQ_REG_REG)
  m4_index_index(MATCH_REG_REG)
  m4_index_index_offset(MATCH_REG_REG_OFF)
  m4_index_const(MATCH_REG_ATOM)
  m4_index_offset_const(MATCH_REG_OFF_ATOM)
  m4_index_const(MATCH_REG_INTEGER)
  m4_index_offset_const(MATCH_REG_OFF_INTEGER)
  m4_index(MATCH_REG_NIL)
  m4_index_offset(MATCH_REG_OFF_NIL)
  m4_index_index(MATCH_REG_YVAR)
  m4_index_index(MATCH_YVAR_YVAR)
  m4_index_index_offset(MATCH_YVAR_REG_OFF)
  m4_index_offset(MATCH_REG_H_LIST)
  m4_index_offset(MATCH_YVAR_H_LIST)
  m4_index_offset(MATCH_REG_H_STRUCT)
  m4_index_offset(MATCH_YVAR_H_STRUCT)
  m4_index_functor_label_offset_index(MATCH_REG_STRUCT)
  m4_index_functor_label_level_offset_index(MATCH_REG_STRUCT_LEVEL)
  m4_index_offset_functor_label_offset_index(MATCH_REG_OFF_STRUCT)
  m4_index_offset_functor_label_level_offset_index(MATCH_REG_OFF_STRUCT_LEVEL)
  m4_index_functor_label_offset_index(MATCH_YVAR_STRUCT)
  m4_index_functor_label_level_offset_index(MATCH_YVAR_STRUCT_LEVEL)
  m4_index_label_index(MATCH_REG_LIST_CAR)
  m4_index_label_level_index(MATCH_REG_LIST_CAR_LEVEL)
  m4_index_offset_label_index(MATCH_REG_OFF_LIST_CAR)
  m4_index_offset_label_level_index(MATCH_REG_OFF_LIST_CAR_LEVEL)
  m4_index_label_index(MATCH_YVAR_LIST_CAR)
  m4_index_label_level_index(MATCH_YVAR_LIST_CAR_LEVEL)
  m4_index_label_index(MATCH_REG_LIST_CDR)
  m4_index_label_level_index(MATCH_REG_LIST_CDR_LEVEL)
  m4_index_offset_label_index(MATCH_REG_OFF_LIST_CDR)
  m4_index_offset_label_level_index(MATCH_REG_OFF_LIST_CDR_LEVEL)
  m4_index_label_index(MATCH_YVAR_LIST_CDR)
  m4_index_label_level_index(MATCH_YVAR_LIST_CDR_LEVEL)
  m4_none(PUSH_LIST_IMM)
  m4_offset(PUSH_LIST)
  m4_none(PUSH_STRUCTURE_IMM)
  m4_offset(PUSH_STRUCTURE)
  m4_none(PUSH_NIL)
  m4_index(PUSH_REG)
  m4_index(PUSH_YVAR)
  m4_none(PUSH_VOID)
  m4_index(SET_REG_H_AND_PUSH_VOID)
  m4_index(SET_YVAR_H_AND_PUSH_VOID)
  m4_index_index(SET_REG_AND_YVAR_H_AND_PUSH_VOID)
  m4_const(PUSH_ATOM)
  m4_const(PUSH_INTEGER)
  m4_functor(PUSH_FUNCTOR)
  m4_index(SET_REG_H)
  m4_index(SET_YVAR_H)
  m4_label_index_binding(BTRY)
  m4_label_index_binding(BTRUST)
  m4_label_label(TEST_TRY)
  m4_label_label(TEST_TRUST)
  m4_label(S_TRY)
  m4_label(S_TRUST)
  m4_label(BACK)
  m4_label_live(GEN_TRY)
  m4_none(GEN_TRUST)
  m4_pred(BEXECUTE_SIMPLE)
  m4_pred(BEXECUTE)
  m4_pred_live(BCALL)
  m4_label(JUMP_GC_AND_DUMP_CONT)
  m4_label(JUMP_GC)
  m4_label(JUMP)
  m4_none(BPROCEED_SIMPLE)
  m4_none(BPROCEED)
  m4_size(CREATE_CONT)
  m4_level_label(TEST_LEVEL)
  m4_label_live(CONSTRAINT_STACK_TEST)
  m4_label(JUMP_ON_NONEMPTY_CONSTRAINT_STACK)
  m4_none(ALIAS_CHECK)
  m4_index_binding(ALIAS_CHECK_REG)
  m4_index(FAIL_ON_ALIAS)
  m4_size(CHOICE_QUIET_CUT)
  m4_index_label_arity(SUSPEND_LONE_VAR)
  m4_index_label_arity(BSUSPEND)
  m4_label_arity(SUSPEND_WITHOUT_REG)
  m4_size(CREATE_GUARD)
  m4_label_arity(FLAT_QUIET_CUT)
  m4_label_arity_live(FLAT_QUIET_COMMIT)
  m4_label_arity_live(FLAT_NOISY_WAIT)
  m4_label(SHORTCUT_QUIET_CUT)
  m4_label(SHORTCUT_QUIET_COMMIT)
  m4_label(SHORTCUT_NOISY_WAIT)
  m4_none(DEEP_QUIET_CUT)
  m4_none(DEEP_QUIET_COMMIT)
  m4_none(DEEP_NOISY_WAIT)
#endif

  default:
    printf("No such instruction!\n");
    pc += 1;
    break;
  }

  return pc-pc0;
}



void indent(n)
    int n;
{
    register int i;
    
    for(i = n; i > 0; i--)
	printf(" ");
}
	

void display_choice(c, ind,base,ins,chb,flag,flat_and,depth)
    choicebox *c;
    int ind;
    andbox *base;
     choicebox *ins,*chb;
    bool flag,flat_and;
    int depth;
{
  int arity;
  char  *name;
  /* Display goal with arguments */

  printf("\n");
  if((suspend_depth != -1) && (depth>suspend_depth)) return;
  indent(ind);

  if(c->def != NULL && c->def->predicate_type == C_PREDICATE) {
    arity = c->def->arity;
    printf("%s", AtmPname(c->def->name));
    if(c->cont != NULL) {
      int i;
      printf("(");
      for(i = 0; i < arity; i++) {
	display_term(c->cont->arg[i],-1);
	printf("%s", (i+1 == c->cont->arity ? "" : ","));
      }
      printf(")");
    } else {
      printf("/%d", arity);
    }
    return;
  }
    
  if(c->def == NULL) {
    assert(!(NonEmptyChoiceCont(c)));
    if(c->tried == NULL) {
      printf("FAIL");
      return;
    }
    else if (c->tried->next == NULL) {
      display_and(c->tried, ind,base,ins,chb,flat_and,depth+1);
      return;
    }
    else {
      printf("OR[");
#ifdef DEBUG
      printf("@%#lx, ", (uword)c);
#endif
#ifdef TRACE
      printf("id:%d,",c->id);
#endif
    }
  } else {
    name = AtmPname(c->def->name);
    arity = c->def->arity;

  if(flag)
    {
#ifdef TRACE
      if(c->trace & (MONITOR|MONITOR_CHILDREN))
	printf("CHOICE[*@ "); 
      else
#endif
	printf("CHOICE[ @ "); 
    }
  else
    {
#ifdef TRACE
      if(c->trace & (MONITOR|MONITOR_CHILDREN))
	printf("CHOICE[* ");  
      else
#endif
	printf("CHOICE[");  
    }
  
#ifdef DEBUG
    printf("@%#lx, ", (uword)c);
#endif
#ifdef TRACE
    printf("id:%d, ",c->id);
#endif
    printf("%s", name);
  
    if(c->cont != NULL) {
      int i;
      printf("(");
      for(i = 0; i < c->cont->arity; i++) {
	display_term(c->cont->arg[i],-1);
	printf("%s", (i+1 == c->cont->arity ? "" : ","));
      }
      printf(")");
    } else {
      printf("/%d", arity);
    }

  if(flat_and)
    {
      printf("]");
      return;
    }


  }

  /* Display tried branches atop each other in order. */
    
  if(c->tried != NULL) 
    {
      andbox *tried;
      tried = c->tried;
      
      while(tried != NULL) 
	{
	  display_and(tried, ind+2,base,ins,chb,flat_and,depth+1); /* indent 2 extra */
	  tried = tried->next;
	  if(tried != NULL) printf(",");
	}
      
      /* Display continuation (if any) */
      
      
      if(NonEmptyChoiceCont(c)) {
	printf(",\n");
        indent(ind+2);
	printf("AND choice continuation]");
	return;
      }
      printf("]");
    } 
  else 
    {
      if(NonEmptyChoiceCont(c))
	{
	  printf("  AND choice continuation]");
	}
      else
	printf("]");
    }
}


void display_constraint(constr)
     constraint *constr;
{
  if(constr == NULL)
    return;
  constr->method->print(constr);
}

void display_unifier(unif)
     unifier *unif;
{
  if(unif == NULL)
    return;
  printf("(");
  display_term(unif->arg1,-1);
  printf(" = ");
  display_term(unif->arg2,-1);
  printf(")");
  return;
}


void display_and(a, ind,base,ins,chb,flat_and,depth)
    andbox *a;
    int ind;
     andbox *base;
     choicebox *ins,*chb;
     bool flat_and;
     int depth;
{
  choicebox *tried;
  unifier *unif;  
  constraint *constr;
  bool flag;
    
  printf("\n");
  indent(ind);
  if(andbox_is_on_path(a,base))
    {
      printf("AND[ @ ");
      flag=TRUE;
    }
  else
    {
      printf("AND[");
      flag=FALSE;
    }
#ifdef DEBUG
  printf("@%#lx, ", (uword)a);
#endif
#ifdef TRACE
  printf("id:%d, ", a->id);
#endif
#ifdef DEBUG
  printf("st:%#x, env:%#lx, ", (int)a->status, (uword)a->env );
#endif

  /* Display unifiers. */
    
  if(a->unify != NULL) {
    printf("{");
    for(unif = a->unify; unif != NULL; unif = unif->next) {
      display_unifier(unif);
      if(unif->next!= NULL)
	printf(", ");
    }
    printf("} ");
  }
    
  /* Display constraints. */

  if(a->constr != NULL) {
    printf("{");
    for(constr = a->constr; constr != NULL; constr = constr->next) {
      display_constraint(constr);
      if(constr->next!= NULL)
	printf(", ");
    }
    printf("} ");
  }

  /* Display choice-boxes atop each other in order. */
  if(a->tried!=NULL)
    {
      if(flag)
	{
	  tried = a->tried;
	  while(tried != NULL) 
	    {
	      if(ins==tried)
		{
		  display_choice(tried, ind+2,base,ins,chb,FALSE,flat_and,depth); 
		  display_here(ind+2);
		  display_a_continuations(a->cont,ind+2);
		}
	      else if ((ins==(choicebox *)1) && (a==base))
		{
		  display_here(ind+2);
		  display_a_continuations(a->cont,ind+2);
		  display_choice(tried,ind+2,base,ins,chb,FALSE,flat_and,depth); 
		}
	      else if((tried==chb) || (choicebox_is_on_path(tried,base)))
		{
		  display_choice(tried, ind+2,base,ins,chb,TRUE,flat_and,depth); 
		  display_a_continuations(a->cont,ind+2);		  
		}
	      else
		{
		  display_choice(tried, ind+2,base,ins,chb,FALSE,flat_and,depth); 
		}
	      tried = tried->next;
	    }
	  display_b_continuation(a->cont,ind+2);
	  printf("]");
	}
      else
	{
	  tried = a->tried;
	  while(tried != NULL) 
	    {
	      display_choice(tried, ind+2,base,ins,chb,FALSE,flat_and,depth); 
	      tried = tried->next;
	    }
	  display_lone_b_continuation(a->cont,ind+2);
	  printf("]");
	}
    }
  else
    {
      if(flag) display_here(ind+2);
      if(a->cont!=NULL)
	{
	  display_a_continuations(a->cont,ind+2);
	  display_b_continuation(a->cont,ind+2);
	}
      else
	{
	  printf("\n");
	  indent(ind+2);
	  printf("<< not yet known >>");
	}
      printf("]");
    }
}

void display_cont_args(cont)
    andcont *cont;
{

#ifdef TRACE

  Term *areg;
  int arity;

  arity=cont->def->arity;
  areg=cont->choice_cont->arg;

  if(arity>0)
    {
      if(arity > 0) {
	int i;
	printf("(");
	for(i = 0 ; i != arity ; i++) {
	  display_term(areg[i],-1);
	  if(i != arity - 1) printf(", ");
	}
	printf(")");
      }
      return;
    }
#else
  return;
#endif
}

#ifdef TRACE
void display_cont_trace(cont)
     andcont *cont;
{
  if(cont->trace & (MONITOR_CHILDREN))
    printf("*");
  if(cont->trace & CREEP)
    printf("^");
}
#endif

void display_lone_b_continuation(cont,ind)
     andcont *cont;
     int ind;
{    
#ifdef TRACE
char *name;
int arity;

if(cont==NULL) return;
if(cont->def==NULL) {
  name="Root";
  arity = 0;
} else {
  name=AtmPname(cont->def->name);
  arity = cont->def->arity;
}
#endif

#ifdef TRACE
if(cont->trace & TRACE_INIT)
  {
    printf("\n");
    indent(ind);
    printf("%%  << top level >>");
    return;
  }
#endif
printf("\n");
indent(ind);

if(cont->label==NULL)
  {
    printf("<< not yet known >>");
    return;
  }

    switch(CodeToEnum(GetOpCode(cont->label))) {
    
    case GUARD_COLLECT:

#ifdef TRACE
      printf("C  <<");
      break;
#else
      printf("<<C>>");
      return;
#endif

    case GUARD_UNIT:

#ifdef TRACE
      printf("U  <<");
      break;
#else
      printf("<<U>>");
      return;
#endif

    case GUARD_CUT:

#ifdef TRACE
      printf("-> <<");
      break;
#else
      printf("<<->>>");
      return;
#endif

    case GUARD_NOISY_CUT:

#ifdef TRACE
      printf("!  <<");
      break;
#else
      printf("<<!>>");
      return;
#endif

    case GUARD_COMMIT:
#ifdef TRACE
      printf("|  <<");
      break;
#else
      printf("<<|>>");
      return;
#endif

    case GUARD_NOISY_COMMIT:
#ifdef TRACE
      printf("|| <<");
      break;
#else
      printf("<<||>>");
      return;
#endif

    case GUARD_WAIT:
#ifdef TRACE
      printf("?  <<");
      break;
#else
      printf("<<?>>");
      return;
#endif

    case GUARD_QUIET_WAIT:
#ifdef TRACE
      printf("?? <<");
      break;
#else
      printf("<<??>>");
      return;
#endif

    case GUARD_HALT:
#ifdef TRACE
      printf("H  <<");
      break;
#else
      printf("<<H>>");
      return;
#endif

    default:
#ifdef TRACE
      printf("... %% <<");
      break;
#else
      printf("<<... %%>>");
      return;
#endif

      }

#ifdef TRACE
display_cont_trace(cont);
if(trace_full_cont) 
  {
    printf("%d:%s",AndContNo(cont),name);
  }
else
  {
    printf("%s/%d/%d>>",name,arity,AndContNo(cont));
    return;
  }

if(cont->def!=NULL)
  display_cont_args(cont);
printf(")>>");
return;
#endif
}


void display_a_continuations(cont,ind)
    andcont *cont;
     int ind;
{    

#ifdef TRACE
char *name;
int arity;  
if(cont==NULL) return;
if(cont->def==NULL) {
  name="Root";
  arity = 0;
} else {
  name=AtmPname(cont->def->name);
  arity = cont->def->arity;
}
#endif
    if(cont->next==NULL) return;

#ifdef TRACE
    if(cont->trace & TRACE_INIT) 
      {
	printf("\n");
	indent(ind);
	printf("<< top level >>");
	return;
      }
#endif

    if(cont->label==NULL) 
      {
	display_a_continuations(cont->next,ind);
	return;
      }

    switch(CodeToEnum(GetOpCode(cont->label))) {
    case GUARD_COLLECT:
    case GUARD_UNIT:
    case GUARD_CUT:
    case GUARD_NOISY_CUT:
    case GUARD_COMMIT:
    case GUARD_NOISY_COMMIT:
    case GUARD_WAIT:
    case GUARD_QUIET_WAIT:
    case GUARD_HALT:
      printf("\n");
      indent(ind);
      printf("%% ");
#ifdef TRACE
      printf("<<");
      display_cont_trace(cont);
      if(trace_full_cont) 
	{
	  printf("%d:%s",AndContNo(cont),name);
	  break;
	}
      else
	{
	  printf("%s/%d/%d>>",name,arity,AndContNo(cont));
	  display_a_continuations(cont->next,ind);
	  return;
	}
#else
      printf("<<>>");
      display_a_continuations(cont->next,ind);
      return;
#endif
    case PROCEED:
      printf("\n");
      indent(ind);
#ifdef TRACE
      printf("<<<");
      display_cont_trace(cont);
      if(trace_full_cont) 
	{
	  printf("%d:%s",AndContNo(cont),name);
	  break;
	}
      else
	{
	  printf("%s/%d/%d>>",name,arity,AndContNo(cont));
	  display_a_continuations(cont->next,ind);
	  return;
	}
#else
      printf("<<>>");
      display_a_continuations(cont->next,ind);
      return;
#endif
      
    default:
      printf("\n");
      indent(ind);
#ifdef TRACE
      printf("<<");
      display_cont_trace(cont);
      if(trace_full_cont) 
	{
	  printf("%d:%s",AndContNo(cont),name);
	  break;
	}
      else
	{
	  printf("%s/%d/%d>>",name,arity,AndContNo(cont));
	  display_a_continuations(cont->next,ind);
	  return;
	}
#else
      printf("<<>>");
      display_a_continuations(cont->next,ind);
      return;
#endif

    }
#ifdef TRACE
if(cont->def!=NULL)
  display_cont_args(cont);
printf(")>>");
display_a_continuations(cont->next,ind);
#endif
}

void display_here(ind)
int ind;
{
  printf("\n");
  indent(ind);
  printf("@@ HERE @@");
}

void display_b_continuation(cont,ind)
    andcont *cont;
     int ind;
{    
  if(cont==NULL) return;
  while(TRUE)
    {
      if(cont->next==NULL) { display_lone_b_continuation(cont,ind); return; }
      cont=cont->next;
    }
}



void display_constraints(constr)
     constraint *constr;
{
  constraint *cnst;
  for(cnst = constr; cnst != NULL; cnst = cnst->next) {
    display_constraint(cnst);
    printf("\n ");
  }
}

  

void display_ref(ref)
     Reference ref;
{
  envid *env;
  
  printf("REF, ");

  for(env = RefEnv(ref); (env != NULL && env != env->env) ; env = env->env);
#ifdef DEBUG
  printf("Id: %#lx, ", env);
#endif

  if(IsUnBoundRef(ref))
    printf("unbound, ");
  else
    printf("bound %#lx, ", RefTerm(ref));
  printf("\n");

  printf("\n");
}


void display_var(var)
     Reference var;
{
  envid *env;
  suspension *susp;
  
  printf("VAR, ");

  if (IsUnBoundRef(var)) {
    for(env = RefEnv(var); (env != NULL && env != env->env) ; env = env->env);
#ifdef DEBUG
    printf("Id: %#lx, ", env);
#endif
  }

  if(IsUnBoundRef(var))
    printf("unbound, ");
  else
    printf("bound %#lx, ", RefTerm(var));
  printf("\n");

  if (IsGVA(RefTerm(var)) && GvaIsSva(RefGva(var))) {
    susp = SvaSusp(GvaSva(RefGva(var)));
    if(susp == NULL) {
      printf("no suspensions");
    } else {
      printf("suspensions %#lx", (long)susp);
    }
  }

  printf("\n");
}


    
void dt(t)
    Term t;
{
    display_term(t,-1); printf("\n");
}


void dr(reg,nr)
    Term *reg;
    int nr;
{
    int		i;

    for(i=0 ; i!=nr ; i++) {
	printf("r[%d] = ",i);
	display_term(reg[i],-1);
	printf("\n");
    }
}

bool andbox_is_on_path(present,base)
     andbox *present,*base;
{
  andbox *andb=base;

  if(base==NULL) return FALSE;
  
  if(present==base) return TRUE;
  while(TRUE)
    {
      andb=andb->father->father;
      if(andb==NULL) return FALSE;
      if(andb==present) return TRUE;
    }
}

bool choicebox_is_on_path(present,base)
     choicebox *present;
     andbox *base;
{
  choicebox *chb=base->father;

  if(base==NULL) return FALSE;

  while(TRUE)
    {
      if(chb==present) return TRUE;
      if(chb->father==NULL) return FALSE;
      chb=chb->father->father;
    }
}

void display_configuration(andb, insert,chb)
    andbox *andb;
    choicebox *insert,*chb;
{
    choicebox *top;

    for(top = andb->father;
	top->father != NULL;
	top = top->father->father) ;

    display_choice(top, 0, andb, insert, chb, TRUE, FALSE,0);
    printf("\n");
}

void display_choicebox(chb, insert,chb1)
     choicebox *chb;
     choicebox *insert,*chb1;
{
  andbox *base;

  base=NULL;
  
  display_choice(chb, 0, base, insert, chb1,TRUE, FALSE,0);
  printf("\n");
}

void display_andbox(andb, insert, chb)
     andbox *andb;
     choicebox *insert;
     choicebox *chb;
{
  andbox *base;

  base=NULL;
  display_and(andb, 0, base, insert, chb, FALSE, 0);
}

void display_flat_andbox(andb, insert,chb)
     andbox *andb;
     choicebox *insert,*chb;
{
  andbox *base;

  base=andb;
  display_and(andb, 0, base, insert, chb, TRUE,0);
}

void da(andb)
     andbox *andb;
{
  display_andbox(andb, NULL,NULL);
}

void dc(chb)
     choicebox *chb;
{
  display_choicebox(chb, NULL,NULL);
}
