%{
#include <stdio.h>
#include <setjmp.h>
#include <signal.h>
#include "tag.h"
#include "structs.h"
#define  	YYMAXDEPTH	300
#define		PNULL		-1
#define		BOTTOM		-2
#define		MAXNOID		100
/*
#define		NUMOFCELL	50000
*/
#define		MAXAUXEQN	100
#define 	MAXIFLEVEL	16
#define		FNTABSIZE	100
#define		MAXEQNSINEXP	25
#define		NUMOFFILES	10
/*
#define		WRSTKLN		10000
#define		RDSTKLN		10000
*/
#define		MAXNUMCONSULT	10
/*macros for accessing the field in a particular heapcell */
#define		heap_tag(i)	heap[i].tag
#define		heap_lptr(i)	heap[i].lfld.lptr
#define		heap_name(i)	heap[i].lfld.name
#define		heap_numb(i)	heap[i].lfld.numdata
#define		heap_offs(i)	heap[i].lfld.var_offset
#define		heap_rptr(i)	heap[i].rptr
#define		heap_auxv(i)	heap[i].auxval
#define		heap_eqnt(i)	heap[i].eqntype
#define		heap_next(i)	heap[i].next_free_cell

extern FILE *yyin; 
extern char yytext[];
extern int line;
extern int yyleng;
extern int functor_count;
extern char *functor_array[];
extern short int bracket_count;
extern short int list_read_flag;
char *openfilename;

int	NUMOFCELL     = 50000;
int	WRSTKLN	      = 10000;
int	RDSTKLN	      = 10000;
int	FSTKSIZE      = 25000;
int	TRAILSTKSIZE  = 30000;
int	VARSTKSIZE    = 60000;
int	SOPSTKSIZE    = 10000;


/*
struct heapcell 	heap[NUMOFCELL];
struct readst		*read_stack[RDSTKLN];
struct writest_cell 	write_stack[WRSTKLN];
*/

struct heapcell 	*heap;
varstkptrtype           *trailstk;
                             /*trailstk stores pointers to var cell whose*/
                             /* bindings are to be undone on backtracking*/
struct frame_stk_cell   *fstk;
struct var_stk_cell     *varstk;
struct sop_stack_cell 	*sopstk;
struct readst  		**read_stack;
struct writest_cell 	*write_stack;
					/*In the type field of the write-stack*/
					/*PFALSE is for num & PTRUE for string*/
int			readst_top, writest_top, read_ptr;
struct {char *fname;
	short int cflag;	/*PTRUE for reconsult; PFALSE for consult*/
	short int line;
	FILE *fptr;
	short int time;
       }		consult_array[MAXNUMCONSULT];
int			consult_ptr;
struct file_struct	files[NUMOFFILES];
int			fileindex;
struct fn_hash_cell 	*fn_hash_table[FNTABSIZE];
cellptrtype 		*tempeqn;
cellptrtype		flattened_in_exp[MAXEQNSINEXP];	
			    /*used to  handle  flattened eqns of*/
			    /*exp in the f(..) => exp where eqns*/
	/*tempeqnstk is used as a stack to handle the "if" in the manner*/
	/*described in the file if.handle. The routines  push_tempeqnstk*/
	/*and pop_tempeqnstk manipulate this structure.			*/
struct tempeqnstk_cell 	tempeqnstk[MAXIFLEVEL];
short  int		top_tempeqnstk = 0; 	/*stk-ptr for tempeqnstk*/
int			curr_temp_eqn_slot = 0; /*tempeqn's index*/
int			curr_temp_exp_slot = 0; /*flattened_in_exp's index*/
int			num_of_eqns  = 0; 	/*record no. of equations*/
char			*tempvartab[MAXNOID];
int			var_tab_ptr; 		/*keep track of no. of vars*/
						/*in the function*/
int			num_of_formals = 0; 	/*keep track of # of formals*/
int			num_of_actuals ; 	/*keep track of # of actuals*/
int			numgoals = 0;	    /*keep track of # of goals solved*/
int			report_last_var;    /*1 if query is functional else 0*/
cellptrtype		x, i, j, k, l, insert_pt, exec_code, rcode, endlist;
				/*rcode is used to pass the structure*/
				/*constructed by yyparse to the read */
				/*list routine. The list-read routine*/
				/*checks if the structure constructed*/
				/*is a list and nothing else.	     */
int			m, n; 
char			*s, *str;
struct molecule		*next_mol;	    /*Pointer to next free molecule*/
short int		isempty_file;	    /*for empty input file*/
short int		yyprs_begin ;	    /*to identify first call to yylex*/
short int 		timestamp = 0;      /*used for reconsulting*/
short int 		currstamp;          /*used for reconsulting*/
short int 		reconsult_flag;     /* --- do ------*/
short int 		isreconsult;        /* --- do ------*/
struct spycell		*spyptr ;
int			spyframe;
short int		spyflag;
short int		err_flag = PFALSE;
short int		execOVER;	     /*used for user interrupts*/
jmp_buf		 	initbuff, execbuff, parserrbuff;

#include "memman.h"
#include "init.h"
#include "inframe.h"
%}
%union {
	char *string;
	int  intval;
        };
%type <intval> exp expp pgm def eqlist eqn comps fnmlist defgoal thenwhp elsewhp
%type <string> funcd
%type <intval> list explist wrlist arglist term body patterns stsym strterm
%type <intval> query bodytype thenpt ifcond funcall tconstructor tstring exph
	/*warning: the order of the tokens for key words is very crucial 
	  here. If you change the order here then a different y.tab.h 
	  would be generated and then the function keywd_search in eql.lex
	  would have to be changed */
%left TOR
%left TAND
%right TNOT
%nonassoc TLESSP TGREATERP TNUMBERP TLISTP TGREATEREQ TLESSEQ  
%left TPLUS TMINUS
%left TMUL TDIVIDE
%left TMOD TDIV
%right TABS
%nonassoc TEQ TNULL TATOM TBOOL TISVAR TCPUTIME TSHOWTIME
%token TREAD TREADB TWRITE TWRITEB TCONSTRUCTOR TCONSULT 
%token TRECONSULT TSAVE TTRACE
%token TIF TELSE TTHEN TWHERE TTRUE TFALSE TCONS TCAR TCDR 
%token TLINE TCHAR TINT TLIST
%token TLBRACK TRBRACK TBELONG TLPAR TRPAR TLBRACE TRBRACE TQMARK 
%token TDEF TCOMMA TSEMCOL TEQUAL TPERIOD TBAR TCOLON
%token <string> TID TNATOM TNUM TFUNCTORNM TSTRING
%start stsym
%%
/*grammer rules for EqL*/
stsym	:	stsym TCONSTRUCTOR TCOLON fnmlist TPERIOD pgm 
			{
			 /*disp_heap();*/
			 /*printf("%d goals solved\n", numgoals);*/
			 /*numgoals = 0;*/
			 $$ = $6;
			}
	|	TCONSTRUCTOR TCOLON fnmlist TPERIOD pgm
			{$$ = $5;}
	|	TCONSTRUCTOR TCOLON fnmlist TPERIOD
			{$$ = PNULL;}
	|	pgm
			{$$ = $1;}
	|		{isempty_file = PTRUE; 
		 	 $$ = PNULL;
			}
	|	TPERIOD
			{isempty_file = PTRUE;
			 $$ = PNULL;
			}
	|	TQMARK	
			{isempty_file = PTRUE;
			 $$ = PNULL;
			}
	;

fnmlist :	fnmlist TCOMMA TID
			{ 
			  functor_array[functor_count] = $3;
			  ++functor_count;
			}
	|	TID
			{ 
			  functor_array[functor_count] = $1;
			  ++functor_count;
			}
	|	fnmlist TCOMMA TNATOM
			{ 
			  functor_array[functor_count] = $3;
			  ++functor_count;
			}
	|	TNATOM
			{ 
			  functor_array[functor_count] = $1;
			  ++functor_count;
			}
				/*rules below needed for reconsult*/
	|	TFUNCTORNM
		        {
			}	
	|	fnmlist TCOMMA TFUNCTORNM
			{
			}
	;


defgoal :	def 
			/*TPERIOD*/
			{ rcode = PNULL; $$ = $1;}
     	|	TQMARK query 
			/* TPERIOD*/
			{ $$ = $2;}
	| 	error   
			{rcode = PNULL;}
        ;

pgm	:	defgoal TPERIOD
			{ $$ = $1;}

query   :       eqlist
                        {
			 heap[$1].auxval = heap[heap[$1].lfld.lptr].auxval;
				/*The auxval field of eqlist is being used*/
				/*for parsing so we have to restore    the*/
				/*priority value stored there.		  */
			 m = num_of_eqns + curr_temp_eqn_slot;
                         exec_code = node(GWHERE, PNULL, $1, m, 0);
                                /*dummy node to facilitate sorting */
				/*and to store the no. of equations*/
                         insert_eqns(exec_code);
                         sort_eqns(exec_code);
			 curr_temp_eqn_slot = 0;
			 num_of_eqns = 0;
			 report_last_var = 0;
			 $$ = $1;
			 rcode = PNULL;
                        }
        |       bodytype
                        {
			 m = num_of_eqns + curr_temp_eqn_slot + 1;
                          /* $1 points to a list of equations*/
                         exec_code = node(GWHERE, PNULL, $1, m, 0);
                                /*dummy node to facilitate sorting*/
				/*return this cell to the heap after sorting*/
                         insert_eqns(exec_code);
                         sort_eqns(exec_code);
			 curr_temp_eqn_slot = 0;
			 num_of_eqns = 0;
			 report_last_var = 1;
			 $$ = $1;
                        }
        ;
 
 
bodytype :      exp
                        {
                         i = nodegid(GID, var_tab_ptr, PNULL, PNULL, 0);
                         tempvartab[var_tab_ptr] = "";
				/*The last slot in tempvartab contains the*/
				/*value of  the  expression to be reported*/
                         ++var_tab_ptr;
                         m = calc_eqn_prio(i, $1);
                         n = find_eqn_type(i, $1);
                         j = node(GEQN, i, $1, m, n);
                         $$ = node(GEQNODE, j, PNULL, m, n);
			 rcode = $1;		/*rcode used by list read*/
                        }
        |       expp TWHERE eqlist
                        {
			 rcode = PNULL;
			 insert_eqns_of_exp(heap[$3].auxval);
			 heap[$3].auxval = heap[heap[$3].lfld.lptr].auxval;
				/*The auxval field of eqlist is being used*/
				/*for parsing so we have to restore    the*/
				/*priority value stored there.		  */
                         i = nodegid(GID, var_tab_ptr, PNULL, PNULL, 0);
                         tempvartab[var_tab_ptr] = "";
                         ++var_tab_ptr;
				/*The last slot in tempvartab contains the*/
				/*value of  the  expression to be reported*/
                         m = calc_eqn_prio(i, $1);
                         n = find_eqn_type(i, $1);
                         j = node(GEQN, i, $1, m, n);
                         $$ = node(GEQNODE, j, $3, m, n);
                        }
        ;



def	:	funcd TLPAR patterns TRPAR TDEF body
			{
			 insert_eqns($6);
			                        /*insert_eqns is called only*/
						/*if  num_of_eqns  is  zero.*/
			 sort_eqns($6);
			 curr_temp_eqn_slot = 0;
			 num_of_eqns = 0;
			 insert_fn_in_hash_tab($3, $6, $1, 
					num_of_formals, var_tab_ptr);
			 num_of_formals = 0;
			 $$ = $6;
			}
	|	funcd TLPAR TRPAR TDEF body
			{
			 insert_eqns($5);
			 sort_eqns($5);
			 curr_temp_eqn_slot = 0;
			 num_of_eqns = 0;
			 insert_fn_in_hash_tab(PNULL, $5, $1, 
					num_of_formals, var_tab_ptr);
			 num_of_formals = 0;
			 $$ = $5;
			}
	;

patterns :	term
		  	{
			 $$ = node(GFORMAL, $1, PNULL, PNULL,0);
			 ++num_of_formals;
			}
	 |	term TCOMMA patterns 
			{
			 $$ = node(GFORMAL, $1, $3, PNULL,0);
			 ++num_of_formals;
			}
	 ;

tstring  :	TSTRING
			{m = strlen($1) - 1;
			 i = node(GCONS, PNULL, PNULL, ISTRING, 0);
			 while(m >= 0)
			      { x = getfreecell(heap);
				heap[x].tag = GNATOM;
				str = (char *) malloc(2);
				str[0] = $1[m];
				str[1] = '\0';
				heap[x].lfld.name = str;
				heap[x].rptr = PNULL;
				heap[x].auxval = PNULL;
				heap[x].eqntype = 0;
				j = node(GCONS, x, i, ISTRING, 0);
				i = j;
				--m;
			      };
			 $$ = i;
			}
	;

strterm :	TLBRACK TID TCOLON TID TRBRACK
			{i = nodegid(GID, var_search($2), PNULL, PNULL, 0);
			 j = nodegid(GID, var_search($4), PNULL, PNULL, 0); 
			 $$ = node(GCONS, i, j, ISTRING, 0);
			}
	|	TLBRACK TNATOM  TCOLON TID TRBRACK
			{if (strlen($2) > 1) 
				{printf("Illegal string catenation : error\n");
				 longjmp(parserrbuff, 0);
				};
			 i = nodegid(GNATOM, 0, PNULL, PNULL, 0);
			 heap[i].lfld.name = $2;
			 j = nodegid(GID, var_search($4), PNULL, PNULL, 0); 
			 $$ = node(GCONS, i, j, ISTRING, 0);
			}
	|	TLBRACK TID TCOLON tstring TRBRACK
			{i = nodegid(GID, var_search($2), PNULL, PNULL, 0);
			 $$ = node(GCONS, i, $4, ISTRING, 0);
			}
	|	TLBRACK TNATOM  TCOLON tstring TRBRACK
			{if (strlen($2) > 1) 
				{printf("Illegal string catenation : error\n");
				 longjmp(parserrbuff, 0);
				};
			 i = nodegid(GNATOM, 0, PNULL, PNULL, 0);
			 heap[i].lfld.name = $2;
			 $$ = node(GCONS, i, $4, ISTRING, 0);
			}
	;

term	:	TNATOM
			{
			 x = getfreecell(heap);
			 heap[x].tag = GNATOM;
			 heap[x].lfld.name = $1;
			 $$ = x; 
			 heap[x].rptr = PNULL;
			 heap[x].auxval = PNULL;
			 heap[x].eqntype = 0;
			}
	|	TID
			{
			 $$ = nodegid(GID, var_search($1), PNULL, PNULL, 0);
			}
	|	strterm
			{
			 $$ = $1;
			}
	|	tstring
			{
			 $$ = $1;
			}
	|	TNUM
			{
			 $$ = node(GNUM, atoi($1), PNULL, PNULL,0);
			}
	|	TCONS TLPAR term TCOMMA term TRPAR
			{
			 $$ = node(GCONS, $3, $5, PNULL,0);
			}
	|	TLBRACK term TBAR term TRBRACK
			{
			 $$ = node(GCONS, $2, $4, PNULL, 0);
			}
	|	tconstructor TLPAR comps TRPAR
			{
			 $$ = node(GCONS, $1, $3, PTRUE, 0);
			}
	|	tconstructor TLPAR TRPAR
			{
			 $$ = node(GCONS, $1, PNULL, PTRUE, 0);
			}
	|	list
			{
			 $$ = $1;
			}
	;

list	:	TLBRACK comps TRBRACK
			{
			 $$ = $2;
			}
	|	TLBRACK TRBRACK
			{
			 $$ = node(GCONS, PNULL, PNULL, PNULL,0);
			}
	;

comps	:	term
			{
			 i = node(GCONS, PNULL, PNULL, PNULL,0);
			 $$ = node(GCONS, $1, i, PNULL,0);
			}
	|	term TCOMMA comps
			{
			 $$ = node(GCONS, $1, $3, PNULL,0);
			}
	;

body	:	exp
			{
			 $$ = node(GWHERE, $1, PNULL, curr_temp_eqn_slot,0);
			}
	|	expp TWHERE eqlist
			{
			 insert_eqns_of_exp(heap[$3].auxval);
			 heap[$3].auxval = heap[heap[$3].lfld.lptr].auxval;
				/*The auxval field of eqlist is being used*/
				/*for parsing so we have to restore    the*/
				/*priority value stored there.		  */
			 m = num_of_eqns + curr_temp_eqn_slot;
		         $$ = node(GWHERE, $1, $3, m, 0);
			}
	;

expp	:	exp
		   	{
			int j;
			for(j = 0; j < curr_temp_eqn_slot; j++)
				flattened_in_exp[j] = tempeqn[j];
			curr_temp_exp_slot = curr_temp_eqn_slot;
			if (curr_temp_exp_slot >= MAXEQNSINEXP)
			 {printf("Too much nesting in expressions: aborting\n");
			  longjmp(parserrbuff, 0);
			 };
			curr_temp_eqn_slot = 0;
			}
	;


ifcond	:	TIF exp
		  	{ 
			 i = flatten($2);
			 $$ = i;
			 push_tempeqnstk();
			 /*printf("inside then\n");*/
			}		 
	;

thenpt 	:	ifcond TTHEN exp
			{
			 i = nodenum(GTRUE, PTRUE, PNULL, PNULL, 0);
	  		 tempeqn[curr_temp_eqn_slot++] = node(GEQN, $1, i, 
				calc_eqn_prio($1, i), find_eqn_type($1, i));
			 j = node(GWHEREIF, $3, PNULL, curr_temp_eqn_slot, 0);
			 insert_eqns(j);
			 sort_eqns(j);
                         free(tempeqn);
                         tempeqn = (cellptrtype *) calloc(MAXAUXEQN, sizeof(cellptrtype));
			 curr_temp_eqn_slot = 0;
			 $$ = node(GIF, $1, j, PNULL,0);
			 /*printf("inside else\n");*/
			}
	|	thenwhp TWHERE eqlist TRPAR
			{
			 endlist = heap[$3].auxval;
			 heap[heap[$1].rptr].rptr = $3;
			 heap[$3].auxval = heap[heap[$3].lfld.lptr].auxval;
				/*The auxval field of eqlist is being used*/
				/*for parsing so we have to restore    the*/
				/*priority value stored there.		  */
			 insert_eqns(heap[$1].rptr);
			 free(tempeqn);
			 pop_tempeqnstk();
			 insert_eqns(endlist);
			 sort_eqns(heap[$1].rptr);
			 /*sort_eqns(endlist);*/
                         free(tempeqn);
                         tempeqn = (cellptrtype *) calloc
					     (MAXAUXEQN, sizeof(cellptrtype));
			 curr_temp_eqn_slot = 0;
			 j = heap[heap[heap[$1].rptr].lfld.lptr].lfld.lptr;
			 $$ = node(GIF, j, $1, PNULL,0);
			 /*printf("inside else\n");*/
			}
	;

thenwhp : 	ifcond TTHEN TLPAR exp  
			{
			 i = nodenum(GTRUE, PTRUE, PNULL, PNULL, 0);
	  		 k = node(GEQN, $1, i, calc_eqn_prio($1, i),
						 find_eqn_type($1, i));
			 l = node(GEQNODE, k, PNULL, calc_eqn_prio($1, i),
                                                 find_eqn_type($1, i));
			 j = node(GWHEREIF, $4, l, curr_temp_eqn_slot, 0);
			 push_tempeqnstk();
			 $$ = j;
			}
	;

elsewhp : 	thenpt TELSE TLPAR exp
			{
			 i = node(GFALSE, PFALSE, PNULL, PNULL, 0);
			 j = heap[$1].lfld.lptr;
	  		 k = node(GEQN, j, i, calc_eqn_prio(j, i),
						 find_eqn_type(j, i));
			 l = node(GEQNODE, k, PNULL, calc_eqn_prio(j, i),
                                                 find_eqn_type(j, i));
			 j = node(GWHEREIF, $4, l, curr_temp_eqn_slot, 0);
			 push_tempeqnstk();
                         l = node(GIFBODY, heap[$1].rptr, j, PNULL,0);
						/*reuse l*/
                         heap[$1].rptr = l;
			 $$ = $1;
			}
	;

eqn	:	exp TEQUAL exp 
			{
			 $$ = node(GEQN, $1, $3, calc_eqn_prio($1,$3), 
						 find_eqn_type($1,$3));
			}
	|	TWRITEB TLPAR wrlist TRPAR
			{
			 i = node(GWRITE, PNULL, $3, GWRITE, 0);
			 j = nodegid(GID, var_search("_"), PNULL, PNULL, 0);
			 $$ = node(GEQN, i, j, calc_eqn_prio(i, j), 
						 find_eqn_type(i, j));
			}
	|	TWRITE TLPAR TNATOM TCOMMA wrlist TRPAR
			{
			 i = node(GWRITE, PNULL, $5, PNULL, 0);
			 heap[i].lfld.name = $3;
			 j = nodegid(GID, var_search("_"), PNULL, PNULL, 0);
			 $$ = node(GEQN, i, j, calc_eqn_prio(i, j), 
						 find_eqn_type(i, j));
			}
	|	TWRITE TLPAR TID TCOMMA wrlist TRPAR
			{
			 i = node(GWRITE, PNULL, $5, PNULL, 1);
			 heap[i].lfld.var_offset = var_search($3);
			 j = nodegid(GID, var_search("_"), PNULL, PNULL, 0);
			 $$ = node(GEQN, i, j, calc_eqn_prio(i, j), 
						 find_eqn_type(i, j));
			}
	|	exp TBELONG exp
			{
			 $$ = node(GBELONG, $1, $3, calc_eqn_prio($1,$3), 
						 find_eqn_type($1,$3));
			}
	;


exp	:	thenpt TELSE exp  
			{
			 i = node(GFALSE, PFALSE, PNULL, PNULL, 0);
			 k = heap[$1].lfld.lptr;
	  		 tempeqn[curr_temp_eqn_slot++] = node(GEQN, k, i, 
				calc_eqn_prio(k, i), find_eqn_type(k, i));
			 j = node(GWHEREIF, $3, PNULL, curr_temp_eqn_slot, 0);
			 insert_eqns(j);
			 sort_eqns(j);
                         l = node(GIFBODY, heap[$1].rptr, j, PNULL,0);
                         heap[$1].rptr = l;
			 $$ = $1;
			 /*printf("if recognized\n");*/
			 pop_tempeqnstk();
			 	/*if recognized so restore tempeqn */
			}
   	|	elsewhp TWHERE eqlist TRPAR  
			{
			 endlist = heap[$3].auxval;
			 heap[$3].auxval = heap[heap[$3].lfld.lptr].auxval;
                                /*The auxval field of eqlist is being used*/
                                /*for parsing so we have to restore    the*/
                                /*priority value stored there.            */
			 k = heap[heap[heap[$1].rptr].rptr].rptr;
			 heap[k].rptr = $3;
                         insert_eqns(k);
                         free(tempeqn);
                         pop_tempeqnstk();
                         insert_eqns(endlist);
                         sort_eqns(k);
                         free(tempeqn);
			 pop_tempeqnstk();
			 	/*if recognized so restore tempeqn */
			}
	|	TCONS TLPAR exp TCOMMA exp TRPAR 
			{
			 i = flatten($3);
			 j = flatten($5);
			 $$ = node(GCONS, i, j, PNULL,0);
			}
	|	TLBRACK exp TBAR exp TRBRACK
			{
			 i = flatten($2);
			 j = flatten($4);
			 $$ = node(GCONS, i, j, PNULL,0);
			}
	|	TCAR TLPAR exp TRPAR 
			{
			 i = flatten($3);
			 $$ = node(GCAR, i, PNULL, PNULL,0);
			}
	|	TCDR TLPAR exp TRPAR 
                        { 
                         i = flatten($3); 
                         $$ = node(GCDR, i, PNULL, PNULL,0); 
                        } 
	|	funcall TLPAR TRPAR 
			{
			 $$ = $1;
			 heap[$1].eqntype = var_look(heap[$1].lfld.name);
			}
	|	funcall TLPAR arglist TRPAR 
			{
			 heap[$1].rptr = $3;
			 num_of_actuals = heap[$3].eqntype;
			 heap[$1].auxval = heap[$1].auxval + 
						num_of_actuals* FNTABSIZE;
					/*auxval MOD FNTABSIZE is number of */
					/*parameters while auxval DIV FNTAB-*/
					/*-SIZE is the hash value of the fn.*/
			 heap[$1].eqntype = var_look(heap[$1].lfld.name);
					/*eqntype stores the offset of the id*/
					/*in case the name of the fn. is  be-*/
					/*ing passed as a parameter   (higher*/
					/*order function).		     */
			 $$ = $1;
			}
	|	tconstructor TLPAR explist TRPAR
			{
			 $$ = node(GCONS, $1, $3, PTRUE, 0);
			}
	|	tconstructor TLPAR TRPAR
			{
			 $$ = node(GCONS, $1, PNULL, PTRUE, 0);
			}
	|	TLBRACK explist TRBRACK
			{
			 $$ = $2;
			}
	|	TLBRACK TRBRACK
			{
			 $$ = node(GCONS, PNULL, PNULL, PNULL, 0);
			}
	|	TNATOM 
			{
			 x = getfreecell(heap);
			 heap[x].tag = GNATOM;
			 heap[x].lfld.name = $1;
			 heap[x].rptr = PNULL;
			 heap[x].auxval = PNULL;
			 heap[x].eqntype = 0;
			 $$ = x;
			}
	| 	TID
			{
			 $$ = nodegid(GID, var_search($1), PNULL, PNULL, 0);
			}
	|	tstring
			{
			 $$ = $1;
			}
	|	TLBRACK TID TCOLON exp TRBRACK
			{j = flatten($4); 
			 i = nodegid(GID, var_search($2), PNULL, PNULL, 0);
			 $$ = node(GCONS, i, j, ISTRING, 0);
			}
	|	TLBRACK TNATOM  TCOLON exp TRBRACK
			{if (strlen($2) > 1) 
				{printf("Illegal string catenation : error\n");
				 longjmp(parserrbuff, 0);
				};
			 j = flatten($4);
			 i = nodegid(GNATOM, 0, PNULL, PNULL, 0);
			 heap[i].lfld.name = $2;
			 $$ = node(GCONS, i, j, ISTRING, 0);
			}
	|	exp TMOD exp
			{
			 i = flatten($1);
			 j = flatten($3);
			 $$ = node(GMOD, i, j, PNULL, 0);
			}
	|	exp TDIV exp
			{
			 i = flatten($1);
			 j = flatten($3);
			 $$ = node(GDIV, i, j, PNULL, 0);
			}
	|	exp TMUL exp
			{
			 i = flatten($1);
			 j = flatten($3);
			 $$ = node(GMUL, i, j, PNULL, 0);
			}
	| 	exp TDIVIDE exp
			{
			 i = flatten($1);
			 j = flatten($3);
			 $$ = node(GDIVIDE, i, j, PNULL, 0);
			}
	|	exp TPLUS exp
			{
			 i = flatten($1);
			 j = flatten($3);
			 $$ = node(GPLUS, i, j, PNULL, 0);
			}
	|	exp TMINUS exp
			{
			 i = flatten($1);
			 j = flatten($3);
			 $$ = node(GMINUS, i, j, PNULL, 0);
			}
	|	TMINUS exp
			{
			 i = flatten($2);
			 $$ = node(GUMINUS, i, PNULL, PNULL, 0);
			}
	|	TABS TLPAR exp TRPAR 
			{
			 i = flatten($3);
			 $$ = node(GABS, i, PNULL, PNULL, 0);
			}
	|	TREADB TLPAR TRPAR
			{
			 $$ = node(GREAD, PNULL, PNULL, GREAD, PNULL);
			 heap[$$].lfld.name = "tty";
			}
	|	TREADB TLPAR TINT TRPAR
			{
			 $$ = node(GREAD, PNULL, PNULL, GREAD, GNUM);
			 heap[$$].lfld.name = "tty";
			}
	|	TREADB TLPAR TATOM TRPAR
			{
			 $$ = node(GREAD, PNULL, PNULL, GREAD, GATOM);
			 heap[$$].lfld.name = "tty";
			}
	|	TREADB TLPAR TBOOL TRPAR
			{
			 $$ = node(GREAD, PNULL, PNULL, GREAD, GBOOL);
			 heap[$$].lfld.name = "tty";
			}
	|	TREADB TLPAR TLINE TRPAR
			{
			 $$ = node(GREAD, PNULL, PNULL, GREAD, GLINE);
			 heap[$$].lfld.name = "tty";
			}
	|	TREADB TLPAR TLIST TRPAR
			{
			 $$ = node(GREAD, PNULL, PNULL, GREAD, GLIST);
			 heap[$$].lfld.name = "tty";
			}
	|	TREADB TLPAR TCHAR TRPAR
			{
			 $$ = node(GREAD, PNULL, PNULL, GREAD, GCHAR);
			 heap[$$].lfld.name = "tty";
			}
	|	TREAD TLPAR TCHAR TCOMMA TNATOM TRPAR
			{
			 $$ = node(GREAD, PNULL, PNULL, PNULL, GCHAR);
			 heap[$$].lfld.name = $5;
			}
	|	TREAD TLPAR TLIST TCOMMA TNATOM TRPAR
			{
			 $$ = node(GREAD, PNULL, PNULL, PNULL, GLIST);
			 heap[$$].lfld.name = $5;
			}
	|	TREAD TLPAR TLINE TCOMMA TNATOM TRPAR
			{
			 $$ = node(GREAD, PNULL, PNULL, PNULL, GLINE);
			 heap[$$].lfld.name = $5;
			}
	|	TREAD TLPAR TBOOL TCOMMA TNATOM TRPAR
			{
			 $$ = node(GREAD, PNULL, PNULL, PNULL, GBOOL);
			 heap[$$].lfld.name = $5;
			}
	|	TREAD TLPAR TATOM TCOMMA TNATOM TRPAR
			{
			 $$ = node(GREAD, PNULL, PNULL, PNULL, GATOM);
			 heap[$$].lfld.name = $5;
			}
	|	TREAD TLPAR TINT TCOMMA TNATOM TRPAR
			{
			 $$ = node(GREAD, PNULL, PNULL, PNULL, GNUM);
			 heap[$$].lfld.name = $5;
			}
	|	TREAD TLPAR TNATOM TRPAR
			{
			 $$ = node(GREAD, PNULL, PNULL, PNULL, PNULL);
			 heap[$$].lfld.name = $3;
			}
				/*reads with filename bound to an id*/
	|	TREAD TLPAR TCHAR TCOMMA TID TRPAR
			{
			 $$ = node(GREAD, PNULL, PNULL, BOTTOM, GCHAR);
			 heap[$$].lfld.var_offset = var_search($5);
			}
	|	TREAD TLPAR TLIST TCOMMA TID TRPAR
			{
			 $$ = node(GREAD, PNULL, PNULL, BOTTOM, GLIST);
			 heap[$$].lfld.var_offset = var_search($5);
			}
	|	TREAD TLPAR TLINE TCOMMA TID TRPAR
			{
			 $$ = node(GREAD, PNULL, PNULL, BOTTOM, GLINE);
			 heap[$$].lfld.var_offset = var_search($5);
			}
	|	TREAD TLPAR TBOOL TCOMMA TID TRPAR
			{
			 $$ = node(GREAD, PNULL, PNULL, BOTTOM, GBOOL);
			 heap[$$].lfld.var_offset = var_search($5);
			}
	|	TREAD TLPAR TATOM TCOMMA TID TRPAR
			{
			 $$ = node(GREAD, PNULL, PNULL, BOTTOM, GATOM);
			 heap[$$].lfld.var_offset = var_search($5);
			}
	|	TREAD TLPAR TINT TCOMMA TID TRPAR
			{
			 $$ = node(GREAD, PNULL, PNULL, BOTTOM, GNUM);
			 heap[$$].lfld.var_offset = var_search($5);
			}
	|	TREAD TLPAR TID TRPAR
			{
			 $$ = node(GREAD, PNULL, PNULL, BOTTOM, PNULL);
			 heap[$$].lfld.var_offset = var_search($3);
			}
	|	TWRITEB TLPAR wrlist TRPAR
			{
			 $$ = node(GWRITE, PNULL, $3, GWRITE, 0);
			}
	|	TWRITE TLPAR TNATOM TCOMMA wrlist TRPAR
			{
			 $$ = node(GWRITE, PNULL, $5, PNULL, 0);
			 heap[$$].lfld.name = $3;
			}
					/*if heap_eqnt is 1 then TID*/
	|	TWRITE TLPAR TID TCOMMA wrlist TRPAR
			{
			 $$ = node(GWRITE, PNULL, $5, PNULL, 1);
			 heap[$$].lfld.var_offset = var_search($3);
			}
	|	TLPAR exp TRPAR
			{
			 $$ = $2;
			}
	|	TNUM
			{
			 $$ = nodenum(GNUM, atoi($1), PNULL, PNULL, 0);
			}
	|	exp TOR exp
			{
			 i = flatten($1);
			 j = flatten($3);
			 $$ = node(GOR, i, j, PNULL, 0);
			}
	|	exp TAND exp
			{
			 i = flatten($1);
			 j = flatten($3);
			 $$ = node(GAND, i, j, PNULL, 0);
			}
        |       TNOT exp 
			{
			 i = flatten($2);
			 $$ = node(GNOT, i, PNULL, PNULL, 0);
			}
	|	TTRUE
			{
			 $$ = nodenum(GTRUE, PTRUE, PNULL, PNULL, 0);
			}
	|	TFALSE
			{
			 $$ = nodenum(GFALSE, PFALSE, PNULL, PNULL, 0);
			}
	|	TNULL TLPAR exp TRPAR
			{
			 i = flatten($3);
			 $$ = node(GNULL, i, PNULL, PNULL, 0);
			}
	|	TNUMBERP TLPAR exp TRPAR
			{
			 i = flatten($3);
			 $$ = node(GNUMBERP, i, PNULL, PNULL, 0);
			}
	|	TEQ TLPAR exp TCOMMA exp TRPAR
			{
			 i = flatten($3);
			 j = flatten($5);
			 $$ = node(GEQ, i, j, PNULL, 0);
			}
	| 	TATOM TLPAR exp TRPAR
			{
			 i = flatten($3);
			 $$ = node(GATOM, i, PNULL, PNULL, 0);
			}
        |       TLISTP TLPAR exp TRPAR
			{
			 i = flatten($3);
			 $$ = node(GLISTP, i, PNULL, PNULL, 0);
			}
        |       TBOOL TLPAR exp TRPAR
			{
			 i = flatten($3);
			 $$ = node(GISBOOL, i, PNULL, PNULL, 0);
			}
        |       TISVAR TLPAR TID TRPAR
			{
			 i = nodegid(GID, var_search($3), PNULL, PNULL, 0);
			 $$ = node(GISVAR, i, PNULL, PNULL, 0);
			}
        |       TCONSULT TLPAR exp TRPAR
			{
			 i = flatten($3);
			 $$ = node(GCONSULT, i, PNULL, PNULL, 0);
			}
        |       TRECONSULT TLPAR exp TRPAR
			{
			 i = flatten($3);
			 $$ = node(GRECONSULT, i, PNULL, PNULL, 0);
			}
        |       TSAVE TLPAR exp TRPAR
			{
			 i = flatten($3);
			 $$ = node(GSAVE, i, PNULL, PNULL, 0);
			}
        |       TTRACE
			{
			 $$ = node(GTRACE, PNULL, PNULL, PNULL, 0);
			 heap[$$].lfld.name = NULL;
			}
        |       TTRACE TLPAR TID TRPAR
			{
			 $$ = node(GTRACE, PNULL, PNULL, PNULL, 0);
			 heap[$$].lfld.name = $3;
			}
        |       TTRACE TLPAR TNATOM TRPAR
			{
			 $$ = node(GTRACE, PNULL, PNULL, PNULL, 0);
			 heap[$$].lfld.name = $3;
			}
        |       TCPUTIME
			{
			 $$ = node(GCPUTIME, PNULL, PNULL, PNULL, 0);
			}
        |       TSHOWTIME
			{
			 $$ = node(GSHOWTIME, PNULL, PNULL, PNULL, 0);
			}
        |       TGREATERP TLPAR exp TCOMMA exp TRPAR
			{
			 i = flatten($3);
			 j = flatten($5);
			 $$ = node(GGREATERP, i, j, PNULL, 0);
			}
        |       exp TGREATERP exp 
			{
			 i = flatten($1);
			 j = flatten($3);
			 $$ = node(GGREATERP, i, j, PNULL, 0);
			}
        |       TGREATEREQ TLPAR exp TCOMMA exp TRPAR
			{
			 i = flatten($3);
			 j = flatten($5);
			 $$ = node(GGREATEREQ, i, j, PNULL, 0);
			}
        |       exp TGREATEREQ exp 
			{
			 i = flatten($1);
			 j = flatten($3);
			 $$ = node(GGREATEREQ, i, j, PNULL, 0);
			}
	|	TLESSP TLPAR exp TCOMMA exp TRPAR
			{
			 i = flatten($3);
			 j = flatten($5);
			 $$ = node(GLESSP, i, j, PNULL, 0);
			}
        |       exp TLESSP exp 
			{
			 i = flatten($1);
			 j = flatten($3);
			 $$ = node(GLESSP, i, j, PNULL, 0);
			}
	|	TLESSEQ TLPAR exp TCOMMA exp TRPAR
			{
			 i = flatten($3);
			 j = flatten($5);
			 $$ = node(GLESSEQ, i, j, PNULL, 0);
			}
        |       exp TLESSEQ exp 
			{
			 i = flatten($1);
			 j = flatten($3);
			 $$ = node(GLESSEQ, i, j, PNULL, 0);
			}
	;

explist :	exp
			{
			 i = node(GCONS, PNULL, PNULL, PNULL, 0);
			 k = flatten($1);
			 $$ = node(GCONS, k, i, PNULL, 0);
			}
	|	exp TCOMMA explist 
			{
			 i = flatten($1);
			 $$ = node(GCONS, i, $3, PNULL, 0);
			}
	;

wrlist :	exp
			{
			 k = flatten($1);
			 $$ = node(GWRITE, k, PNULL, PNULL, 0);
			}
	|	exp TCOMMA wrlist
			{
			 i = flatten($1);
			 $$ = node(GWRITE, i, $3, PNULL, 0);
			}
	;


eqlist	:	eqlist TSEMCOL eqn 
			{int l;
			 $$ = $1;
			 insert_pt = heap[$$].auxval;
			 i = node(GEQNODE, $3, PNULL, heap[$3].auxval,
						      heap[$3].eqntype);
			 heap[insert_pt].rptr = i;
			 if (heap[$3].tag == GBELONG)
				for (l = 0; l < curr_temp_eqn_slot; l++)
					heap[tempeqn[l]].tag = GBELONG;
			 insert_eqns(insert_pt);
			 heap[$$].auxval = i;
			 ++num_of_eqns;
			 curr_temp_eqn_slot = 0;
			}
	|	eqn 
			{int l;
			i = node(GEQNODE, $1, PNULL, heap[$1].auxval,
                                                    heap[$1].eqntype);
			k = node(GEQNODE, PNULL, i, PNULL, PNULL);
					/*k is a dummy node to help in insert*/
					/*it can be freed  after  eq'ns  have*/
					/*been inserted.		     */
			++num_of_eqns;
			if (heap[$1].tag == GBELONG)
				for (l = 0; l < curr_temp_eqn_slot; l++)
					heap[tempeqn[l]].tag = GBELONG;
			insert_eqns(k);
			curr_temp_eqn_slot = 0;
			$$ = heap[k].rptr;
			heap[$$].auxval = i;
			}
	;

tconstructor	:	TFUNCTORNM
			{
			 x = getfreecell(heap);
			 heap[x].tag = GNATOM;
			 heap[x].lfld.name = $1;
			 heap[x].rptr = PNULL;
			 heap[x].auxval = PNULL;
			 heap[x].eqntype = 0;
			 $$ = x;
			}
		;

funcd	:	TID 
			{
			$$ = $1;
			}
	|	TNATOM 
			{
			$$ = $1;
			}
	;


funcall	:   	TID
			{
                         x = getfreecell(heap);
                         heap[x].tag = GFUNCALL;
                         heap[x].lfld.name = $1;
                         heap[x].auxval = hashf($1);
                         $$ = x;
                         heap[x].rptr = PNULL;
                         heap[x].eqntype = 0;
			}
	|	TNATOM
                        {
                         x = getfreecell(heap);
                         heap[x].tag = GFUNCALL;
                         heap[x].lfld.name = $1;
                         heap[x].auxval = hashf($1);
                         $$ = x;
                         heap[x].rptr = PNULL;
                         heap[x].eqntype = 0;
                        }
	;

exph	:	exp
			{
			 $$ = flatten($1);
			}
	;

arglist	:	exph TCOMMA arglist  
			{
			 num_of_actuals = ++heap[$3].eqntype;
			 $$ = node(GACTUAL, $1, $3, PNULL, num_of_actuals);
			}
        |       exp 
			{
			 num_of_actuals = 1;
			 i = flatten($1);
			 $$ = node(GACTUAL, i, PNULL, PNULL, num_of_actuals);
				/*the 5th field is used to compute */
				/*the no. of actuals by passing up */
			}
        ; 


%%

/*programs section */

bus_error()
{
	signal(SIGBUS, bus_error);
	printf("Bus Error : abort : No core image produced\n");
	longjmp(execbuff, 0);
}

seg_violation()
{
	signal(SIGSEGV, seg_violation);
	printf("Segmentation Fault : abort : No core image produced\n");
	longjmp(execbuff, 0);
}

onintr()		/*interrupt handler*/
{
char *request; short int over;
	signal(SIGINT, onintr);		/*reset for next interrupt*/
	request = (char *) malloc (20);
	over = PFALSE;
	while (over == PFALSE)
	  {
	   printf("What now? (type h for help): ");
	   scanf(" %s", request);
	   (void) getchar();		/*eat the carriage return*/
	   if (!strcmp(request, "h") || !strcmp(request, "he") || 
	       !strcmp(request, "hel") || !strcmp(request, "help"))
	       {
		printf("\ntype a for abort\n");
		printf("type c for continue\n");
		printf("type t for trace\n");
		printf("type u for untrace\n");
		printf("type r for reset\n");
		printf("type e for erase constructors\n");
		printf("\n\n");
	       }
	   else
	       if (!strcmp(request, "a") || !strcmp(request, "ab") ||
                   !strcmp(request, "abo") || !strcmp(request, "abor") ||
	           !strcmp(request, "abort"))
		 {
		  printf("\n[ query execution aborted ]\n");
		  over = PTRUE;
		  if (execOVER == PTRUE)
			longjmp(execbuff, 0);
		  else 
			longjmp(initbuff, 0);
		 }
	       else
	       if (!strcmp(request, "t") || !strcmp(request, "tr") ||
                   !strcmp(request, "tra") || !strcmp(request, "trac") ||
	           !strcmp(request, "trace"))
		   {
			debug = PTRUE;
		        over = PTRUE; 
			/*printf("eql> ");
			fflush(stdout);*/
		   }
	       else
	       if (!strcmp(request, "r") || !strcmp(request, "re") ||
                   !strcmp(request, "res") || !strcmp(request, "rese") ||
	           !strcmp(request, "reset"))
			{int jj;
			 execOVER = PFALSE;
			 for(jj = 0; jj < functor_count; jj++)
				 free(functor_array[jj]);
			 functor_count = 0;
			 printf("\neql> ");
			 longjmp(initbuff, 0);
		         over = PTRUE; 
			}
	       else
	       if (!strcmp(request, "c") || !strcmp(request, "co") ||
		   !strcmp(request, "con") || !strcmp(request, "cont") ||
		   !strcmp(request, "conti") || !strcmp(request, "contin") ||
		   !strcmp(request, "continu") || !strcmp(request, "continue"))
		      {
		        over = PTRUE; 
		        /*printf("eql> ");
			fflush(stdout);*/
		      }
	       else 
	       if (!strcmp(request, "u") || !strcmp(request, "un") ||
		   !strcmp(request, "unt") || !strcmp(request, "untr") ||
		   !strcmp(request, "untra") || !strcmp(request, "untrac") ||
		   !strcmp(request, "untrace")) 
			{ over = PTRUE;
			  debug = PFALSE;
			}
	       else 
	       if (!strcmp(request, "e") || !strcmp(request, "er") ||
		   !strcmp(request, "era") || !strcmp(request, "eras") ||
		   !strcmp(request, "erase")) 
			{ int jj;
			  over = PTRUE;
			  printf("\neql> ");
			  fflush(stdout);
			  for(jj = 0; jj < functor_count; jj++)
				 free(functor_array[jj]);
			  functor_count = 0;
			}
	       else 
		   printf("Unknown Option\n");	
	   };
}

main(argc,argv)
int argc;
char *argv[];

{
int i, k, tmp_index, l_bound = 0, u_bound = 0;
FILE *fopen();
	printf("EqL Version 1.0\n\n");
	execOVER = PFALSE;
	consult_ptr = 0;
	tempeqn = (cellptrtype *) calloc(MAXAUXEQN, sizeof(cellptrtype));
	consult_array[consult_ptr].fname = "standard input"; 
	consult_array[consult_ptr].fptr = stdin;
	consult_array[consult_ptr].line = 0;
	consult_array[consult_ptr].time = timestamp++;
	consult_array[consult_ptr++].cflag = PFALSE;
	report_last_var = PNULL;
	tmp_index = 1;
	while (tmp_index < argc)
	  if (argv[tmp_index][0] == '-')
	     switch (argv[tmp_index][1])
	      {
	       case 'h'   :
		  NUMOFCELL = atoi(argv[++tmp_index]);
		  ++tmp_index;
		  break;
	       case 't'	  :
		  TRAILSTKSIZE = atoi(argv[++tmp_index]) + 500; 
		  ++tmp_index;
                  break; 
	       case 'v'	  :
		  VARSTKSIZE = atoi(argv[++tmp_index]) + 500;  
		  ++tmp_index;
                  break;  
	       case 'c'   :
		  FSTKSIZE = atoi(argv[++tmp_index]);  
		  ++tmp_index;
                  break;  
	       case 'w'   :
		  WRSTKLN = atoi(argv[++tmp_index]);  
		  ++tmp_index;
                  break;  
	       case 'r'   :
		  RDSTKLN = atoi(argv[++tmp_index]);  
		  ++tmp_index;
                  break;  
	       case 'e'    :
		  SOPSTKSIZE = atoi(argv[++tmp_index]) + 125;  
		  ++tmp_index;
                  break;  
	       case 'f'    :
		  l_bound = tmp_index++;
		  while ((tmp_index < argc) && (argv[tmp_index][0] != '-')) 
			++tmp_index;
		  u_bound = tmp_index - 1;
		  break;
	       default     :
		  printf("illegal option %s to eql : abort\n", argv[tmp_index]);
		  exit(-1);
		  break;
	      }
	  else {printf("Usage: eql [-erwlvth #] [-f file_1 .. file_n]\n"); 
		exit(-1);};
	heap = (struct heapcell *) calloc(NUMOFCELL, sizeof(struct heapcell));
	freep = (int *) calloc(NUMOFCELL, sizeof(int));
	read_stack = (struct readst **) 
				calloc(RDSTKLN, sizeof(struct readst *));
	write_stack = (struct writest_cell *)
				calloc(WRSTKLN, sizeof(struct writest_cell));
	trailstk = (varstkptrtype *) 
				calloc(TRAILSTKSIZE, sizeof(varstkptrtype));
  	fstk = (struct frame_stk_cell *)
			        calloc(FSTKSIZE, sizeof(struct frame_stk_cell));
	varstk = (struct var_stk_cell *)
				calloc(VARSTKSIZE, sizeof(struct var_stk_cell));
 	sopstk = (struct sop_stack_cell *)
			calloc(SOPSTKSIZE, sizeof(struct sop_stack_cell));
	for(i = u_bound; i > l_bound; i--)
	     {  openfilename = argv[i];
		if ((yyin = fopen(argv[i],"r")) == NULL) 
	   		printf("cannot open file: %s\n", argv[i]);
		else 
		     { consult_array[consult_ptr].fname = argv[i];
		       consult_array[consult_ptr].fptr = yyin;
		       consult_array[consult_ptr].line = 0;
		       consult_array[consult_ptr].time = timestamp++;
		       consult_array[consult_ptr++].cflag = PFALSE;
		     };	
	     };
	if (l_bound == 0)		/*no files in the command line*/
		printf("eql> ");
	setjmp(initbuff);
	if (signal(SIGINT, SIG_IGN) != SIG_IGN)
		signal(SIGINT, onintr);
			/*keep ignoring  signal  if  they are already*/
			/*being ignored (process being run in backgd)*/
			/*NOT so for segsegv, sigbus; always catch'em*/
	signal(SIGSEGV, seg_violation);
	signal(SIGBUS, bus_error);
	initialize();
	setjmp(execbuff);
	setjmp(parserrbuff);
      while(PTRUE)
       {
	while (consult_ptr > 0) 
	   { k = consult_ptr - 1;
	     yyin = consult_array[k].fptr;
	     openfilename = consult_array[k].fname;
	     line = consult_array[k].line;
	     currstamp = consult_array[k].time;
	     isreconsult = consult_array[k].cflag;
	     if (isempty_file == PTRUE)
	       {
		     isempty_file = PFALSE;
		     /*if (k > 0)
		          printf("\b\b\b\b\b\bFile: %s consulted\n", 
						consult_array[k].fname);*/
		     consult_ptr--;
		     if (consult_ptr == 1)	/*stdin*/
			printf("eql> ");
	       }
	     else 
		{ yyprs_begin = PTRUE;
		  yyparse();
		  if (err_flag != PTRUE)
		   {
		    consult_array[k].line = line;
		    if (report_last_var >= 0)
                         execute(exec_code, var_tab_ptr, 
					tempvartab, report_last_var);
		   };
		    execOVER = PTRUE;
		    setjmp(execbuff);
                  	/* var_tab_ptr tells the # of cells needed for vars*/
		  	/* tempvartab  stores the names  of the  vars whose*/
		  	/* values are  reported after the execution is over*/
		    for(j = 0; j < var_tab_ptr; j++)
                	free(tempvartab[j]);
                    var_tab_ptr = 0;
		    report_last_var = PNULL;
		  err_flag = PFALSE;
	          if (isempty_file != PTRUE)
		      if (yyin == stdin) 
		        if (consult_ptr == 1)
		    	   printf("eql> ");
			else if (consult_array[consult_ptr - 1].fptr == stdin)
				     printf("| ");
		};
 	   };
       if (feof(stdin) != 0)		/*eof seen in stdin*/
		{printf("  \n[ EqL execution halted ]\n\n");
                        return;}
       else {consult_ptr = 1; printf("eql> ");};
      };
}


yyerror(s)
char *s;

{
	printf("Syntax error near token \"%s\"" , yytext);
	if (yyin != stdin) 
		printf("in line: %d in file: %s", line + 1, openfilename);
	printf("\n");
	isempty_file = PFALSE;
		/*This is needed because sometimes*/
		/*on an error the yacc may reduce */
		/*by the epsilon rule and that may*/
		/*cause isempty_file to become set*/
		/*which causes interpreter to halt*/
	err_flag = PTRUE;
}


free_fn_cell(q)
struct fn_hash_cell *q;

{ free(q);
}

/*delete_old_fns takes a position in function index table*/
/*a function name and num of formals and deletes all the */
/*functions with identical names and number of arguments */
/*and whose timestamps is less than currstamp		 */
delete_old_fns(fn_tab_index, fn_name, numofargs)
int fn_tab_index;
char *fn_name;
int numofargs;

{ struct fn_hash_cell *p, *q, *head;
  short int nomore;
        q = fn_hash_table[fn_tab_index];
	p = head = (struct fn_hash_cell *) 
				calloc(1, sizeof(struct fn_hash_cell));
						/*head is a dummy header*/
	head->next_candidate = q;
	nomore = PTRUE;
	while ((q != NULL) && (nomore == PTRUE))
	   if ((!strcmp(q->funcname, fn_name)) &&
		 (q->num_of_args == numofargs) &&
		    (q->timestamp < currstamp))		/*if old defn.*/
		{ p->next_candidate = q->next_candidate;
		  free_fn_cell(q);
		  if (q->lastdef == 1) 
			nomore = PFALSE;     /*last defn. found, stop search*/
		  q = p->next_candidate;
	        }
	   else { p = q;
		  q = q->next_candidate;
		};
	fn_hash_table[fn_tab_index] = head->next_candidate;
	free(head);
}
		  
		    
	  
  

insert_fn_in_hash_tab(argptr, bodyptr, nameptr, numofargs, numofvars)
cellptrtype argptr, bodyptr;
char *nameptr;
int 	    numofargs, numofvars;

{
    struct fn_hash_cell *j, *p;
    int k, notokay;

	k = hashf(nameptr);
	if (isreconsult == PTRUE) 
		delete_old_fns(k, nameptr, numofargs);
	j = fn_hash_table[k];
		/* create a fn_hash_cell pointed to by p and */
		/* then insert in the  function hash table     */
	p = (struct fn_hash_cell *) calloc(1, sizeof(struct fn_hash_cell));
	p->funcname = nameptr;
	p->num_of_args = numofargs;
	p->num_of_vars = numofvars;
	p->fn_body = bodyptr;
	p->fn_args_ptr = argptr;
	p->lastdef = 1;
	p->timestamp = currstamp;
	/*disp_func(p);*/
	if (j == NULL)		/* no fn-entry in that bucket */
		{ fn_hash_table[k] = p;
		  p->next_candidate = NULL;
		}
	   else
		  /* there is a fn. in the bucket */
		{ notokay = 1;
		  while((notokay == 1) && (j->next_candidate != NULL))
			    /* both conditions can't be false simultaneously*/
			{ if ((!strcmp(j->funcname, nameptr)) && 
			      (j->num_of_args == numofargs) &&
			      ((j->next_candidate->num_of_args != numofargs) ||
			      (strcmp(j->next_candidate->funcname, nameptr))))
					/*if we are at the point where j holds*/
					/*a fn with identical name and arity &*/
					/* j->next doesn't then  we are at the*/
					/*last entry for this fn in the bucket*/
			     	notokay = 0;
			  else
				j = j->next_candidate;
			}
		  if (notokay == 0)
			{ 	/*we are at the last def. of this fn.*/
				/*so insert the current fn. at this pt.*/
			  j->lastdef = 0;
		  	  p->next_candidate = j->next_candidate;
		  	  j->next_candidate = p;
			}
		  else
			{	/*we are at the end of the list*/
			  if ((!strcmp(j->funcname, nameptr)) && 
					(j->num_of_args == numofargs))
				j->lastdef = 0;
			  p->next_candidate = j->next_candidate;
			  j->next_candidate = p;
			}
			 
		}
}

insert_and_sort_eqns(bodyptr)
cellptrtype bodyptr;
	{ 
	  insert_eqns(bodyptr);
	  sort_eqns(bodyptr);
	}


insert_eqns(bodyptr)
cellptrtype bodyptr;
{ cellptrtype p, q, r;
  int i, count;
  p = bodyptr;
         /* p points to the cell pointing to the list of equations now */
  r = heap[p].rptr;
	 /* save the pointer to the list of equations in the body in r. */
	 /* Add all the equations in tempeqn in the begining of the */
	 /* current equation list.				    */
  for(i=0; i < curr_temp_eqn_slot; i++)
 	{ q = node(GEQNODE, tempeqn[i], PNULL, heap[tempeqn[i]].auxval,
					       heap[tempeqn[i]].eqntype);
	  heap[p].rptr = q;
	  p = q;
	}
		/* The for loop above does the insertion.*/
		/* Now add the equations pointed to by r */
		/* at the end. p points to the last inserted equation.*/
  heap[p].rptr = r;
}

/*insert_eqns_of_exp  is used  for inserting the flattened*/
/*equations arising out of EXP in f(...) => EXP where EQNS*/

insert_eqns_of_exp(bodyptr)
cellptrtype bodyptr;
{ cellptrtype p, q, r;
  int i, count;
  p = bodyptr;
         /* p points to the cell pointing to the list of equations now */
  r = heap[p].rptr;
	 /* save the pointer to the list of equations in the body in r. */
	 /* Add all the equations in  flattened_in_exp in  the begining */
	 /* of the current equation list.				*/
  for(i=0; i < curr_temp_exp_slot; i++)
 	{ q = node(GEQNODE, flattened_in_exp[i], PNULL, 
			heap[flattened_in_exp[i]].auxval,
					   heap[flattened_in_exp[i]].eqntype);
	  heap[p].rptr = q;
	  p = q;
	}
		/* The for loop above does the insertion.*/
		/* Now add the equations pointed to by r */
		/* at the end. p points to the last inserted equation.*/
  heap[p].rptr = r;
}
sort_eqns(bodyptr)
cellptrtype bodyptr;
/* Now the list of equations has to be sorted.*/
/* The priority value is the sort key.	    */
{ cellptrtype p, q, r;
  int i, count;
	p = bodyptr;
	q = heap[p].rptr;
	if (q == PNULL) return;
	/* No equations so return*/
	r = heap[q].rptr;
	if (r == PNULL) return;
	/*only one equation so no need to sort*/
	count = -1;
	 	/*count = -1 to enter the while loop */
		/*using bubble sort to do the sorting */
	while (count != 0) 
 	   { count = 0;
	     while (r != PNULL)
		{ if (heap[q].auxval > heap[r].auxval)
		      { heap[p].rptr = r;
			heap[q].rptr = heap[r].rptr;
			heap[r].rptr = q;
			++count;
		      }
		   p = heap[p].rptr;
		   q = heap[p].rptr;
		   r = heap[q].rptr;
		 };
	     p = bodyptr;
	     q = heap[p].rptr;
             r = heap[q].rptr;
	    }
}		 

/*flatten is used to convert an expression into an equation	*/
/*It takes a pointer to an expression and creates an equation	*/
/* creating a new variable name. A cell containing the offset	*/
/*of the variable introduced is returned.			*/

cellptrtype flatten(p)
cellptrtype p;
	{ cellptrtype i;
	  if ((heap_tag(p) == GNUM) || (heap_tag(p) == GID) ||
	      (heap_tag(p) == GNATOM) || (heap_tag(p) == GTRUE) ||
	      (heap_tag(p) == GFALSE) || (heap_tag(p) == GCONS)) 
			return(p);
	  i = nodegid(GID, var_tab_ptr, PNULL, PNULL, 0);
	  tempvartab[var_tab_ptr] = "";
	  ++var_tab_ptr;
	  tempeqn[curr_temp_eqn_slot] = node(GEQN, i, p, calc_eqn_prio(i,p),
							 find_eqn_type(i,p));
	  curr_temp_eqn_slot++;
	  return(i);
	}


cellptrtype
node(tag, p1, p2, v1, v2)
short int tag;
cellptrtype p1, p2;
short int v2;
int v1;

	{ cellptrtype i;
	  i = getfreecell(heap);
	  heap[i].tag = tag;
	  heap[i].lfld.lptr = p1;
	  heap[i].rptr = p2;
	  heap[i].eqntype = v2;
	  heap[i].auxval = v1;
	  return(i);

	}
 
cellptrtype
nodegid(tag, offset, p, v1, v2)
short int tag;
short int offset;
cellptrtype p;
short int v2;
int v1;

	{ cellptrtype i;
          i = getfreecell(heap);
          heap[i].tag = tag;
          heap[i].lfld.var_offset = offset;
          heap[i].rptr = p;
          heap[i].eqntype = v2;
	  heap[i].auxval = v1;
	  return(i);
	}

cellptrtype
nodenum(tag, value, p, v1, v2)
short int tag;
int value;
cellptrtype p;
int v1;
short int v2;
        { cellptrtype i;
          i = getfreecell(heap);
          heap[i].tag = tag;
          heap[i].lfld.numdata = value;
          heap[i].rptr = p; 
          heap[i].eqntype = v2; 
          heap[i].auxval = v1;
	  return(i);
	}

int var_search(p)
char *p;

{	int i;
	if (list_read_flag == PTRUE) 
		{printf("variables illegal in input list: abort\n");
		 longjmp(execbuff, 0);
		 return;
		};
	if (p[0] == '_')
	   {i = var_tab_ptr++;
	    tempvartab[i] = "";
	    return(i);
	   }
	else
	   {for(i=0; i < var_tab_ptr; i++)
		if (!strcmp(p, tempvartab[i]))
			return(i);
	    ++var_tab_ptr;
	    tempvartab[i] = (char *) calloc(strlen(p) + 1, sizeof(char));
	    strcpy(tempvartab[i], p);
	    return(i);
	   };
}

int var_look(p)
char *p;

{	int i;
	for(i=0; i < var_tab_ptr; i++)
		if (!strcmp(p, tempvartab[i]))
			return(i);
	return(PNULL);
}


/*------------------------------------------------------*/
/* hash : adds up the character values in the string	*/
/* 	  and forms the remainder modulo the array size	*/
/* Provided by bj.					*/
/*------------------------------------------------------*/
int hashf(s)
char *s;
{
	int hashval;

	for (hashval = 0; *s != '\0'; )
	     hashval += *s++;

	return (hashval % FNTABSIZE);
	}

/*The routine push_tempeqnstk pushes the current tempeqn and */
/*the curr_temp_eqn_slot into the stack and reallocates space */
/*to tempeqn and sets curr_temp_eqn_slot to 0. 			*/

push_tempeqnstk()
	{
	 tempeqnstk[top_tempeqnstk].tempeqn = tempeqn;
	 tempeqnstk[top_tempeqnstk].curr_temp_eqn_slot = curr_temp_eqn_slot;
	 tempeqn = (cellptrtype *) calloc(MAXAUXEQN, sizeof(cellptrtype));
	 curr_temp_eqn_slot = 0;
	 top_tempeqnstk++;
	 if (top_tempeqnstk > 16)
		{
		 printf("If can be nested only 16 levels\n");
		 longjmp(parserrbuff, 0);
		};
	}

/*pop_tempeqnstk is inverse of push_tempeqnstk */
pop_tempeqnstk()
	{
	 free(tempeqn);
	 --top_tempeqnstk;
	 if (top_tempeqnstk < 0) 
			{
			 printf("IF equation-stack out of order: panic\n");
			 longjmp(parserrbuff, 0);
			};
	 tempeqn = tempeqnstk[top_tempeqnstk].tempeqn;
	 curr_temp_eqn_slot = tempeqnstk[top_tempeqnstk].curr_temp_eqn_slot; 
	}



