/*This file stores all the major datastructures used by the interpreter */

typedef int cellptrtype;
			/* cellptrtype is the type of a pointer	*/
		   	/* pointing to a cell in the heap	*/
typedef int fstkptrtype;
			/*fstkptrtype is the type of a pointer 	*/
			/* pointing to a cell in frame stack	*/
typedef int trailstkptrtype;
			/*The type of the pointers pointing to trail-stack*/
typedef int varstkptrtype;
			/*The variables are allocated space on a stack	*/
			/*whose contents are accessed by using an index	*/
			/*of type varstkptrtype.			*/

struct sop_stack_cell {
			cellptrtype lhs;
			cellptrtype rhs;
			varstkptrtype envl;
			varstkptrtype envr;
			char          done;
		      };

struct file_struct {
		     char 	*fname;
		     FILE	*fptr;
		   };

/*readst is used to return the value read  by the read*/
/*routine. The read routine determines the type of the*/
/*value read and puts the type in  the  type_fld field*/
/*and the value  read in the   appropriate field after*/
/*conversion.  All   values   are   read  as  strings.*/

struct readst {
		short int typefld;
		union {
			char	    *atomval;
			int	    numval;
			cellptrtype listval;
		       }  valfld;
	      };

struct writest_cell {
		     short int type;                 
		     union
          		{char *string;
           		 int   num;
           		 struct molecule *mol;
          		} data;
		    };  

struct spycell {
		char *fname;
		struct spycell *next;
	       };

/*heapcell is the description of the cell in the heap. */
/*The  4th field,  auxfld stores the priority of the   */
/* equations or the address in the hash-table of the   */
/* function depending upon this cell is used to store  */
/* an equation or a function name. The fifth field     */
/* identifies the action to be taken on a particular   */
/* equation. Using it we know the "type" of the eqn    */
/* i.e. what type of expressions comprise the left     */
/* hand side and the right hand side of the equation.  */

struct heapcell {
			short int tag;
			union  {
			       	cellptrtype lptr;
				char *name;
				int numdata;
				short int var_offset;
			       } lfld;
			cellptrtype rptr;
			int auxval;
			short int eqntype;
		  };

struct var_stk_cell {
			short int type_fld;
				/*  type_fld stores the type information*/
				/* 0	=	var uninstantiated	*/	
				/* 1	=	var is an atom.		*/
				/* 2    =       var is an integer	*/
				/* 3 	=	pointer to cons		*/
				/* 4    = 	pointer to another var  */
				/* 5  	=	value is boolean true	*/
				/* 6	= 	value is boolean false  */
			union {
				char 		*atomname;
				int 	numint;
				struct molecule *consptr;
				varstkptrtype	varptr;
				short int	bool;
			       } datafld;
			/*varstkptrtype env_fld;*/
				/* env_fld is used to store the env of the*/
				/* var. to which a var. of type VARTYPE is*/
				/* pointing to. E.g. if var x points to  y*/
				/* and y's env is e then x.env_fld = e.   */
		    };

		/*NOTE: Some optimization of space can be done in the*/
		/*above struct. The fields type_fld and env_fld   can*/
		/*be merged. All type values except VARTYPE would  be*/
		/*negative values. If type_fld >= 0 then it is of the*/
		/*type VARTYPE. In the case of vartype we store   the*/
		/*environment in the type field. As a result of  this*/
		/*compaction some routines in actions.h will have  to*/
		/*be changed -- namely, those of the kind fid_______.*/

/* frame_stk_cell contains the description of a cell in the  	  */
/* frame stack. This is the main data strucure of the interpreter */

struct frame_stk_cell {
	cellptrtype		eqn_tab_ptr;
				  /*pointer to a list of equations */
	fstkptrtype   	     	bktrk_fld;
				  /*the backtrack pointer 	   */
				  /*PNULL if not a backtrack point.*/
	trailstkptrtype		trail_stk_marker;
				  /*pointer to trailstack. PNULL if*/
				  /*not a backtrack point.	   */
	struct fn_hash_cell	*next_cand_ptr;
				  /*pointer to the function cell */
				  /* of the next candidate fn.   */
				  /* NULL if no next_candidate.  */
	varstkptrtype		var_space_base;
				  /*pointer to the cell on the variable*/
				  /*cell stack starting from where the */
				  /*space for the variables associated */
				  /*with this frame is allocated.      */
	cellptrtype		call_eqn_no;
				  /*contains the pointer to the  equation  in*/
				  /*the parent frame which created this frame*/
	fstkptrtype		parent_ptr;
				  /*contains a pointer to the parent frame*/
	cellptrtype		intro_rhs;
				  /*intro_rhs is a pointer to exp_2  in*/
				  /*equation  f(....) = exp_2,  where a*/
				  /*call to f(....) created this frame.*/
	varstkptrtype		intro_env;
				  /*intro_env is the env of the intro_rhs*/
	cellptrtype		intro_lhs;
				  /*The other side of the equation introduced*/
	short int		belong_tag;
				  /*PTRUE if frame corresponds to <- equation*/
				  /*else it is  false.			     */
	int			readptr;
				  /*used for backtrackable  read*/
	int			writeptr;
				  /*used for backtrackable write*/
	int			sop_ptr;
				  /*pointer to strict op delay stack*/
	short int		selective_trace;
				  /*to maintain trace info.*/
		      };	

/*NOTE: The following conventions are used. Each frame  has two bunch of*/
/*equations: 1) The  regular  equations and 2) the  introduced equations*/
/*If the regular equations  in a frame have been solved (or there are no*/
/*regular equations then the eqn_tab_ptr field would be PNULL. Once this*/
/*field becomes PNULL, the introduced equation would be solved and the  */
/*eqn_tab_ptr field would become BOTTOM. BOTTOM means that the frame has*/
/*been completely solved. 						*/

/*eqn_tab_cell describes a typical cell in the equation table*/
/*pointed to by the the frame stack's equation table pointer */
/*field. It consists of five fields 2 of which are pointers  */
/*to code and the remaining two are pointers to evnvironment.*/
/*The last field contains the priority of the equation.	     */

struct eqn_tab_cell {
			cellptrtype lcode_ptr;
			fstkptrtype l_env_ptr;
			cellptrtype rcode_ptr;
			fstkptrtype r_env_ptr;
			short int   priority;
			short int   eqntype;
		    };



/*fn_hash_table describes a cell of the function table which is a*/
/*hashed structure. The hashing is done on the character string  */
/*which comrises the function name.				 */

struct fn_hash_cell {
			int num_of_args;
			int num_of_vars;
			short int timestamp;
			char *funcname;
			cellptrtype fn_args_ptr;
			cellptrtype fn_body;
			struct fn_hash_cell *next_candidate;
			int lastdef;
				/*1 if it is last defn. 0 otherwise*/
		      };

/*tempeqnstk_cell is a cell of the tempeqnstk used for  */
/*handling  the if statements as described in if.handle */
struct  tempeqnstk_cell {
         		  int    	curr_temp_eqn_slot;
         		  cellptrtype 	*tempeqn;
        		};

struct 	molecule	{
			  cellptrtype		code_ptr;
			  varstkptrtype		env_ptr;
			  struct molecule	*next;
			};

