eqlread(fp, tempstr)
FILE *fp;
char *tempstr;
{char c; int i;
 i = 0;
 c = getc(fp);
 if (c == EOF) return(EOF);	/*error if the very first char is EOF*/
 while ((c == ' ') || (c == '\t') || (c == '\n'))
	c = getc(fp);
 if (c != '\'')			/*not a quoted atom*/
     if (((c >= '0') && (c <= '9')) || 
		((c >= 'A') && (c <= 'Z')) ||
     			   ((c >= 'a') && (c <= 'z'))) 
          while ((c != EOF) && (((c >= '0') && (c <= '9')) || 
			        ((c >= 'A') && (c <= 'Z')) ||
     			        ((c >= 'a') && (c <= 'z')))) 
				      /*slightly inefficient, but that's okay*/
         	{
          	 tempstr[i++] = c;
          	 c = getc(fp);
         	}
     else 
      {
       if (c != EOF)
	 {
	  tempstr[i++] = c;
          c = getc(fp);
	 }
      }
 else
   {
    c = getc(fp);
    while ((c != '\'') && (c != EOF))
      {
	tempstr[i++] = c;
         c = getc(fp);
      };
    c = getc(fp);
   }; 			/*c contains the character from*/
			/*the next token or white space*/
 tempstr[i] = '\0';
 while ((c == ' ') || (c == '\t'))
	c = getc(fp);
 if ((c != '\n') && (c != EOF)) ungetc(c, fp); 
 return('a');			
}


struct readst *fread(code, env)
cellptrtype code;
varstkptrtype env;

{struct readst *out;
 int i; varstkptrtype j;
 char *tempstr, *filename;
 FILE *fp;
 out = (struct readst *) malloc(sizeof(struct readst));
 tempstr = (char *) malloc(100);
 if (heap_auxv(code) == BOTTOM)			/*file name bound to a var*/
	{j = heap_offs(code) + env;
	 while (var_cell_type(j) == VARTYPE)
		j = var_cell_data_var(j);
	 if (var_cell_type(j) != ATOMTYPE)
	      {
		printf("Illegal file name%s : failure\n");
                free(out); free(tempstr);
                return(NULL);
	      }
	 else filename = var_cell_data_atom(j);
	}
 else filename = heap_name(code);
   if (!strcmp(filename, "tty") || !strcmp(filename, "TTY"))
					/*Read from stdin*/
	    fp = stdin;
   else		/*Read from a text file and not stdin*/
    {
     for(i=0; (i < fileindex) && strcmp(filename,files[i].fname) ; i++);
     if (i == fileindex)	
			/*The file is not in the list of open files*/
	      if ((fp = fopen(filename, "r")) == NULL)
		      {
			printf("Cannot open file %s : failure\n", filename);
			free(out); free(tempstr);
			return(NULL);
		      }
	      else
		      {
			if (fileindex >= NUMOFFILES)
				{ printf("No. of open files limit exceeded\n");
				  longjmp(execbuff, 0);
				};
		 	files[fileindex].fname = filename;
		 	files[fileindex++].fptr  = fp;
		      }
      else		/*file filename is already open*/
		 fp = files[i].fptr;
    };
	/*The string is in tempstr whether it is a bktrk read or ordinary read*/
 switch (heap_eqnt(code))
    {
     case PNULL	:
     case GNUM	:
     case GATOM	:
     case GBOOL	:
	  if (eqlread(fp, tempstr) == EOF)
                  {printf("premature end of file %s \n", filename);
                   longjmp(execbuff, 0);
                  };
	  break;
     case GLINE :
	  out->typefld = CONSTYPE;
	  {char c; cellptrtype x, y, z;
	   y = node(GCONS, PNULL, PNULL, PNULL, PNULL);
	   z = y;
           c = getc(fp);
	   while ((c != '\n') && (c != EOF))
           {
	    if ((c != ' ') && (c != '\t'))
	     {
	       ungetc(c, fp);
	       fscanf(fp, " %s", tempstr);
	       x = getfreecell(heap);
	       if ((tempstr[0] <= '9') && (tempstr[0] >= '0'))
		    { heap_tag(x) = GNUM;
		      heap_numb(x) = atoi(tempstr);
		    }
	       else
		  if (!strcmp(tempstr, "true"))
		      { heap_tag(x) = GTRUE;
			heap_numb(x) = PTRUE;
		      }
		  else if (!strcmp(tempstr, "false"))
		           { heap_tag(x) = GFALSE;
		             heap_numb(x) = PFALSE;
		           }
		       else
		           {
	       	            heap_tag(x) = GNATOM;
	       	            heap_name(x) = (char *) malloc(strlen(tempstr) + 1);
	       	            strcpy(heap_name(x), tempstr);
		           };
	       heap_rptr(x) = PNULL;
	       heap_auxv(x) = PNULL;
	       heap_eqnt(x) = 0;
	       heap_lptr(y) = x;
	       x = node(GCONS, PNULL, PNULL, PNULL, PNULL);
	       heap_rptr(y) = x;
	       y = x;
	     };
            c = getc(fp);
	   };
	   out->valfld.listval = z;
	  };
	   free(tempstr);
	   return(out);
	   break;
      case GCHAR  :
	   out->typefld = ATOMTYPE;
	   out->valfld.atomval = (char *) malloc(2);
	   out->valfld.atomval[0] = (char) getc(fp);
	   out->valfld.atomval[1] = '\0';
	   free(tempstr);
	   return(out);
	   break;
      case GLIST  :
	   out->typefld = CONSTYPE;
	   yyprs_begin = PTRUE;
	   { FILE *yyinsave; char *oldopenfile; int oldline;
	     yyinsave = yyin;
	     yyin = fp;
	     oldopenfile = openfilename;
	     openfilename = filename;
	     oldline = line;
	     line = 1;
	     bracket_count = 0;
	     list_read_flag = PTRUE;
	     yyparse();
	     list_read_flag = PFALSE;
	     yyin = yyinsave;
	     line = oldline;
	     openfilename = oldopenfile;
	   };
	   if ((rcode == PNULL) || (heap_tag(rcode) != GCONS))
		{free(out); free(tempstr);
		 printf("Error in list input: failing\n");
		 return(NULL);
		}
	   out->valfld.listval = rcode;
	   getc(fp);		/*eat the terminating CR*/
	   return(out);
	   break;
      default     :
	   printf("Internal Error in read: panic\n");
	   longjmp(execbuff, 0);
	   break;
   };
  switch (heap_eqnt(code))
    {
     case PNULL	:
	if ((tempstr[0] >= '0') && (tempstr[0] <= '9'))		/*A no.*/
	   { i = atoi(tempstr);
	     out->typefld = INTTYPE;
	     out->valfld.numval = i;
	     free(tempstr);
	     return(out);
	   }
	else if(!strcmp(tempstr, "true"))		/*boolean  true*/
	       {
		out->typefld = TRUETYPE;
		out->valfld.atomval = "";
		free(tempstr);
		return(out);
	       }
	     else if(!strcmp(tempstr, "false"))		/*boolean false*/
	           {
		      out->typefld = FALSTYPE;
		      out->valfld.atomval = "";
		      free(tempstr);
		      return(out);
	           }
		  else
			{out->typefld = ATOMTYPE;
			 out->valfld.atomval =(char *)malloc(strlen(tempstr)+1);
			 strcpy(out->valfld.atomval, tempstr);
			 free(tempstr);
			 return(out);
			};
	break;
      case GNUM:
	if ((tempstr[0] >= '0') && (tempstr[0] <= '9'))         /*A no.*/
           { i = atoi(tempstr);    
             out->typefld = INTTYPE;
             out->valfld.numval = i;
             free(tempstr);
             return(out); 
           }
	else {free(out); free(tempstr); return(NULL);}		
				/*not a no.; return NULL*/
	break;
      case GATOM :
	out->typefld = ATOMTYPE;
        out->valfld.atomval =(char *)malloc(strlen(tempstr)+1);
	strcpy(out->valfld.atomval, tempstr);
        free(tempstr);
        return(out);
	break;
      case GBOOL :
	if(!strcmp(tempstr, "false"))         /*boolean false*/
              {
               out->typefld = FALSTYPE;
               out->valfld.atomval = "";
               free(tempstr);
               return(out); 
              }
	else if (!strcmp(tempstr, "true"))               /*boolean  true*/
               { 
                out->typefld = TRUETYPE;
                out->valfld.atomval = "";
                free(tempstr);
                return(out);
               }
	     else {
		   free(tempstr);
		   free(out);
		   return(NULL);
		  };
	break;
      default :
	   printf("Internal I/O Error : panic\n");
	   longjmp(execbuff, 0);
	   break;
    };
}


struct readst *fbread(code, env)
cellptrtype code;
varstkptrtype env;

{struct readst *out; 
 if (read_ptr == readst_top)             /*No strings left in read_stack.*/ 	
       {
	out = fread(code, env);     /*read from stdin.*/
	read_stack[readst_top] = out;
	++readst_top;
  	if (readst_top >= RDSTKLN)
		{printf("Out of read stack : abort\n");
	 	longjmp(execbuff, 0);
		};
	++read_ptr;
	return(out);
       }
 else  return(read_stack[read_ptr++]);
}


struct writest_cell
*fbwrite(code, env)
cellptrtype code;
varstkptrtype env;

{ 
  varstkptrtype i;
  register cellptrtype tcode;
  short int done, tag;
  struct writest_cell out;
  tcode = heap_rptr(code);
  while (tcode != PNULL)
    {
     code = heap_lptr(tcode);
     tag = heap_tag(code);
     switch (tag)
       {
	case GID	:
	    i = heap_offs(code) + env;
	    done = 1;
	    while (done == 1)
	     switch (var_cell_type(i))
	       {
		 case TRUETYPE	:
			write_stack[writest_top].type = PTRUE;
			write_stack[writest_top++].data.string = "true";
			done = 0;
			break;
		 case FALSTYPE	:
			write_stack[writest_top].type = PTRUE;
			write_stack[writest_top++].data.string = "false";
			done = 0;
			break;
		 case ATOMTYPE	:
			write_stack[writest_top].type = PTRUE;
			write_stack[writest_top++].data.string 
					= var_cell_data_atom(i);
			done = 0;
			break;
		 case INTTYPE  :
			write_stack[writest_top].type = PFALSE;
			write_stack[writest_top++].data.num 
					= var_cell_data_int(i);
			done = 0;
			break;
		 case UNBOUND  :
			write_stack[writest_top].type = PTRUE;
			write_stack[writest_top++].data.string = "_unbound";
			done = 0;
			break;
		 case CONSTYPE :
			write_stack[writest_top].type = PNULL;
			write_stack[writest_top++].data.mol = 
						var_cell_data_cons(i);
			done = 0;
			break;
		 case VARTYPE 	:
			while (var_cell_type(i) == VARTYPE)
                           {
                             /*env = var_cell_env(i);*/
                             i = var_cell_data_var(i);
                           };
                 	break;
		 default	:
			printf("Internal I/O error : panic\n");
			done = 0;
			longjmp(execbuff, 0);
			break;
		};
	    out.type = var_cell_type(i);
	    out.data = write_stack[writest_top - 1].data;
	    break;
	case GTRUE	:
		out.type = TRUETYPE;
		write_stack[writest_top].type = PTRUE; 
                write_stack[writest_top++].data.string = "true";
                break;
	case GFALSE	:
		out.type = FALSTYPE;
		write_stack[writest_top].type = PTRUE; 
                write_stack[writest_top++].data.string = "false";
                break;
	case GNUM	:
		out.type = INTTYPE;
		write_stack[writest_top].type = PFALSE; 
		out.data.num = 
		write_stack[writest_top++].data.num = heap_numb(code);
		break;
	case GNATOM	:
		out.type = ATOMTYPE;
		write_stack[writest_top].type = PTRUE;
		out.data.string = 
                write_stack[writest_top++].data.string = heap_name(code);
		break;
	case GCONS	:
		out.type = CONSTYPE;
	        {struct molecule *cptr; 
	        if (next_mol->next != NULL) 	/*get a molecule*/
                      {cptr = next_mol;
                       next_mol = next_mol->next;
                      }
                else               /*Out of molecules so allocate more*/
                      {struct molecule *molptr; int jj;
                       molptr = (struct molecule *)
                                    calloc(2000, sizeof(struct molecule));                             for(jj = 0; jj < 1999; jj++)
                               molptr[jj].next = molptr + jj + 1;
                                          /*next  field  points  to*/
                                          /*next entry in the array*/
                       molptr[1999].next = NULL;
                       next_mol->next = molptr;
                       molptr = next_mol;
                       next_mol = next_mol->next;
                       cptr = molptr;
                      };		/*same code as in unbound_id = cons */
	        cptr->code_ptr = code;
	        cptr->env_ptr = env;
		write_stack[writest_top].type = PNULL;
		out.data.mol = 
		write_stack[writest_top++].data.mol = cptr;
	 	};
                break;
	default		:
		printf("Internal I/O error : panic\n");
		longjmp(execbuff, 0);
		break;
       };
     tcode = heap_rptr(tcode);
    };
  if (writest_top >= WRSTKLN)
	{printf("Out of write stack : abort\n");
	 longjmp(execbuff, 0);
	};
  return(&out);
}

struct writest_cell 
*fwrite(code, env)
cellptrtype code;
varstkptrtype env;

{struct writest_cell out;
 char  *filename;
 varstkptrtype i, j;
 register cellptrtype tcode;
 short int done, tag;
 FILE *fp;
 if (heap_eqnt(code) == 1)			/*file name bound to a var*/
	{j = heap_offs(code) + env;
	 while (var_cell_type(j) == VARTYPE)
		j = var_cell_data_var(j);
	 if (var_cell_type(j) != ATOMTYPE)
	      {
		printf("Illegal file name%s : abort\n");
		longjmp(execbuff, 0);
	      }
	 else filename = var_cell_data_atom(j);
	}
 else filename = heap_name(code);
 if ((!strcmp("tty", filename)) || (!strcmp("TTY", filename)))
       fp = stdout;
 else
  {
 	for(i=0; (i < fileindex) && strcmp(filename,files[i].fname); i++);
 	if (i == fileindex)	
				/*The file is not in the list of open files*/
      	   if ((fp = fopen(filename, "w")) == NULL)
	      {
		printf("Cannot open file %s \n", filename);
		longjmp(execbuff, 0);
	      }
           else
	      {
		if (fileindex == NUMOFFILES)
			{ printf("No. of open files limit exceeded\n");
			  longjmp(execbuff, 0);
			};
	 	files[fileindex].fname = filename;
	 	files[fileindex++].fptr  = fp;
	      }
  	else		/*file filename is already open*/
	     fp = files[i].fptr;
  };
  tcode = heap_rptr(code);
  while (tcode != PNULL)
    {
     code = heap_lptr(tcode);
     tag = heap_tag(code);
     switch (tag)
       {
	case GID	:
	    i = heap_offs(code) + env;
	    done = 1;
	    while (done == 1)
	     switch (var_cell_type(i))
	       {
		 case TRUETYPE	:
			fprintf(fp, "%s ", "true");
			done = 0;
			break;
		 case FALSTYPE	:
			fprintf(fp, "%s ", "false");
			done = 0;
			break;
		 case ATOMTYPE	:
			if (!strcmp(var_cell_data_atom(i), "\\n"))
				fprintf(fp, "\n");
			else if (!strcmp(var_cell_data_atom(i), "\\t"))
				fprintf(fp, "\t");
			     else
				fprintf(fp, "%s ", var_cell_data_atom(i));
			out.data.string = var_cell_data_atom(i);
			done = 0;
			break;
		 case INTTYPE  :
			out.data.num = var_cell_data_int(i);
			fprintf(fp, "%d ", var_cell_data_int(i));
			done = 0;
			break;
		 case VARTYPE 	:
			while (var_cell_type(i) == VARTYPE)
                             i = var_cell_data_var(i);
                 	break;
		 case UNBOUND  :
			fprintf(fp, "%s ", "_unbound");
			done = 0;
			break;
		 case CONSTYPE :
			out.data.mol = var_cell_data_cons(i);
			    print_cons(var_cell_data_cons(i)->code_ptr,
					var_cell_data_cons(i)->env_ptr, fp);
			done = 0;
			break;
		 default     :
			printf("Internal I/O error : panic\n");
			done = 0;
			longjmp(execbuff, 0);
			break;
		};
	    out.type = var_cell_type(i);
	    break;
	case GTRUE	:
		out.type = TRUETYPE;
		fprintf(fp, "%s ", "true");
                break;
	case GFALSE	:
		out.type = FALSTYPE;
		fprintf(fp, "%s ", "false");
                break;
	case GNUM	:
		out.type = INTTYPE;
		out.data.num = heap_numb(code);
		fprintf(fp, "%d ", heap_numb(code));
		break;
	case GNATOM	:
		if (!strcmp(heap_name(code), "\\n"))
			fprintf(fp, "\n");
		else if (!strcmp(heap_name(code), "\\t"))
			fprintf(fp, "\t");
		     else fprintf(fp, "%s ", heap_name(code));
		out.type = ATOMTYPE;
		out.data.string = heap_name(code);
		break;
	case GCONS	:
	        if (heap_rptr(tcode) == PNULL)
	          {
		   out.type = CONSTYPE;
	           {struct molecule *cptr; 
	           if (next_mol->next != NULL) 	/*get a molecule*/
                      {cptr = next_mol;
                       next_mol = next_mol->next;
                      }
                   else               /*Out of molecules so allocate more*/
                      {struct molecule *molptr; int jj;
                       molptr = (struct molecule *)
                                    calloc(2000, sizeof(struct molecule));                             for(jj = 0; jj < 1999; jj++)
                               molptr[jj].next = molptr + jj + 1;
                                          /*next  field  points  to*/
                                          /*next entry in the array*/
                       molptr[1999].next = NULL;
                       next_mol->next = molptr;
                       molptr = next_mol;
                       next_mol = next_mol->next;
                       cptr = molptr;
                      };		/*same code as in unbound_id = cons */
		   cptr->code_ptr = code;
		   cptr->env_ptr =  env;
		   out.data.mol = cptr;
	           };
		  };
		print_cons(code, env, fp);
                break;
	default		:
		printf("Internal I/O error : panic\n");
		longjmp(execbuff, 0);
		break;
       };
     tcode = heap_rptr(tcode);
    };
   return(&out);
}
