		/* For all the stack the  following  convention	*/
		/* has been used :  The  stack  pointer  always	*/
		/* points to the next available slot on the stk	*/

/*
#define  	FSTKSIZE	30000
#define		TRAILSTKSIZE	30000
#define		VARSTKSIZE	90000
#define 	SOPSTKSIZE	1000 
*/
/*The macros below are used for accessing the */
/*different fields of the different structs.  */
#define var_cell(x)		varstk[x]
#define var_cell_type(x)	varstk[x].type_fld
#define var_cell_data_atom(x)	varstk[x].datafld.atomname
#define var_cell_data_int(x)	varstk[x].datafld.numint
#define var_cell_data_cons(x)	varstk[x].datafld.consptr
#define var_cell_data_var(x)	varstk[x].datafld.varptr
#define var_cell_data_bool(x)	varstk[x].datafld.bool
#define var_cell_env(x)		varstk[x].env_fld

#define fstk_eqp(x)		fstk[x].eqn_tab_ptr
#define fstk_bp(x)		fstk[x].bktrk_fld
#define fstk_tp(x)		fstk[x].trail_stk_marker
#define fstk_nc(x)		fstk[x].next_cand_ptr
#define fstk_data(x)		fstk[x].var_space_base
#define fstk_call_eqn(x)	fstk[x].call_eqn_no
#define fstk_par_ptr(x)		fstk[x].parent_ptr
#define fstk_intro_env(x)	fstk[x].intro_env
#define fstk_intro_rhs(x)	fstk[x].intro_rhs
#define fstk_intro_lhs(x)	fstk[x].intro_lhs
#define fstk_belong(x)		fstk[x].belong_tag
#define fstk_rdptr(x)		fstk[x].readptr
#define fstk_wrptr(x)		fstk[x].writeptr
#define fstk_sopptr(x)		fstk[x].sop_ptr
#define fstk_trace(x)		fstk[x].selective_trace

#define sop_lhs(x)		sopstk[x].lhs
#define sop_rhs(x)		sopstk[x].rhs
#define sop_envl(x)		sopstk[x].envl
#define sop_envr(x)		sopstk[x].envr
#define sop_done(x)		sopstk[x].done

short int		choice_point;

int			loop_count;
				/*loop_count is used to check the*/
				/*stack boundaries every 500 ite-*/
				/*rations of the execute routine.*/

cellptrtype		current_eqnl;

/*
varstkptrtype		trailstk[TRAILSTKSIZE];
*/
			     /*trailstk stores pointers to var cell whose*/
			     /* bindings are to be undone on backtracking*/
/*
struct frame_stk_cell	fstk[FSTKSIZE];
*/
			     /*fstk is the main stack -- the local stack */
/*
struct var_stk_cell	varstk[VARSTKSIZE];
*/
			     /*varstk is used for allocating space to vars */
trailstkptrtype		trail_top;
			     /*trail_top is the stack pointer of the trail */
fstkptrtype		mrb;
			     /*mrb is the most recent backtrack pointer */
fstkptrtype		top_fstk;
			     /*top_fstk is the stack ptr for the frame-stk*/
fstkptrtype		currenv;
			     /*currenv is the ptr to current environment*/
varstkptrtype		varstk_top;
			     /*points to the bottom of free space*/
struct fn_hash_cell	*next_candidate;

short int 		failflag;
			     /*this flag gets set when a failure occurs*/
fstkptrtype		parent_frame;
			     /*stores parent frame pointer on backtracking*/
cellptrtype		restart_eqn;
			     /*stores the equation no. from where the comp-*/
			     /*utation has to be restarted on backtracking.*/
short int		debug = PFALSE;
			     /*debug is the debug flag*/
short int		timeflag = PFALSE;
			     /*to print the run time info.*/
short int		timeflagturned = PFALSE;
			     /*timeflagturned is used so that  runtime*/
			     /*is not printed when the timer is turned*/
short int		response;
			     /*records the response of the user, i.e., */
			     /*whether he wants to see the next sol. or not.*/
short int		isbelong;
short int		do_else;
short int		computation_over;
short int		eqn_suspended;
short int 		reinvoked;
short int 		sopeqn_solved;

int (*value_comp_fn[10]) ();
        /*This array  stores  pointers to  functions  which*/
        /*given a type, compare if the two values are equal*/
	/*These  functions are  defined in the file comp.h.*/

int (*action_array[35]) ();
                /*action_array is an  array of  pointers to  functions*/
                /*returning void. These  functions specify the action */
                /*for each kind of equation. This array is initialized*/
                /*with proper  pointers to functions whose definitions*/
		/*are given in the file actions.h.		      */

/*
struct sop_stack_cell sopstk[SOPSTKSIZE];
*/

int    sopstk_top;

/*get_fn_cell takes 3 parameters : bucket  address, no. of actual */
/*parameters and the name of  the function and returns a  pointer */
/*to the  fn_hash_cell struct  which contains the body and params */
/*of the fn. In selecting we check that the fn. name is identical */
/*and the  no. of  arguments  are equal. If the fn. is  not found */
/*NULL is returned, causing the fn. to fail. To  check if a  next */
/*candidate exists  check the lastdef  field of the fn_hash_cell. */

struct fn_hash_cell *get_fn_cell(bucket_no, numofargs, fnname)

register short int bucket_no, numofargs;
register char *fnname;

{ register struct fn_hash_cell *p;
  p = fn_hash_table[bucket_no];
  while (p != NULL)
	if ((!strcmp(p->funcname, fnname)) && (p->num_of_args == numofargs)) 
		return(p);
	else 
		p = p->next_candidate;
  return(p);		/* p is NULL if it comes out of the while loop */
}  

#include "time.h"
#include "comp.h"

		/*modify_caller_frame_if  overwrites the  new  frame over*/
		/*the  calling  frame. The  calling  frame  is   currenv */
		/*However, it is used only for overwriting the IF frames.*/

modify_caller_frame_if(eqp, intro_l, intro_r, intro_r_env)
cellptrtype 	intro_l, intro_r, eqp;
varstkptrtype		intro_r_env;
{auto varstkptrtype j;
	fstk_eqp(currenv) = eqp;
	fstk_intro_env(currenv) = intro_r_env;
	fstk_intro_rhs(currenv) = intro_r;
	fstk_intro_lhs(currenv) = intro_l;
	if (isbelong == 1)
		fstk_belong(currenv) = isbelong;	/*isbelong is global*/
}

		/*modify_caller_frame overwrites the new frame over */
		/*the calling frame. The calling  frame is  currenv */

modify_caller_frame(eqp, numofvars, intro_l, intro_r,  
				intro_r_env)
cellptrtype 	intro_l, intro_r, eqp;
short int               numofvars;
varstkptrtype		intro_r_env;
{auto varstkptrtype j;
	fstk_eqp(currenv) = eqp;
	for(j = varstk_top; j < (numofvars + varstk_top); j++)
	    var_cell_type(j) = UNBOUND;
					/*clear the space for usage*/
	fstk_data(currenv) = varstk_top;	/*allocate space for the*/
	                              		/*variables on the var  */
	varstk_top += numofvars;		/*stack.		*/
	fstk_intro_env(currenv) = intro_r_env;
	fstk_intro_rhs(currenv) = intro_r;
	fstk_intro_lhs(currenv) = intro_l;
	if (isbelong == 1)
		fstk_belong(currenv) = isbelong;	/*isbelong is global*/
}

		/*push_on_fstk pushes a frame on the frame stack. */
		/*If the  frame is a choice point then appropriate*/
		/*information needed to backtrack is also stored. */
/*push_on_fstk converted to a macro*/

push_on_fstk_mac(eqp, nc, numofvars, intro_l, intro_r,  
		intro_r_env, parent_frame, calling_eqn, isbelong, isbktrkpt)

cellptrtype 		intro_l, intro_r, eqp;
struct fn_hash_cell     *nc;
short int               numofvars, calling_eqn;
fstkptrtype		parent_frame; 
varstkptrtype		intro_r_env;
short int		isbelong;
short int		isbktrkpt;

{	register fstkptrtype   x; 
	register varstkptrtype j;
	x = top_fstk++;
	if (top_fstk > FSTKSIZE) 
		{ printf("Out of local stack\n");
		  longjmp(execbuff, 0);
		};
	fstk_eqp(x) = eqp;
	for(j = varstk_top; j < (numofvars + varstk_top); j++)
	    var_cell_type(j) = UNBOUND;
					/*clear the space for usage*/
	fstk_data(x) = varstk_top;		/*allocate space for the*/
	                              		/*variables on the var  */
	varstk_top += numofvars;		/*stack.		*/
	if (isbktrkpt)
	   {
	      fstk_nc(x)  = nc;
              fstk_tp(x)  = trail_top;
			/*on backtracking undo all the bindings between	*/
			/*trail_top - 1 and fstk_tp(x).			*/
	      fstk_rdptr(x) = read_ptr;
	      fstk_wrptr(x) = writest_top;
	      fstk_sopptr(x)    = sopstk_top;
	   };
	if (nc == NULL)          /*This frame is not a choice point*/
                fstk_bp(x) = PNULL;
        else      
                { fstk_bp(x)  = mrb;
                  mrb = x;
                }; 
	fstk_par_ptr(x) = parent_frame;
	fstk_call_eqn(x) = calling_eqn;
	fstk_intro_env(x) = intro_r_env;
	fstk_intro_rhs(x) = intro_r;
	fstk_intro_lhs(x) = intro_l;
	fstk_belong(x) 	  = isbelong;
}

#define push_on_fstk(eqp,nc,numofvars,intro_l,intro_r,intro_r_env,parent_frame,calling_eqn,isbelong,isbktrkpt) {register fstkptrtype   x;		\
				register varstkptrtype j;		\
				x = top_fstk++;				\
				if (top_fstk > FSTKSIZE)		\
				    { printf("Out of local stack\n");	\
		  		      longjmp(execbuff, 0);		\
				    };					\
				fstk_eqp(x) = eqp;			\
				for(j = varstk_top; j < (numofvars +    \
					               varstk_top); j++)\
	    			           var_cell_type(j) = UNBOUND;	\
				fstk_data(x) = varstk_top;		\
				varstk_top += numofvars;		\
				if (isbktrkpt)				\
	   			    {					\
	      			     fstk_nc(x)  = nc;			\
              			     fstk_tp(x)  = trail_top;		\
	      			     fstk_rdptr(x) = read_ptr;		\
	      			     fstk_wrptr(x) = writest_top;	\
	      			     fstk_sopptr(x)    = sopstk_top;	\
	   			    };					\
				if (nc == NULL)          		\
                			fstk_bp(x) = PNULL;		\
        			else      				\
                			{ fstk_bp(x)  = mrb;		\
                  			  mrb = x;			\
                  			}; 				\
	                        fstk_par_ptr(x) = parent_frame;		\
	  			fstk_call_eqn(x) = calling_eqn;		\
	  			fstk_intro_env(x) = intro_r_env;	\
	  			fstk_intro_rhs(x) = intro_r;		\
	  			fstk_intro_lhs(x) = intro_l;		\
	  			fstk_belong(x) 	  = isbelong;		\
  			       }

#include "actions.h"


/*Note:*/

		/*A frame  on the  frame stack  never needs  to be */
		/*popped explicitly because when we backtrack   we */
		/*go to the most recent back track point  which is */
		/*done in one swoop, simply by making the top_fstk */
		/*point to the frame pointed to by  the mrb.  That */
		/*is the reason why when we push a frame we  check */
		/*if eqp field is not pointing to something before */
		/*allocating anything to it. If it is pointing  to */
		/*something then we first free it and then use  it */
		/*for holding a new eq. table for  the  new  frame */
		/*This means that the eqp field is to be initiali- */
		/*to NULL in the begining before it can  be  used. */
	

/*unify_params takes list of formals and actuals*/
/*and unifies them. Remember both actuals    and*/
/*formals are parsed and stored in pactual   and*/
/*pformal respectively in the reverse order. And*/
/*the call to unify_params is made only if   the*/
/*number of actual parms exactly matches the no.*/
/*of formal params. Note that actualenv is   the*/
/*env. of the actual params while formalenv   is*/
/*the environment of the formal parameters. 	*/
		  
unify_params(actualenv, formalenv, pactual, pformal)

varstkptrtype		actualenv, formalenv;
cellptrtype 		pactual; 
cellptrtype		pformal;

{	register cellptrtype l, k, p, q;
	short int action_no;
	l = pactual; k = pformal;
	if (debug == PTRUE)
	   while(l != PNULL) 
	      {
		printf("\t");
	        p = heap_lptr(l);
                print_heap_val(p, actualenv);
		l = heap_rptr(l);
	      };
	l = pactual; 
	while ((l != PNULL) && (failflag == PFALSE))
		{ p = heap_lptr(l);	/* p points to the l_code */
		  q = heap_lptr(k);	/* p points to the r_code */
		  action_no = find_eqn_type(p, q);
		  (*action_array[action_no])(actualenv, formalenv, p, q);
		  l = heap_rptr(l);
		  k = heap_rptr(k);
		};
	if (debug == PTRUE) printf("\n");
}
		

/*body is the pointer to the code to be executed and*/
/*numofvars is the no. of vars in that code. vartab */
/*contains user-defined variables whose values are  */
/*to be reported  back on  completion of  execution.*/

execute(body, numofvars, vartab, report_last_var)
char    *vartab[];
register cellptrtype body;
int numofvars, report_last_var ;
{short int action_no, iprio;
 int jj, soptr;
 fstkptrtype i, tempenv;
 register varstkptrtype execenv;
 auto cellptrtype pcellp;
 auto cellptrtype  eq, el, p1, temp_rhs;
 auto float elapsed_t;
 auto short int aux_fail_flag; 
	top_fstk = 0;
	loop_count = 0;
	trail_top = 0;
	varstk_top = 0;
	writest_top = 0;
	fileindex = 0;
	readst_top = read_ptr = 0;
	do_else = PFALSE;
	sopstk_top = 1;
	computation_over = PFALSE;
	p1 = heap_rptr(body);		/*p1 points to list of eq'ns*/
	push_on_fstk(p1,NULL,numofvars,PNULL,PNULL,PNULL,PNULL,PNULL,PFALSE,0);
				/*1st frame is not choice pt. so last param 0*/
	mrb = BOTTOM;
			/*BOTTOM indicates no back track pts beyond this*/
	currenv = 0;
	failflag = PFALSE;
                        /*eqt points to the eqp entry cotaining*/
                        /*the current equations record*/
	response = ';';
	while (response == ';')
  	  {
	   ++loop_count;
	   if ((loop_count % 500) == 0)
		{ if (varstk_top > (VARSTKSIZE - 500))
		     {
		      printf("warning : running short of variable stack\n");
		      printf("Retry with more space\n");
		      longjmp(execbuff, 0);
		     }
		  if (trail_top > (TRAILSTKSIZE - 500)) 
		     {
		      printf("warning : running short of trail stack\n");
		      printf("Retry with more space\n");
		      longjmp(execbuff, 0);
		     }
		  if (sopstk_top > (SOPSTKSIZE - 125))
		     {
		      printf("warning : running short of equation stack\n");
		      printf("Retry with more space\n");
		      longjmp(execbuff, 0);
		     }
	        };
	   if (timeflag == PTRUE)
	   	elapsed_t = CPUTime();
	   if ((failflag == PTRUE) && (currenv > 0))
		/*backtracking occurs from the top level*/
	     { fstk_eqp(parent_frame) = restart_eqn;
	       currenv = parent_frame;
				/*parent_frame and restart_eqn    are*/
				/*vars which are set by backtrack fn.*/
	     };
	   if (currenv == BOTTOM) 
		{
		 printf("\nno solution\n"); 
		 return;
		};
	   while (currenv >= 0) 
		{ 
		  eq = fstk_eqp(currenv);
		  tempenv = currenv;
		  while(fstk_bp(tempenv) < BOTTOM)  	/*IF frame*/
			tempenv = fstk_par_ptr(tempenv);
		  execenv = fstk_data(tempenv);
		  temp_rhs = fstk_intro_rhs(currenv);
		  if (temp_rhs != PNULL)  /*auxiliary eqn. not already solved*/
		   {
		     iprio = calc_eqn_prio(fstk_intro_lhs(currenv),
			   				temp_rhs);
				/*substitute this later for efficiency*/
		     if (iprio == TERM_EQN_PRIO)
			{ action_no = find_eqn_type(fstk_intro_lhs(currenv),
                                                        temp_rhs);
                          (*action_array[action_no]) (fstk_intro_env(currenv),
                                 execenv, temp_rhs, fstk_intro_lhs(currenv));
			  fstk_intro_rhs(currenv) = PNULL;
			  aux_fail_flag = failflag; /*aux_fail_flag is 1 if*/
						    /*if aux equation fails*/
			}; /*If introduced eqn involves only terms, solve it*/
		   };
		  if (aux_fail_flag == PTRUE) 	/*aux eqn failed*/
			aux_fail_flag = PFALSE;
		  else 
		   if (eq != PNULL)	  /*Some eqns to be solved still left*/
		     {el = heap_lptr(eq); /*el is equation to be solved*/
		      if (heap_tag(el) == GBELONG) 
					isbelong = PTRUE;
		      else	isbelong = PFALSE;
		      current_eqnl = eq;
		      fstk_eqp(currenv) = heap_rptr(eq);
					  /*fstk_eqp is updated */
		      action_no = heap_eqnt(el);
	              (*action_array[action_no]) (execenv, execenv, 
					heap_lptr(el), heap_rptr(el));
		     }
		   else	   /*All regular eqns solved, solve the intro. eqn.*/
		     { if (fstk_intro_rhs(currenv) == PNULL)  
			   fstk_eqp(currenv) = BOTTOM;
		       else
			  { current_eqnl = PNULL;
			    if (fstk_belong(currenv) == PTRUE) 
						isbelong = PTRUE;
			    else isbelong = PFALSE;
			    fstk_eqp(currenv) = BOTTOM;
		  	    action_no = find_eqn_type(fstk_intro_lhs(currenv),
			   				temp_rhs);
			    (*action_array[action_no]) (fstk_intro_env(currenv),
				 execenv, temp_rhs, fstk_intro_lhs(currenv)); 
			  };
		     };
		  if (currenv == BOTTOM) 
			{
			 printf("\nno solution\n"); 
			 return;
			};
		  if (failflag == PTRUE) 	
			/*backtracking has  occured  and  there is a candidate*/
			/*If there is no candidate then this pt is not reached*/
		     { fstk_eqp(parent_frame) = restart_eqn;
		       currenv = parent_frame;
					/*parent_frame and restart_eqn    are*/
					/*vars which are set by backtrack fn.*/
		     };
		  if (failflag == PFALSE) 
		    while ((currenv >= 0) && (fstk_eqp(currenv) == BOTTOM))
						/*last equation in the current*/
						/*frame has been solved, i.e. */
			 {
			  i = fstk_par_ptr(currenv);
			  if (i >= 0) 
			    {
			      pcellp = fstk_call_eqn(currenv);
			      if  (pcellp != PNULL) 
			          fstk_eqp(i) = heap_rptr(pcellp);
			      else
			          fstk_eqp(i) = BOTTOM;
			      if (debug == PTRUE)
			           printf("Exiting frame %d \n", currenv);
			      else 
				if ((spyflag == PTRUE) &&
					(fstk_trace(currenv) == PTRUE))
				   { printf("Exiting frame %d \n", currenv);
				     fstk_trace(currenv) = PFALSE;
				   };
			    };
			  if ((fstk_belong(currenv) == PTRUE)) 
				{
				 if (fstk_bp(currenv) != PNULL)
				       if (fstk_bp(currenv) < BOTTOM)
					   mrb = (-1) * (fstk_bp(currenv) + 10);
				       else 
					   mrb = fstk_bp(currenv);
				 else
				    while (mrb > currenv)
				       if (fstk_bp(mrb) < BOTTOM) 
                                           mrb = (-1) * (fstk_bp(mrb) + 10); 
                                       else  
                                           mrb = fstk_bp(mrb);	
				};
					  /*if it is a <- frame with a choice*/
					  /*pt then update mrb and delete it.*/
				/* OLD CODE BEGIN 
				{
				 if (fstk_bp(currenv) != PNULL)
					mrb = fstk_bp(currenv);
				 else
					while(mrb > currenv)
					    mrb = fstk_bp(mrb);
				 top_fstk = currenv;
				};
				 OLD CODE END */
			  if (mrb <= i) 
			       {
				top_fstk = i + 1; 
					/*pop on success exit*/
			       };
			  if (sopstk_top > 1)	/*delayed sop eqns are there*/
			     {short int over;
			      reinvoked = over = PTRUE;
			      while (over == PTRUE)
			       {
				over = PFALSE;
			        for (soptr = 1; soptr < sopstk_top; soptr++)
				  if ((failflag == PFALSE) &&
					(sop_done(soptr) != '1'))
				   {
		  	              action_no = find_eqn_type(sop_lhs(soptr),
							        sop_rhs(soptr));
			              (*action_array[action_no]) 
					   (sop_envl(soptr), sop_envr(soptr),
					    sop_lhs(soptr), sop_rhs(soptr));
				      if (currenv == BOTTOM)
                        		{
                         		 printf("\nno solution\n");
                         		 return;
                        		};
		  		      if (failflag == PTRUE)
		     		        { fstk_eqp(parent_frame) = restart_eqn;
		                          currenv = parent_frame;
					  over = PFALSE; /*to exit the while*/
						 	 /*loop on failure..*/
		     			}
				      else
					  if (sopeqn_solved == PTRUE)
					     {
				              sop_done(soptr) = '1';
					      over = PTRUE;
					      if (soptr < fstk_sopptr(mrb))
					         trailstk[trail_top++] = -soptr;
					     };
			           };
			       };
			      reinvoked = PFALSE;
			     };
			  if (failflag == PFALSE)
		  	       currenv = i;
			};
		};  
	  if (timeflag == PTRUE)
	    if (timeflagturned == PFALSE)
	     {
	   	elapsed_t = CPUTime() - elapsed_t;
	   	printf("\nRuntime: %f sec.\n", elapsed_t);
	     }
	    else timeflagturned = PFALSE;
	   if (sopstk_top != 1)		/*some sop eqns still left*/
              {int allsolved = 1;
		for(jj = 1; ((jj < sopstk_top) && allsolved); jj++)
		   allsolved = allsolved && (sop_done(jj) == '1') ; 
		if (!allsolved) printf("Input system not fully constrained\n"); 
	      };
	   report_solutions(report_last_var, numofvars, vartab);
	   if (mrb == BOTTOM)
		 response = ',';       /*some arbitrary char to exit the loop*/
	   else
	      	response = getchar();
	   /*printf("\n");*/
           for (jj = 0; jj < writest_top; jj++)
	      switch (write_stack[jj].type)
	       {
		case PTRUE	:
			if (!strcmp(write_stack[jj].data.string, "\\n"))
	 	     		printf("\n");
			else if (!strcmp(write_stack[jj].data.string, "\\t"))
				printf("\t");
			     else 
				printf("%s ", write_stack[jj].data.string);
			break;
		case PFALSE	:
			printf("%d ", write_stack[jj].data.num);
			break;
		case PNULL	:
			print_cons(write_stack[jj].data.mol->code_ptr,
                                   write_stack[jj].data.mol->env_ptr, stdout);
			break;
		default		:
			printf("Illegal type in write stack: panic\n");
			longjmp(execbuff, 0);
			break;
	       };
	   if (jj > 0) printf("\n");
	   if (response == ';') 
		{
		 (void) getchar(); 		/*eat the carriage return*/
		 ffail();
		};
          };
	for (jj = 0; jj < fileindex ; jj++)
		fclose(files[jj].fptr);
	/*printf("\nyes\n");*/
	printf("\n");
}

/*report_solutions reports the solutions after the query*/
/*has been solved. The function execute keeps track  of*/
/*if the query  was  functional  in nature, that is, of*/
/*the form "exp where eqlist" or "exp", in which   case*/
/*the value returned is to be reported. The value to be*/
/*returned is the value of the last variable in the  ST*/
/*of the query, and can be readily found. The  bindings*/
/*which other vars receive are also reported. vartab is*/
/*a table containing the string of variable names    in*/
/*position OFFSET where OFFSET is the offset of    this*/
/*variable in the variable stack of the first    frame.*/
/*report_solution will be called at the end of execute.*/

report_solutions(report_last_var, numofvars, vartab)

int report_last_var, numofvars;
char 	*vartab[];
 { int i, no_sol_to_rep = 0;
	if (report_last_var == 1)	/*query was functional in nature*/
	   {
		printf("\n");
		/*print_exp_val(numofvars - 1, DOTFALSE);*/
		print_exp_val2(numofvars - 1, stdout);
	   };
	for (i = 0; i < numofvars; i++)
	      if (strcmp("", vartab[i]))
		  {
		    printval(vartab[i], i);
				/*If it is  not a compiler  generated name*/
				/*then print its binding through printval.*/
		    no_sol_to_rep = 1;
		  };
	if (report_last_var == 0)
           if (no_sol_to_rep == 0) 
		if (mrb == BOTTOM) 
			printf("yes\n");
		else 
			printf("yes");
 }


/*printval is a routine which takes a location in the var stack*/
/*as input and prints the  value of that  variable in a  proper*/
/*format depending upon its type, i.e., atom, cons, or num etc.*/

printval(varname, offs)			/*offs is the absolute offset*/

char *varname;
varstkptrtype	offs;
{
	printf("\n %s \t = ", varname);
	/*print_exp_val(offs, DOTFALSE);*/
	print_exp_val2(offs, stdout);
	printf(" ");
}

/*print_heap_val is only being used by the trace.*/
print_heap_val(p, env)
cellptrtype	p;
varstkptrtype	env;
{
	char *str;
	switch (heap_tag(p))
	  {
		case GID	:
			print_exp_val2(heap_offs(p) + env, stdout);
			break;
		case GNATOM	:
			str = heap_name(p);
			if (!strcmp(str, "\\n"))
			    printf("\n");
			else if (!strcmp(str, "\\t"))
			    	printf("\t");
			     else
			printf("%s",str);
		case GNUM	:
			printf("%d", heap_numb(p));
			break;
		case GTRUE	:
			printf("true");
			break;
		case GFALSE	:
			printf("false");
			break;
		case GCONS	:		/*This point is only reached*/
						/*if a list is being printed*/
						/*as a result of call   from*/
						/*unify_params,   when   the*/
						/*debug flag is on.	    */
			print_cons(p, env, stdout);
			break;
		default		:
			printf("Illegal type in print : panic\n");
			longjmp(execbuff, 0);
			break;
	  }
}			

/*print_exp_val2 just prints the value*/
/*of the variable  using the type info*/

print_exp_val2(offs, fp)
varstkptrtype  	offs;
FILE *fp;

{varstkptrtype 	env;
 char *str;
 cellptrtype 	code;	
	while (var_cell_type(offs) == VARTYPE)
		offs = var_cell_data_var(offs);
	switch (var_cell_type(offs))  
	     {
		case UNBOUND 	: 
			fprintf(fp, "_%d", offs);
			break;
		case ATOMTYPE	:
			str = var_cell_data_atom(offs);
			if (!strcmp(str, "\\n"))
			    fprintf(fp, "\n");
			else if (!strcmp(str, "\\t"))
			    	fprintf(fp, "\t");
			     else
			        fprintf(fp, "%s", str);
			break;
		case INTTYPE	:
			fprintf(fp, "%d", var_cell_data_int(offs));
			break;
		case TRUETYPE	:
			fprintf(fp, "true");
			break;
		case FALSTYPE	:
			fprintf(fp, "false");
			break;
		case CONSTYPE	:
					/*a variable bound to a cons is */
					/*actually  bound  to a molecule*/
			env = var_cell_data_cons(offs)->env_ptr;
			code  = var_cell_data_cons(offs)->code_ptr;
			       /*code points to the code part of the molecule*/
			       /*to which variable in location offs is bound.*/
			print_cons(code, env, fp);
			break;
	        default		:
			printf("\nillegal data type: panic\n");
			longjmp(execbuff, 0);
			break;
	     };
}	

print_cons(code, env, fp)

cellptrtype code;
varstkptrtype env;
FILE *fp;

{cellptrtype functornm;
 if (heap_auxv(code) == PTRUE) 	/*It is a functor stored as a list*/
	{ 
 	  functornm = heap_lptr(code);
	  fprintf(fp, "%s", heap_name(functornm));
	  fprintf(fp, "(");
	  print_open_cons(heap_rptr(code), env, fp);
	  fprintf(fp, ")");
	}
 else if (heap_auxv(code) == ISTRING)		/*it is a string*/
	     {fprintf(fp, "\"");
	      print_string(code, env, fp);
	      fprintf(fp, "\"");
	     }
      else
		{ fprintf(fp, "[");
	  	  print_open_cons(code, env, fp);
	  	  fprintf(fp, "]");
		};
}

print_open_cons(code, env, fp)

cellptrtype code;
varstkptrtype env;
FILE *fp;

{ cellptrtype lhs, p, ccode;
  short int over;
  int i;
  char *str;
  p = code; 
  over = PFALSE;
  while ((p != PNULL) && (over == PFALSE))
	{
	 lhs = heap_lptr(p);
	 if (lhs != PNULL)
	 {
	  switch (heap_tag(lhs))
	   {
	    case GNUM	:
		  	fprintf(fp, "%d", heap_numb(lhs));
			break;
	    case GTRUE	:
			fprintf(fp, "true");
			break;
	    case GFALSE	:
			fprintf(fp, "false");
			break;
	    case GNATOM :
			str = heap_name(lhs);
			if (!strcmp(str, "\\n"))
			    fprintf(fp, "\n");
			else if (!strcmp(str, "\\t"))
			    	fprintf(fp, "\t");
			     else
				fprintf(fp, "%s", str);
			break;
	    case GID	:
		        print_exp_val2(heap_offs(lhs) + env, fp);
			break;
	    case GCONS  :
			print_cons(lhs, env, fp);
			break;
	    default	:
			printf("Illegal type encountered in print : panic\n");
			longjmp(execbuff, 0);
			break;
           };
	  p = heap_rptr(p);
	  if (heap_lptr(p) != PNULL)
	   switch (heap_tag(p))
	   {
	    case GNUM	:
		  	fprintf(fp, " | %d", heap_numb(p));
			over = PTRUE;
			break;
	    case GTRUE	:
			fprintf(fp, " | true");
			over = PTRUE;
			break;
	    case GFALSE	:
			fprintf(fp, " | false");
			over = PTRUE;
			break;
	    case GNATOM :
			str = heap_name(p);
			if (!strcmp(str, "\\n"))
			    fprintf(fp, "\n");
			else if (!strcmp(str, "\\t"))
			    	fprintf(fp, "\t");
			     else
				fprintf(fp, " | %s", str);
			over = PTRUE;
			break;
	    case GID	:
		        i = env + heap_offs(p);
			while (var_cell_type(i) == VARTYPE)
				i = var_cell_data_var(i);
				/*we are printing the second element of */
				/*of   the  list   so   print  a  comma.*/
				/*but only if it  is  a non-empty  list.*/
			if (var_cell_type(i) != CONSTYPE)
			      {
				fprintf(fp, " | ");
		        	print_exp_val2(heap_offs(p) + env, fp);
			      }
			else	
			      {
				ccode = var_cell_data_cons(i)->code_ptr;
			 	if (heap_lptr(ccode) != PNULL)
 			     	     if (heap_auxv(ccode) == PTRUE) 	
					/*This situation can only arise*/
					/*if we have something like say*/
					/*[exp | x] and x is bound to a*/
					/*functor ex.functor(.., ..)]  */
				        {
				         fprintf(fp, " | ");
	  			         print_cons(ccode,
					         var_cell_data_cons(i)->env_ptr
 							,fp);
					 return;
					}
				      else
					fprintf(fp, ", ");
				print_open_cons(ccode, 
					var_cell_data_cons(i)->env_ptr, fp);
			      };
			over = PTRUE;
			break;
	    case GCONS  :
			if (p != PNULL)
 			     if (heap_auxv(p) == PTRUE) 	
					/*This situation can only arise*/
					/*if we have something like say*/
					/*[exp | functor(.., .., ..)]  */
				  {
				    fprintf(fp, " | ");
	  			    print_cons(p, env, fp);
				    return;
				   }
			     else
		 		fprintf(fp, ", ");
			break;
	    default	:
			printf("Illegal type encountered in print : panic\n");
			longjmp(execbuff, 0);
			break;
	   };
	 }
	 else over = PTRUE;
	};
}


print_string(code, env, fp)

cellptrtype code;
varstkptrtype env;
FILE *fp;

{ cellptrtype lhs, p, ccode;
  short int over;
  int offs, i;
  p = code; 
  over = PFALSE;
  while ((p != PNULL) && (over == PFALSE))
	{
	 lhs = heap_lptr(p);
	 if (lhs != PNULL)
	 {
	  switch (heap_tag(lhs))
	   {
	    case GNATOM :
			if (strlen(heap_name(lhs)) > 1)
			   {printf("\nillegal component in string : abort\n");
			    return;}
			fprintf(fp, "%s", heap_name(lhs));
			break;
	    case GID	:
		        offs = heap_offs(lhs) + env;
			while(var_cell_type(offs) == VARTYPE)
				offs = var_cell_data_var(offs);
			if ((var_cell_type(offs) == ATOMTYPE) &&
				(strlen(var_cell_data_atom(offs)) == 1))
			     fprintf(fp, "%s", var_cell_data_atom(offs));
			else 
			   if  (var_cell_type(offs) == UNBOUND)
				fprintf(fp, "_%d", offs);
			   else
			     {printf("\nIllegal component in string : abort\n");
			      return;};
			break;
	    default	:
			printf("Illegal component in the string : abort\n");
			return;
			break;
           };
	  p = heap_rptr(p);
	  if (heap_lptr(p) != PNULL)
	   switch (heap_tag(p))
	   {
	    case GNATOM :
			fprintf(fp, " : %s", heap_name(p));
			over = PTRUE;
			break;
	    case GID	:
		        i = env + heap_offs(p);
			while (var_cell_type(i) == VARTYPE)
				i = var_cell_data_var(i);
			if ((var_cell_type(i) == ATOMTYPE) &&
				(strlen(var_cell_data_atom(i)) == 1))
			     fprintf(fp, " : %s", var_cell_data_atom(i));
			else if (var_cell_type(i) == UNBOUND)
				fprintf(fp, " : _%d", i);
			     else if (var_cell_type(i) == CONSTYPE)
			           print_string(var_cell_data_cons(i)->code_ptr,
					var_cell_data_cons(i)->env_ptr, fp);
			          else
			          {printf("\nillegal component in "); 
				   printf("string : abort\n");
                                   return;};
			over = PTRUE;
			break;
	    case GCONS  :
			break;
	    default	:
			printf("Illegal type encountered in print : panic\n");
			longjmp(execbuff, 0);
			break;
	   };
	 }
	 else over = PTRUE;
	};
}
