/* Ulam revisited */
SPEC ULAM =
SORTS
nat ::= z | xx nat | xx1 nat.

OPNS
eins :: nat.
zwei :: nat.
drei :: nat.
EQNS
eins = xx1 z.
zwei = xx eins.
drei = xx1 eins.

OPNS
ulam :: nat -> nat.
EQNS
ulam z = z.
ulam (xx X) = ulam X.
ulam (xx1 z) = xx1 z.
$ulam (xx1 X) = ulam (div2 (inc (mult drei (xx1 X)))).

OPNS
div2 :: nat -> nat.
EQNS
div2 z = z.
div2 (xx X) = X.
div2 (xx1 X) = X.

OPNS
inc :: nat -> nat.
EQNS
inc z = eins.
inc (xx X) = (xx1 X).
inc (xx1 X) = xx (inc X).

OPNS
add :: nat -> nat -> nat.
EQNS
add z X = X.
$add X z = X.
add (xx X) (xx Y) = xx (add X Y).
add (xx X) (xx1 Y) = xx1 (add X Y).
add (xx1 X) (xx Y) = xx1 (add X Y).
add (xx1 X) (xx1 Y) = xx (inc (add X Y)).

OPNS
mult :: nat -> nat -> nat.
EQNS
mult z _ = z.
mult (xx X) Y = xx (mult X Y).
mult (xx1 X) (xx1 Y) = xx1 (add (xx (mult X Y)) (add X Y)).
$mult _ z = z.
$mult X (xx Y) = xx (mult X Y).

IMPORTS READWRITE +
OPNS goal :: system -> system.
EQNS
  goal S = system (write (ulam (mult drei drei),S)).
END.
