SPEC STRASSEN = INTEGER + READWRITE +
SORTS qtree ::= v(integer,integer,integer,integer) |
                m(qtree,qtree,qtree,qtree).

OPNS qtree * qtree :: qtree.
     qtree + qtree :: qtree.
     qtree - qtree :: qtree.

MACROS
  #p1i = (A11+A22)*(B11+B22).
  #p2i = (A21+A22)*B11.
  #p3i = A11*(B12-B22).
  #p4i = A22*(B21-B11).
  #p5i = (A11+A12)*B22.
  #p6i = (A21-A11)*(B11+B12).
  #p7i = (A12-A22)*(B21+B22).
  #c11i = (#p1i+#p4i-#p5i)+#p7i.
  #c12i = #p3i+#p5i.
  #c21i = #p2i+#p4i.
  #c22i = (#p1i+#p3i-#p2i)+#p6i.  
    
  #p1 = (A11+A22)*(B11+B22).
  #p2 = (A21+A22)*B11.
  #p3 = A11*(B12-B22).
  #p4 = A22*(B21-B11).
  #p5 = (A11+A12)*B22.
  #p6 = (A21-A11)*(B11+B12).
  #p7 = (A12-A22)*(B21+B22).
  #c11 = (#p1+#p4-#p5)+#p7.
  #c12 = #p3+#p5.
  #c21 = #p2+#p4.
  #c22 = (#p1+#p3-#p2)+#p6. 
  #ill = v(0,0,0,0).
    
EQNS
  m(A11,A12,A21,A22) * m(B11,B12,B21,B22) = m(#c11,#c12,#c21,#c22).  
  v(A11,A12,A21,A22) * v(B11,B12,B21,B22) = v(#c11i,#c12i,#c21i,#c22i).  
 $ _ * _ = #ill.
      
      
  v(A11,A12,A21,A22) + v(B11,B12,B21,B22) = v(A11+B11,A12+B12,A21+B21,A22+B22).
  m(A11,A12,A21,A22) + m(B11,B12,B21,B22) = m(A11+B11,A12+B12,A21+B21,A22+B22).
 $ _ + _ = #ill.
 
  v(A11,A12,A21,A22) - v(B11,B12,B21,B22) = v(A11-B11,A12-B12,A21-B21,A22-B22).
  m(A11,A12,A21,A22) - m(B11,B12,B21,B22) = m(A11-B11,A12-B12,A21-B21,A22-B22).
 $ _ - _ = #ill.
 
OPNS goal:: system -> system.
     gen:: integer -> qtree.
     
EQNS
  gen 0 = v(1,2,3,4).
 $gen N = m(gen(N-1),gen(N-1),gen(N-1),gen(N-1)).
 
  goal S = system(write((gen 6*gen 6) == gen 0,S)).
     
END.
