SPEC MASTERMIND = INTEGER + STREAM + LISTOPS +

SORTS is ::= [integer].
      iss ::= [is].

OPNS filter :: is -> iss -> integer -> integer -> iss.
EQNS filter _ [] _ _ = [].
     filter C (A:X) R P = if test C A R P then A:filter C X R P 
                                          else   filter C X R P.

OPNS   test :: is -> is -> integer -> integer -> boolean.
MACROS (#r,#x,#y) = place X Y.
EQNS   test X Y R I = if #r == R then inthere #x #y == I else false.
  
OPNS   place :: is -> is -> (integer,is,is).
MACROS (#i,#x,#y) = place X Y.
EQNS   place (A:X) (B:Y) = if A==B then (#i+1,  #x,  #y)
                                   else (#i  ,A:#x,B:#y).
      $place _ _ = (0,[],[]).

OPNS   inthere :: is -> is -> integer.
MACROS (#i,#y) = inthere A Y.
EQNS   inthere (A:X) Y = #i+inthere X #y.
       inthere [] _ = 0.

OPNS   inthere :: integer -> is -> (integer,is).
MACROS (#i,#x) = inthere I X.
EQNS   inthere _ [] = (0,[]).
       inthere I (A:X) = if I==A then (1,X)
                                 else (#i,A:#x). 

OPNS   gen :: integer -> integer -> integer -> integer -> integer -> iss.
EQNS   gen A B C D E = 
                     [[A,B,C,D,E]
                     | if E==8
                       then if D==8
                            then if C==8
                                 then if B==8
                                      then if A==8
                                           then []
                                           else gen (A+1) 1 1 1 1
                                      else gen A (B+1) 1 1 1
                                 else gen A B (C+1) 1 1
                            else gen A B C (D+1) 1
                       else gen A B C D (E+1)
                      ].

OPNS answer :: system -> (system,integer,integer).
MACROS (_,#r,#s1) = read(0,  S+"  X: ").
       (_,#p,#s2) = read(0,#s1+"             O: ").
       
EQNS answer S = (#s2,#r,#p).

OPNS goal :: system -> system.
EQNS goal S = guess (gen 1 1 1 1 1) (S+"Mastermind Guess V1.1\n"). 

OPNS takeone :: integer -> iss -> is.
EQNS takeone _ [] = [].
     takeone _ [A] = A.
    $takeone I IS = if length IS < I then takeone (I-length IS) IS
                                     else IS!I.
                
OPNS guess :: iss -> system -> system.
MACROS #A = takeone 83 X.
       (_,#s0) = write(length X,S+"Searchspace:").
       (_,#s1) = write(#A,#s0+"\n").
       (#s2,#r,#p) = answer #s1.
       #m = filter #A X #r #p.
       #l = guess #m #s2.
EQNS guess [] S = S+"Na das war wohl nichts\n".
     guess [X] S = system(write(X,S+"Das ist sie: "))+"\n".
    $guess X S = #l.                             
END.
