SPEC LEXEXP =

  ARRAY ACTUAL SORTS data=boolean. array=boolarray. END+
  SLIST ACTUAL SORTS data=integer. list =integers.  
               OPNS  compare=(>). END+

SORTS 
   exp ::= eps 
        |  class boolarray integer 
        |  closure exp
	|  alt(exp,exp)
	|  cat(exp,exp) 
	|  trail integer
	|  end   integer.
	
OPNS
  nullable:: exp -> boolean.

EQNS
  nullable eps = true.
  nullable(class _ _) = false.
  nullable(closure _) = true.
  nullable(alt(N1,N2)) = nullable N1 || nullable N2.
  nullable(cat(N1,N2)) = nullable N1 && nullable N2.
  nullable(trail _) = true.
  nullable(end _) = false.

OPNS 
  firstpos:: exp -> integers.
  lastpos:: exp -> integers.
  
EQNS
  firstpos eps = [].
  firstpos(class(_,I)) = [I].
  firstpos(closure N) = firstpos N.
  firstpos(alt(N1,N2)) = union(firstpos N1,firstpos N2).
  firstpos(cat(N1,N2)) = if nullable N1
                         then union(firstpos N1,firstpos N2)
                         else firstpos N1.
  firstpos(trail I) = [I].
  firstpos(end I) = [I].
  
  lastpos eps = [].
  lastpos(class(_,I)) = [I].
  lastpos(closure N) = lastpos N.
  lastpos(alt(N1,N2)) = union(lastpos N1,lastpos N2).
  lastpos(cat(N1,N2)) = if nullable N2
                        then union(lastpos N1,lastpos N2)
                        else lastpos N2.
  lastpos(trail I) = [I].
  lastpos(end I) = [I].
  
END.
