/* fib by Ric 21.3.1990 */
SPEC FIB = 

 LONGINT +
 
/* Version 1 */

OPNS
  fib:: integer -> int.
  
EQNS
  fib 0 = [].
  fib 1 = [1].
 $fib N = fib (N-1) + fib (N-2).



/* Version 2 */
OPNS
  fib1:: integer -> int.
  ff1:: (int,int,integer) -> int.
  
EQNS
  fib1 N = ff1([1],[],N).
  
  ff1(_,N1,0) = N1. 
 $ff1(N,N1,M) = ff1(N+N1,N,M-1).



/* Version 3 */
/* es gilt: fib (2n)   = (fib n + fib (n-1))^2 - (fib (n-1))^2
            fib (2n+1) = (fib n + fib (n-1))^2 + (fib n)^2
*/
OPNS
  fib2:: integer -> int.
  ff2:: integer -> (int,int).
  
MACROS
  (#n2,#n1) = ff2(N _div 2).
  #n3 = #n2+ #n1.
  #f1 = sqr #n2 + sqr #n1.
  #f2 = #n2*(#n3+ #n1).
  #f3 = sqr #n3 + sqr #n2.
  
EQNS
  fib2 N = int.1(ff2 N).

  ff2 0 = ([],[1]).
  ff2 1 = ([1],[]). 
 $ff2 N = 
    if (N _mod 2) == 0
    then (#f2,#f1)
    else (#f3,#f2).


OPNS 
  goal:: system -> system.
  
EQNS 
  goal S = system(write_int(fib2 20000,S)).
  
END.
