SPEC EVALRED = ID + LISTOPS + FLIP +
               STANDARD + ERROR + CONCAT +

SORTS term ::= square term
             | plus term term
             | time term term
             | num integer
             .

      subterm ::= c(fst::term,
                    term->term).
      
      subterms ::= [subterm].
      terms    ::= [term].
      termss   ::= [terms].
      
OPNS  rebuild :: subterm -> term.
EQNS  rebuild (c(T,EMBED)) = EMBED T.

OPNS  subterms :: term -> subterms.
EQNS  subterms T = [c(T,id)]++properSubterms T.

OPNS  properSubterms :: term -> subterms.
EQNS  properSubterms (square T)   = down square (subterms T).
      properSubterms (plus T1 T2) = down (flip plus T2) (subterms T1) ++
                                    down (plus T1)      (subterms T2).
      properSubterms (time T1 T2) = down (flip time T2) (subterms T1) ++
                                    down (time T1)      (subterms T2).
      properSubterms (num _)      = [].

OPNS  down :: (term -> term) -> subterms -> subterms.
EQNS  down F = map (down2 F).

  OPNS down2 :: (term -> term) -> subterm -> subterm.
  EQNS down2 F (c(T,E)) = c(T,F * E).

OPNS map2 :: (term -> term) -> subterms -> subterms.
EQNS map2 F = map (map2_ F).
  
  OPNS map2_ :: (term -> term) -> subterm -> subterm.
  EQNS map2_ F (c(A,C)) = c(F A,C).

OPNS isRedex :: term -> boolean.
EQNS isRedex (square _)             = true.
     isRedex (plus (num _) (num _)) = true.
     isRedex (time (num _) (num _)) = true.
    $isRedex _                      = false.

OPNS contract :: term -> term.
EQNS contract (square T)             = time T T.
     contract (plus (num N) (num M)) = num (N+M).
     contract (time (num N) (num M)) = num (N*M).
    $contract _                      = error "Not a redex!".

OPNS singleStep :: term -> terms.
EQNS singleStep = (map rebuild) * (map2 contract) * (filter (isRedex * fst)) * subterms.

OPNS normalForms :: term -> terms.
EQNS normalForms T = if singleStep T == []
                     then [T]
                     else concat ((map normalForms (singleStep T))::termss).
                     

OPNS a_term :: term.
EQNS a_term = square (square (plus (num 3) (num 7))).


IMPORTS
 SYSTEM+
 READWRITE +
 

OPNS  goal:: system -> system.

MACROS
      (_,     #S2) = write(length (normalForms a_term),S).
      (_,     #S3) = write_string "\n" #S2.
EQNS  goal S = #S3.

END.
