/* NO_TIMER_AVAIL should be defined iff this feature is not available
   at your machine!
*/ 

#ifdef MAC
/* MacIntosh does not support getrusage ... */
#define NO_TIMER_AVAIL
#endif



#include <sys/time.h>

#ifndef NO_TIMER_AVAIL

#include <sys/resource.h>
struct rusage STARTTIME,ENDTIME;

#endif

unsigned mode = 0;

#define sec(x) x.ru_utime.tv_sec
#define usec(x) x.ru_utime.tv_usec

TERM
DEFUN(xx_TIMERstop_timer_0,(S),
      TERM S)
{ 
#ifndef NO_TIMER_AVAIL
  getrusage(RUSAGE_SELF,&ENDTIME);
  mode = 2; /* we are stopped */
#endif
  return S;
}

TERM
DEFUN(xx_TIMERstart_timer_0,(S),
      TERM S)
{
#ifndef NO_TIMER_AVAIL
  getrusage(RUSAGE_SELF,&STARTTIME);
  mode = 1; /* we are running */
#endif
  return S;
}

void
DEFUN(xx_TIMERelapsed_time_0,(SI,SEC,HSEC,SO),
      TERM  SI   AND
      TERM *SEC  AND
      TERM *HSEC AND
      TERM *SO) 
{ *SO = SI;
#ifdef NO_TIMER_AVAIL
  *SEC = (TERM) -1;
  *HSEC = (TERM) -1;
#else
  if(mode==0) { *SEC = 0; *HSEC = 0; return; }
  if(mode==1) getrusage(RUSAGE_SELF,&ENDTIME);
  if(usec(ENDTIME)<usec(STARTTIME)) {
     *SEC = (TERM)(sec(ENDTIME)-sec(STARTTIME)-1);
     *HSEC = (TERM)((usec(ENDTIME)+1000000-usec(STARTTIME)) / 10000);
  } else {
     *SEC = (TERM)(sec(ENDTIME)-sec(STARTTIME));
     *HSEC = (TERM)((usec(ENDTIME)-usec(STARTTIME)) / 10000);
  }
#endif
}

void
DEFUN(xx_TIMERavailable_0,(SI,ISIT,SO),
      TERM  SI   AND
      TERM *ISIT AND
      TERM *SO) 
{ *SO = SI;
#ifdef NO_TIMER_AVAIL
  *ISIT = false;
#else
  *ISIT = true;
#endif
}

unsigned __XINIT_TIMER = 0;
void
DEFUN(TIMER_Xinitialize,(MODE),unsigned MODE)
 {if(__XINIT_TIMER == 0)__XINIT_TIMER = 1;}
