SPEC SLIST = { sorted list }

FORMAL SORTS data.
       OPNS compare:: data -> data -> boolean.

GLOBAL

  INTEGER +

SORTS
  list ::= empty | ins(data,list).
  
OPNS 

{ constructors are not visible so ... }

  mt :: list.
  data : list :: list.
  
{ the miranda set of listops which are suitable }

  length :: list -> integer.
  
  list ! integer :: data.
  
  list ++ list :: list.
  list -- list :: list.

  hd :: list -> data.
  tl :: list -> list.

  init :: list -> list.
  last :: list -> data.

  drop :: integer -> list -> list.
  dropwhile :: (data -> boolean) -> list -> list.

  take :: integer -> list -> list.
  takewhile :: (data -> boolean) -> list -> list.

  mkset :: list -> list.
  
  rep :: integer -> data -> list.
  
  member :: list -> data -> boolean.

  limit :: list -> data.
  
  select :: (data -> data -> boolean) -> list -> data.
  
{ more listops }

  union :: list -> list -> list.
  intersect :: list -> list -> list.
  
  delete_ith :: (integer,list) -> list.
  
  idx :: list -> data -> integer.
  
  is_head_of :: (list,list) -> boolean.
  
  single :: list -> boolean.
  
  ismt :: list -> boolean.
  
  split :: integer -> list -> (list,list).
  
LOCAL
  ERROR +

  
EQNS
  [] = empty.
  
  A : empty = ins(A,empty).
  A : ins(B,Y) = if compare A B then ins(A,ins(B,Y))
                                else ins(B,ins(A,Y)).

  length empty = 0.
  length (ins(_,X)) = 1+length X.
  
  empty    ! _ = error "subscript out of range".
  ins(A,X) ! N = if N==0 then A
                         else X ! (N-1).
  
  empty    ++ L = L.
  ins(A,X) ++ L = A:(X++L).
  
  X -- empty      = X.
  X -- (ins(B,Y)) = (remove B X) -- Y.

OPNS remove :: data -> list -> list.
EQNS remove _ empty = empty.
     remove B (ins(A,X)) = if B==A then X 
                           else ins(A,remove B X).

  hd (ins(A,_)) = A.
  hd empty = error "hd []".

  tl (ins(_,X)) = X.
  tl empty = error "tl []".

  init empty = error "init []".
  init (ins(A,X)) = if X==empty then empty 
                                else ins(A,init X).

  last empty = error "last []".
  last (ins(A,X)) = if X==empty then A
                                else last X.
  
  drop _ empty = empty.
  drop N (ins(A,X)) = if N>0 then drop (N-1) X 
                             else ins(A,X).

  dropwhile _ empty = empty.
  dropwhile F (ins(A,X)) = if F A then dropwhile F X 
                                  else ins(A,X).

  take _ empty = empty.
  take N (ins(A,X)) = if N>0 then ins(A,take (N-1) X)
                             else empty.

  takewhile _ empty = empty.
  takewhile F (ins(A,X)) = if F A then ins(A,takewhile F X)
                                  else empty.

  mkset empty = empty.
  mkset (ins(A,X)) = if member X A then mkset(ins(A,remove A X)) 
                                   else ins(A,mkset X).
  
  rep N D = if N <= 0 then empty 
                      else ins(D,rep(N-1) D).
  
  member empty _ = false.
  member (ins(A,X)) B = if A==B then true 
                                elsif compare A B then false
                                                  else member X B.
  
  limit (ins(A,ins(B,X))) = if A==B then A
                                    else limit (ins(B,X)).
 $limit _ = error "incorrect use of limit".
 
  select _ empty = error "incorrect use of select".
  select _ (ins(A,empty)) = A.
  select F (ins(A,ins(B,X))) = select F ((if F A B then A else B):X).
  
EQNS
  union empty Y = Y.
  union (ins(A,X)) Y = if member Y A then   union X Y 
                                     else A:union X Y.
  
  intersect empty _ = empty.
  intersect (ins(A,X)) Y = if member Y A then ins(A,intersect X Y)
                                         else       intersect X Y.

  delete_ith(_,empty) = empty.
  delete_ith(N,ins(A,X)) = if N<1 then error "wrong index in delete_ith" else 
                           if N==1 then X else ins(A,delete_ith(N-1,X)).
                        
  idx empty      _ = -1.
  idx (ins(A,X)) D = if A==D        then  0 
                  elsif idx X D < 0 then -1 
                  else                    1+idx X D.

  is_head_of(ins(_,_),empty) = false.
  is_head_of(empty,_) = true.
  is_head_of(ins(A,X),ins(B,Y)) = (A==B) && is_head_of(X,Y).
  
  single (ins(_,empty)) = true.
 $single _ = false.
 
  ismt = (==) empty.
  
MACROS 
  (#l,#r) = split(N-1) X.

EQNS
  split N (ins(A,X)) = if N==0 then (empty,ins(A,X)) else (ins(A,#l),#r).
  split _ empty = (empty,empty).
 
END.
