% search.nl

% search_l( +Parsetree, -Parsetree, +Gapnum, +SequenceFlag, 
%			-SequenceFlag, +SubsSoFar, -RestofSubs).
%
% a parse tree is searched, left to right,  for the list of
% "subs" which  are not neccesarily contiguous leaves in the tree.
% gaps are substituted and the resultant parse tree is returned as is the
% parse tree of the "sub" being searched for.
% If the sub parse tree S is given, it will be replaced in the tree if
% a suitable "gap" is there.
%
% Some subs in the list may require contiguous 'leaves' - e.g. those
% from a string - "foo(" will tokenize into two tokens 'foo and '('
% such contiguous subs are named 'csub' in the search_l predicate

% tnode is exactly the same as sub being searched for 
search_l(tnode(Type, Tokens), gap(N), N, CS, CS,  
		 [sub(Type, Tokens, S)|Subs], Subs):-
	!, S = tnode(Type, Tokens).
search_l(tnode(Type, Tokens), gap(N), N, _, some,
                 [csub(Type, Tokens, S)|Subs], Subs):-
        !, S = tnode(Type, Tokens).
% tnode is same as next sub after a mult, abandon "mult" search
search_l(tnode(Tp, Toks), NewNode, N, CS, CS1, 
                        [mult(_, _, _)|Subs], RSubs):-
	(Subs = [sub(Tp, Toks, _)| _]	; Subs = [csub(Tp, Toks, _)|_]), !,	
	search_l(tnode(Tp, Toks), NewNode, N, CS, CS1, Subs, RSubs).
% continue mult search
search_l(tnode(Tp, Toks), gap(N), N, CS, CS, 
                        [mult(Tp, [Toks|LToks], [tnode(Tp,Toks)|Lpts])|Subs],
                        [mult(Tp, LToks, Lpts)|Subs]):-  !.
% node is same type as sub being searched for,
% check if children span the tokens
search_l(node(Type, Chs), gap(N), N, CS, CS,    
			[sub(Type, Tokens, S)|Subs], Subs):-
	nonvar(Tokens),!,
	spanned(Chs, Tokens, []),
	S = node(Type, Chs). 
% node same type - tokens a var, so tokens of node can be extracted & returned
search_l(node(Type, Chs), gap(N), N, CS, CS,    
			[sub(Type, Tokens, S)|Subs], Subs):-
	var(Tokens),
	S = node(Type, Chs),
	extract_tokens(S, Tokens). 
search_l(node(Type, Chs), gap(N), N, _, some,
                        [csub(Type, Tokens, S)|Subs], Subs):-
        nonvar( Tokens),!,
	spanned(Chs, Tokens, []),
        S = node(Type, Chs).
search_l(node(Type, Chs), gap(N), N, _, some,    
			[csub(Type, Tokens, S)|Subs], Subs):-
	var(Tokens),
	S = node(Type, Chs),
	extract_tokens(S, Tokens). 
search_l(node(Tp, Chs), NewNode, N, CS, CS1,  
			 [mult(_, _, _)|Subs], RSubs):-
	(Subs = [sub(Tp, _, _)| _];Subs = [csub(Tp, _, _)|_]),!,	
	search_l(node(Tp, Chs), NewNode, N, CS, CS1, Subs, RSubs).
search_l(node(Tp, Chs), gap(N), N, CS, CS,   
			[mult(Tp, [Toks|LToks], [node(Tp,Chs)|Lpts])|Subs],
			[mult(Tp, LToks, Lpts)|Subs]):-
	!, extract_tokens(Chs, Toks).
% node is a "gap" and gapnumber N is different from that being searched for 
search_l(gap(N), gap(N), N1, CS, CS,  
		[sub(Type, Toks, S)|Subs], [sub(Type, Toks, S)|Subs]):-
	var(S),
	N1 \== N, !.
search_l(gap(N), gap(N), N1, CS, CS,
                [csub(Type, Toks, S)|Subs], [csub(Type, Toks, S)|Subs]):-
        var(S),
	N1 \== N, !.
search_l(gap(N), gap(N), N1, CS, CS, [mult(Tp, LToks, LPTs)|Subs], 
			[mult(Tp, LToks, LPTs)|Subs]):-
	var(LToks),
	N1 \== N, !.
% node is a gap, S is returned in its place
search_l(gap(N), S, N, CS, CS, [sub(_, _, S)|Subs], Subs):-
	nonvar(S), !.
search_l(gap(N), S, N, _, some, [csub(_, _, S)|Subs], Subs):-
        nonvar(S), !.
search_l(gap(N), Pt, N, CS, CS, [mult(Tp, [_|LToks], [Pt|Pts])|Subs],
                        [mult(Tp, LToks, Pts)|Subs]):-
	nonvar(Pt), !.
% node is empty
search_l(node(Tp, [empty]), node(Tp, [empty]), _, CS, CS, S, S):- !.
% node of different Type to that being searched for,
% check tokens are in the children of the node & then search the children
search_l(node(Type, Chs), node(Type, NewChs), N, CS, CS1, 
			Subs, RestSubs):-  
	Subs = [sub(_, Toks, S)|_],
	var(S),
	integer(N),	%replacing
	Chs \== [empty], !, 	
	tokens_in_children(Toks, Chs), % speeds up search if Toks not in Chs
	search_l_c(Chs, NewChs, N, CS, CS1, Subs, RestSubs).
% parse tree of sub - S is a non var, replacing it in the children of 
% node
search_l( node(Type, Chs), node(Type, NewChs), N, CS, CS1,  
                       Subs, RestSubs):-
	Subs = [sub(_, _, S)|_],
	nonvar(S),
	integer(N),		%putting back
	Chs \== [empty], !, 
	search_l_c(Chs, NewChs, N,  CS, CS1, Subs, RestSubs).
% gap number is a var and S is instantiated - just looking
search_l(node(Type, Chs), node(Type, NewChs), N, CS, CS1, 
			Subs, RestSubs):-  
	Subs = [sub(_, Toks, S)|_],
	nonvar(S),
	var(N),	%just looking
	Chs \== [empty],!,	
	tokens_in_children(Toks, Chs), % speeds up search if Toks not in Chs
	search_l_c(Chs, NewChs, N, CS, CS1, Subs, RestSubs).
% same as above - for csubs
search_l(node(Type, Chs), node(Type, NewChs), N, CS, CS1,
                        Subs, RestSubs):-
        Subs = [csub(_, Toks, S)|_],
	var(S),
	integer(N),     %replacing
        Chs \== [empty], !, 
        tokens_in_children(Toks, Chs), % speeds up search if Toks not in Chs
        search_l_c(Chs, NewChs, N, CS, CS1, Subs, RestSubs).
search_l( node(Type, Chs), node(Type, NewChs), N, CS, CS1,
                       Subs, RestSubs):-
        Subs = [csub(_, _, S)|_],
        nonvar(S),
        integer(N),             %putting back
        Chs \== [empty], !,
        search_l_c(Chs, NewChs, N,  CS, CS1, Subs, RestSubs).
search_l( node(Type, Chs), node(Type, NewChs), N, CS, CS1,
                       Subs, RestSubs):-
        Subs = [csub(_, _, S)|_],
	nonvar(S),
	var(N), %just looking
        Chs \== [empty], !,
	tokens_in_children(Toks, Chs), % speeds up search if Toks not in Chs
	search_l_c(Chs, NewChs, N,  CS, CS1, Subs, RestSubs).
% search the children of node for mults
search_l(node(Type, Chs), node(Type, NewChs), N, CS, CS1, Subs, RestSubs):-
	Subs = [mult(_, _, _)|_],
	Chs \== [empty], !, 
	search_l_c(Chs, NewChs, N, CS, CS1, Subs, RestSubs).
%
% search the children
search_l_c([], [], _,  CS, CS, S, S):- !.
search_l_c(Chs, Chs, _, CS, CS, [], []) :-
	Chs \== [], !.
search_l_c([Ch|Chs], [NewCh|NewChs], Gnum, CS, CS2, Subs, RestSubs):-
	Subs = [_|_], 
	search_l(Ch, NewCh, Gnum, CS, CS1, Subs, MoreSubs), 
	NewCh \== Ch, !,
	search_l_c(Chs, NewChs, Gnum, CS1, CS2, MoreSubs, RestSubs).
search_l_c([Ch|Chs], [Ch|NewChs], Gnum, CS, CS1, Subs, RestSubs):-
	(Subs = [sub(_, _, _)|_]; Subs = [mult(_, _, _)|_]), !,
	search_l_c(Chs, NewChs, Gnum, CS, CS1, Subs, RestSubs).
search_l_c([Ch|Chs], [Ch|NewChs], Gnum, none, CS1, Subs, RestSubs):-
	Subs = [csub(_, _, _)|_], !,
	search_l_c(Chs, NewChs, Gnum, none, CS1, Subs, RestSubs).
search_l_c([Ch|Chs], [NewCh|NewChs], N, CS, CS1,  
			[mult(_, [], [])|Subs], RSubs):-
	!, search_l_c([Ch|Chs], [NewCh|NewChs], N, CS, CS1, Subs, RSubs).

% search_sseq( +Parsetree, -Parsetree, +Gapnum, +SequenceFlag,
%                       -SequenceFlag, +MultFlag, -MultFlag, 
%			+SubsSoFar, -RestofSubs).
% same as search_l, except the "subs" and "mults" must be contiguous leaves
% in the parsetree - hence the two sets of flags, which will be set and
% must remain set throughout the search & finding of all subs in the list.
%
search_sseq(tnode(Tp, Toks), gap(N), N, _, some, Ms, Ms, 
			[sub(Tp, Toks, S)|Subs], Subs):-
	!, S = tnode(Tp, Toks).
search_sseq(tnode(Tp, Toks), gap(N), N, _, some, _ ,mult,
                        [mult(Tp, [Toks|LToks], [tnode(Tp,Toks)|Lpts])|Subs],
                        [mult(Tp, LToks, Lpts)|Subs]) :- !.
search_sseq(node(Tp, Chs), gap(N), N, _, some, Ms, Ms, 
			[sub(Tp, Toks, S)|Subs], Subs):-
	nonvar(Toks), !,
	spanned(Chs, Toks, []),
	S = node(Tp, Chs).
search_sseq(node(Tp, Chs), gap(N), N, _, some, Ms, Ms,
			[sub(Tp, Toks, S)|Subs], Subs):-
	var(Toks), % no cut, want to be able to re-enter search here
		   % in case node required is inside Chs 
	S = node(Tp, Chs),
	extract_tokens(S, Toks).
search_sseq(node(Tp, Chs), gap(N), N, _, some, _, mult,
			[mult(Tp, [Toks|LToks], [node(Tp,Chs)|Lpts])|Subs],
			[mult(Tp, LToks, Lpts)|Subs]):-
	!, extract_tokens(Chs, Toks).
search_sseq(gap(N), gap(N), N1, SS, SS, MS, MS,
			[sub(Tp, Toks, S)|Subs],  [sub(Tp, Toks, S)|Subs]):-
	var(S),
	N1 \== N, ! .
search_sseq(gap(N), gap(N), N1, SS, SS, MS, MS, 
			[mult(Tp, LToks, LPTs)|Subs], 
			[mult(Tp, LToks, LPTs)|Subs]):-
	var(LToks),
	N1 \== N, !.
search_sseq(gap(N), S, N, _, some, MS, MS,  
			[sub(_, _, S)|Subs], Subs):-
	nonvar(S), !.
search_sseq(gap(N), Pt, N, _, some, _, mult,
			[mult(Tp, [_|LToks], [Pt|Pts])|Subs],
                        [mult(Tp, LToks, Pts)|Subs]):-
	nonvar(Pt), !.
search_sseq(node(Tp, [empty]), node(Tp, [empty]), _, 
			SS, SS, MS, MS, Subs, Subs) :- !.
search_sseq(node(Tp, Chs), node(Tp, NewChs), N, SS, SS1, MS, MS1,
			Subs, Rsubs):-
	Subs = [sub(_, Toks, S)|_],
	var(S),
	integer(N), 	%search & remove 
	Chs \== [empty], !, 
	tokens_in_children(Toks, Chs),
	search_sseq_c(Chs, NewChs, N, SS, SS1, MS, MS1, Subs, Rsubs).
search_sseq(node(Tp, Chs), node(Tp, NewChs), N, SS, SS1, MS, MS1,
			Subs, Rsubs):-
	Subs = [sub(_, _, S)|_],
	nonvar(S),
	integer(N), 	% putting back
	Chs \== [empty], !, 
	search_sseq_c(Chs, NewChs, N, SS, SS1, MS, MS1, Subs, Rsubs).
search_sseq(node(Tp, Chs), node(Tp, NewChs), N, SS, SS1, MS, MS1,
			Subs, Rsubs):-
	Subs = [sub(_, Toks, S)|_],
	nonvar(S),
	var(N),	 % just looking 
	Chs \== [empty],  
	tokens_in_children(Toks, Chs), !,
	search_sseq_c(Chs, NewChs, N, SS, SS1, MS, MS1, Subs, Rsubs).
search_sseq(node(Type, Chs), node(Type, NewChs), N, SS, SS1, MS, MS1,
				Subs, RSubs):-
	Subs = [mult(_, _, _)|_],
	Chs \== [empty], !,
	search_sseq_c(Chs, NewChs, N, SS, SS1, MS, MS1, Subs, RSubs).


search_sseq_c([], [], _, SS, SS, MS, MS, Subs, Subs):- !. 
search_sseq_c(Chs, Chs, _, SS, SS, MS, MS, [], []) :-
	Chs \== [], !.
search_sseq_c([Ch|Chs], [NewCh|NewChs], N, SS, SS2, MS, MS2, 
				Subs, Rsubs):-
	Subs = [_|_],
	search_sseq(Ch, NewCh, N, SS, SS1, MS, MS1, Subs, Subs1), 
	Ch \== NewCh, !,
	search_sseq_c(Chs, NewChs, N, SS1, SS2, MS1, MS2, Subs1, Rsubs).
search_sseq_c([Ch|Chs], [Ch|NewChs], N, none, SS, MS, MS1, Subs, Rsubs):-
	Subs = [_|_], !,
	search_sseq_c(Chs, NewChs, N, none, SS, MS, MS1, Subs, Rsubs).
search_sseq_c([Ch|Chs], [NewCh|NewChs], N, some, SS, mult, MS,
			[mult(_, [], [])|Subs], Rsubs):- %no mults left
	!, search_sseq_c([Ch|Chs], [NewCh|NewChs], N, some, SS, none, MS,
				Subs, Rsubs).


spanned([], T, T):- !.
spanned([empty], [], []) :- !.
spanned([Ch|Chs], Tokens, RestTokens):-
	!, span(Ch, Tokens, MoreTokens),
	spanned(Chs, MoreTokens, RestTokens).


span(tnode(_, [empty]), T, T) :- !.
span(node(_, [empty]), T, T) :- !.
span(tnode(_, Tokens), T, NewT):-
	Tokens \== [empty], !,
	append(Tokens, NewT, T).
span(node(_, Chs), T, NewT):-
	Chs \== [empty], !,
	spanned(Chs, T, NewT).


