ptn$program(A, B, node(ptn$program, [C])) :-
	ptn$clauses(A, B, C).

ptn$clauses(A, B, node(ptn$clauses, [C, tnode(atom, [.]), D])) :-
	ptn$clause(A, [.|E], C),
	ptn$clauses(E, B, D).

ptn$clauses(A, A, node(ptn$clauses, [empty])).

ptn$clause(A, B, node(ptn$clause, [C, D])) :-
	ptn$head(A, E, C),
	ptn$body(E, B, D).

ptn$head(A, B, node(ptn$head, [C])) :-
	ptn$goal(A, B, C).

ptn$body([(:-)|A], B, node(ptn$body, [tnode(atom, [(:-)]), C, D])) :-
	ptn$goal(A, E, C),
	ptn$restBody(E, B, D).

ptn$body(A, A, node(ptn$body, [empty])).

ptn$goal(A, B, node(ptn$goal, [C, D])) :-
	atom(A, E, C),
	ptn$restGoal(E, B, D).

ptn$goal([!|A], A, tnode(ptn$goal, [!])).

ptn$goal(A, B, node(ptn$goal, [C, tnode(atom, [unify]), D])) :-
	ptn$nodeTerm(A, [unify|E], C),
	ptn$plusTerm(E, B, D).

ptn$restGoal(['('|A], B, node(ptn$restGoal, [tnode(atom, ['(']), C, tnode(atom, [')'])])) :-
	ptn$args(D, A, [')'|B], C).

ptn$restGoal(A, A, node(ptn$restGoal, [empty])).

ptn$args(A, B, C, node(ptn$args(A), [D, E])) :-
	ptn$term(B, F, D),
	ptn$restArgs(G, F, C, E),
	A is G + 1.

ptn$restBody(A, B, node(ptn$restBody, [C, D, E])) :-
	ptn$andor(A, F, C),
	ptn$goal(F, G, D),
	ptn$restBody(G, B, E).

ptn$restBody(A, A, node(ptn$restBody, [empty])).

ptn$andor([(',')|A], A, tnode(ptn$andor, [(',')])).

ptn$andor([(';')|A], A, tnode(ptn$andor, [(';')])).

ptn$restArgs(A, [(',')|B], C, node(ptn$restArgs(A), [tnode(atom, [(',')]), D, E])) :-
	ptn$term(B, F, D),
	ptn$restArgs(G, F, C, E),
	A is G + 1.

ptn$restArgs(0, A, A, node(ptn$restArgs(0), [empty])).

ptn$term(A, B, node(ptn$term, [C])) :-
	number(D, A, B, C).

ptn$term(A, B, node(ptn$term, [C])) :-
	atom(A, B, C).

ptn$term(A, B, node(ptn$term, [C])) :-
	var(A, B, C).

ptn$term(A, B, node(ptn$term, [C])) :-
	ptn$string(A, B, C).

ptn$term(A, B, node(ptn$term, [C])) :-
	ptn$list(A, B, C).

ptn$term(A, B, node(ptn$term, [C])) :-
	ptn$goal(A, B, C).

ptn$term(A, B, node(ptn$term, [C])) :-
	ptn$nodeTerm(A, B, C).

ptn$plusTerm(A, B, node(ptn$plusTerm, [C, tnode(atom, [++]), D])) :-
	ptn$nodeTerm(A, [++|E], C),
	ptn$restPlusTerm(E, B, D).

ptn$plusTerm(A, B, node(ptn$plusTerm, [C])) :-
	var(A, B, C).

ptn$restPlusTerm(A, B, node(ptn$restPlusTerm, [C, D])) :-
	number(E, A, F, C),
	ptn$subTerm(F, B, D).

ptn$restPlusTerm(A, B, node(ptn$restPlusTerm, [C])) :-
	ptn$subTerm(A, B, C).

ptn$subTerm([' ('|A], B, node(ptn$subTerm, [tnode(atom, [' (']), C, tnode(atom, [')'])])) :-
	ptn$subs(A, [')'|B], C).

ptn$subTerm([<<|A], B, node(ptn$subTerm, [tnode(atom, [<<]), C, tnode(atom, [>>])])) :-
	ptn$subs(A, [>>|B], C).

ptn$subTerm(A, B, node(ptn$subTerm, [C])) :-
	ptn$sub(A, B, C).

ptn$subs(A, B, node(ptn$subs, [C, D])) :-
	ptn$sub(A, E, C),
	ptn$moreSubs(E, B, D).

ptn$moreSubs([(',')|A], B, node(ptn$moreSubs, [tnode(atom, [(',')]), C, D])) :-
	ptn$sub(A, E, C),
	ptn$moreSubs(E, B, D).

ptn$moreSubs(A, A, node(ptn$moreSubs, [empty])).

ptn$sub(A, B, node(ptn$sub, [C, tnode(atom, [::]), D])) :-
	ptn$nodeTerm(A, [::|E], C),
	ptn$restSub(E, B, D).

ptn$sub(A, B, node(ptn$sub, [C])) :-
	var(A, B, C).

ptn$sub(A, B, node(ptn$sub, [C])) :-
	ptn$string(A, B, C).

ptn$restSub(A, B, node(ptn$restSub, [C, tnode(atom, [*])])) :-
	ptn$atomVar(A, [*|B], C).

ptn$restSub(A, B, node(ptn$restSub, [C])) :-
	ptn$atomVar(A, B, C).

ptn$restSub(A, B, node(ptn$restSub, [C, tnode(atom, [*])])) :-
	ptn$goal(A, [*|B], C).

ptn$restSub(A, B, node(ptn$restSub, [C])) :-
	ptn$goal(A, B, C).

ptn$nodeTerm([A|B], B, tnode(ptn$nodeTerm, [A])) :-
	isNode(A).

ptn$nodeTerm(A, B, node(ptn$nodeTerm, [C])) :-
	var(A, B, C).

ptn$atomVar(A, B, node(ptn$atomVar, [C])) :-
	atom(A, B, C).

ptn$atomVar(A, B, node(ptn$atomVar, [C])) :-
	var(A, B, C).

ptn$list(['['|A], B, node(ptn$list, [tnode(atom, ['[']), C, tnode(atom, [']'])])) :-
	ptn$listArgs(A, [']'|B], C).

ptn$listArgs(A, B, node(ptn$listArgs, [C, D])) :-
	ptn$term(A, E, C),
	ptn$restListArgs(E, B, D).

ptn$listArgs(A, A, node(ptn$listArgs, [empty])).

ptn$restListArgs([(',')|A], B, node(ptn$restListArgs, [tnode(atom, [(',')]), C, D])) :-
	ptn$term(A, E, C),
	ptn$restListArgs(E, B, D).

ptn$restListArgs(['|'|A], B, node(ptn$restListArgs, [tnode(atom, ['|']), C])) :-
	ptn$term(A, B, C).

ptn$restListArgs(A, A, node(ptn$restListArgs, [empty])).

atom([A|B], B, tnode(atom, [A])) :-
	atom(A).

var([A|B], B, tnode(var, [A])) :-
	A = [C|D],
	(	[C] == "_"
	;	isUpper(C)
	).

number(A, [A|B], B, tnode(number(A), [A])) :-
	number(A).

ptn$string([A|B], B, tnode(ptn$string, [A])) :-
	string(A).

descendent(ptn$program, [ptn$clauses]).

descendent(ptn$clauses, [ptn$clause, ., ptn$clauses]).

descendent(ptn$clause, [ptn$head, ptn$body]).

descendent(ptn$head, [ptn$goal]).

descendent(ptn$body, [(:-), ptn$goal, ptn$restBody]).

descendent(ptn$goal, [atom, ptn$restGoal]).

descendent(ptn$goal, [ptn$nodeTerm, unify, ptn$plusTerm]).

descendent(ptn$restGoal, ['(', ptn$args(A), ')']).

descendent(ptn$args(A), [ptn$term, ptn$restArgs(B)]).

descendent(ptn$restBody, [ptn$andor, ptn$goal, ptn$restBody]).

descendent(ptn$restArgs(A), [(','), ptn$term, ptn$restArgs(B)]).

descendent(ptn$term, [number(A)]).

descendent(ptn$term, [atom]).

descendent(ptn$term, [var]).

descendent(ptn$term, [ptn$string]).

descendent(ptn$term, [ptn$list]).

descendent(ptn$term, [ptn$goal]).

descendent(ptn$term, [ptn$nodeTerm]).

descendent(ptn$plusTerm, [ptn$nodeTerm, ++, ptn$restPlusTerm]).

descendent(ptn$plusTerm, [var]).

descendent(ptn$restPlusTerm, [number(A), ptn$subTerm]).

descendent(ptn$restPlusTerm, [ptn$subTerm]).

descendent(ptn$subTerm, [' (', ptn$subs, ')']).

descendent(ptn$subTerm, [<<, ptn$subs, >>]).

descendent(ptn$subTerm, [ptn$sub]).

descendent(ptn$subs, [ptn$sub, ptn$moreSubs]).

descendent(ptn$moreSubs, [(','), ptn$sub, ptn$moreSubs]).

descendent(ptn$sub, [ptn$nodeTerm, ::, ptn$restSub]).

descendent(ptn$sub, [var]).

descendent(ptn$sub, [ptn$string]).

descendent(ptn$restSub, [ptn$atomVar, *]).

descendent(ptn$restSub, [ptn$atomVar]).

descendent(ptn$restSub, [ptn$goal, *]).

descendent(ptn$restSub, [ptn$goal]).

descendent(ptn$nodeTerm, [var]).

descendent(ptn$atomVar, [atom]).

descendent(ptn$atomVar, [var]).

descendent(ptn$list, ['[', ptn$listArgs, ']']).

descendent(ptn$listArgs, [ptn$term, ptn$restListArgs]).

descendent(ptn$restListArgs, [(','), ptn$term, ptn$restListArgs]).

descendent(ptn$restListArgs, ['|', ptn$term]).

