% ptn_io.pl
%
% most of the io predicates for ptn

% read_clauses( +InputFile, -Clauses)
% used by the dcg => predicates_with_parse_trees translator, gr2nl
%
read_clauses( InputFile, Clauses) :-
	nonvar( InputFile),
	open( InputFile, read, Stream),
	gather_clauses( Stream, Clauses),
	close( Stream).

gather_clauses( Stream, [ Term|Rest]) :-
	read( Stream, Term),
	Term \== end_of_file,!,
	gather_clauses( Stream, Rest).
gather_clauses( _, []).

% get_tokens( +InputFile, -Tokens)
%
% used by ptn to tokenize a file prior to parsing
% tokens are returned as a list of [Token|Type] - see np_depend.nl
%
get_tokens( Input, Tokens) :-
	nonvar( Input),
	open( Input, read, Stream),
	gather_tokens( Stream, Tokens),
	close( Stream).

gather_tokens( S, [Tok|Toks]) :-
	get_token( S, T, Type),
	Type \== end_of_file,!,
	inputToToken( T, Type, Tok),	
	gather_tokens( S, Toks).
gather_tokens( _, []).
	
inputToToken( _, end, '.').	
inputToToken( T, string, Str) :-
	termToChars( T, Str).
inputToToken( T, quoted, Tok) :-
	atom_chars( T, Ch),
	append( "'", Ch, Ch1),
	append( Ch1, "'", Ch2),
	atom_chars( Tok, Ch2).	
inputToToken( T, _, T).	

% write Terms to a Stream
%
write_terms( _, []).
write_terms( Stream, [ Term|Terms]) :-
	write_clause( Stream, Term),   % so its readable!
	write( Stream, '.'),		% by prolog too
	nl( Stream), nl(Stream),
	write_terms( Stream, Terms).

% write Tokens to a File
%
print_tokens( Filename, List) :-
	open( Filename, write, Stream),
	print_list( Stream, List),
	close( Stream). 
%
% attempting to layout code reasonably...
% 
print_list( _, []).
print_list( Stream, [ H|Rest]) :-
	atom_chars( H, S),
	S  == ":-" ,!,
	write( Stream, H),
	nl( Stream),
	write( Stream, '	'),
	print_list( Stream, Rest).
print_list( Stream, ['.'|Rest]) :-
	!, write( Stream, '.'),
	nl(Stream),
	nl(Stream),
	print_list( Stream, Rest).
print_list( Stream, [')', ','|Rest]) :-
	!, write( Stream, ')'),
	write( Stream, ','),
	nl(Stream),
	write( Stream, '	'),
	print_list( Stream, Rest).
print_list( Stream, [ ','|Rest]) :-
	!, write( Stream, ','),
	write( Stream, ' '),
	print_list( Stream,  Rest).
print_list( Stream, ['('|Rest]) :-
	!, write(Stream,  '('),
	write( Stream, ' '),
	print_list( Stream, Rest).
print_list( Stream, [H|Rest]) :-
	string(H), !,
	write_string(Stream, H),
	print_list( Stream, Rest).	
print_list( Stream, [H|Rest]) :-
	!, write( Stream, H),
	print_list( Stream, Rest).

	
