% demo.nl
%
% need to load phones_gr and phones, and run phones('phones.txt') to assert
% facts
%
% the facts represent the relation between each person and details
% about them, like name, room number etc.
% They are just lists of whatever was in the phones.txt file 
% Better to have represented as structures maybe e.g. room( 2, 21)
% instead of [L2, '.', 21] as is here. 

demo:-
	write( 'Staff whose office is on level 2:'), nl, nl,
	findall( [B, A], (staff( [N],[F|_], _, _, _, ["L2"|_]),
                        atom_chars( A, N), atom_chars( B, F)), Names),
	sort( Names, SNames),
	write_names( SNames), nl, nl,
	write( 'PhD students and telephone numbers :'), nl, nl,	
	findall( [E, C, Tel], (student( [N1],[F1|_], ["PhD"], [Tel], _, _),
                        atom_chars( C, N1), atom_chars( E, F1)), Names1),
	sort( Names1, SNames1),
        write_names( SNames1), nl, nl.


write_names( []).
write_names( [N|Names]) :-
	write_list( N),
	nl,
	write_names( Names).

write_list( []).
write_list( [A|Rest]) :-
	write( A),
	write( ' '),
	write_list( Rest).
