/*
** this is prom.c
**
** source of PROM's startup program
**
** (c) T. Kielmann, 92-06-01
*/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

/*
** static variables for possible command line options
*/

static int noactions= 0,
           dependencies = 0,
           knowledge_base = 0;

static char *promfile = NULL;


typedef struct _paths {
           char *path;
           struct _paths *next;
           } paths;

static paths *searchpaths = NULL;

/*
** ...for targets
*/

typedef struct _targets {
           char *target;
           struct _targets *next;
           } targets;

static targets *targetlist = NULL;

/*
** ...for the PROLOG interpreter's command line
*/

#ifndef PROLOG
#define PROLOG "swipl"
#endif
#ifndef BOOTFILE
#define BOOTFILE "promboot"
#endif
#define ENVVAR "PROM"

static char *plargs[8] = {
	PROLOG,
	"-x",
	BOOTFILE,
	"-g",
	NULL,
	"-t",
	"halt",
	NULL
	};



int main(argc, argv)
  int argc;
  char *argv[];
{
  int i;
  char *optlist;
  int opts_inserted;
  char *envvar;

  if ( argc == 1 )
    helptext();

  /* examine command line options... */
  parse_args(argc, argv);

  /* examine environment variable... */
  /* transform it into a form similar to (argc,argv)... */

  envvar = getenv(ENVVAR);
  if (envvar != NULL) {
    char *envdup;
    int envc;
    char **envv;

    envdup = (char*)strdup(envvar);
    if (envdup == NULL)
      no_memory();

    if ( strtok(envdup," \t") != NULL ) {
      envc=1;
      while (strtok(NULL," \t") != NULL )
        envc++;
    }
    envv = (char**)malloc(++envc * sizeof(char*));
    if (envv == NULL)
      no_memory();
    envc = 1;
    free(envdup);
    envdup = (char*)strdup(envvar);
    if (envdup == NULL)
      no_memory();

    envv[envc++] = strtok(envdup," \t");
    while ( envv[envc-1] != NULL )
      envv[envc++] = strtok(NULL," \t");
    envc--;
    parse_args(envc,envv);
  }

  if ( (knowledge_base == 0) && (targetlist == NULL) )
    no_target();

/*
** make command line out of options...
*/
  optlist = (char*)malloc(32768*sizeof(char));
                  /* upper bound for UNIX command line :-) */
  if (optlist == NULL)
    no_memory();

  opts_inserted = 0;
  (void) strcpy(optlist,"run([");
  if (noactions) {
    (void) strcat(optlist,"noaction");
    opts_inserted = 1;
  }
  if (dependencies) {
    if (opts_inserted)
      (void) strcat(optlist,",");
    (void) strcat(optlist,"dependgraph");
    opts_inserted = 1;
  }
  if (knowledge_base) {
    if (opts_inserted)
      (void) strcat(optlist,",");
    (void) strcat(optlist,"knowledgebase");
    opts_inserted = 1;
  }

  if (promfile != NULL) {
    if (opts_inserted)
      (void) strcat(optlist,",");
    (void) strcat(optlist,"(file,");
    (void) strcat(optlist,promfile);
    (void) strcat(optlist,")");
    opts_inserted = 1;
  }

  { paths *tmp = searchpaths;
    while (tmp) {
      if (opts_inserted)
        (void) strcat(optlist,",");
      (void) strcat(optlist,"(searchpath,");
      (void) strcat(optlist,tmp->path);
      (void) strcat(optlist,")");

      opts_inserted = 1;
      tmp = tmp->next;
    }
  }
  (void) strcat(optlist,"],[");
  opts_inserted = 0;

  { targets *tmp = targetlist;
    while (tmp) {
      if (opts_inserted)
        (void) strcat(optlist,",");
      (void) strcat(optlist,tmp->target);
      opts_inserted = 1;
      tmp = tmp->next;
    }
  }
  (void) strcat(optlist,"])");

  plargs[4] = optlist;
  exit(execvp(PROLOG,plargs));
}



/*
** examine a set of command line options
*/

int parse_args(argc, argv)
  int argc;
  char *argv[];
{
  int i;

  for (i=1; i<argc; i++){
    if ( argv[i][0] == '-' )
      switch ( argv[i][1] ) {
        case 'n': noactions = 1;
                  break;
        case 'k': knowledge_base = 1;
                  break;
        case 'd': dependencies = 1;
                  break;
        case 'f': if ( argv[i][2] != '\0' )
                    promfile = &(argv[i][2]);
                  else {
                    if ( i+1 < argc ) 
                      promfile = argv[++i];
                    else bad_option(argv[i]);
                  }
                  break;
        case 'I': if ( argv[i][2] != '\0' )
                    new_path(&(argv[i][2]));
                  else {
                    if ( i+1 < argc )
                      new_path(argv[++i]);
                    else bad_option(argv[i]);
                  }
                  break;
        case 'h': helptext();
                  break;
	default:  bad_option(argv[i]);
      }
    else new_target(argv[i]);
  }
}



/*
** add a new search path to the end of the path list
*/

int new_path (pathstring)
  char * pathstring;
{
  paths *newpath, *tmp;

  newpath = (paths*) malloc(sizeof(paths));
  if ( newpath == NULL )
    no_memory();
  newpath->path = pathstring;
  newpath->next = NULL;
  if ( searchpaths == NULL )
    searchpaths = newpath;
  else {
    tmp = searchpaths;
    while (tmp->next != NULL)
      tmp = tmp->next;
    tmp->next = newpath;
  }
}



/*
** add a new target to the target list
*/

int new_target (targetstring)
  char * targetstring;
{
  targets *newtarget, *tmp;

  newtarget = (targets*) malloc(sizeof(targets));
  if ( newtarget == NULL )
    no_memory();
  newtarget->target = targetstring;
  newtarget->next = NULL;
  if ( targetlist == NULL )
    targetlist = newtarget;
  else {
    tmp = targetlist;
    while (tmp->next != NULL)
      tmp = tmp->next;
    tmp->next = newtarget;
  }
}



/*
** print a help message and exit
*/

int helptext()
{
  fprintf(stderr,"Welcome to PROM, Version 1.1\n");
  fprintf(stderr,"(c) 1991, 1992 by T.Kielmann and TH Darmstadt/ITI\n");
  fprintf(stderr,"parameters of PROM (any order):\n");
  fprintf(stderr,"terms denoting target files... (at least one)\n");
  fprintf(stderr,"-f <promfile>: file to be interpreted by PROM\n");
  fprintf(stderr,"-I <path>    : searchpath for included promfiles\n");
  fprintf(stderr,"-n           : no actions will be performed\n");
  fprintf(stderr,"-d           : show dependencies between files (no actions)\n");
  fprintf(stderr,"-k           : show knowledge base after reading promfile (no actions)\n");
  fprintf(stderr,"-help        : print this message\n");
  exit(0);
}



/*
** print error message for bad option and exit
*/

int bad_option(argument)
  char *argument;
{
  fprintf(stderr,"prom: bad parameter: %s\n",argument);
  fprintf(stderr,"      try '-help' for possible parameters\n");
  exit(2);
}



/*
** print error message for bad option and exit
*/

int no_target()
{
  fprintf(stderr,"prom: no target specified\n");
  fprintf(stderr,"      (don't know which file(s) to update)\n");
  exit(2);
}



/*
** print error message if no memory available
*/

int no_memory()
{
  fprintf(stderr,"prom: no memory available\n");
  exit(3);
}

