/* This is main.pl
**
** Purpose: Control execution for PROM
**
** (c) T.Kielmann, 92-04-22
**
*/

/*
** main goal is run/2
** 1. process options
** 2. execute update process
*/

run(Optlist,Goallist) :-
        process_opts(Optlist),!,
        recorded(file,Makefile),
        process_file(Makefile),!,
        process(Goallist).

process_opts([]).
process_opts([O|List]) :-
        opt(O),
        process_opts(List).

opt((searchpath,Path)) :-
        recordz(searchpath,Path).

opt((file,File)) :-
        remove_tmp_predicate(file),
        recordz(file,File).

opt(noaction) :-
        recordz(noaction,noaction).

opt(knowledgebase) :-
	recordz(knowledgebase,knowledgebase).

opt(dependgraph) :-
        recordz(dependgraph,dependgraph).

opt(Unknown) :-
	write('prom: unknown option '),
        write(Unknown),nl,
        abort.


process(_) :-
        recorded(knowledgebase,knowledgebase),
        show_knowledge_base,!.

process(Goallist) :-
        recorded(dependgraph,dependgraph),
        show_deptrees(Goallist),!.

process(Goallist) :-
        make(Goallist),!.

