/* This is expand.pl
**
** Purpose: Term expansionc facility for PROM
**
** (c) T.Kielmann, 92-04-15
**
*/


/*
** first look for old expansion
*/
expand(Term,Exp) :-
	recorded(oldexp,oldexp(Term,Exp)),
        !.

/*
** for concatenation, we first expand the two subterms and 
** concatenate their expansions afterwards
*/
expand(+(L,R),Exp) :-
	!,
	expand(L,LExp),
	expand(R,RExp),
	convert([+(LExp,RExp)],Exp),
	recorda(oldexp,oldexp(+(L,R),Exp)).
		     
/*
** external evaluation
*/
expand(Term,Exp) :-
	Term =.. [eval|Argv],!,
	expandall(Argv,ArgvExp),
	calleval(ArgvExp,Exp),
	recorda(oldexp,oldexp(Term,Exp)).

/*
** expand using the knowledge base
*/
expand(Term,Expansion) :-
	recorded(def,def(Term,TermExp)),!,
	expandall(TermExp,FullExp),
	convert(FullExp,Expansion),
	recorda(oldexp,oldexp(Term,Expansion)).

/*
** empty expansion of terms with existing definition but
** without definition for current instantiation
*/
expand(Term,[[]]) :-
	not atom(Term),
	unb_term(Term,UTerm),
	recorded(def,def(UTerm,_)),!,
	recorda(oldexp,oldexp(Term,[[]])).

/*
** if all else fails...
** the term remains unchanged
*/
expand(Term,[Term]):-
	recorda(oldexp,oldexp(Term,[Term])).


/*
** expand all members of a list
*/
expandall([],[]).
expandall([T1|TL],Full) :- 
        expand(T1,T1E),
	expandall(TL,TLE),
	append(T1E,TLE,Full).


/*
** convert a list of ``concatenation terms''
*/
convert([],[]).
convert([H|T],[HE|TE]) :- 
        cvt(H,HE),
	convert(T,TE).

cvt(+([L],[R]),Concat) :- 
        !,
	cvt(L,LConv),
        cvt(R,RConv),
        concat_atom([LConv,RConv],Concat).
cvt(Nonplus,Nonplus).



/*
** **********************************************************************
** unbind: replace all atoms of a structure (except the functor)
** with unbound variables
*/

unb_term(T,_) :- atom(T),!.
unb_term(T,_) :- var(T),!.

unb_term([T],[UT]) :- unb_term(T,UT),!.

unb_term([T1|TL],[UT1|UTL]) :-
	unb_term(T1,UT1),
	unb_term(TL,UTL).

unb_term(T,UT) :-
	not functor(T,.,_),    /* T is no list */
	T =.. [F|AL],
	unb_term(AL,UAL),
	UT =.. [F|UAL].



/*
** **********************************************************************
** external evaluation
*/


/*
** use create_action/2 from make.pl for expanding terms inside the action
** construct action and read from pipe
*/
calleval(Argv,Exp) :-
        create_action(Argv,Action),
        open(pipe(Action),read,Stream),
        readeval(Stream,Exp),
        close(Stream).

/*
** read until end_of_file appears
*/
readeval(Stream,List) :-
        read(Stream,Term),
        app_term(Stream,Term,List).

/*
** append Term to list of already read terms
*/
app_term(_,end_of_file,[]) :- !.
app_term(Stream,Term,[Term|Following]) :-
        readeval(Stream,Following),
        !.
