/* This is debug.pl
**
** Purpose: Print debugging information for PROM
**
** (c) T.Kielmann, 92-04-15
**
*/


/*
** **********************************************************************
** show the knowledge base after processing the makefile(s)
*/

show_knowledge_base :-
        write('Definitions:'),nl,
        write('============'),nl,
        show_defs,
        nl,write('Rules:'),nl,
           write('======'),nl,
        show_rules,
        nl,write('Dependencies:'),nl,
           write('============='),nl,
        show_deps.

show_defs :-
        findall(Def,recorded(def,Def),DefList),
        forall(member(Definition,DefList),show_def(Definition)).

show_def(def(Defname,Expansion)) :-
        write('define '),
        write(Defname),
        write(' = '),
        write(Expansion),
        nl.

show_rules :-
        findall(Rule,recorded(rule,Rule),RuleList),
        forall(member(TheRule,RuleList),show_rule(TheRule)).

show_rule(rule(Target,Deplist,Actlist,RuleId)) :-
        write('create '),
        write(Target),
        write(' : '),
        write(Deplist),
        write(' -->   (rule id = '),
        write(RuleId),
        write(' )'),nl,
        forall(member(Action,Actlist),show_act(Action)).

show_act(Action) :-
        write('        '),
        write(Action),
        nl.

show_deps :-
        findall(Dep,recorded(dep,Dep),DepList),
        forall(member(Dependence,DepList),show_dep(Dependence)).

show_dep(dep(Target,Deplist)) :-
        write('depend '),
        write(Target),
        write(' : '),
        write(Deplist),
        nl.



/*
** **********************************************************************
** show the dependency graph of a target
*/

show_deptrees(TargetList) :-
        forall(member(Target,TargetList),show_deptree(Target)).

indentskip(2).

show_deptree(Target) :-
	makedeptree(Target,T,RuleNo),
	write(Target),
	printrule(RuleNo),nl,
	indentskip(Initialindent),
	printout(T,Initialindent,Initialindent).

printout([],_,_).
printout([(Target,Subtree,RuleNo)|Trailer],Indent,Offset) :-
	tab(Indent),write(Target),
	printrule(RuleNo),nl,
	indentskip(Offset),
	NextIndent is Indent + Offset,
	printout(Subtree,NextIndent,Offset),
	printout(Trailer,Indent,Offset).

printrule(norule).
printrule(expand) :-
	write(' ...expand structure').
printrule(No) :-
	write(' ...rule id '),
	write(No).

