% Second example in the manual:

% Example illustrating the difference between
% forward and reverse accumulation:

% Sample execution:
% | ?- flist(10, [], List).
% 
% List = [1,2,3,4,5,6,7,8,9,10]
% 
% yes
% | ?- rlist(10, List, []).
% 
% List = [10,9,8,7,6,5,4,3,2,1]
% 
% yes
% | ?-

% Declare the accumulators:
acc_info(fwd, T, In, Out, Out=[T|In]).   % Forward accumulator.
acc_info(rev, T, Out, In, Out=[T|In]).   % Reverse accumulator.

% Declare the predicates using them:
pred_info(flist, 1, [fwd]).
pred_info(rlist, 1, [rev]).

% flist(N, [], List) creates the list [1, 2, ..., N]
flist(0) -->> [].
flist(N) -->> N>0, [N]:fwd, N1 is N-1, flist(N1).

% rlist(N, List, []) creates the list [N, ..., 2, 1]
rlist(0) -->> [].
rlist(N) -->> N>0, [N]:rev, N1 is N-1, rlist(N1).
