%
%  iqueen5.pl			Nai-Wei Lin			November, 1991
%
%  This program plays the inverse n-queens game.
%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
:- mode(iqueen/5,[+,+,+,+,+]).
:- measure(iqueen/5,[int,int,int,int,int]).
:- domain(iqueen/5,[1-5,1-5,1-5,1-5,1-5]).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
iqueen(X1,X2,X3,X4,X5) :-
	safe([X1,X2,X3,X4,X5]).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
:- mode(safe/1,[+]).
:- measure(safe/1,[length]).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
safe([]).
safe([X|L]) :-
	attacks(L,X,1),
	safe(L).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
:- mode(attacks/3,[+,+,+]).
:- measure(attacks/3,[length,int,void]).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
attacks([],_,_).
attacks([Y|L],X,D) :-
	attack(X,Y,D),
	D1 is D+1,
	attacks(L,X,D1).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
:- mode(attack/3,[+,+,+]).
:- measure(attack/3,[int,int,void]).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
attack(X,Y,_) :-
	X =:= Y,!.
attack(X,Y,D) :-
	Y-X =:= D,!.
attack(X,Y,D) :-
	Y-X =:= -D.

