#include <stdio.h>
#include "token.h"
#include "interf.h"

void *malloc();
long strlen();

#define BALLOC(P) { if (blockroot) { \
    (P) = (void *)blockroot; blockroot = blockroot->next; \
  } else { \
    (P) = (void *)malloc(sizeof(struct blocklist)); \
  }}

#define BFREE(P) {((blocklist *)(P))->next = blockroot; \
                  blockroot = (blocklist *)(P);}

/* parse stack */
typedef struct stacktype {
    int tokentype;
    int priority;
    int specifier;
    termtype *term;
    struct stacktype *down;
} stacktype;

/* variable list */
typedef struct varlist {
    termtype *var;
    symboltype *name;
    int refcount;
    struct varlist *next;
} varlist;

/* free memory list */
typedef struct blocklist {
    struct blocklist *next;
    unsigned char body[sizeof(struct stacktype)>sizeof(struct varlist) ? 
              (sizeof(struct stacktype)-4) : (sizeof(struct varlist)-4)];
} blocklist;


stacktype *pstack;
int varcount;
varlist *varroot;
blocklist *blockroot;


/* variable management ; all correctly parsed variable names are put
   in a list to be used later to return the variables names to the
   options of read_term/3 */

void initvars()
/* initialize variable list */
{
  varcount = 0;
  varroot = (varlist *)NULL;
}

varlist *findvar(varname)
register symboltype *varname;
/* find name of variable in variable list; return 0 is not found */
{
  register varlist *vlp = varroot;
  while (vlp) {
    if (vlp->name == varname) 
      return vlp;
    else 
      vlp = vlp->next;
  }
  return 0;
}

termtype *createvar(H,s)
register heapcell *H;
register unsigned char *s;
/* create variable in variable list if it does not already exist.
   If it already exists, increment reference counter */
{
  register varlist *vlp;
  register symboltype *varname = getsymbol(s,0);

  if ((s[0] == '_' && !s[1]) || !(vlp = findvar(varname))) {
    BALLOC(vlp);
    vlp->name = varname;
    vlp->var = makevar(H);
    vlp->refcount = 0;
    vlp->next = varroot;
    varroot = vlp;
  } 
  vlp->refcount++;
  return vlp->var;
}

termtype *makevariablesoption(H)
register heapcell *H;
/* generate list of variable to be used by the option variables(T) 
   T = [v1,v2,...]  */
{
  register varlist *vlp = varroot;
  register termtype *t;

  t = makeatom(H,"[]");
  while (vlp) {
    termtype *t2 = maketerm(H, ".",2);
    __ARG(t2, 1) = vlp->var;
    __ARG(t2, 2) = t;
    t = t2;
    vlp = vlp->next;
  }
  return t;
}

termtype *makevariable_namesoption(H)
register heapcell *H;
/* generate list of variable to be used by the option variable_names(T) 
   T = [v1='name1',v2='name2',...]  */
{
  register varlist *vlp = varroot;
  register termtype *t;
  register symboltype *anonymous = getsymbol("_",0);

  t = makeatom(H,"[]");
  while (vlp) {
    if (vlp->name != anonymous) {
      termtype *t2 = maketerm(H, ".", 2);
      __ARG(t2, 2) = t;
      t = t2;
      t2 = maketerm(H, "=", 2);
      __ARG(t2, 1) = vlp->var;
      __ARG(t2, 2) = (termtype *)vlp->name;
      __ARG(t, 1) = t2;
    }
    vlp = vlp->next;
  }
  return t;
}

termtype *makesingletonsoption(H)
register heapcell *H;
/* generate list of variable to be used by the option singletons(T) 
   T = [v1='name1',v2='name2',...]  */
{
  register varlist *vlp = varroot;
  register termtype *t;
  register symboltype *anonymous = getsymbol("_",0);

  t = makeatom(H,"[]");
  while (vlp) {
    if (vlp->refcount == 1 && vlp->name != anonymous) {
      register termtype *t2 = maketerm(H, ".", 2);
      __ARG(t2, 2) = t;
      t = t2;
      t2 = maketerm(H, "=", 2);
      __ARG(t2, 1) = vlp->var;
      __ARG(t2, 2) = (termtype *)vlp->name;
      __ARG(t, 1) = t2;
    }
    vlp = vlp->next;
  }
  return t;
}

void releasevars()
{
  register varlist *vlp = varroot;
  while (vlp) {
    register varlist *vlq = vlp->next;
    BFREE(vlp);
    vlp = vlq;
  }
}

void reduce(H,newpri)
register heapcell *H;
register int newpri;
/*
 *  lterm = term, op, term ;
 *  f(a,b)    a   f    b
 *    n      n-a  n   n-1
 *               xfx
 *
 *  lterm = lterm, op, term ;
 *  f(a,b)    a    f     b
 *     n      n    n    n-1
 *                yfx
 *
 *  term = term, op, term ;
 *  f(a,b)   a    f   b
 *    n     n-1   n   n
 *               xfy
 *
 *  lterm = lterm, op ;
 *  f(a)      a     f
 *   n        n     n
 *                  yf
 *
 *  lterm = term, op ;
 *  f(a)      a    f
 *   n       n-1   n
 *                 xf
 *
 *  term = op, term ;
 *  f(a)    f   a
 *  n       n   n
 *          fy
 *
 *  lterm = op, term ;
 *  f(a)    f    a
 *  n       n   n-1
 *          fx
 */ 
{
  register stacktype *top1, *top2, *top3;
  
reduce:
  if (top1 = pstack) {
    if (top2 = top1->down) {
      if (top3 = top2->down) {
        if (isxfx(top2->specifier)) {
          if (top2->priority <= newpri &&
              isterm(top3->specifier) && top3->priority < top2->priority &&
              isterm(top1->specifier) && top1->priority < top2->priority) {
             top2->term = maketerm(H,__ATOMNAME(top2->term), 2);
             __ARG(top2->term,1) = top3->term;
             __ARG(top2->term,2) = top1->term;
             top2->down = top3->down;
             BFREE(top3);
             BFREE(top1);
             pstack = top2;
             pstack->specifier = LTERM;
             pstack->tokentype = TERMTYPE;
             goto reduce;
          }
        } else if (isyfx(top2->specifier)) {
          if (top2->priority <= newpri &&
              (isterm(top3->specifier) && top3->priority < top2->priority ||
               islterm(top3->specifier) && top3->priority == top2->priority) &&
              isterm(top1->specifier) && top1->priority < top2->priority) {
             top2->term = maketerm(H,__ATOMNAME(top2->term), 2);
             __ARG(top2->term,1) = top3->term;
             __ARG(top2->term,2) = top1->term;
             top2->down = top3->down;
             BFREE(top3);
             BFREE(top1);
             pstack = top2;
             pstack->specifier = LTERM;
             pstack->tokentype = TERMTYPE;
             goto reduce;
          }
        } else if (isxfy(top2->specifier)) {
          if (top2->priority < newpri &&
              isterm(top3->specifier) && top3->priority < top2->priority &&
              isterm(top1->specifier) && top1->priority <= top2->priority) {
             top2->term = maketerm(H,__ATOMNAME(top2->term), 2);
             __ARG(top2->term,1) = top3->term;
             __ARG(top2->term,2) = top1->term;
             top2->down = top3->down;
             BFREE(top3);
             BFREE(top1);
             pstack = top2;
             pstack->specifier = TERM;
             pstack->tokentype = TERMTYPE;
             goto reduce;
          }
        }
      } 
      if (isyf(top1->specifier)) {
        if (isterm(top2->specifier) && top2->priority < top1->priority ||
            islterm(top2->specifier) && top2->priority == top1->priority) {
           top1->term = maketerm(H,__ATOMNAME(top1->term), 1);
           __ARG(top1->term,1) = top2->term;
           top1->down = top2->down;
           BFREE(top2);
           pstack->specifier = LTERM;
           pstack->tokentype = TERMTYPE;
           goto reduce;
        }
      } else if (isxf(top1->specifier)) {
        if (isterm(top2->specifier) && top2->priority < top1->priority) {
           top1->term = maketerm(H,__ATOMNAME(top1->term), 1);
           __ARG(top1->term,1) = top2->term;
           top1->down = top2->down;
           BFREE(top2);
           pstack->specifier = LTERM;
           pstack->tokentype = TERMTYPE;
           goto reduce;
        }
      } else if (isfy(top2->specifier)) {
        if (top2->priority < newpri &&
            isterm(top1->specifier) && top1->priority <= top2->priority) {
           top2->term = maketerm(H,__ATOMNAME(top2->term), 1);
           __ARG(top2->term,1) = top1->term;
           BFREE(top1);
           pstack = top2;
           pstack->specifier = TERM;
           pstack->tokentype = TERMTYPE;
           goto reduce;
        }
      } else if (isfx(top2->specifier)) {
        if (top2->priority <= newpri &&
            isterm(top1->specifier) && top1->priority < top2->priority) {
           top2->term = maketerm(H,__ATOMNAME(top2->term), 1);
           __ARG(top2->term,1) = top1->term;
           BFREE(top1);
           pstack = top2;
           pstack->specifier = LTERM;
           pstack->tokentype = TERMTYPE;
           goto reduce;
        }
      }
    } 
  } 
}

void shift(tok, tterm, pri, spec)
register int tok;
register termtype *tterm;
register int pri;
{
  register stacktype *sp;

  BALLOC(sp);
  sp->tokentype = tok;
  sp->term = tterm;
  sp->priority = pri;
  sp->specifier = spec;
  sp->down = pstack;
  pstack = sp;
}

void releasestack()
/* return memory used for the variable list */
{
  register stacktype *vlp = pstack;
  while (vlp) {
    register stacktype *vlq = vlp->down;
    BFREE(vlp);
    vlp = vlq;
  }
}


void shift_char_code_list(H,s)
register heapcell *H;
register unsigned char *s;
/*
 * term = char code list 
 *
 * this is list containing the ascii values of the characters belonging
 * to the string.
 */
{
  register termtype *listterm, *secondarg;
  register unsigned char *p = s+strlen(s);

  secondarg = makeatom(H,"[]");
  while (p > s) {
    listterm = maketerm(H, ".", 2);
    __ARG(listterm,1) = makeinteger(H,*--p);
    __ARG(listterm,2) = secondarg;
    secondarg = listterm;
  }
  shift(TERMTYPE,secondarg,0,TERM);
}

void shifttoken(H,tok)
register heapcell *H;
register int tok;
/*
 *  term = integer ;        (* 6.3.1.1 *)
 *  term = float number ;   (* 6.3.1.1 *)
 *  term = - integer ;      (* 6.3.1.2 *)
 *  term = - float number ; (* 6.3.1.2 *)
 *  term = atom ; (not an operator)  (* 6.3.1.2 *)
 *  term = atom ; (an operator )     (* 6.3.1.2 *)
 *    atom = name ;
 *    atom = empty list ;
 *       empty list = open list, close list ;
 *    atom = curly brackets ;
 *       curly brackets = open curly, close curly ;
 *  term = variable
 */
{
  switch (tok) {
    case NAME_TOKEN: {
      int prepri, inpri, postpri, spec;
      register int inpostpri, sumpri;

      if (operator(tokenstring, &prepri, &inpri, &postpri, &spec)) { /* an operator */
        if (prepri > 0 && (inpostpri = inpri + postpri) > 0) {
          /* infix and postfix do never occur together 6.3.4.2 */
          if (open_char(LOOKAHEAD_CHAR)) {
            /* prefix can never be followed directly by an open char */
            reduce(H,inpostpri);
            shift(NAME_TOKEN,makeatom(H,tokenstring), inpostpri, spec & (XFX|XFY|YFX|YF|XF));
          } else {
            if (pstack) {
              reduce(H,inpostpri); /* must be done before testing the stack */
              if (isterm(pstack->specifier)) {
                /* can be either infix of postfix */
                shift(NAME_TOKEN, makeatom(H,tokenstring), inpostpri, 
                     spec & (XFX|XFY|YFX|XF|YF));
              } else {
                /* in the beginning of an expression -> must be prefix */
                shift(NAME_TOKEN,makeatom(H,tokenstring),prepri,isprefix(spec));
              }
            } else /* empty stack */
              shift(NAME_TOKEN, makeatom(H,tokenstring),prepri,spec&(FX|FY));
          } 
        } else { /* there is only one specifier with priority sumpri */
          reduce(H, sumpri = prepri+inpri+postpri);
          shift(NAME_TOKEN,makeatom(H,tokenstring), sumpri, spec);
        }
      } else /* not an operator */
        shift(NAME_TOKEN,makeatom(H,tokenstring),0,TERM);
      break;
    }
    case VARIABLE_TOKEN:
      shift(VARIABLE_TOKEN,createvar(H,tokenstring),0,TERM);
      break;
    case INTEGER_TOKEN:
      if (pstack && pstack->term &&
          ISATOM(pstack->term) && isprefix(pstack->specifier)) {
        /*
         *  if a is a numeric constant, f is not -
         */
        register unsigned char *s = __ATOMNAME(pstack->term);
        if (s[0] == '-' && !s[1]) {
          register stacktype *sp = pstack;
          pstack = pstack->down;
          BFREE(sp);
          shift(INTEGER_TOKEN,makeinteger(H,-integertoken),0,TERM);
          break;
        } 
      } 
      shift(INTEGER_TOKEN,makeinteger(H,integertoken),0,TERM);
      break;
    case FLOAT_NUMBER_TOKEN:
      if (pstack && pstack->term &&
          ISATOM(pstack->term) && isprefix(pstack->specifier)) {
        /*
         *  if a is a numeric constant, f is not -
         */
        register unsigned char *s = __ATOMNAME(pstack->term);
        if (s[0] == '-' && !s[1]) {
          register stacktype *sp = pstack;
          pstack = pstack->down;
          BFREE(sp);
          shift(FLOAT_NUMBER_TOKEN,makefloat(H,-floattoken),0,TERM);
          break;
        } 
      } 
      shift(FLOAT_NUMBER_TOKEN,makefloat(H,floattoken),0,TERM);
      break;
    case CHAR_CODE_LIST_TOKEN:
      shift_char_code_list(H, tokenstring);
      break;
    case OPEN_TOKEN:
      shift(OPEN_TOKEN, (termtype *)NULL,1300,DELIMITER);
      break;
    case OPEN_CT_TOKEN:
      shift(OPEN_CT_TOKEN, (termtype *)NULL,1300,DELIMITER);
      break;
    case CLOSE_TOKEN:
      if (!reduceterm(H)) 
        if (!reducebrackets(H)) 
          seterr(ERR_NONDET);
      break;
    case OPEN_LIST_TOKEN:
      shift(OPEN_LIST_TOKEN, (termtype *)NULL,1300,DELIMITER);
      break;
    case CLOSE_LIST_TOKEN:
      if (!reducelist(H)) puts("Error in reducelist");
      break;
    case OPEN_CURLY_TOKEN:
      shift(OPEN_CURLY_TOKEN, (termtype *)NULL, 1300, DELIMITER);
      break;
    case CLOSE_CURLY_TOKEN:
      if (!reducecurly(H)) puts("Error in reducecurly");
      break;
    case HEAD_TAIL_SEPARATOR_TOKEN:
      reduce(H,1000);
      shift(HEAD_TAIL_SEPARATOR_TOKEN, (termtype *)NULL, 1000, DELIMITER);
      break;
    case COMMA_TOKEN:
      reduce(H,1000);
      shift(COMMA_TOKEN, makeatom(H,","), 1000, XFY);
      break;
    case EOFFILE:
      reduce(H,1400);
      shift(EOFFILE, makeatom(H,"end_of_file"), 1400, DELIMITER);
      break;
    case END_TOKEN:
      break;
  }
}

termtype *readterm(H)
register heapcell *H;
/*
 * this procedure reads tokens and puts them on the stack
 * until it read either eof or end token. If one term is
 * left on the stack, the clause is correctly parsed.
 */
{
   register int tok;
   pstack = NULL;
   initvars();
   parseerror = ERR_NOERROR;
   do {
     shifttoken(H,tok=token());
   } while (tok != EOFFILE && tok != END_TOKEN && parseerror == ERR_NOERROR);
   reduce(H,1400);
   if (tok == EOFFILE) {
     if (pstack->down) {
       seterr(ERR_UNEXPECTED_EOF);
       showerror();
       showstack();
       releasestack();
       return (termtype *)NULL;
     }
   }
   if (parseerror == ERR_NOERROR && (tok==EOFFILE || tok==END_TOKEN) && 
       pstack && !pstack->down) {
     register termtype *tp = pstack->term;
     releasestack();
     return tp;
   } else {
     while (tok != EOFFILE && tok != END_TOKEN) 
       tok=token(); 
     if (parseerror == ERR_NOERROR) seterr(ERR_INCOMPLETE_REDUCTION);
     showerror();
     showstack();
     releasestack();
     return (termtype *)NULL;
   }
}

int reducelist(H)
register heapcell *H;
/*
 * term = open list, items, close list ; (* 6.3.5 *)
 *   items = exp, comma, items ;
 *   items = exp, ht sep, exp ;
 *   items = exp ;
 *
 * exp = atom  (operator but no comma);
 * exp = term  (priority < 1000)
 */
{
  if (!pstack) return 0; /* empty stack */
  if (pstack->tokentype == OPEN_LIST_TOKEN) {
    /* empty list */
    pstack->specifier = TERM;
    pstack->tokentype = NAME_TOKEN; /* behaves like atom 6.3.1.3 */
    pstack->term = makeatom(H,"[]");
    pstack->priority = 0;
    return 1;
  } else {
    register stacktype *sp;
    register termtype *tterm;
    register int arty = 0, inlist = 1;

    reduce(H,1000);
    sp = pstack;
    do {
      if (isterm(sp->specifier) || 
          isop(sp->specifier) && sp->tokentype != COMMA_TOKEN) {
        arty++;
        sp = sp->down;
      } else 
        return 0;
      if (!sp) return 0;
      if (sp->tokentype == HEAD_TAIL_SEPARATOR_TOKEN) {
        if (arty == 1) {
          sp = sp->down;
          if (!sp) return 0;
        } else 
          return 0;
      } else if (sp->tokentype == COMMA_TOKEN) {
        sp = sp->down;
        if (!sp) return 0;
      } else if (sp->tokentype == OPEN_LIST_TOKEN) 
        inlist = 0;
      else return 0;
    } while (inlist);

    if (pstack->down->tokentype != HEAD_TAIL_SEPARATOR_TOKEN) {
      shift(HEAD_TAIL_SEPARATOR_TOKEN, (termtype *)NULL, 1000, DELIMITER);
      shift(NAME_TOKEN, makeatom(H,"[]"), 0, TERM);
      arty++;
    }
    tterm = pstack->term;
    sp = pstack;
    pstack = pstack->down;
    BFREE(sp);
    while (--arty) {
      register termtype *lterm = maketerm(H, ".", 2);
      sp = pstack->down;
      BFREE(pstack); 
      __ARG(lterm,1) = sp->term;
      __ARG(lterm,2) = tterm;
      tterm = lterm;
      pstack = sp->down;
      BFREE(sp); 
    }
    pstack->term = tterm;
    pstack->tokentype = TERMTYPE;
    pstack->specifier = TERM;
    pstack->priority = 0;
    return 1;
  } 
}

int reduceterm(H)
register heapcell *H;
/*
 * term = atom, open ct, arg list, close ;
 * 
 * arg list = exp ;
 * arg list = exp , comma, arg list ;
 */
{
  register stacktype *sp;
  register termtype *tterm;
  register int arty = 0, interm = 1;

  if (!pstack) return 0;
  reduce(H,1000);
  sp = pstack;
  do {
    if (isterm(sp->specifier) || 
        isop(sp->specifier) && sp->tokentype != COMMA_TOKEN) {
      arty++;
      sp = sp->down;
    } else 
      return 0;
    if (!sp) return 0;
    if (sp->tokentype == COMMA_TOKEN) {
      sp = sp->down;
      if (!sp) return 0;
    } else if (sp->tokentype == OPEN_CT_TOKEN) {
      interm = 0;
    } else
      return 0; 
  } while (interm);
  sp = sp->down;
  if (!sp) return 0;
  if (sp->tokentype != NAME_TOKEN) return 0; /* term must contain atom */
  /* postfix operator can never occur individually, it immediately reduces.
     if it occurs, it must be a function name */
  if (isinfix(sp->specifier) && sp->down) {
    /* if (isterm(sp->down->specifier)) return 0; term infix_op (exp) */
    if (!(separator_token(sp->down->tokentype) || isop(sp->down->specifier))) {
      return 0;
    }
  }
  tterm = maketerm(H,__ATOMNAME(sp->term),arty);
  while (arty) {
    __ARG(tterm,arty--) = pstack->term;
    sp = pstack->down;
    BFREE(pstack);
    pstack = sp->down;
    BFREE(sp); 
  }
  pstack->priority = 0;
  pstack->tokentype = TERMTYPE;
  pstack->specifier = TERM;
  pstack->term = tterm;
  return 1;
}

termtype *separator2atom(H,tok)
register heapcell *H;
register int tok;
{
  switch (tok) {
    case OPEN_LIST_TOKEN: return makeatom(H,"[");
    case CLOSE_LIST_TOKEN: return makeatom(H,"]");
    case HEAD_TAIL_SEPARATOR_TOKEN: return makeatom(H,"|");
    case OPEN_CT_TOKEN:
    case OPEN_TOKEN: return makeatom(H,"(");
    case CLOSE_TOKEN: return makeatom(H,")");
    case OPEN_CURLY_TOKEN: return makeatom(H,"{");
    case CLOSE_CURLY_TOKEN: return makeatom(H,"}");
    case END_TOKEN: return makeatom(H,".");
    case COMMA_TOKEN: return makeatom(H,",");
  }
  return (termtype *)NULL;
}

int reducebrackets(H)
register heapcell *H;
/*
 *   6.3.4.1
 *   term = open, term, close ;
 *   term = copen ct, term, close ;
 */
{
  register stacktype *sp;

  if (!pstack) return 0;
  reduce(H,1300);
  /* anything can between brackets */
  sp = pstack->down;
  if (!sp) return 0;
  if (sp->tokentype == OPEN_TOKEN || sp->tokentype == OPEN_CT_TOKEN) {
    pstack->down = sp->down;
    BFREE(sp);
    if (!pstack->term) pstack->term = separator2atom(H,pstack->tokentype);
    pstack->specifier = TERM;
    pstack->tokentype = TERMTYPE;
    pstack->priority = 0;
    return 1;
  } else return 0;
}

int reducecurly(H)
register heapcell *H;
/*
 *   term = open curly, term, close curly ;
 */
{
  if (!pstack) return 0;
  if (pstack->tokentype == OPEN_CURLY_TOKEN) {
    pstack->specifier = TERM;
    pstack->tokentype = NAME_TOKEN; /* behaves like atom 6.3.1.3 */
    pstack->priority = 0;
    pstack->term = makeatom(H,"{}");
    return 1;
  } else {
    register stacktype *sp;

    reduce(H,1300);
    /* anything can between curly brackets */
    sp = pstack->down;
    if (!sp) return 0;
    if (sp->tokentype == OPEN_CURLY_TOKEN) {
      register termtype *tterm = pstack->term;

      if (!tterm) tterm = separator2atom(H,pstack->tokentype);
      pstack->down = sp->down;
      BFREE(sp);
      pstack->tokentype = TERMTYPE;
      pstack->priority = 0;
      pstack->specifier = TERM;
      pstack->term = maketerm(H, "{}",1);
      __ARG(pstack->term,1) = tterm;
      return 1;
    } else return 0;
  }
}

void showspecifier(spec)
register int spec;
{
  if (spec &  FX) printf("   fx");
  if (spec &  FY) printf("   fy");
  if (spec &  XF) printf("   xf");
  if (spec &  YF) printf("   yf");
  if (spec & XFX) printf("  xfx");
  if (spec & YFX) printf("  yfx");
  if (spec & XFY) printf("  xfy");
  if (islterm(spec)) printf("lterm"); else
  if (isterm(spec)) printf(" term");
  if (spec & DELIMITER) printf("  del");
}

void showstackelement(sp)
register stacktype *sp;
{
  printf("| %4d: ", sp->priority);
  printf(" %04x ", sp->specifier);
  showspecifier(sp->specifier); printf("   ");
  if (sp->term) {
    writeterm(stdout,sp->term,1+4); puts("");
  } else {
   switch (sp->tokentype) {
     case COMMA_TOKEN: printf(",\n"); break;
     case OPEN_LIST_TOKEN: printf("[\n"); break;
     case CLOSE_LIST_TOKEN: printf("]\n"); break;
     case HEAD_TAIL_SEPARATOR_TOKEN: printf("|\n"); break;
     case OPEN_CURLY_TOKEN: printf("{\n"); break;
     case CLOSE_CURLY_TOKEN: printf("}\n"); break;
     case OPEN_CT_TOKEN: printf("(\n"); break;
     case OPEN_TOKEN: printf("(\n"); break;
     case CLOSE_TOKEN: printf(")\n"); break;
     case END_TOKEN: printf(".\n"); break;
   }
  }
}

int showstack()
{
  register stacktype *sp = pstack;
  puts("");
  printf("=====================\n");
  while (sp) {
    showstackelement(sp);
    sp = sp->down;
  }
  printf("=====================\n");
}

