/*
Note: Carl is an A.D.A. PROLOG user who has contributed this program for
the enjoyment of others.

          Residential Air Conditioning Diagnosis System
                         by Carl Bredlau
                        909 Rahway Avenue
                   Westfield, New Jersey 07090
*/


nothing(X)  :-
     print('Is there a/c (y/n)? '),
     ratom(n), !, X = running,
     asserta( (nothing(running) :- !) ).

nothing(X)   :-
      print('I can not diagnose this.  Will quit'), nl,
      asserta( (nothing(running) :- (!, fail)) ), fail.

check(thermostat_system_switch) :-
      nothing(running).


check(thermostat_fan_switch) :-
      check(thermostat_system_switch),
      switch(thermostat_system_switch,'in the cool position',yes).
      thermostat(calling).

check(for_air)   :-
     check(thermostat_fan_switch),
     switch(thermostat_fan_switch,on,yes),
     fan(furnace,on).

check(furnace_24_volts) :-
       check(thermostat_fan_switch),
       switch(thermostat_fan_switch,on,yes),
       fan(furnace,off).

check(furnace_110_volts) :-
    check(furnace_24_volts),
    voltage(furnace,24,no).

check(service_switch) :-
     check(furnace_110_volts),
     voltage(furnace,110,no).

check(circuit_breaker) :-
      check(service_switch),
      voltage('service switch',line,110,no).

check(coil_of_fan_relay) :-
      check(furnace_24_volts),
      voltage(furnace,24,yes).

check(fan,closed_coil_relays) :-
      check(coil_of_fan_relay),
      voltage( fan_relay_coil,24,yes).

check(Which,continuity_at_relay_coil) :-
      check(Which,closed_coil_relays),
      coil_contacts(Which,open).

check(Which,voltage_at_motor) :-
      check(Which,closed_coil_relays),
      coil_contacts(Which,closed).

check(Which,over_amp) :-
     check(Which,voltage_at_motor),
     motor_voltage(Which,line,yes),
     motor(Which,running,no),
     motor(Which,hot,yes),
     print( Which, 'motor has internal overload -- thermal relay kicked off'), nl,
     print( 'Cool and check for overamperage'), nl.

check(Which,motor_continuity) :-
     (check(Which,voltage_at_motor);
      (Which = compressor, check(continuity_at_compressor) )),
     motor_voltage(Which,line,yes),
     motor(Which,running,no),
     motor(Which,hot,no).

check(condensing_unit) :-
    check(for_air),
    air(yes),
    switch(system_cooling_switch,on,yes).

check(condenser_24_volts) :-
    check(condensing_unit),
    fan(condenser,off),
    voltage(condenser,220,yes).

check(condensing_unit_breaker) :-
     check(condensing_unit),
     fan(condenser,off),
     voltage(condenser,220,no),
     switch(disconnect,on,yes).

check(compressor_contactor_coil) :-
     check(condenser_24_volts),
     voltage(condenser,24,yes).

check(condenser,closed_coil_relays) :-
     check(compressor_contactor_coil),
     voltage(compressor_contactor_coil,24,yes),
     safeties(yes).

check(compressor_voltage) :-
     check(condensing_unit),
     fan(condenser,on),
     voltage(condenser,220,yes),
     voltage(condenser,24,yes),
     coil_contacts(compressor,closed),
     motor(compressor,running,no).

check(compressor_internals_overload) :-
     check(compressor_voltage),
     motor_voltage(compressor,line,yes).


check(continuity_at_compressor) :-
     check(compressor_internals_overload),
     coil_contacts(compressor_internals,closed).

check(gauges) :-
     check(condensing_unit),
     fan(condenser,on),
     voltage(condenser,220,yes),
     voltage(condenser,24,yes),
     coil_contacts(compressor,closed),
     motor(compressor,running,yes),
     gauge(X).




diagnosed(burned_out_transformer) :-
        check(furnace_110_volts),
        voltage(furnace,110,yes),
        print('Transformer burned out. Replace transformer'),nl.


diagnosed(repair_line_voltage_wire) :-
       check(service_switch),
       voltage('service switch',lOad,110,yes),
       print( 'Repair line voltage wire'), nl.


diagnosed(replace_service_switch) :-
        check(service_switch),
        voltage('service switch',lOad,110,no),
        voltage('service switch',line,110,yes),
        print( 'Replace service switch if switch is on'), nl,
        print( 'Otherwise, turn on switch'), nl.

diagnosed(replace_circuit_breaker) :-
        check(circuit_breaker),
        voltage('circuit breaker',lOad,110,no),
        voltage('circuit breaker',line,110,yes),
        breaker(circuit,on),
        print( 'Replace circuit breaker' ), nl.

diagnosed(repair_circuit_wire) :-
        check(circuit_breaker),
        voltage( 'service switch',line,110,no),
        voltage( 'circuit breaker',lOad,110,yes),
        print( 'Repair wire between circuit breaker and switch'),
        nl.

diagnosed(breaker_switch) :-
         check(circuit_breaker),
         breaker(circuit,off),
         print( 'Please turn on the breaker'), nl.

diagnosed(check_for_grounds) :-
        check(circuit_breaker),
        breaker(circuit,tripped),
        print('Check for grounded load'), nl,
        print('i.e., motor, relay, transformer, burnt ground wire'),nl.

diagnosed(replace_subbase) :-
       check(coil_of_fan_relay),
       voltage( fan_relay_coil,24,no),
       print('Jump R to G at thermostat'),nl,
       fan_turns(furnace,yes),
       print('Replace subbase of thermostat'), nl.


diagnosed(replace_therm_wire) :-
       check(coil_of_fan_relay),
       voltage( fan_relay_coil,24,no),
       fan_turns(furnace,no),
       print('Look for open wire between thermostat and subbase'), nl.

diagnosed([Which,replace_relay]) :-
      check(Which,continuity_at_relay_coil),
      continuity(Which,no),
      print( 'Replace ',Which, ' relay'), nl.

diagnosed([Which,replace_relay]) :-
      check(Which,continuity_at_relay_coil),
      continuity(Which,yes),
      print( 'Check for mechanical failure and replace ',Which, ' relay'), nl.

diagnosed([Which,repair_wire]) :-
     check(Which,voltage_at_motor),
     motor_voltage(Which,line,no),
     print( 'Repair wire between relay and ',Which,'?'), nl.

diagnosed([Which,replace_motor_or_adjust_pulley]) :-
     check(Which,over_amp),
     motor(Which,over_amperage,yes),
     print( 'With direct drive replace motor.'),nl,
     print( 'With pulley drive adjust pulley to proper amperage'),nl.

diagnosed([Which,replace_motor]) :-
     check(Which,motor_continuity),
     continuity(Which,no),
     print('Replace ',Which,' motor'),nl.

diagnosed([Which,look_at_capacitor]) :-
     check(Which,motor_continuity),
     continuity(Which,yes),
     motor(Which,hum,yes),
     print('Look at the ',Which,' motor capacitor'),nl.

diagnosed(dirty_stuff) :-
     check(for_air),
     air(no),
     maintenance(List),
     perform_maintenance(List).

diagnosed(replace_thermostat) :-
    check(condenser_24_volts),
    voltage(condenser,24,no),
    print('Jump out R to Y at thermostat'),
    fan_turns(condenser,yes),
    print('Replace thermostat'), nl.

diagnosed(repair_condenser_wire) :-
    check(condenser_24_volts),
    voltage(condenser,24,no),
    fan_turns(condenser,no),
    print('Repair wire between thermostat and condenser'),nl,
    print('Check 24 volt source'),nl.



diagnosed(replace_condensing_unit_breaker) :-
        check(condensing_unit_breaker),
        voltage('condensing unit breaker',lOad,110,no),
        voltage('condensing unit breaker',line,110,yes),
        breaker(condensing_unit,on),
        print( 'Replace condensing unit breaker' ), nl.

diagnosed(repair_condensing_unit_wire) :-
        check(condensing_unit_breaker),
        voltage( 'condensing unit breaker',lOad,110,yes),
        print( 'Repair wire between condensing unit breaker and switch'),
        nl.

diagnosed(condensing_unit_switch) :-
         check(condensing_unit_breaker),
         breaker(condensing_unit,off),
         print( 'Please turn on the condensing unit breaker'), nl.


diagnosed(check_for_condensing_unit_grounds) :-
        check(condensing_unit_breaker),
        breaker(condensing_unit,tripped),
        print('Check for grounded load'), nl,
        print('i.e., motor, relay, transformer, burnt ground wire'),nl.


diagnosed(safeties_open) :-
     check(compressor_contactor_coil),
     voltage(compressor_contactor_coil,24,no),
     safeties(no),
     print('Check safeties'),nl.

diagnosed(compressor_contactor) :-
     check(compressor_voltage),
     motor_voltage(compressor,line,no),
     print('Check for contactor problem or wire open'), nl.

diagnosed(refrigerant_charge) :-
     check(compressor_internals_overload),
     coil_contacts(compressor_internals,open),
     motor(compressor,hot,yes),
     print( 'Cool and check refrigerant charge'), nl.

diagnosed(replace_compressor) :-
     check(compressor_internals_overload),
     coil_contacts(compressor_internals,open),
     motor(compressor,hot,no),
     print( 'Replace compressor'), nl.

diagnosed(defective_condenser_fan) :-
     check(condensing_unit),
     fan(condenser,off),
     voltage(condenser,220,yes),
     voltage(condenser,24,yes),
     coil_contacts(compressor,closed),
     motor(compressor,running,yes),
     print('Defective condenser fan'),nl.

diagnosed(leak) :-
    check(gauges),
    pressure(high,High),
    pressure(low,Low),
    Low = 0, High = 0,
    print('Find leak, repair, and recharge'),nl.

diagnosed(replace_compressor) :-
    check(gauges),
    pressure(high,High),
    pressure(low,Low),
    60 =< Low, Low =< 90,
    60 =< High, High =< 90,
    Diff is High - Low,
    Diff =< 10,
    motor(compressor,drawing_amperage,yes),
    print('Pressures are almost equal.  Replace compressed'),nl.

diagnosed(low_pressure) :-
    check(gauges),
    pressure(low,Low),
    Low =< 40,
    print('(1) Check for lack of maintenance on inside'), nl,
    maintenance(X),
    print_maintenance_start(X),
    print('(2) short of coolant'), nl,
    print('(3) restriction in refrigerant line'), nl,
    print('(4) expansion valve problem'), nl.

diagnosed(high_pressure) :-
    check(gauges),
    pressure(high,High),
    High >= 300,
    print('(1) Lack of maintenance on outside : compressor plugged'),nl,
    print('(2) Overcharged unit'),nl.


diagnosed(compressor_valve) :-
    check(gauges),
    pressure(low,Low),
    pressure(high,High),
    65 =< Low, Low =< 70,
    220 =< High, High =< 280,
    maintenance(X),
    print_maintenance_start(X),
    motor(compressor,low_amperage,yes),
    print('Possible broken compressor valve. Replace'),nl.


diagnosed(replace_compressor) :-
    check(gauges),
    pressure(low,Low),
    pressure(high,High),
    65 =< Low, Low =< 70,
    220 =< High, High =< 280,
    maintenance(X),
    print_maintenance_start(X),
    motor(compressor,high_amperage,yes),
    print('Compressor worn out. Replace'), nl.




possibilities( [
     burned_out_transformer,
     replace_service_switch,
     repair_line_voltage_wire,
     replace_circuit_breaker,
     repair_circuit_wire,
     breaker_switch,
     check_for_grounds,
     replace_subbase,
     repair_therm_wire,
     [fan,replace_relay],
     [fan,repair_wire],
     [fan,replace_motor_or_adjust_pulley],
     [fan,replace_motor],
     [fan,look_at_capacitor],
     dirty_stuff,
     replace_thermostat,
     repair_condenser_wire,
     replace_condensing_unit_breaker,
     repair_condensing_unit_wire,
     condensing_unit_switch,
     check_for_condensing_unit_grounds,
     safeties_open,
     [condenser,replace_relay],
     [condenser,repair_wire],
     [condenser,replace_motor_or_adjust_pulley],
     [condenser,replace_motor],
     [condenser,look_at_capacitor],
     compressor_contactor,
     refrigerant_charge,
     replace_compressor,
     [compressor,replace_motor],
     [compressor,look_at_capacitor],
     defective_condenser_fan,
     leak,
     low_pressure,
     high_pressure,
     compressor_valve
  ]).

begin :-
    print('Expert a/c system'), nl,
    possibilities(X),
    begin1(X).

begin1([]) :-
    print('Seems I could not find the problem'), nl,
    print('Better luck next time'), !.

begin1([H|T]) :-
       diagnosed(H), ! ,
       print('We diagnosed ',H), nl,
       print('I hope that this is it'), nl.

begin1([H|T]) :-
       !, begin1(T).





switch(Switch,How,YesNo) :-
        print('Is the ',Switch,' ',How,' (y/n)? '),
        ratom(y),
        !,
        asserta( (switch(Switch,How,Y) :- (!, Y = yes)) ),
        YesNo = yes.

switch(Switch,How,YesNo) :-
        print('Please turn on the ',Switch, ' now'), nl,
        asserta( (switch(Switch,How,Y) :- (!, Y = yes)) ),
        YesNo = yes.

thermostat(X) :-
        print('Is the thermostat calling (y/n)? '),
        ratom(y),
        !,
        asserta( (thermostat(Y) :- (!, Y = calling)) ),
        X = calling.

thermostat(X) :-
        print('Please make call for cooling'),
        asserta( (thermostat(Y) :- (!, Y = calling)) ),
        X = calling.

fan(Which,OnOff) :-
        print('Do you hear the ',Which,' fan (y/n)? '),
        ratom(y),
        !,
        asserta( (fan(Which,Y) :- (!, Y = on)) ),
        OnOff = on.

fan(Which,OnOff) :-
        asserta( (fan(Which,Y) :- (!, Y = off)) ),
        OnOff= off.

voltage(X,Y,Volts,Z)   :-
       print( 'Is there ', Volts, ' volts on the ',
       Y, ' side of the ',
       X, ' (y/n)?  '),
       ratom(y),
       !,
       asserta( (voltage(X,Y,Volts,W) :- (!, W = yes)) ),
       Z = yes.

voltage(X,Y,Volts,Z)   :-
       asserta( (voltage(X,Y,Volts,W) :- (!, W = no)) ),
       Z = no.

voltage(X,Volts,Z)   :-
       print( 'Is there ', Volts, ' volts at the ',
       X, '? (y/n) '),
       ratom(y),
       !,
       asserta( (voltage(X,Volts,W) :- (!, W = yes)) ),
       Z = yes.

voltage(X,Volts,Z)   :-
       asserta( (voltage(X,Volts,W) :- (!, W = no)) ),
       Z = no.

motor_voltage(X,Volts,Z)   :-
       print( 'Is there ', Volts, ' volts at the ',
       X, ' motor? (y/n) '),
       ratom(y),
       !,
       asserta( (motor_voltage(X,Volts,W) :- (!, W = yes)) ),
       Z = yes.

motor_voltage(X,Volts,Z)   :-
       asserta( (motor_voltage(X,Volts,W) :- (!, W = no)) ),
       Z = no.




breaker(Which,X)  :-
        print('Is the ',X,' breaker tripped (y/n)? '),
        ratom(y),
        !,
        asserta( (breaker(Which,Y) :- (!, Y = tripped)) ),
        X = tripped.

breaker(Which,X)  :-
     print('Is the breaker on (y/n)'),
     ratom(y),
     !,
     asserta( (breaker(Which,Y) :- (!, Y = on)) ),
     X = on.


breaker(Which,X)  :-
     asserta( (breaker(Which,Y) :- (!, Y = off)) ),
     X = off.

fan_turns(Which,X) :-
        print('Does the ',Which, ' fan turn now (y/n)? '),
        ratom(y),
        !,
        asserta( (fan_turns(Which,Y) :- (!, Y = yes)) ),
        X = yes.

fan_turns(Which,X) :-
        asserta( (fan_turns(Which,Y) :- (!, Y = no)) ),
        X = no.


coil_contacts(Which,X)  :-
     print('Are the ',Which, ' contacts open (y/n)? '),
     ratom(y),
     !,
     asserta( (coil_contacts(Which,Y) :- (!, Y = open)) ),
     X = open.

coil_contacts(Which,X)  :-
     asserta( (coil_contacts(Which,Y) :- (!, Y = closed)) ),
     X = closed.


continuity(Device,YesNo) :-
        print('Is there continuity at the ',Device,' (y/n)? '),
        ratom(y),
        !,
        asserta( (continuity(Device,Y) :- (!, Y = yes)) ),
        YesNo = yes.

continuity(Device,YesNo) :-
        asserta( (continuity(Device,Y) :- (!, Y = no)) ),
        YesNo = no.

motor(Which,How,YesNo) :-
        print('Is the ',Which, ' motor ',How,' (y/n)? '),
        ratom(y),
        !,
        asserta( (motor(Which,How,Y) :- (!, Y = yes)) ),
        YesNo = yes.

motor(Which,How,YesNo) :-
        asserta( (motor(Which,How,Y) :- (!, Y = no)) ),
        YesNo = no.

air(X)  :-
        print('Do you hear any air (y/n)? '),
        ratom(y),
        !,
        asserta( (air(Y) :- (!, Y = yes)) ),
        X = yes.

air(X) :-
        asserta( (air(Y) :- (!, Y = no)) ),
        X = no.

perform_maintenance([]) :- !.
perform_maintenance([[Symptom,Action] | Tail]) :-
     do_maintenance(Symptom,Action),
     perform_maintenance(Tail).

do_maintenance(Symptom,Action) :-
     print('Is there a ',Symptom,'? (y/n)'),
     ratom(y), !,
     print(Action),nl.
do_maintenance(Symptom,Action).

maintenance( [
     [plugged_filter, replace],
     [broken_or_loose_belt, replace],
     [plugged_coil, clean],
     [dirty_blower_wheel, clean],
     [plugged_return_grill, clean],
     [closed_grill,open],
     [plugged_grill,clean] ]).



check_safeties([],Num) :- !, Num is 0.
check_safeties([[Safety,Action] | Tail], Num) :-
     ! ,
     check_safety(Safety,Action,Num1),
     check_safeties(Tail, Num2),
     Num is Num1 + Num2.

check_safety(Safety,Action, Num) :-
     print('Is the ',Safety,' safety open (y/n)?'),
     ratom(y), !,
     print(Action) ,nl,
     Num is 1.

check_safety(Symptom,Action,Num ) :- Num is 0.

safety_list( [
     [high_pressure,
       'Check for clogged condenser coils, condenser fan motor problem, overcharged unit'],
     [low_pressure,'Check for loss of refrigerant'],
     [compressor_internal,
       'Low refrigerant charge, expansion valve problems, filters, belts coils, compressor amperage']
           ]).

safeties(X)  :-
        safety_list(List),
        check_safeties(List,Num),
        Num = 0,
        !,
        asserta( (safeties(Y) :- (!, Y = yes)) ),
        X = yes.

safeties(X) :-
        asserta( (safeties(Y) :- (!, Y = no)) ),
        X = no.


gauge(X) :-
        print('Install gauges'), nl,
        asserta(( gauge(X) :- !)).


pressure(HighLowSide,Pounds) :-
        print('What is the pressure on the ',HighLowSide,' (end # with .)? '),
        read(Pounds),
        asserta((pressure(HighLowSide,Pounds) :- !)).



print_maintenance_start(X) :-
    print('Be sure that the maintenance has been done first'), nl,
    print_maintenance(X),
    asserta( (print_maintenance_start(Y) :- !) ).


print_maintenance([]) :- !.
print_maintenance([Head | Tail] ) :-
    print('     '),
    Head = [Symptom, Stuff], print(Symptom),nl,
    print_maintenance(Tail).







