#include <stdio.h>
#include "cells.h"

extern char *strcat(char *, char *);
extern EXP cursym;
extern void nextsym();
extern void fprints(FILE *, EXP, int);
extern int linecount;
extern long cellcount;
extern long totalcells;


FILE *input;

EXP c_s_exp();

void prompt() {
	printf("\n%ld> ",(totalcells-cellcount));
	fflush(stdout);
}

EXP brds(EXP args)
{
EXP tmp = NIL;
trace("brds: ");
trace_exp(args);

	tmp = newocell(input);
	input = cor(car(args));
   	return( tmp );
}

/*****************************************************************************
 *
 *
 *
 */
EXP c_m_list()
{
EXP tree = NIL;

   nextsym();
   lif( equal( cursym, rpar) )
      tree = NIL;
   else lif( equal( cursym, period ) ) {
      nextsym();
      tree = c_s_exp();
      nextsym();
   }
   else {
      tree = c_s_exp();
      tree = cons( tree, c_m_list() );
   }
   return( tree );
}
/*****************************************************************************
 *
 *
 *
 */
EXP c_s_exp()
{
EXP tree = NIL;

   lif( equal( cursym, beof ) ) {
      fatal_err("unexpected EOF");
      tree  = NIL;
   }
   else lif( equal( cursym, rpar ) ) {
      serr("unexpected )");
      tree = NIL;
   }
   else if( cursym == raw_quote ) {
	  nextsym();
	  tree = cons( quote, cons( c_s_exp(), NIL) );
   }
   else if( cursym == back_quote ) {
	  nextsym();
	  tree = cons( backquote, cons( c_s_exp(), NIL) );
   }
   else if( cursym == raw_comma ) {
	  nextsym();
	  tree = cons( comma, cons( c_s_exp(), NIL) );
   }
   else if( cursym == raw_comma_at ) {
	  nextsym();
	  tree = cons( comma_at, cons( c_s_exp(), NIL) );
   }
   else if( cursym == raw_func ) {
	  nextsym();
	  tree = cons( func_quote, cons( c_s_exp(), NIL) );
   }
   else if( cursym == raw_uchar1 ) {
	  nextsym();
	  tree = cons( uchar1, cons( c_s_exp(), NIL) );
   }
   else if( cursym == raw_uchar2 ) {
	  nextsym();
	  tree = cons( uchar2, cons( c_s_exp(), NIL) );
   }
   else lif( equal( cursym, lpar ) ) {
      tree = c_m_list();
	  lif( equal( cursym, rpar ) ) {
      }
      else {
         serr(" missing )");
      }
   }
   else {
      tree = cursym;
   }
   return(tree);
}

/*****************************************************************************
 *
 *
 *
 */
EXP reads(FILE *stream)
{
EXP retval = NIL;


   input = stream;

   nextsym();
   lif( equal( cursym, beof) ) {
      retval = beof;
   }
   else {
      retval = c_s_exp();
   }
   return(retval);
}
EXP breads(EXP args)
{
register EXP filename = NIL;

	lif( null(args) )
		return(reads(stdin));
	filename = car(args);
	lif(lnot(filep(filename))) {
		serr("non-file passed to read");
		return(NIL);
	}
	return(reads(cor(filename)));
}
EXP bgetcs(EXP args)
{
register EXP filename = NIL;
int retval;
FILE *fd;

	lif( null(args) )
		fd = stdin;
	else {
		filename = car(args);
		lif(lnot(filep(filename))) {
			serr("non-file passed to getc");
			return(NIL);
		}
		else 
			fd = cor(filename);
	}
	retval = getc(fd);
	if( retval == EOF)
		return(beof);
	else
		return(newicell(retval));
}

extern EXP reference(EXP);

void readfile(FILE *inpf,FILE *outpf,int load_print, int verbose)
{
EXP inpt = NIL, result = NIL;
int old_linecount;
int prompter =0;

	verbose = verbose;
	old_linecount = linecount;	/* Save the current file's  */
	linecount = 1;			/* linecount for restore later */

		if(inpf == stdin) prompter =1;
		if(prompter) prompt();


		lwhile( lnot(equal( (inpt = reads(inpf)), beof)) ) {

		  	inpt = reference( inpt);
  	    	result = reference( eval(inpt));
			if( load_print )
				fprints(outpf, result, PRIN1 );

      		purge(result);
	  		purge(inpt);

		if(prompter)
			prompt();
		else
			if( load_print )
				fprintf(outpf,"\n");
	   }
	linecount = old_linecount; /* and restore. */
}
int rawread( char *in, char *out, int load_print, int verbose)
{
FILE *infd, *outfd;

	if( in == NULL)
		infd = stdin;
	else {
		if( (infd = fopen(in,"r")) == NULL)
			return(0);
	}
	if( out == NULL)
		outfd = stdout;
	else {
		if( (outfd = fopen(out,"w+")) == NULL)
			return(0);
	}
	if(verbose)
		fprintf(stderr,"; reading %s \n", in);
	readfile(infd, outfd, load_print, verbose);
	if(infd != stdin)
		fclose(infd);
	if(outfd != stdout)
		fclose(outfd);
	return(1);
}
EXP rdf(EXP args)
{
char  *outfile;
char  ibuf[80];
EXP retval = NIL;
	
int	load_print = 0; /* silent by default */
int verbose = 1;

	lif( null(args) )
		return(NIL);
	lif( lor(stringp(car(args)), bigstringp(car(args))) ) {
		c_tostr(ibuf,car(args));
	}
	else  {
    	return(NIL);
    }
	lwhile( lnot(null(cdr(args))) ) {
		args = cdr (args);        /* next key */
		if( car(args) == lookup(":verbose")  ){
			args = cdr (args);        /* next argument */
			if( car(args) == T ) {
				verbose = 1;
			}
			else  {
				verbose = 0;
			}
		}
		else if( car(args) == lookup(":print")  ){
			args = cdr (args);        /* next argument */
			if( car(args) == T ) {
				load_print = 1;
			}
			else  {
				load_print = 0;
			}
		}
	}
	outfile = (char *)NULL;
	if( rawread(ibuf, outfile, load_print, verbose ) != 0)
		retval = T ;
	else
		retval = NIL;

	return(retval);
}
EXP bclose(EXP args)
{
register EXP filename = NIL;

	filename = car(args);
	lif(lnot(filep(filename))) {
		serr("non-file passed to close");
		return(NIL);
	} 
	fclose(cor(filename));
	return(T);
}
/*
(defun reverse-aux (l rev-result)
	(do-while l
		(setq rev-result (cons (car l) rev-result))
		(setq l (cdr l)))
	rev-result)
*/
EXP reverse(EXP s)
{
EXP rev_result = NIL;

	lwhile( lnot(null(s))) {
		rev_result = cons(car(s), rev_result);
		s = cdr(s);
	}
	return(rev_result);
}
LISPFUNC(breverse)
{
	return(reverse(car(args)));
}
/*
(defun append2 (a b) 
	(setq a (reverse a))
	(do-while a
		(setq b (cons (car a) b))
		(setq a (cdr a)))
	b)
*/
EXP append(EXP a, EXP b)
{

EXP tmp, tmp2;

	tmp	= reference(reverse(a));
	tmp2 = tmp;

	lwhile( lnot(null(tmp2)) ) {
		b = cons(car(tmp2), b);
		tmp2 = cdr(tmp2);
	}
	reference(b);
	purge(tmp);
	dereference(b);
	return(b);
}
/*
(defun append (a &rest l)
	(do-while l
		(setq a (append2 a (car l)))
		(setq l (cdr l)) )
	a )
*/

LISPFUNC(bappend) {
EXP l = cdr(args);
EXP result = reference(append(car(args), car(l)));

	l = cdr(l);
	lwhile( lnot(null(l)) ) {
		EXP tmp = reference(append(result, car(l)));
		purge(result);
		result = tmp;
		l = cdr(l);
	}
	dereference(result);
	return(result);
}
/*
 * (df backquote (_s)
 *	(_bq1 _s) )
 *
 *
 *(defun _bq1 (_s1) 
 *	(cond
 *		((or (null _s1) (atom _s1)) _s1)
 *		((equal (car _s1) 'comma) (eval (cadr _s1)))
 *		((and (not (atom (car _s1))) (equal (caar _s1) 'comma-at))
 *			(append (eval (cadar _s1)) (_bq1 (cdr _s1))))
 *
 *		(t (cons (_bq1 (car _s1)) (_bq1 (cdr _s1)))) ) )
 *
 */

EXP backquote_fn( EXP s)
{
	lif(lor(null(s), atom(s))){
		return(s);
	}
	else lif(equal(car(s), comma))  {
		return(eval(car(cdr(s))));
	}
	else lif(land(lnot(atom(car(s))),equal(car(car(s)),comma_at))) {
        EXP hold = reference(car(cdr(car(s))));
		EXP tmp = reference(eval(hold));
		EXP result = reference(append(tmp, backquote_fn(cdr(s))));
		purge(tmp);
		dereference(result); dereference(hold);
		return(result);
	}
	else {
		return(cons(backquote_fn(car(s)),backquote_fn(cdr(s))));
	}
}
LISPFUNC(back)
{
	return(backquote_fn(car(args)));
}
void InitParse()
{
	set(lookup("backquote"), newffcell(back) );
	set(lookup("reverse"), newfcell(breverse) );
	set(lookup("append"), newfcell(bappend) );

	set(lookup("close"), newfcell(bclose) );
	set(lookup("read"), newfcell(breads) );
	set( lookup("load"), newfcell( rdf ));
    set( lookup("rds"), newfcell(brds));
	set(lookup("read-char"), newfcell(bgetcs) );
	set(lookup("*eof*"), beof );

	set(lookup(":verbose"), lookup(":verbose") );
	set(lookup(":print"), lookup(":print") );
}

 
