#ifndef LASER
void InitMidi() {};
#endif
#ifdef LASER
#include <stdio.h>
#include <math.h>
#include <osbind.h>
#include "cells.h"

#define PRT 0
#define AUX 1
#define CON 2
#define MIDI 3

#define DEBUG

/*
 * Global Variables
 */
int	tempo = 1000;


EXP noteon(args)
EXP args;
{
int channel, note, velocity;

	channel =   cir(car(args));
	note =      cir(car(cdr(args)));
	velocity =  cir(car(cdr(cdr(args))));
	Bconout(3, (128+16+channel));
	Bconout(3,note );
	Bconout(3,velocity );
	return(T);
}
EXP noteoff( args)
EXP args;
{
int channel, note, velocity;

	channel =  cir(car(args));
	note =     cir(car(cdr(args)));
	velocity = cir(car(cdr(cdr(args))));
	Bconout(3, (128+channel));
	Bconout(3,note );
	Bconout(3,velocity );
	return(T);
}
delay(length)
int length;
{
int d1,d2;

	for( d1 =0; d1 <length*tempo; d1++)
		for( d2 =0; d2 <8; d2++)
			d2 = d2;
}
EXP edelay(args) 
EXP args;
{
	delay(cir(car(args)));
	return(T);
}
EXP setempo(args) 
EXP args;
{
	tempo = cir(car(args));
	return(newicell(tempo));
}
EXP programchange(args)
EXP args;
{
int channel, value;

	channel = cir(car(args));
	value = cir(car(cdr(cdr(args))));
	Bconout(3, (128+64+channel));
	Bconout(3,value );
	return(T);
}
EXP playnote(args)
EXP args;
{
int channel, note, velocity,length;

trace("playnote");
trace_exp(args);
trace("\n");

	channel = cir(car(args));
	note = cir(car(cdr(args)));
	velocity = cir(car(cdr(cdr(args))));
	length = cir(car(cdr(cdr(cdr(args)))));
	Bconout(3, (128+16+channel));
	Bconout(3,note );
	Bconout(3,velocity );
	delay(length);
	Bconout(3, (128+channel));
	Bconout(3,note );
	Bconout(3,velocity );
	return(T);
}
EXP playtune(args)
EXP args;
{
EXP current = NIL;
trace("playtune");
trace_exp(args);
trace("\n");

	current = car(args);
	while( current != NIL) {
		playnote( car(current) );
		current = cdr(current);
	}
}
/*
 * Music.c
 */
/*
 * scale - fuction to translate from musical scales to MIDI notes
 *
 * where:
 *		scaleptr -	 pointer to an array of int which contains a scale
 * 					 mapping.
 *					 e.g 0,2,4,5,7,9,11 corresponds to a major scale.
 *		octave_size	- no of semitones in the scale eg 12
 *		
 *		scale_size - # of naturals in the scale eg 7
 *	
 *		note -		note in the scale eg. 0-C, 1-D, 2-E ...
 *	
 *		adj -		+1 = sharp, 0 = natural, -1 = flat
 *
 *		key -		starting point of the scale eg. 0-C, 1-D, 2-E ...
 *	
 *		key_adj -		+1 = sharp, 0 = natural, -1 = flat
 */
int major_scale[7] = { 0,2,4,5,7,9,11 };
 
int scale( scaleptr, scale_size, octave_size, key, key_adj, note, note_adj)
int *scaleptr, scale_size, octave_size, key, key_adj, note, note_adj;
{
int octave;
int tone,midi,semi;

	octave = (note-key)/scale_size; /* transpose to down to C */
	tone = (note-key)%scale_size;
	semi =	scaleptr[tone % scale_size]; /* semitone */
	
	midi = octave*octave_size /* in the octave */
			+ semi 
			+ scaleptr[key%scale_size]+key_adj /* transpose up */
	 + note_adj;	/* accidentals */
#ifdef DEBUG	 
printf("scale: octave %d tone %d semi %d midi %d\n",
	 			octave,tone,semi,midi);
#endif
	 return(midi); 
}

/*
 * routine to convert a conventional major scale into MIDI note #
 */
int major( note, note_adj, key, key_adj)
int note, note_adj, key, key_adj;
{
	return(scale(major_scale, 7,12,key,key_adj,note,note_adj));
}
EXP emajor(args)
EXP args;
{
int note, note_adj, key, key_adj;

	note = cir(car(args));
	note_adj = cir(car(cdr(args)));
	key = cir(car(cdr(cdr(args))));
	key_adj = cir(car(cdr(cdr(cdr(args)))));

#ifdef DEBUG	 
printf("emajor: note %d note_adj %d key %d key_adj %d\n",
	 	note, note_adj, key, key_adj);		
#endif
	return( newicell(major( note, note_adj, key, key_adj)));

}
 				

int lowest_note = 21; /* MIDI = 36 TANDY Realistic Concertmate-100M */
int highest_note = 56; /* MIDI = 96 TANDY Realistic Concertmate-100M */

/*
 * Dumb terminal emulator
 * Copied from the Laser 'C' manual.
 */

EXP emu(args)
EXP args;
{
char *outfile;
FILE *fp = NULL;
char c = 0;
int printit = 0;

	lif( null( args))
		outfile = NULL;
	else {
		lif( idp(car(args)) )
			outfile = pname(car(args));
		else lif( stringp(car(args)) )
			outfile = csr(car(args));
		else
			return(NIL);
		if( ( fp = fopen(outfile,"w+")) == NULL) 
			return(NIL);
		else
			printf("saving session to %s\n",outfile);
	}


	
	while( 1 ) {

		if( Bconstat(AUX)) {
			c = ((int)Bconin(AUX))&127;
			Bconout(CON,c);
			if(outfile) {
				putc(c,fp);
			}
		}
		if( Bconstat(CON)) {
			c = (int)Bconin(CON)&127;

			if( c == '~' )  {
				int c2;

				while( !Bconstat(CON))
					; 
				c2 = (int)Bconin(CON)&127;
				if( c2 != '~' ) {
					if(outfile) {
							fclose(fp);
					}
					return(NIL);
				}
			}
			while(!Bcostat(AUX))
				;
			Bconout(AUX,c);
		}
	}
	return(NIL);
}
EXP exbios(args)
EXP args;
{
int length;
long retval;
EXP sav = NIL;

	length = cir(sav = explength(args));
	erase(sav);
	switch( length) {
		case 1 :
			retval = xbios( cir(car(args)) );
			break;
		case 2 :
			retval = xbios( cir(car(args)), cir(car(cdr(args))) );
			break;
		case 3 :
			retval = xbios( cir(car(args)), 
							cir(car(cdr(args))), 
							cir(car(cdr(cdr(args)))));
			break;
		case 4 :
			retval = xbios( cir(car(args)), 
							cir(car(cdr(args))), 
							cir(car(cdr(cdr(args)))),
							cir(car(cdr(cdr(cdr(args))))));
			break;
		default:
			return(NIL);
			break;
	}
	return( newicell(retval));
}
EXP ebios(args)
EXP args;
{
int length;
long retval;
EXP sav = NIL;

	length = cir(sav = explength(args));
	erase(sav);
	switch( length) {
		case 1 :
			retval = bios( cir(car(args)) );
			break;
		case 2 :
			retval = bios( cir(car(args)), cir(car(cdr(args))) );
			break;
		case 3 :
			retval = bios( cir(car(args)), 
							cir(car(cdr(args))), 
							cir(car(cdr(cdr(args)))));
			break;
		case 4 :
			retval = bios( cir(car(args)), 
							cir(car(cdr(args))), 
							cir(car(cdr(cdr(args)))),
							cir(car(cdr(cdr(cdr(args))))));
		default:
			return(NIL);
			break;
	}
	return( newicell(retval));
}
typedef union {
	struct {
		unsigned day : 5;
		unsigned month : 4;
		unsigned year : 7;
		unsigned seconds : 5;
		unsigned minutes : 6;
		unsigned hours : 5;
	} part;
	long realtime;
} time;
time mytime;

EXP egetstr(args)
EXP args;
{
int port = cir(car(args));
int timeout = cir(car(cdr(args)));
char string[LEN_STRING];
int wr, not_ended =1;
time now;

	wr = 0;
	mytime.realtime = Gettime();
	while( not_ended ) {
		while(Bconstat(port) && not_ended) {
			string[wr] = Bconin(port)&127;
			if( wr > LEN_STRING-1) {
				not_ended = 0;
			}
			switch( string[wr++] ) {
					
				case ' ' : case '\t' : case '\n' : case '\r' :
					if( wr == 1)
						wr = 0; /* skip over white space */
					else
						not_ended = 0;
					break;
				case '(' : case ')' : case '.' : case '\'' :
				case '[' : case ']' : case '{' : case '}' :
				case '!' : case '"' :  case '$' :
				case '%' : case '^' : case '&' : case '*' :
				case '_' : case '+' : case '=' : case '`' :
				case '@' : case '<' : case '>' : case '/' :
				case '\\' : case '|' : case ';' : case '#' :
				case '~' : 
					not_ended = 0;
				break;
			}
		}
	now.realtime = Gettime();
	if( (now.part.seconds+ now.part.minutes*60) 
		- (mytime.part.seconds+mytime.part.minutes*60) > timeout/2 ) 
			return(NIL);
	}
	string[wr]=0;
	return(newscell(string));
}
EXP eputstr(args)
EXP args;
{
int port = cir(car(args));
char *string;
EXP exstr=car(cdr(args));

	lif( stringp(exstr) )
		string = csr(exstr);
	else lif( idp(exstr) )
		string = pname(exstr);
	else
		return(NIL);
	while( !Bcostat(port)) ;
	while( *string != 0) {
		while( !Bcostat(port)) ;
		Bconout(port, *string++);
	}
	return(NIL);
}
InitMidi()
{
   set( lookup("getstr"), newfcell(egetstr));	
   set( lookup("putstr"), newfcell(eputstr));	
   set( lookup("bios"), newfcell(ebios));	
   set( lookup("xbios"), newfcell(exbios));	
   set( lookup("delay"), newfcell(edelay));
   set( lookup("tempo"), newfcell(setempo));
   set( lookup("noteon"), newfcell(noteon));
   set( lookup("noteoff"), newfcell(noteoff));
   set( lookup("programchange"), newfcell(programchange));
   set( lookup("playnote"), newfcell(playnote));
   set( lookup("playtune"), newfcell(playtune));
   set( lookup("major"), newfcell(emajor));
   set( lookup("emu"), newfcell(emu));

}
#endif /* LASER */

