#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <limits.h>
#include "cells.h"
extern int c_lenstr(EXP);
EXP explength(EXP args)
{
EXP list = car(args);
int count = 0;

	lif(consp(list)) {
		lwhile( list ) {
			count++;
			list = cdr(list);
		}
	}
	else lif(lor(lor(stringp(list),idp(list)),
			bigstringp(list))) {
        	count = c_lenstr(list);
        }
	else 
		count =0;

	return(newicell(count));
}

EXP bfloat(EXP args)
{
	return(newflocell(cflor(car(args))));
}
EXP absof(EXP args)
{
	lif( floatp( car(args)))
		return(newflocell(abs(cflor(car(args)))));
	else
		return(newicell(abs(cir(car(args)))));
}
EXP seed(EXP args)
{
float the_seed = 1.0;

	the_seed = (long)cflor(car(args));
	srand(the_seed);
	return(newflocell((float)the_seed));
}
EXP brandom(EXP args)
{
int range;

	lif( null(args) )
		range = 32000; 
	else
		range = cir(car(args));
	return( newicell( abs(rand())%(int)range ));
}
EXP greaterp(EXP args)
{
	lif( lor( floatp( car(args)) , floatp(car(cdr(args))))) {
		if( cflor( car(args)) > cflor( car(cdr(args))) )
			return(T);
		else
			return(NIL);
	}
	else {
		if( cir( car(args)) > cir( car(cdr(args))) )
			return(T);
		else
			return(NIL);
	}
}
EXP lessp(EXP args)
{
	lif( lor(floatp( car(args)) , floatp(car(cdr(args))))) {
		if( cflor( car(args)) < cflor( car(cdr(args))) )
			return(T);
		else
			return(NIL);
	}
	else {
		if( cir( car(args)) < cir( car(cdr(args))) )
			return(T);
		else
			return(NIL);
	}
}
EXP stringcmp(EXP args)
{
register char *left, *right;

	lif(idp(car(args)))
		left = pname(car(args));
	else lif(stringp(car(args)))
		left = csr(car(args));
	else {
		serr("non-string passed to stringcmp");
		return(NIL);
	}
	lif(idp(car(cdr(args))))
		right = pname(car(cdr(args)));
	else lif(stringp(car(cdr(args))))
		right = csr(car(cdr(args)));
	else {
		serr("non-string passed to stringcmp");
		return(NIL);
	}
	if( strcmp(left,right ) < 0 )
		return(T);
	else
		return(NIL);
}
EXP difference(EXP args)
{
	lif(null(cdr(args)) ) {   /* (minus) logic */
		lif( floatp( car(args)) ) {
			return( newflocell( cflor(car(args)) * (float)-1  ) );
		}
		else {
			return( newicell( cir(car(args)) * -1  ) );
		}
	}
	else lif( lor(floatp( car(args)) , floatp(car(cdr(args))))) {
		return( newflocell( cflor( car(args)) - cflor( car(cdr(args)))   ) );
	}
	else {
		return( newicell( cir( car(args)) - cir( car(cdr(args)))   ) );
	}
}
EXP quotient(EXP args)
{
	lif(null(cdr(args)) ) {   /* invert logic */
		return( newflocell(1.0 / cflor( car(args))   ) );
    }
	lif( lor( floatp( car(args)) , floatp(car(cdr(args))))) {
		return( newflocell( cflor( car(args)) / cflor( car(cdr(args)))   ) );
	}
	else {
		int A = cir(car(args));
		int B = cir(car(cdr(args)));
		if(A%B != 0)  {
			return( newflocell( (float)A / (float)B) );
		}
        else
			return( newicell( cir( car(args)) / cir( car(cdr(args)))   ) );
	}
}
EXP btimes(EXP args)
{
int floatem = 0; /* flag */
float fresult = 1.0;
int iresult =1;

	lif( null(args) )
		return(newicell((int)1));
	lwhile( args ) {
		if( floatem ) {
				fresult *= cflor( car(args));
	    	}
	    	else lif( floatp( car(args))) {
				floatem = 1;
				fresult = iresult;
			fresult *= cflor( car(args));
		}
		else {
			long tmp = (long) iresult;
			tmp  *= cir(car(args));
			if(tmp > INT_MAX || tmp <INT_MIN ) {
				/* to big to contain in an int */
				floatem = 1;
				fresult = iresult;
				fresult *= cflor( car(args));
            }
			else  {
				iresult *= cir(car(args));
			}
		}
		args = cdr(args);
	}

	return( (floatem?newflocell(fresult):newicell(iresult)) );
}
EXP plus(EXP args)
{
int floatem = 0; /* flag */
float fresult = 0.0;
int iresult =0;

	lif( null(args) ) c_error("parameter to + is not a number",args);
	lwhile( args ) {
		if( floatem ) {
				fresult += cflor( car(args));
	    	}
			else lif( floatp( car(args))) {
				floatem = 1;
				fresult = iresult;
				fresult += cflor( car(args));
			}
		else {
			iresult += cir(car(args));
		}
		args = cdr(args);
	}
	return( (floatem?newflocell(fresult):newicell(iresult)) );
}
EXP or(EXP args)
{
EXP result = NIL;

	lwhile( args ) {
		result = eval( car(args) );
		lif( lnot(null(result)) )
			return(result); 
		args = cdr(args);
	}
	return( NIL );
}
EXP and(EXP args)
{
EXP result = NIL;

	lif(null(args))
		return(NIL);
	lwhile( args ) {
		result = eval( car(args) );
		lif( null(result) )
			return(NIL); 
		args = cdr(args);
	}
	return( result );
}
EXP bzerop(EXP args)
{

	lif( null(args) )
		c_error("parameter to ZEROP is not a number",args);
	if( cflor(car(args)) == 0.0 )
		return(T);
	else
		return(NIL);

}
EXP bfloor(EXP args)
{
	lif( floatp( car(args)) ) {
			return( newicell((int)floor((double)cflor(car(args)))));
	}
	else {
			return( car(args) );
	}
}
EXP remainder(EXP args)
{
	lif( bzerop( cdr(args)) ) 
				c_error("Attempt to divide by zero in REMAINDER",args);
	lif( lor( floatp( car(args)) , floatp(car(cdr(args))))) {
		float u,v;
			u = cflor( car(args));
			v = cflor( car(cdr(args)));
			return( newflocell(fmod(u,v)));
	}
	else {
			return( newicell( cir( car(args)) % cir( car(cdr(args)))   ) );
	}
}
EXP bcos(EXP args)
{
	lif( floatp( car(args)) ) {
		return( newflocell( (float)cos( (float)cflor(car(args)))  ) );
	}
	else {
		return( newflocell( (float)cos( (float)cir(car(args)) ) ) );
	}
}
EXP barc_cos(EXP args)
{
	lif( floatp( car(args)) ) {
		return( newflocell( (float)acos( (float)cflor(car(args)))  ) );
	}
	else {
		return( newflocell( (float)acos( (float)cir(car(args)) ) ) );
	}
}
EXP barc_sin(EXP args)
{
	lif( floatp( car(args)) ) {
		return( newflocell( (float)asin( (float)cflor(car(args)))  ) );
	}
	else {
		return( newflocell( (float)asin( (float)cir(car(args)) ) ) );
	}
}
EXP bsin(EXP args)
{
	lif( floatp( car(args)) ) {
		return( newflocell( (float)sin( (float)cflor(car(args)))  ) );
	}
	else {
		return( newflocell( (float)sin( (float)cir(car(args)) ) ) );
	}
}
EXP blog(EXP args)
{
	lif( floatp( car(args)) ) {
		return( newflocell( (float)log( (float)cflor(car(args)))  ) );
	}
	else {
		return( newflocell( (float)log( (float)cir(car(args)) ) ) );
	}
}
EXP blog10(EXP args)
{
	lif( floatp( car(args)) ) {
		return( newflocell( (float)log10( (float)cflor(car(args)))  ) );
	}
	else {
		return( newflocell( (float)log10( (float)cir(car(args)) ) ) );
	}
}
EXP bexp(EXP args)
{
	lif( floatp( car(args)) ) {
		return( newflocell( (float)exp( (float)cflor(car(args)))  ) );
	}
	else {
		return( newflocell( (float)exp( (float)cir(car(args)) ) ) );
	}
}
void InitMath()
{
   set( lookup("length"), newfcell(explength));	
   set( lookup("and"), newffcell(and));
   set( lookup("or"), newffcell(or));
   set( lookup("+"), newfcell(plus));
   set( lookup("-"), newfcell(difference));
   set( lookup("rem"), newfcell(remainder));
   set( lookup("floor"), newfcell(bfloor));
   set( lookup("*"), newfcell(btimes));
   set( lookup("/"), newfcell(quotient));
   set( lookup(">"), newfcell(greaterp));
   set( lookup("<"), newfcell(lessp));
   set( lookup("string<"), newfcell(stringcmp));
   set( lookup("abs"), newfcell(absof));
   set( lookup("random"), newfcell(brandom));
   set( lookup("seed"), newfcell(seed));
   set( lookup("float"), newfcell(bfloat));
   set( lookup("zerop"), newfcell(bzerop));
   set( lookup("log"), newfcell(blog));
   set( lookup("log10"), newfcell(blog10));
   set( lookup("exp"), newfcell(bexp));
   set( lookup("sin"), newfcell(bsin));
   set( lookup("cos"), newfcell(bcos));
   set( lookup("asin"), newfcell(barc_sin));
   set( lookup("acos"), newfcell(barc_cos));
}
 
