#include <stdio.h>
#include <setjmp.h>
#ifdef MSDOS
#include <dos.h>
#endif
#include "cells.h"
extern int rawread(char *, char *, int, int);
extern int readfile(FILE *, FILE *, int, int);
extern char *InitOS();
extern void InitIPC();
extern void	InitCells();
extern void	InitSymtab();
extern void	InitParse();
extern void	InitPrint();
extern void	InitEval();
extern void	InitMidi();
extern void	InitMath();
extern void	InitGraph();
extern void	InitView();
/******************************************************************************
 *
 *
 *
 */
jmp_buf top_level;

#ifdef LASER
long _stksize = 100*1024L;
#endif
#ifdef MSDOS
unsigned _stklen = 48*1024 ;
#endif

 int main(int argc, char **argv)
{

char *initfile;
int arg;
EXP command_args = NIL;

	initfile = "lisprc.lsp";

	if( setjmp(top_level) ){

		printf("Intialisation error, exiting...\n");
		return(-1);
	}
	InitCells();
	InitSymtab();    
	InitParse();
	InitPrint();
	InitEval();
	initfile = InitOS();	/* Operating System specific stuff */
    InitIPC();
	InitMidi();
	InitMath();
	InitGraph();
	InitView();

	{  /* handle command line arguments */

		for(arg = argc-1 ; arg >= 0 ; arg--) {
			command_args = cons(newbigstring(argv[arg]),command_args);
		}
		set(lookup("command-line-args"), reference(command_args));
    }
	set( lookup("error-tag") , newvoidcell((void *)&top_level));
	if( setjmp(top_level) )
		fprintf(stderr,"; skipping files...");
	else {

		if( rawread(initfile,(char *)NULL, (int)0, (int)1) == 0)
			fprintf(stderr,"; cannot read %s, continuing...\n",
				initfile);
			fflush(stderr);
	
	}
	if( setjmp(top_level) )
		printf("back to top level...\n");
	readfile(stdin,stdout, 1, 0);

	exit((int)0);
	return(0);
}



 
