; Test Suite
;
(setq ATARI_ST t)
; play with file reading
(defun type (file)
   (print (setq fd (open file )))
   (do-while (null (equal (setq ch (read-char fd)) *eof*))
      (write-char ch)
      (cond ((equal ch 10)(force-output))(t t) ))
   (close fd)
)
(progn
   (princ "view source code? ")(princ CR)
   (cond
      ((equal (read) 'y) (type "test.lsp"))
      (t t)
   )
)
;
; miscellany
;
(equal (member 'c '(a b c d)) '(c d))
(cond ((equal (last '(a s d f g h the_end)) 'the_end) t) 
   (t '(last failed)))


; Function which draws random lines on the screen
; i - number of lines to draw.
;
(defun lines (i)
   (GraphOpen)
   (do-while (> i 0)
       (line (random 20000)(random 10000) (random 20000)  (random 10000) )
   (setq i (- i 1)) 
   )
   (GraphClose)
)
(cond (ATARI_ST (lines 100))(t "no lines"))
;
; function which constructs MIDI notes from a simple list of
; ( (note# length) ....)
;
(defun melod (l)
   (setq return ())
   (do-while l
      (setq return
          (cons (list 0 
               (car(car l)) 
               63 
               (eval(car(cdr(car l)))) 
            )
          return)
      )
      (setq l (cdr l))
   )
   (reverse return)
)
(setq q 2)    ; long note
(setq c 1)   ; short note
(setq queen '((60 q )(60 q)(62 q)(59 3)(60 c)(62 c))) ; God save the queen !
(defun gsq ()
   (PlayTune (melod queen))
)
"Music 1."
(cond (ATARI_ST (gsq))(t "no music"))
"Music 2."
(defun tune (l)
   (cond
      ((null l) t)
      (t (PlayNote 0 (car l) 63 1)
         (tune (cdr l))
      )
   )
)

; function to print a list one per line.
(defun printl (list)
   (do-while list
      (princ (car list))
	  ;(princ " ")(princ (ccr (car list)))
      (princ CR)
      (setq list (cdr list))
   )
)
; Function to find out the maximum calling depth
; (depth 0) will crash eventually
(defun depth (x) 
    
   (princ x)(princ CR)(depth (+ 1 x))
)
(defun lminus (a b)
   (cond
      ((null a) nil)
      (t (cons (- (car a) (car b)) 
             (lminus (cdr a) (cdr b))
         )
      )
   )
)
; Good old towers of Hanoi
;
; Usage:
;	  (hanoi <n>)
;		  <n> - an integer the number of discs

(defun hanoi(n)
   (setq xcur 0)
   (setq ycur (* (/ xcur 640) 10))
   ;(GraphOpen)
     ( transfer 60 65 70 n )
   ;(GraphClose)
)

(defun print-move ( from to )
(cond
   (ATARI_ST
	  (PlayNote 0 from 63 1) ; play it
      (PlayNote 0 to 63 1)
	  (line xcur (+ ycur (* from 2)) (+ xcur 10) (+ ycur (* to 2))); draw it
      (setq xcur (+ xcur 15))
      (setq ycur (* (/ xcur 640) 20))
   )
   (t   
   ; old printing version:
   ;
      (princ '(Move Disk From ))
      (princ from)
      (princ 'to)
      (princ to)
      (princ CR)
   )
)
)


(defun transfer ( from to via n )
  (cond ((equal n 1) (print-move from to ))
   (t (transfer from via to (- n 1))
      (print-move from to)
      (transfer via to from (- n 1)))))

(setq propt 0)
(put 'propt 'age 67)
(plist 'propt)
; play about with cix
(defun time (i) (setq result nil)
         (putstr 1 "time\n")
         (delay 10)
         (do-while (> i 0)
            
            (cons (getstr 1 10) result)
            
            (setq i (- i 1)) 
         )
         result
)
(load "expand.lsp")
; test function closure via re-write
(defun twice (p x) (p (p x)))
(setq x 3)
(cond ((equal 
      (twice (expand '(lambda (y) (* x y)) '(y)) 2)
      18)
         (princ "expand") (princ " 18 ok\n")
   )
   (t (princ "expand") (princ "not ok\n"))
)
(df function (fn)
   (setq form (eval fn))
   (expand form (cons fn (car(cdr form))))
)
; see if expand makes things faster?
 (perf (hanoi 5))
(setq transfer (expand transfer '( transfer from to via n )))
(setq hanoi (expand hanoi '( hanoi xcur ycur n transfer )))
 (perf (hanoi 5))
