(setq TAB "\t")
(defun terpri () (princ CR))

(setq finished nil)

(defmacro defmenu (name &rest items)
	`(setq ,name '(
			("Exit" (setq finished t)) 
			("Return" (setq backup t))
			,@items)))

(defun menu (tree &optional backup)
	 (do-while (and (not finished) (not backup))
          (pmenu tree)
          (setq response (read))
		  (princ* "selected" TAB response CR)
          (when (and (numberp response) (< response (length tree)))
						(eval `(progn ,@(cdr (nth response tree)))))))

(defun pmenu (tree)
   (terpri)
   (pmenuaux 0 tree)
   (princ* CR "Option? "))

(defun pmenuaux (choice tree)
      (unless (null tree) 
		 (princ* TAB choice TAB (caar tree))
         (terpri)
         (pmenuaux (add1 choice) (cdr tree))))

