; /*
;  *
;  * A supposed solution to the FUNARG problem,
;  * and also a way to speed up your programs.
;  *
;  * This routine returns a copy of the <form>, with any BOUND variables
;  * evaluated, UNBOUND variables remain untouched. Any identifyers
;  * in the <except> list are left untouched.
;  *
;  * Example: page 328 "LISP" 2nd edition, Winston&Horn
;  *
;  * (setq x 3) ; we want this binding
;  * (setq y 100) ; we want to avoid this binding
;  *
;  * (expand '(lambda (y) (* x y)) '(y))
;  *
;  * yeilds:
;  *
;  * (lambda (y) (<subrp:89329> 3 y))
;  *
;  * To pass a function in a function do:
;  *
;  * (defun twice (p x) (p (p x)))
;  * (twice (expand '(lambda (y) (* x y)) '(y))  2) ; ==> 18 !
;  *
;  * A simple classic FUNCTION routine for non-recursive functions
;  * ( with no local use of "setq") would be:
;  *
;  * (df function (fn)
;  *	(setq form (eval fn))
;  *	(expand form (cons fn (car(cdr form))))
;  * )
;  * NB. It is very important to include the function name in
;  * such use of re-writes in self-recursive functions!
;  * If there is local use of setq inside a functions, then
;  * put these variable names in the exceptions list also.
;  * Recursive functions must be replaced with re-written function.
;  *
;  ****************************************************
 (defun expand (form except)
	(cond
		((null form) nil)
		((symbolp form) ; Only symbols get re-written.
			(cond
				((member form except) form) ; don't do exceptions
				((not (boundp form)) form) ; cannot re-write an UNBOUND!
				(t (eval form)) ; replace with current value
			)
		)
		((consp form) (cons (expand (car form) except)
							(expand (cdr form) except) 
						)
		)
		(t  form) ; numbers, strings, atoms...
	)
)		
; /*
;  * And here it is again in 'C' :
;  */
; EXP expand(form, except)
; EXP form, except;
; {
;	if(null(form))
;		return(NIL);
;	else if( symbolp(form) ) {
;		if( member( form, except)|| unboundp(form))
;			return(form);
;		else
;			return( eval(form) );
;	}
;	else if( listp(form) ) {
;		return( cons( 	expand( car(form), except),
;						expand( cdr(form), except)
;					)
;			);
;	}
;	else
;		return(form);
; }
;
(setq x 3) ; we want this binding
(setq y 100) ; we want to avoid this binding

(expand '(lambda (y) (* x y)) '(y))
; (lambda (y) (<subrp:89329> 3 y))

(defun twice (p x) (p (p x)))
(twice (expand '(lambda (y) (* x y)) '(y))  2)
