
(setq button textxy)
(defun cadddr (x)
   (car (cdr (cdr (cdr x))))
)
(defun evprint ()
   (GraphOpen)
   (do-while (not (equal (car (setq ev (getevent))) *keys*))
      (princ ev) 
      (princ CR)
   )
   (GraphClose)
)
(defun evfollow ()
   (setq c 0)
   (GraphOpen)
   (do-while (not (equal (car (setq ev (getevent))) *keys*))
      (cond 
		 ((equal (car ev) *move*)
            (colour (setq c
               (rem (+ c 1) 16)))
            (button (caddr ev) (cadddr ev) "."))
         (t nil)
      ) 
   )
   (GraphClose)
)
(defun evrubber ()
      (setq posx 0)(setq posy 0)
            (setq lastx 0)
            (setq lasty 0)
   (GraphOpen)
   (mode 3)    ; XOR mode
	(line lastx lasty posx posy)	; initialise
   (do-while (not (equal (car (setq ev (getevent))) *keys*))
      (cond 
		 ((equal (car ev) *move*)
			(line lastx lasty posx posy)    ; undraw the last existing line
			(setq posx (caddr ev))          ; get the new position of the line
            (setq posy (cadddr ev))
			(line  lastx lasty posx posy))  ; draw the new line
		 ((equal (car ev) *up*)
			(setq lastx posx )              ; save the new coodinates
            (setq lasty posy )
         )
         (t nil)
      ) 
   )
   (GraphClose)
)
(defun draw:hitp (mx my x1 y1 x2 y2)
   (and (> mx x1) 
      (< mx x2) 
      (> my y1) 
      (< my y2)
   )
)
(defun draw:box (x1 y1 x2 y2)
   (line x1 y1 x1 y2)
   (line x2 y1 x2 y2)
   (line x1 y1 x2 y1)
   (line x1 y2 x2 y2)
)
(defun evhit ()
   (GraphOpen)
   (draw:box 1000 1000 1100 1100)
   (do-while (not (equal (car (setq ev (getevent))) *keys*))
      (cond 
		 ((equal (car ev) *up*)
            (cond
               ((draw:hitp (caddr ev) (cadddr ev) 1000 1000 1100 1100)
                  (button 500 500 "Hit!")
                  ; (Delay 12)
                  (button 500 500 "    ")
               )
               (t nil)
            )
         )
         (t nil)
      ) 
   )
   (GraphClose)
)

(defun evselect ()
   (GraphOpen)
   (setq extent (button 1000 1000 "printtty"))
   (button 5000 1000 (itoa (car extent)) )
   (button 7000 1000 (itoa (cdr extent)) )
   (do-while (not (equal (car (setq ev (getevent))) *keys*))
      (cond 
		 ((equal (car ev) *up*)
            (cond
               ((draw:hitp (caddr ev) (cadddr ev) 
                  1000 1000 (car extent)(cdr extent) )
                  (button 500 500 "Hit!")(Delay 12)
                  (button 500 500 "    ")
               )
               (t nil)
            )
         )
		 ((equal (car ev) *move*)
            (button 5000 1000 (itoa (caddr ev)))
            (button 7000 1000 (itoa (cadddr ev)))
         )
         (t nil)
      ) 
   )
   (GraphClose)

)
;( to use this try (evrubber) -- line drawings)
;(evfollow)
;(-- (evprint))
;(-- (evhit))
