;;; Exercise 2.5 -- Church numerals

(define zero (my-lambda (f) (my-lambda (x) x)))

(define (incr n)
  (my-lambda (f) (my-lambda (x) (f ((n f) x)))))

(define one (incr zero))
(define two (incr (incr zero)))
(define three (incr two))

;; The currification function, which transforms a binary 
;; function into a unary operator:
(define (curry f x) (my-lambda (z) (f x z)))

;; The composition function:
(define (comp f g) (my-lambda (z) (f (g z))))

(define (add n1 n2)
	(my-lambda (f x) ((comp (curry n1 f) (curry n2 f)) x)))

(define (mul n1 n2)
	(my-lambda (f x) ((curry n1 (curry n2 f)) x)))

(define (mysucc x) (cons 's x))
(print (three mysucc 0))


